# ⚙️ Checkout Backend Setup Guide

## 🎯 Quick Setup (5 Minutes)

### Step 1: Run Database Migration
```
1. Open browser: http://localhost/interior/auth-system/migrate-checkout.php
2. Wait for confirmation messages
3. All tables created successfully ✅
```

### Step 2: Test the System
```
1. Go to: http://localhost/interior/shop.php
2. Add items to cart
3. Click "🛒 Go to Cart"
4. Click "Checkout →" button
5. Fill the checkout form
6. Click "Place Order"
7. See confirmation page
```

---

## 📋 Files Overview

| File | Purpose | Location |
|------|---------|----------|
| checkout-api.php | Backend API | auth-system/ |
| checkout.php | Checkout form | Root |
| order-confirmation.php | Order confirmation | Root |
| orders.php | My orders page | Root |
| migrate-checkout.php | Database setup | auth-system/ |

---

## 🔄 Complete User Flow

```
1. User visits shop.php
   ↓
2. Clicks ADD TO CART on products
   ↓
3. Goes to cart.php
   ↓
4. Clicks Checkout button
   ↓
5. Fills checkout form
   ↓
6. Selects payment method
   ↓
7. Clicks "Place Order"
   ↓
8. API creates order in database
   ↓
9. Cart cleared
   ↓
10. Redirected to confirmation page
   ↓
11. Can view all orders at orders.php
```

---

## 📊 Order Calculations

**Pricing:**
- Subtotal: Sum of (product price × quantity)
- Tax: 10% of subtotal
- Shipping: Rs. 500 (fixed)
- Total: Subtotal + Tax + Shipping

**Example:**
```
Items:
- Wooden Chair × 2 = 20,000
- Coffee Table × 1 = 8,000
Subtotal: 28,000
Tax (10%): 2,800
Shipping: 500
Total: 31,300 ✅
```

---

## 🎨 Payment Methods Available

1. **💳 Credit Card** - Card payment
2. **🏦 Bank Transfer** - Direct deposit
3. **📦 Cash on Delivery** - Pay at delivery
4. **🅿️ PayPal** - PayPal account

---

## 🧪 Test Data

### Sample Coupon Code
```
Code: WELCOME10
Discount: 10%
Status: Active
Expires: 30 days from now
```

### Test Product
```
ID: 1
Name: Nordic Wooden Chair
Price: Rs. 10,000
```

---

## 🚨 Troubleshooting

### Issue: "Database connection failed"
**Solution:** 
- Check database name: `interior_design`
- Check credentials: root/no-password
- Ensure MySQL is running

### Issue: "Cart is empty" error
**Solution:**
- Add items to cart first
- Go to shop.php and click ADD TO CART
- Refresh cart.php

### Issue: Checkout page shows blank
**Solution:**
- Clear browser cache
- Check PHP errors in browser console
- Verify database migration completed

### Issue: "User not authenticated"
**Solution:**
- Login first at auth-system/login.php
- Ensure role is "customer"
- Not admin user

---

## 📱 Features Included

✅ Responsive checkout form
✅ Real-time order summary
✅ Multiple payment methods
✅ Billing & shipping address
✅ Order confirmation page
✅ My orders listing
✅ Order status tracking
✅ Toast notifications
✅ Loading states
✅ Input validation
✅ Order history
✅ Admin-ready coupon system

---

## 🔐 Security Verified

✅ SQL Injection Prevention (Prepared Statements)
✅ Session-based authentication
✅ User ownership verification
✅ Role-based access control
✅ XSS prevention (htmlspecialchars)
✅ CSRF-ready architecture

---

## 📈 What's Next?

**Optional Enhancements:**
- Add email notifications
- Integrate payment gateway (Stripe/PayPal)
- Add SMS notifications
- Build admin order management
- Add shipping tracking
- Implement inventory system
- Add product reviews
- Create discount system

---

## 💬 How It Works

### Frontend (checkout.php)
- Beautiful, responsive form
- Real-time validation
- AJAX submission
- Toast notifications
- Loading states

### API (checkout-api.php)
- Validates all inputs
- Creates order record
- Adds order items
- Clears cart
- Returns JSON response

### Database
- Stores all orders
- Tracks order items
- Manages coupons
- Tracks order status
- Maintains user history

---

## 📞 Support

**Having issues?**

1. Check the error messages in browser
2. Open DevTools (F12) → Console
3. Look for error messages
4. Check database connection
5. Verify all files exist

---

## ✅ Verification Checklist

Before going live:
- [ ] Database migration ran successfully
- [ ] Can add items to cart
- [ ] Can checkout
- [ ] Order appears in database
- [ ] Confirmation page shows
- [ ] Can view orders
- [ ] Works on mobile
- [ ] Payment methods visible
- [ ] Shipping address toggle works
- [ ] Order summary accurate

---

**Status:** ✅ Ready to Use
**Last Updated:** December 18, 2025
**Version:** 1.0
