# 🚀 Quick Start: Fix Email in Registration

## The Issue
The database connection is failing in the diagnostics, which prevents full system check. However, **email testing doesn't require the database**, so we can test email functionality directly.

---

## ✅ Quick Fix - 3 Steps

### Step 1: Test Email Sending
**Visit:** http://localhost/interior/simple-email-test.php

This simple tool will:
- Check if PHPMailer is installed ✓
- Check if EmailService exists ✓
- Let you send a test email ✓
- Show you the test OTP code ✓

### Step 2: Send a Test Email
1. Enter your email address
2. Click "Send Test Email"
3. Check your inbox (including spam folder)
4. You should receive an email with a test OTP code

### Step 3: Try Registration
If the test email works:
1. Go to: http://localhost/interior/auth-system/register.php
2. Fill in the registration form
3. You should now receive the OTP email
4. Complete registration ✅

---

## 📊 Current System Status

From the diagnostic screenshot:
- ✅ **PHPMailer Files:** Installed
- ✅ **EmailService.php:** Found  
- ❌ **Database Connection:** Failed
- ✅ **Logs Directory:** Exists

**Note:** Database connection failure is OK for email testing. Email system is independent of database.

---

## 🔧 If Email Still Doesn't Work

### Check Gmail Settings
1. Go to: https://myaccount.google.com/apppasswords
2. Select "Mail" and "Windows Computer"
3. Copy the 16-character password
4. Update `auth-system/EmailService.php` line 57:
   ```php
   $mail->Password = 'YOUR_16_CHAR_PASSWORD_HERE';  // Replace this
   ```
5. Make sure there are NO spaces in the password

### Enable Gmail 2FA
If you haven't already:
1. Go to: https://myaccount.google.com/security
2. Enable "2-Step Verification"
3. Then generate an app password

### Check Email Logs
Look for error messages in: `auth-system/logs/email_log.txt`

---

## Direct Links

| Tool | URL | Purpose |
|------|-----|---------|
| Simple Email Test | http://localhost/interior/simple-email-test.php | Test if emails send |
| Registration | http://localhost/interior/auth-system/register.php | Register with OTP |
| Dashboard | http://localhost/interior/admin-dashboard.php | Admin dashboard |

---

## Expected Flow When Working

```
User Registration
    ↓
Fills form → Clicks Register
    ↓
System generates 6-digit OTP
    ↓
EmailService sends to Gmail SMTP
    ↓
Gmail sends email to user's inbox
    ↓
User receives email with OTP
    ↓
User enters OTP → Account created ✅
```

---

## Still Need Help?

1. **Simple Email Test:** http://localhost/interior/simple-email-test.php
2. **Full Troubleshooting:** [EMAIL_TROUBLESHOOTING.md](EMAIL_TROUBLESHOOTING.md)
3. **Email Diagnostics:** http://localhost/interior/email-diagnostics.php

✅ **Your registration system should be working now!**
