# 📧 Email Not Sending - Troubleshooting Guide

## Quick Diagnosis

Follow these steps to fix email issues in registration:

### Step 1: Check PHPMailer Installation
Visit: **http://localhost/interior/verify-phpmailer.php**

This will show you if PHPMailer is properly installed.

### Step 2: Test Email Configuration
Visit: **http://localhost/interior/test-email-config.php**

This will let you:
- Test if emails can be sent
- Check system configuration
- View email logs
- Verify Gmail credentials

### Step 3: Common Issues & Fixes

#### ❌ "Email failed to send" Message

**Issue 1: PHPMailer Files Missing**
- Solution: Download PHPMailer files to `auth-system/PHPMailer/` directory
- Required files:
  - `PHPMailer.php`
  - `SMTP.php`
  - `Exception.php`

**Issue 2: Gmail Authentication Failed**
- Solution: Check Gmail app password
  1. Go to: https://myaccount.google.com/apppasswords
  2. Select "Mail" and "Windows Computer"
  3. Google generates 16-character password
  4. Update in `auth-system/EmailService.php` line 57:
     ```php
     $mail->Password = 'YOUR_16_CHAR_PASSWORD_HERE';
     ```
  5. Remove all spaces from the password

**Issue 3: 2FA Not Enabled on Gmail**
- Solution: Enable 2FA on Gmail account first
  1. Visit: https://myaccount.google.com/security
  2. Enable "2-Step Verification"
  3. Then generate app password

**Issue 4: Wrong Email Provider**
- Solution: If not using Gmail, update SMTP settings in `EmailService.php`
  - For Outlook: `smtp-mail.outlook.com`, Port 587
  - For other services: Update Host and Port

---

## How Email Should Work

```
User Registration Form
        ↓
User clicks "Register"
        ↓
EmailService::generateOTP() → Creates 6-digit code
        ↓
EmailService::sendEmailVerificationOTP() → Sends via PHPMailer
        ↓
PHPMailer connects to smtp.gmail.com:465 (SMTPS)
        ↓
Email sent to user's inbox
        ↓
User receives email with OTP code
        ↓
User enters OTP in form → Account created ✅
```

---

## Files Involved

| File | Purpose |
|------|---------|
| `auth-system/register.php` | Registration form |
| `auth-system/EmailService.php` | Email sending logic |
| `auth-system/PHPMailer/` | PHPMailer library |
| `auth-system/config/db.php` | Database connection |
| `test-email-config.php` | Email testing tool |
| `verify-phpmailer.php` | Verification tool |

---

## Enable Debug Logging

To see detailed error messages:

1. Open `auth-system/EmailService.php`
2. Find line with: `$mail->SMTPDebug = 0;`
3. Change to: `$mail->SMTPDebug = 2;`
4. Check error logs in `auth-system/logs/email_log.txt`

---

## Check Email Logs

Emails are logged to: **auth-system/logs/email_log.txt**

To view:
- Use FTP/SFTP to access the file
- Or visit `test-email-config.php` and scroll to "Recent Email Logs"

---

## Still Not Working?

1. **Verify credentials are exactly correct** (including spacing)
2. **Check if Gmail account has 2FA enabled**
3. **Confirm you're using an app password, not regular password**
4. **Check spam/junk folder for test emails**
5. **Review error logs** in `auth-system/logs/`
6. **Try a different email provider** (Outlook, Mailtrap, SendGrid)

---

## Next Steps

After fixing email:
1. Go back to: **http://localhost/interior/auth-system/register.php**
2. Try registering with a valid email
3. Check your email inbox for OTP code
4. Enter OTP to complete registration

✅ **Registration with email verification should now work!**
