# Favorites/Wishlist Feature - Quick Start Guide

## 🚀 Quick Setup (2 minutes)

### Step 1: Create Database Table
```
Visit: http://localhost/interior/auth-system/setup-favorites.php
```
You'll see: `{"success":true,"message":"Favorites table created successfully"}`

### Step 2: Done! ✅
The system is ready to use!

---

## 📚 Files Overview

| File | Purpose | Location |
|------|---------|----------|
| `favorites-api.php` | Backend API for favorites | `auth-system/` |
| `setup-favorites.php` | Database table setup | `auth-system/` |
| `shop.php` | Product listing with favorite buttons | Root |
| `my-wishlist.php` | Wishlist display page | Root |
| `FAVORITES_SYSTEM.md` | Complete documentation | Root |

---

## 🎨 User Features

### On Shop Page (shop.php)
- ❤️ Heart icon on each product card
- Click to add/remove from favorites
- Red heart = already favorited
- Toast notifications

### On Wishlist Page (my-wishlist.php)
- View all favorite products
- See total items and total value
- Remove products
- Add products to cart
- Beautiful grid layout

---

## 💻 Database Schema

```sql
CREATE TABLE favorites (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    user_id INT(11) NOT NULL,
    product_id INT(11) NOT NULL,
    product_name VARCHAR(255) NOT NULL,
    product_price DECIMAL(10, 2) NOT NULL,
    product_image VARCHAR(255),
    added_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    UNIQUE KEY unique_user_product (user_id, product_id),
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);
```

---

## 🔌 API Endpoints

### Add to Favorites
```javascript
fetch('auth-system/favorites-api.php?action=add', {
    method: 'POST',
    headers: {'Content-Type': 'application/json'},
    body: JSON.stringify({
        product_id: 1,
        product_name: 'Product Name',
        product_price: 10000,
        product_image: 'image.jpg'
    })
})
```

### Remove from Favorites
```javascript
fetch('auth-system/favorites-api.php?action=remove', {
    method: 'POST',
    headers: {'Content-Type': 'application/json'},
    body: JSON.stringify({product_id: 1})
})
```

### Get All Favorites
```javascript
fetch('auth-system/favorites-api.php?action=get_all')
    .then(r => r.json())
    .then(data => console.log(data.favorites))
```

### Check if Product is Favorited
```javascript
fetch('auth-system/favorites-api.php?action=check&product_id=1')
    .then(r => r.json())
    .then(data => console.log(data.is_favorite))
```

---

## 🔐 Security Features

✅ Prepared statements (SQL injection prevention)  
✅ User authentication required  
✅ Session validation  
✅ Unique constraint prevents duplicates  
✅ Foreign key relationships  

---

## 📱 Responsive Design

- ✅ Desktop (1200px+)
- ✅ Tablet (768px - 1199px)
- ✅ Mobile (320px - 767px)

---

## 🎯 Use Cases

1. **Customers save favorite products for later**
2. **Track price changes on wishlist items** (future)
3. **Share wishlists with friends** (future)
4. **Analytics on customer preferences**
5. **Product recommendations based on favorites**

---

## ⚡ Performance

- Fast database queries with indexing
- Efficient JSON API responses
- Minimal JavaScript footprint
- No page reloads needed
- Real-time UI updates

---

## 🐛 Common Issues & Solutions

### Heart icon not showing?
- User must be logged in
- Check Session in browser DevTools
- Verify `$_SESSION['user_role'] === 'customer'`

### Adding to favorites not working?
- Check browser Console (F12)
- Verify database table exists
- Test API endpoint directly

### Wishlist page is empty?
- Add some products to favorites first
- Refresh page
- Check database for favorites records

### Database errors?
- Run setup script again
- Check database connection credentials
- Verify MySQL is running

---

## 📖 Links

- **Shop Page:** `http://localhost/interior/shop.php`
- **Wishlist Page:** `http://localhost/interior/my-wishlist.php`
- **Setup Script:** `http://localhost/interior/auth-system/setup-favorites.php`
- **API Endpoint:** `http://localhost/interior/auth-system/favorites-api.php`

---

## 🎉 You're All Set!

Your favorites/wishlist system is ready to use!

1. Go to shop.php
2. Log in as a customer
3. Click the heart on any product
4. See your favorites in my-wishlist.php

Enjoy! ❤️
