# 🔧 Fix PHP openssl Duplicate Module Error

## Problem
```
PHP Warning: Module "openssl" is already loaded
```

This error occurs when `openssl` extension is listed multiple times in `php.ini`.

---

## Solution

### Option 1: Automatic Fix (Recommended)

Double-click: **`fix-php-ini.bat`** in `C:\xampp\htdocs\interior\`

This will:
1. ✅ Backup original php.ini
2. ✅ Remove duplicate extensions
3. ✅ Allow Composer to work

---

### Option 2: Manual Fix

1. **Open php.ini in text editor**
   - Path: `C:\xampp\php\php.ini`
   - Right-click → Open with → Notepad

2. **Search for duplicate openssl** (Ctrl+F)
   - Look for: `extension=php_openssl.dll`
   - Should appear only ONCE

3. **If found multiple times:**
   - Keep ONLY the first occurrence (uncommented)
   - Comment out or delete the duplicates
   
   Example:
   ```ini
   ; Before (Wrong - 2 times)
   extension=php_openssl.dll
   extension=php_openssl.dll
   
   ; After (Correct - 1 time)
   extension=php_openssl.dll
   ;extension=php_openssl.dll
   ```

4. **Search for other duplicates:**
   - `extension=php_curl.dll`
   - `extension=php_mysqli.dll`
   - `extension=php_pdo_mysql.dll`
   - Any extension appearing more than once

5. **Save the file** (Ctrl+S)

6. **Restart XAMPP:**
   - Stop Apache
   - Start Apache again

7. **Test PHP:**
   - Run: `php -v`
   - Should show version with no warnings

---

### Option 3: Edit via Script

Run this PowerShell command:

```powershell
# First, backup the file
Copy-Item "C:\xampp\php\php.ini" "C:\xampp\php\php.ini.backup"

# Remove duplicate lines (keeps only first occurrence)
$content = Get-Content "C:\xampp\php\php.ini" | Select-Object -Unique
$content | Set-Content "C:\xampp\php\php.ini"

# Test
php -v
```

---

## Step-by-Step Manual Instructions

### Step 1: Backup php.ini
```
1. Go to: C:\xampp\php\
2. Right-click php.ini
3. Click Copy
4. Paste as: php.ini.backup
```

### Step 2: Open php.ini
```
1. Right-click php.ini
2. Open with → Notepad (or any text editor)
```

### Step 3: Find Duplicates
```
1. Press Ctrl+F
2. Search for: extension=php_openssl.dll
3. Count how many times it appears
4. It should appear ONLY ONCE (uncommented)
```

### Step 4: Remove Duplicates
```
If you see openssl listed 2+ times:

; Comment out (add ; at start) or delete the extra lines
; Keep only the first one uncommented

Before:
extension=php_openssl.dll
extension=php_openssl.dll

After:
extension=php_openssl.dll
;extension=php_openssl.dll
```

### Step 5: Save
```
1. Press Ctrl+S
2. Close the file
```

### Step 6: Restart XAMPP
```
1. Open XAMPP Control Panel
2. Click "Stop" for Apache
3. Wait 5 seconds
4. Click "Start" for Apache
5. Wait for it to start (green highlight)
```

### Step 7: Test
```
1. Open Command Prompt
2. Run: php -v
3. Should show: PHP X.X.X with no warnings
```

### Step 8: Now Install Composer
```
1. Open Command Prompt
2. Navigate to: cd C:\xampp\htdocs\interior\
3. Run: composer require phpmailer/phpmailer
4. Should work without errors!
```

---

## Verify the Fix

### Check if PHP works:
```bash
php -v
```

Should output:
```
PHP 8.X.X (cli) (built: ...)
...
```

No warnings or errors!

### Check php.ini
```bash
php -i | findstr openssl
```

Should show openssl info WITHOUT the duplicate warning.

---

## Additional Cleanup

After fixing, also look for these duplicate extensions:

```ini
; Search for these and remove duplicates:
extension=php_curl.dll
extension=php_gd.dll
extension=php_mysqli.dll
extension=php_pdo_mysql.dll
extension=php_session.dll
extension=php_json.dll
```

Keep only ONE uncommented instance of each.

---

## If Still Having Issues

### Option 1: Reinstall XAMPP
1. Uninstall current XAMPP
2. Delete `C:\xampp` folder
3. Download fresh XAMPP from apachefriends.org
4. Install fresh version

### Option 2: Upgrade PHP Version
XAMPP often has outdated PHP versions. Consider upgrading to latest stable version.

### Option 3: Use Different Method
If Composer still fails, use this workaround:

```php
<?php
// In your register.php, add at the top:
// Use alternative email delivery method
// Or install PHPMailer manually
?>
```

---

## ✅ Verification Checklist

- [ ] Backed up php.ini
- [ ] Found php.ini in C:\xampp\php\
- [ ] Opened in text editor
- [ ] Searched for extension=php_openssl.dll
- [ ] Removed duplicates (keep only 1)
- [ ] Saved the file
- [ ] Restarted Apache
- [ ] Ran `php -v` with no warnings
- [ ] Now running: `composer require phpmailer/phpmailer`
- [ ] Installation successful ✅

---

## Common Locations to Check

```
C:\xampp\php\php.ini              ← Main PHP config
C:\xampp\php\php.ini.backup        ← Backup (create this first!)
C:\xampp\apache\conf\httpd.conf    ← Apache config
```

---

## After Fixing

1. Install PHPMailer:
   ```bash
   cd C:\xampp\htdocs\interior
   composer require phpmailer/phpmailer
   ```

2. Configure PHPMailerConfig.php with your email

3. Test registration:
   ```
   http://localhost/interior/auth-system/register.php
   ```

---

**Status: Ready to Fix and Install!** 🚀
