# 🔒 Fix SSL Certificate Verification Error for Composer

## Problem
```
SSL operation failed with code 1. OpenSSL Error messages:
error:0A000086:SSL routines::certificate verify failed
```

This occurs when XAMPP's SSL certificate bundle is outdated or invalid.

---

## ✅ Solution (Choose One)

### **Option 1: Automatic Fix (Recommended)**

Double-click: **`fix-ssl-certificate.bat`** in `C:\xampp\htdocs\interior\`

This will:
1. ✅ Download latest CA certificate bundle
2. ✅ Install to `C:\xampp\php\cacert.pem`
3. ✅ Update php.ini automatically
4. ✅ Ready for Composer!

---

### **Option 2: Quick Manual Fix**

Edit `C:\xampp\php\php.ini`:

1. Open in notepad: `C:\xampp\php\php.ini`
2. Find this line (around line 1300):
   ```ini
   ;openssl.cafile=
   ```
3. Change to:
   ```ini
   openssl.cafile=C:\xampp\php\cacert.pem
   ```
4. Save and close

Then run Composer:
```bash
cd C:\xampp\htdocs\interior
composer require phpmailer/phpmailer
```

---

### **Option 3: Download Certificate Manually**

1. **Download certificate:**
   - Go to: https://curl.se/ca/cacert.pem
   - Right-click → Save as
   - Save to: `C:\xampp\php\cacert.pem`

2. **Update php.ini:**
   - Open: `C:\xampp\php\php.ini`
   - Find: `;openssl.cafile=`
   - Change to: `openssl.cafile=C:\xampp\php\cacert.pem`
   - Save

3. **Run Composer:**
   ```bash
   cd C:\xampp\htdocs\interior
   composer require phpmailer/phpmailer
   ```

---

### **Option 4: Disable SSL Verification (Temporary)**

If you need to install immediately:

```bash
cd C:\xampp\htdocs\interior
composer require phpmailer/phpmailer --ignore-platform-reqs -n --no-interaction
```

Or create `composer.json` file and run:
```bash
composer install -g --no-ssl
```

⚠️ **Note:** Not recommended for production. Fix properly with Option 1-3.

---

## Step-by-Step Manual Guide

### Step 1: Get the Certificate
Download from: https://curl.se/ca/cacert.pem

- Right-click the link
- Select "Save link as..."
- Save to: `C:\xampp\php\cacert.pem`

### Step 2: Update php.ini
```
1. Open: C:\xampp\php\php.ini
2. Find line with: openssl.cafile
3. Uncomment and set path:
   
   Before:
   ;openssl.cafile=
   ;curl.cainfo=
   
   After:
   openssl.cafile=C:\xampp\php\cacert.pem
   curl.cainfo=C:\xampp\php\cacert.pem
```

### Step 3: Restart Apache
```
1. XAMPP Control Panel
2. Click Stop (Apache)
3. Wait 5 seconds
4. Click Start (Apache)
5. Wait for "green" indicator
```

### Step 4: Verify
```bash
# Test PHP SSL
php -r "echo openssl_get_cert_locations()['cafile'];"

# Should output:
# C:\xampp\php\cacert.pem
```

### Step 5: Install Composer
```bash
cd C:\xampp\htdocs\interior
composer require phpmailer/phpmailer
```

---

## Troubleshooting

### Certificate Still Not Working
```bash
# Clear Composer cache
composer clear-cache

# Try again
composer require phpmailer/phpmailer
```

### Certificate Download Failed
```bash
# Use HTTP instead of HTTPS temporarily
composer config -g repositories.packagist composer https://packagist.org

# Then install
composer require phpmailer/phpmailer
```

### Still Getting SSL Errors
1. Check certificate file exists:
   ```bash
   dir C:\xampp\php\cacert.pem
   ```

2. Verify php.ini is correct:
   ```bash
   php -i | findstr cafile
   ```
   Should show your certificate path

3. Check file permissions:
   - Right-click cacert.pem
   - Properties → Security → Check full access

### Composer Still Fails
Use alternative installation:

```bash
# Install without SSL
composer install --no-ssl

# Or use HTTPS mirror
composer config -g repositories.packagist composer https://composer.pkg.repman.io

composer require phpmailer/phpmailer
```

---

## Permanent Solution

### Update XAMPP

XAMPP often comes with outdated certificates. Consider:

1. **Upgrade XAMPP** to latest version
2. **Update PHP** to latest stable release
3. **Use dedicated server** for production

---

## Configuration Reference

### Minimum php.ini Settings
```ini
[openssl]
openssl.cafile = C:\xampp\php\cacert.pem

[curl]
curl.cainfo = C:\xampp\php\cacert.pem
```

### Alternative Certificate Locations
```
C:\xampp\php\cacert.pem              ← Recommended
C:\xampp\apache\bin\curl-ca-bundle.crt
C:\php\cert\ca-bundle.crt
```

---

## Verify Installation

After fixing, test with:

```bash
# Check certificate is loaded
php -r "
$cafile = ini_get('openssl.cafile');
if (file_exists($cafile)) {
    echo 'Certificate found: ' . $cafile;
} else {
    echo 'ERROR: Certificate not found!';
}
"

# Test HTTPS connection
php -r "
$ctx = stream_context_create([
    'http' => ['timeout' => 5]
]);
$data = file_get_contents('https://www.google.com', false, $ctx);
echo 'HTTPS connection successful!';
"
```

---

## Quick Reference

| Issue | Fix |
|-------|-----|
| SSL certificate not found | Download cacert.pem |
| Certificate path wrong | Update openssl.cafile in php.ini |
| PHP not using certificate | Restart Apache |
| Composer cache corrupted | Run: `composer clear-cache` |
| Still failing | Use: `composer install --no-ssl` |

---

## ✅ Verification Checklist

- [ ] Downloaded cacert.pem to C:\xampp\php\
- [ ] Updated php.ini with certificate path
- [ ] Restarted Apache
- [ ] Verified with: `php -i | findstr cafile`
- [ ] Now running: `composer require phpmailer/phpmailer`
- [ ] Installation successful! ✅

---

## After Installation

Once Composer installation succeeds:

1. **Configure PHPMailer:**
   ```
   Edit: auth-system/PHPMailerConfig.php
   Add your email credentials
   ```

2. **Test Registration:**
   ```
   http://localhost/interior/auth-system/register.php
   ```

3. **OTP Should Send:**
   ```
   Check your email inbox for OTP code
   ```

---

**Status: Ready to Fix SSL Certificate!** 🚀

Run `fix-ssl-certificate.bat` now!
