# 📐 Header & Footer Structure Diagram

## Page Layout

```
┌─────────────────────────────────────────────────────────────────┐
│                                                                 │
│  ┌──────────────────────────────────────────────────────────┐  │
│  │  TOP HEADER (Black Bar)                                  │  │
│  │  Welcome to Faren | Social Icons                         │  │
│  └──────────────────────────────────────────────────────────┘  │
│                                                                 │
│  ┌──────────────────────────────────────────────────────────┐  │
│  │  NAVIGATION HEADER (White Bar with Gold Border)         │  │
│  │  ┌─────────────┐  ┌──────────────────────┐  ┌─────────┐ │  │
│  │  │ Logo 🏠     │  │ Menu Links          │  │ 🛒 Cart │ │  │
│  │  │ Faren Design│  │ Shop About Services │  │ Logout  │ │  │
│  │  └─────────────┘  └──────────────────────┘  └─────────┘ │  │
│  └──────────────────────────────────────────────────────────┘  │
│                                                                 │
│  ┌──────────────────────────────────────────────────────────┐  │
│  │  PAGE INTRO (Gold Gradient)                              │  │
│  │  🛍️ Premium Furniture Store                             │  │
│  │  ✨ Click "ADD TO CART" to add items instantly           │  │
│  └──────────────────────────────────────────────────────────┘  │
│                                                                 │
│  ┌──────────────────────────────────────────────────────────┐  │
│  │                                                          │  │
│  │  MAIN CONTENT (Varies by page)                           │  │
│  │                                                          │  │
│  │  shop.php:  8 Products Grid                             │  │
│  │  cart.php:  Shopping Cart Items                         │  │
│  │                                                          │  │
│  └──────────────────────────────────────────────────────────┘  │
│                                                                 │
│  ┌──────────────────────────────────────────────────────────┐  │
│  │  FOOTER (Dark Background #0f0f0f)                        │  │
│  │                                                          │  │
│  │  ┌────────────┐ ┌────────────┐ ┌────────────┐ ┌────────┐ │  │
│  │  │ Brand      │ │ Company    │ │ Shopping   │ │Contact │ │  │
│  │  │ Faren      │ │ About      │ │ Shop       │ │Phone   │ │  │
│  │  │ Design     │ │ Team       │ │ Cart       │ │Email   │ │  │
│  │  │ Store      │ │ Services   │ │ Checkout   │ │Support │ │  │
│  │  │ ..content..│ │ Pricing    │ │ Gallery    │ │...     │ │  │
│  │  │            │ │ FAQ        │ │ Wishlist   │ │        │ │  │
│  │  └────────────┘ └────────────┘ └────────────┘ └────────┘ │  │
│  │                                                          │  │
│  │  Social Icons: fb twitter linkedin instagram            │  │
│  │                                                          │  │
│  │  Terms | Privacy | Cookies                              │  │
│  │                                                          │  │
│  │  © 2025 Faren Design. All Rights Reserved.              │  │
│  └──────────────────────────────────────────────────────────┘  │
│                                                                 │
└─────────────────────────────────────────────────────────────────┘
```

---

## File Inclusion Flow

### shop.php Structure
```
shop.php (Line 1)
├── session_start()
├── include 'shop-header.php'
│   ├── DOCTYPE, HTML, HEAD tags
│   ├── CSS Styling (all styles)
│   ├── Top Header
│   ├── Navigation Header
│   └── Main Content Start
├── Page Intro Section (Gold Gradient)
├── Products Grid (8 items)
│   └── Add to Cart Buttons (AJAX)
├── JavaScript (AJAX Logic)
└── include 'shop-footer.php'
    ├── Footer HTML
    ├── Scripts
    └── Closing Tags
```

### cart.php Structure
```
cart.php (Line 1)
├── session_start()
├── Auth Checks (user_id, user_role)
├── include 'shop-header.php'
│   ├── DOCTYPE, HTML, HEAD tags
│   ├── CSS Styling
│   ├── Top Header
│   └── Navigation Header
├── Page Title Section (Gold Gradient)
├── Cart Items Section
│   └── Remove Buttons (AJAX)
├── Cart Summary (totals)
├── JavaScript (load/remove logic)
└── include 'shop-footer.php'
    ├── Footer HTML
    ├── Scripts
    └── Closing Tags
```

---

## Component Details

### Header Component (shop-header.php)

```
shop-header.php
│
├── HTML Structure
│   ├── DOCTYPE html
│   ├── <html>
│   ├── <head> with all styles
│   └── <body>
│
├── Top Header Section
│   ├── Black background (#000)
│   ├── Left: Welcome message
│   ├── Right: Social icons
│   └── Color: White (#fff)
│
├── Navigation Header Section
│   ├── White background (#fff)
│   ├── Gold bottom border (#d4a574)
│   │
│   ├── Logo Section
│   │   ├── Icon (🏠)
│   │   ├── Brand name "Faren Design"
│   │   └── Color: Gold (#d4a574)
│   │
│   ├── Menu Links
│   │   ├── Shop (shop.php)
│   │   ├── About (about.html)
│   │   ├── Services (service.html)
│   │   ├── Contact (contact.html)
│   │   └── Color: Dark (#333)
│   │
│   └── Right Side
│       ├── Cart Button (if logged in)
│       │   └── Color: Gold (#d4a574)
│       └── Logout Link (if logged in)
│           └── Color: Dark Red (#dc3545)
│
└── Main Content Start
    └── <div class="main-content">
```

### Footer Component (shop-footer.php)

```
shop-footer.php
│
├── Footer Wrapper
│   ├── Background: Dark (#0f0f0f)
│   ├── Padding: 60px
│   └── Color: Light gray (#aaa)
│
├── Footer Main Section
│   └── 4-column grid
│       │
│       ├── Column 1: Brand
│       │   ├── Title: "Faren Design Store" (Gold)
│       │   └── Description: Company info
│       │
│       ├── Column 2: Company Links
│       │   ├── About Us
│       │   ├── Our Team
│       │   ├── Services
│       │   ├── Pricing
│       │   └── FAQ
│       │
│       ├── Column 3: Shopping Links
│       │   ├── Shop All Products
│       │   ├── Shopping Cart
│       │   ├── Checkout
│       │   ├── Gallery
│       │   └── Wishlist
│       │
│       └── Column 4: Contact
│           ├── Phone
│           ├── Email
│           ├── Location
│           └── Support
│
├── Footer Bottom Section
│   ├── Top border: Dark (#333)
│   ├── Left: Social Icons
│   │   ├── Facebook
│   │   ├── Twitter
│   │   ├── LinkedIn
│   │   └── Instagram
│   │
│   ├── Right: Legal Links
│   │   ├── Terms of Service
│   │   ├── Privacy Policy
│   │   └── Cookies
│   │
│   └── Colors: Gold (#d4a574) on hover
│
├── Copyright Section
│   ├── Text: "© 2025 Faren Design. All Rights Reserved."
│   ├── Background: Black (#000)
│   ├── Border-top: Dark (#333)
│   └── Text color: Gray (#666)
│
└── Closing Tags
    ├── Scripts
    ├── </body>
    └── </html>
```

---

## Navigation Flow

```
                            ┌─────────────────┐
                            │  Home (index)   │
                            └────────┬────────┘
                                     │
                ┌────────────────────┼────────────────────┐
                │                    │                    │
        ┌───────▼────────┐  ┌────────▼────────┐  ┌────────▼────────┐
        │  shop.php      │  │  about.html     │  │ contact.html    │
        │  (Products)    │  │  (Company Info) │  │ (Contact Form)  │
        └────┬────────┬──┘  └─────────────────┘  └─────────────────┘
             │        │
             │        └─────────────┐
             │                      │
        ┌────▼────────────────┐     │
        │  cart.php           │     │
        │  (Shopping Cart)     │     │
        └────┬────────────────┘     │
             │                      │
        ┌────▼────────────────┐     │
        │  checkout.php       │◄────┘
        │  (Checkout Page)    │
        └─────────────────────┘

Auth Links:
├── login.php (auth-system/)
├── register.php (auth-system/)
└── logout.php (auth-system/)
```

---

## Color Scheme

```
Primary Colors:
├── Gold          #d4a574  (Primary accent, buttons)
├── Dark Gold     #b8905a  (Hover state)
├── Black         #000000  (Footer, headers)
└── Dark Gray     #333333  (Text, containers)

Status Colors:
├── Success       #28a745  (Green toast, success messages)
├── Error         #dc3545  (Red toast, delete buttons)
└── Warning       #ffc107  (Yellow, login prompts)

Neutral:
├── White         #ffffff  (Navigation bg)
├── Light Gray    #f5f5f5  (Page background)
├── Medium Gray   #aaa     (Footer text)
└── Dark Gray     #666     (Secondary text)
```

---

## Responsive Breakpoints

```
Desktop (1200px+):
├── Full 4-column footer
├── Horizontal menu
└── Full-width products grid

Tablet (768px - 1199px):
├── 2-column footer (responsive grid)
├── Horizontal menu (smaller gaps)
└── 2-3 column product grid

Mobile (< 768px):
├── Stacked footer (1 column)
├── Collapsed menu (hamburger-ready)
├── 1-2 column product grid
└── Touch-friendly buttons
```

---

## CSS Hierarchy

```
shop-header.php:
├── Global Styles (*, body, html)
├── Top Header Styles
├── Navigation Styles
├── Page Content Styles
├── Product Grid Styles
├── Toast Notification Styles
├── Responsive Media Queries
└── Animations (@keyframes)

shop-footer.php:
├── Footer Container
├── Footer Main Content
├── Footer Columns
├── Footer Bottom
├── Social Icons
├── Copyright Section
└── Responsive Footer
```

---

## JavaScript Behavior

### shop.php
```
Add to Cart Button Click:
├── Get product data (ID, name, price, image)
├── Get quantity from input
├── Show loading state ("⏳ Adding...")
├── Send AJAX fetch to cart-api.php
├── Parse JSON response
├── Show toast (success/error)
└── Reset quantity input
```

### cart.php
```
Page Load:
├── Fetch cart items from cart-api.php
├── Display items in grid
├── Calculate totals
└── Set up auto-refresh (3 seconds)

Remove Button Click:
├── Get confirmation
├── Send AJAX fetch to cart-api.php
├── Parse JSON response
├── Show toast confirmation
├── Refresh cart display
└── Update totals
```

---

## Integration Points

```
shop.php ──includes──> shop-header.php
     │                     └─ Provides: HTML structure, CSS, nav
     │
     └──includes──> shop-footer.php
                         └─ Provides: Footer, closing tags

cart.php ──includes──> shop-header.php
     │                     └─ Provides: HTML structure, CSS, nav
     │
     └──includes──> shop-footer.php
                         └─ Provides: Footer, closing tags
```

---

**Complete header and footer integration with professional design!** 🎨
