# Hero Slider Quick Reference

## System Components

| File | Purpose |
|------|---------|
| `admin-dashboard.php` | Admin interface with hero slider management section |
| `admin-hero-slider-handler.php` | Backend processor that updates index.html |
| `index.html` | Frontend website with hero slider |

## Quick Actions

### Add a New Hero Slide
1. Go to Admin Dashboard → Hero Slider Management
2. Click **"Add Slide"** button
3. Fill in the form:
   - **Background Image URL:** `assets/img/your-image.jpg`
   - **Slide Title:** The full title text
   - **Highlight Word:** The word that appears in gold (e.g., "Luxury")
   - **Subtitle:** Default is "Innovative solutions"
4. Click **"Add Slide"** → index.html is automatically updated ✓

### Edit an Existing Hero Slide
1. Go to Admin Dashboard → Hero Slider Management
2. Find the slide you want to edit
3. Click the **"Edit"** button
4. Modify any field
5. Click **"Save Changes"** → index.html is automatically updated ✓

### Delete a Hero Slide
1. Go to Admin Dashboard → Hero Slider Management
2. Find the slide to delete
3. Click the **"Delete"** button
4. Confirm deletion → index.html is automatically updated ✓

## Example Slide Data

```
Image:        assets/img/1349902.jpeg
Title:        Interior Design for [Luxury] Living Spaces.
Subtitle:     Innovative solutions
```

## Common Image Locations

Place hero slider images in: `assets/img/`

Examples:
- `assets/img/1349902.jpeg` - First slide
- `assets/img/362537.jpg` - Second slide
- `assets/img/647571.jpg` - Third slide

## Important Rules

✓ **Must Have:**
- Image URL
- Slide Title
- Highlight Word

✓ **Automatic:**
- index.html synchronization
- Button linking (Contact & Projects)
- Styling and animations

✗ **Cannot:**
- Delete last slide (minimum 1 required)
- Manually edit slide HTML in index.html (use admin only)

## File Paths

```
Home: c:\xampp\htdocs\interior\

Files:
├── admin-dashboard.php                    ← Admin interface
├── admin-hero-slider-handler.php         ← Backend processor (NEW)
├── index.html                             ← Frontend (automatically updated)
└── HERO_SLIDER_SYNCHRONIZATION.md        ← Full documentation
```

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Changes don't appear | Refresh browser (Ctrl+F5) |
| "Add Slide" button doesn't work | Check browser console for errors |
| Images not showing | Verify correct image path exists |
| Handler errors | Ensure admin-hero-slider-handler.php is in root directory |

## How It Works (Behind the Scenes)

1. **Admin Page:** You fill out the form and click a button
2. **JavaScript:** Sends request to `admin-hero-slider-handler.php`
3. **Handler:** Reads `index.html`, finds the hero slider section
4. **Update:** Adds/edits/deletes the slide HTML
5. **Save:** Writes updated `index.html` back to disk
6. **Refresh:** Admin page reloads to show changes

## Key Features

- ✓ **Automatic Synchronization:** Changes reflect on website immediately
- ✓ **No Manual Coding Required:** Use the friendly admin interface
- ✓ **Backup Safety:** File permissions prevent accidental deletion
- ✓ **Real-time Preview:** See thumbnail of what you're editing
- ✓ **Easy to Reverse:** Delete unwanted slides anytime

## Support Files

For detailed technical information, see: [HERO_SLIDER_SYNCHRONIZATION.md](HERO_SLIDER_SYNCHRONIZATION.md)

---

**Made with ❤️ for Interior Design Dashboard**
