# Hero Slider Synchronization System

## Overview

The hero slider section in `admin-dashboard.php` is now fully synchronized with `index.html`. Any changes you make to hero slides in the admin dashboard will automatically update the index.html file.

## How It Works

### Files Involved

1. **admin-dashboard.php** - The admin interface for managing hero slides
2. **index.html** - The main website file containing the hero slider HTML
3. **admin-hero-slider-handler.php** - The backend processor that handles all slider operations

### Backend Handler (admin-hero-slider-handler.php)

This PHP file handles all operations and automatically updates index.html:

#### Supported Actions

##### 1. Get Slides (`get_slides`)
- Fetches all current hero slides from index.html
- Returns slide data in JSON format
- Used to populate the admin dashboard display

##### 2. Add Slide (`add_slide`)
**Parameters:**
- `image` - Image URL (required)
- `title` - Full slide title (required)
- `highlight` - The highlighted/colored word in the title (required)
- `subtitle` - Subtitle text (optional, defaults to "Innovative solutions")

**Result:**
- Adds a new swiper-slide div to index.html
- Automatically refreshes the admin display

##### 3. Edit Slide (`edit_slide`)
**Parameters:**
- `slide_index` - The index of the slide to edit (required)
- `image` - New image URL (required)
- `title` - New title (required)
- `highlight` - New highlighted word (required)
- `subtitle` - New subtitle (required)

**Result:**
- Updates the specific slide in index.html
- Maintains the slide position

##### 4. Delete Slide (`delete_slide`)
**Parameters:**
- `slide_index` - The index of the slide to delete (required)

**Restrictions:**
- At least one slide must always exist
- Will prevent deletion if only one slide remains

**Result:**
- Removes the slide from index.html

## Admin Dashboard Features

### View Hero Slides
The admin dashboard displays:
- Thumbnail preview of each slide
- Full slide title with highlighted text
- Subtitle text
- Edit and Delete buttons

### Add New Slide
**Steps:**
1. Click "Add Slide" button
2. Enter the background image URL
3. Enter the slide title
4. Enter the highlight word (will appear in gold color)
5. Enter the subtitle (optional)
6. Click "Add Slide"

The new slide will be automatically added to index.html at the end of the slider.

### Edit Existing Slide
**Steps:**
1. Click the "Edit" button on any slide
2. Modify the image URL, title, highlight word, or subtitle
3. Click "Save Changes"

Changes are saved to index.html immediately.

### Delete Slide
**Steps:**
1. Click the "Delete" button on any slide
2. Confirm the deletion
3. The slide is removed from index.html

## Technical Details

### How Synchronization Works

1. **JavaScript AJAX Calls:** The admin dashboard uses JavaScript to send requests to the handler
2. **PHP File Processing:** The handler reads and parses index.html using regex patterns
3. **HTML Modification:** New/updated slides are inserted or replaced in the proper location
4. **File Writing:** Changes are written back to index.html

### Slide HTML Structure

Each slide in index.html follows this structure:

```html
<div class="swiper-slide">
    <div class="hero-inner">
        <div class="th-hero-bg" data-bg-src="path/to/image.jpg"></div>
        <div class="container" style="padding-top: 50px;">
            <div class="row align-items-end">
                <div class="col-xl-8">
                    <div class="hero-style8">
                        <span class="sub-title">Subtitle Text</span>
                        <h1 class="hero-title">
                            Title Part 1 <span class="text-theme">Highlighted Word</span> Title Part 2
                        </h1>
                        <div class="btn-group justify-content-xl-start justify-content-center">
                            <a href="contact.html" class="th-btn style3">Know More Us</a>
                            <a href="project.html" class="th-btn white-btn">Explore Projects</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
```

## Best Practices

1. **Image URLs:** Always use relative paths like `assets/img/filename.jpg`
2. **Highlight Words:** Keep highlighted words short (1-2 words) for better appearance
3. **Titles:** Structure titles as "[Text] [Highlight] [Text]" for proper formatting
4. **Subtitles:** Common subtitles include "Innovative solutions", "Creative design", etc.
5. **Image Optimization:** Ensure images are optimized for web (compressed but good quality)

## Troubleshooting

### Slides Not Appearing
- Check that admin-hero-slider-handler.php file exists
- Verify write permissions on index.html
- Clear browser cache and reload

### Changes Not Saving
- Check browser console for error messages
- Verify that admin-hero-slider-handler.php is in the root directory
- Ensure index.html structure matches the expected format

### Edit/Delete Buttons Not Working
- Ensure the edit JavaScript functions are loaded (check browser console)
- Verify that the slide data is being fetched correctly
- Try refreshing the page

## File Locations

```
/admin-dashboard.php              (Main admin interface)
/admin-hero-slider-handler.php    (Backend processor)
/index.html                       (Frontend with hero slider)
```

## Important Notes

⚠️ **Always backup index.html before making bulk changes**

The handler automatically manages the HTML structure, so manual editing of the slide HTML in index.html is not recommended. Always use the admin interface to make changes.

## API Response Format

All handler responses use this JSON format:

```json
{
    "success": true/false,
    "message": "Status message",
    "data": null or [slide objects]
}
```

### Slide Object Format

```json
{
    "index": 0,
    "image": "assets/img/1349902.jpeg",
    "subtitle": "Innovative solutions",
    "title_part1": "Interior Design for",
    "highlight": "Luxury",
    "title_part2": "Living Spaces."
}
```

---

**Last Updated:** December 25, 2025
