# Hero Slider System - Visual Guide

## System Architecture Diagram

```
┌─────────────────────────────────────────────────────────────────┐
│                    ADMIN DASHBOARD (admin-dashboard.php)         │
│                                                                   │
│  ┌──────────────────────────────────────────────────────────┐  │
│  │ Hero Slider Management Section                           │  │
│  │                                                           │  │
│  │  [Add Slide] [Edit] [Delete] [Edit] [Delete]            │  │
│  │                                                           │  │
│  │  Card 1: Slide preview          Card 2: Slide preview    │  │
│  │  ─────────────────────          ─────────────────────    │  │
│  │  [Image Thumbnail]              [Image Thumbnail]        │  │
│  │  Title Preview                  Title Preview            │  │
│  │  [Edit] [Delete]                [Edit] [Delete]          │  │
│  │                                                           │  │
│  └──────────────────────────────────────────────────────────┘  │
│                                                                   │
└──────────────────────────────────────────────────────────────────┘
                            │
                ┌───────────┼───────────┐
                │           │           │
           [Add]        [Edit]     [Delete]
                │           │           │
                └───────────┼───────────┘
                            │
                      JavaScript AJAX
                       POST Request
                            │
                            ▼
┌─────────────────────────────────────────────────────────────────┐
│        Backend Handler (admin-hero-slider-handler.php)           │
│                                                                   │
│  ┌──────────────────────────────────────────────────────────┐  │
│  │ switch($action) {                                        │  │
│  │   case 'add_slide':    → Create new slide HTML          │  │
│  │   case 'edit_slide':   → Modify existing slide          │  │
│  │   case 'delete_slide': → Remove slide from HTML         │  │
│  │   case 'get_slides':   → Extract all slides             │  │
│  │ }                                                        │  │
│  └──────────────────────────────────────────────────────────┘  │
│                                                                   │
│  ┌──────────────────────────────────────────────────────────┐  │
│  │ File Operations                                          │  │
│  │ 1. Read index.html                                      │  │
│  │ 2. Parse with Regex: /<div class="swiper-slide">.../    │  │
│  │ 3. Modify HTML content                                  │  │
│  │ 4. Write back to index.html                             │  │
│  │ 5. Return JSON response                                 │  │
│  └──────────────────────────────────────────────────────────┘  │
│                                                                   │
└──────────────────────────────────────────────────────────────────┘
                            │
                      JSON Response
                    { success, data }
                            │
                            ▼
┌─────────────────────────────────────────────────────────────────┐
│                 Admin Dashboard (Updated)                        │
│                                                                   │
│  Refresh Display with new slide data                            │
│  Show success/error message                                     │
│  Reload slides from index.html                                  │
│                                                                   │
└─────────────────────────────────────────────────────────────────┘
                            │
                            ▼
┌─────────────────────────────────────────────────────────────────┐
│              index.html (UPDATED AUTOMATICALLY)                   │
│                                                                   │
│  <div class="swiper-wrapper">                                   │
│    <div class="swiper-slide">                                   │
│      <div class="th-hero-bg" data-bg-src="image.jpg"></div>    │
│      <h1 class="hero-title">                                    │
│        Title <span class="text-theme">Highlight</span>...       │
│      </h1>                                                       │
│    </div>                                                        │
│    <!-- More slides... -->                                       │
│  </div>                                                          │
│                                                                   │
└─────────────────────────────────────────────────────────────────┘
                            │
                            ▼
                    LIVE WEBSITE UPDATES ✓
```

## Data Flow Sequence

```
User Action
    │
    ├─── Add Slide ───────────┐
    │                          │
    ├─── Edit Slide ──────────┤──→ Modal Form
    │                          │
    └─── Delete Slide ────────┘
                  │
                  ▼
          Form Data Collected
                  │
                  ▼
         JavaScript Validation
                  │
         ┌────────┴────────┐
         │ Valid          Invalid
         │                  │
         ▼                  ▼
    AJAX POST          Show Error
         │
         ▼
   admin-hero-slider-handler.php
         │
         ├─→ Parse Action
         │
         ├─→ Read index.html
         │
         ├─→ Extract Slides (Regex)
         │
         ├─→ Modify HTML
         │
         ├─→ Write Back
         │
         └─→ JSON Response
              │
              ├─ success: true
              ├─ message: "Success"
              └─ data: [slides]
                  │
                  ▼
            Admin Page Updates
                  │
                  ▼
            Show Success Message
                  │
                  ▼
            Reload Slide List
                  │
                  ▼
         index.html reflects changes ✓
```

## User Action Timeline

```
Step 1: Open Admin Dashboard
   └─→ Hero Slider Section loads

Step 2: Click "Add Slide"
   └─→ Modal form opens with input fields

Step 3: Fill in Slide Details
   ├─→ Background Image URL
   ├─→ Slide Title
   ├─→ Highlight Word (gold color)
   └─→ Subtitle

Step 4: Click "Add Slide" Button
   └─→ AJAX request sent to handler

Step 5: Handler Processes Request
   ├─→ Validates data
   ├─→ Reads index.html
   ├─→ Creates new slide HTML
   ├─→ Inserts into correct location
   ├─→ Writes file
   └─→ Returns success response

Step 6: Admin Page Updates
   ├─→ Closes modal
   ├─→ Shows success message
   ├─→ Reloads slide list
   └─→ New slide visible

Step 7: Website Updates
   └─→ index.html now contains new slide ✓
```

## File Modification Process

```
Original index.html:
───────────────────
...
<div class="swiper-wrapper">
    <div class="swiper-slide">
        <!-- Slide 1 HTML -->
    </div>
    <div class="swiper-slide">
        <!-- Slide 2 HTML -->
    </div>
</div>
...


Add Operation:
───────────────
Find: </div>\s*<div class="slider-pagination">

Insert: <div class="swiper-slide"><!-- New Slide HTML --></div>

Result: New slide added BEFORE slider-pagination div


Edit Operation:
───────────────
Find: Complete slide 1 HTML (regex pattern)
Replace: New slide 1 HTML


Delete Operation:
───────────────
Find: Complete slide HTML (via regex)
Remove: Delete matched content

Result: Slide removed from DOM
```

## Request/Response Flow

### Add Slide Request
```javascript
POST /admin-hero-slider-handler.php
{
    action: "add_slide",
    image: "assets/img/luxury.jpg",
    title: "Interior Design for Living Spaces.",
    highlight: "Luxury",
    subtitle: "Innovative solutions"
}
```

### Handler Response
```json
{
    "success": true,
    "message": "Slide added successfully!",
    "data": [
        {
            "index": 0,
            "image": "assets/img/1349902.jpeg",
            "subtitle": "Innovative solutions",
            "title_part1": "Interior Design for",
            "highlight": "Luxury",
            "title_part2": "Living Spaces."
        },
        {
            "index": 1,
            "image": "assets/img/362537.jpg",
            "subtitle": "Innovative solutions",
            "title_part1": "Interior Design for",
            "highlight": "Inspired",
            "title_part2": "Living Spaces."
        },
        {
            "index": 2,
            "image": "assets/img/luxury.jpg",
            "subtitle": "Innovative solutions",
            "title_part1": "Interior Design for",
            "highlight": "Luxury",
            "title_part2": "Living Spaces."
        }
    ]
}
```

## Component Interaction Map

```
┌──────────────────────┐
│  admin-dashboard.php │ ← User clicks buttons here
└──────────┬───────────┘
           │
        JavaScript
      (AJAX Functions)
           │
           ├─ addHeroSlide()
           ├─ editHeroSlide()
           ├─ deleteHeroSlide()
           ├─ saveHeroSlide()
           └─ updateHeroSlide()
           │
    POST Request with action
           │
           ▼
┌──────────────────────────────────┐
│ admin-hero-slider-handler.php    │ ← Backend processor
│                                   │
│ ├─ Validate input               │
│ ├─ Read/Parse index.html        │
│ ├─ Modify HTML                  │
│ ├─ Write changes                │
│ └─ Return JSON                  │
└──────────┬──────────────────────┘
           │
    JSON Response
           │
           ▼
┌──────────────────────┐
│  admin-dashboard.php │ ← Update display
│  (JavaScript)        │
└──────────┬───────────┘
           │
      Refresh UI
           │
           ▼
┌──────────────────────┐
│   index.html         │ ← Already updated!
│   (Read by handler)  │
└──────────────────────┘
           │
           ▼
┌──────────────────────┐
│   LIVE WEBSITE       │ ← Shows new slider ✓
└──────────────────────┘
```

## State Management

```
Admin Dashboard State Lifecycle:

1. INITIAL STATE
   └─→ Page loads
       └─→ loadHeroSlides() called
           └─→ window.heroSlides = []

2. LOADING STATE
   └─→ AJAX request to handler
   └─→ Show "Loading..." message

3. LOADED STATE
   └─→ Slides fetched from index.html
   └─→ window.heroSlides populated
   └─→ Render slide cards with edit/delete buttons

4. USER INTERACTION
   ├─→ Click Add/Edit/Delete
   └─→ Open modal with form

5. PROCESSING STATE
   └─→ Form submitted
   └─→ Button shows "Adding/Saving/Deleting..."
   └─→ AJAX request sent

6. UPDATED STATE
   └─→ Handler confirms success
   └─→ Page reloads
   └─→ Slides refreshed from updated index.html
   └─→ Back to LOADED STATE

7. ERROR STATE
   └─→ Handler returns error
   └─→ Show error message
   └─→ Stay in current form
```

## Security Checkpoints

```
Request comes in
    │
    ▼
Check Session Auth  ← Must be logged in as admin
    │
    ▼
Validate Action     ← Must be: get_slides, add_slide, edit_slide, or delete_slide
    │
    ▼
Check POST method   ← Must be POST (prevents CSRF)
    │
    ▼
Validate File Path  ← Must be index.html in root
    │
    ▼
Check Permissions   ← File must be readable/writable
    │
    ▼
Validate Input      ← Image URL, title, etc.
    │
    ▼
Escape Output       ← htmlspecialchars() on strings
    │
    ▼
Write to File       ← Safe write operation
    │
    ▼
Return Response     ← No sensitive data leaked
```

---

**This visual guide shows how all components work together to keep your hero slider synchronized!**
