# Payment Method Flow Diagrams

## 1. User Flow Diagram

```
START
  ↓
Load Checkout Page
  ↓
Fill Billing Address
  ↓
Select Shipping Address (Optional)
  ↓
Add Order Notes (Optional)
  ↓
[PAYMENT METHOD SECTION] ← You are here
  ├─→ Click Payment Method
  │     ├─→ Credit Card
  │     ├─→ PayPal
  │     ├─→ Bank Transfer
  │     └─→ Cash on Delivery
  │
  ├─→ Method is Selected
  │     └─→ Visual Highlight (Color change)
  │
  ├─→ Payment Form Appears
  │     ├─→ Credit Card Form
  │     │     ├─→ Card Holder Name
  │     │     ├─→ Card Number (formatted)
  │     │     ├─→ Expiry Date (MM/YY)
  │     │     └─→ CVV
  │     │
  │     ├─→ PayPal Form
  │     │     └─→ PayPal Email
  │     │
  │     ├─→ Bank Transfer Form
  │     │     └─→ Confirmation Checkbox
  │     │
  │     └─→ COD Form
  │           └─→ Agreement Checkbox
  │
  ├─→ Enter Payment Details
  │     └─→ Real-Time Validation
  │           ├─→ Valid → Green indicator
  │           └─→ Invalid → Red + Error message
  │
  ├─→ All Details Valid?
  │     ├─→ YES → Can Submit
  │     └─→ NO → Form Disabled, show errors
  │
  ├─→ Click "Place Order"
  │     └─→ Validate All Fields
  │           ├─→ All Valid → Submit
  │           └─→ Error Found → Show toast
  │
  ├─→ Order Confirmation Modal
  │     ├─→ Order Number
  │     ├─→ Order Total
  │     └─→ Action Buttons
  │
  ├─→ Redirect to Order Confirmation
  │
END
```

---

## 2. Payment Method Selection Flow

```
┌─────────────────────────────────────────────────────┐
│         PAYMENT METHOD SELECTION                    │
├─────────────────────────────────────────────────────┤
│                                                     │
│  ┌────────────────────────────────────────────┐   │
│  │ 💳 Credit Card (DEFAULT SELECTED)          │   │
│  │ Secure payment via credit card             │   │
│  └────────────────────────────────────────────┘   │
│           ↑                                         │
│           │ Click anywhere on card                │
│           │                                         │
│  ┌────────────────────────────────────────────┐   │
│  │ 🅿️ PayPal                                  │   │
│  │ Secure payment via PayPal                  │   │
│  └────────────────────────────────────────────┘   │
│                                                     │
│  ┌────────────────────────────────────────────┐   │
│  │ 🏦 Bank Transfer                          │   │
│  │ Direct bank transfer to our account       │   │
│  └────────────────────────────────────────────┘   │
│                                                     │
│  ┌────────────────────────────────────────────┐   │
│  │ 💰 Cash on Delivery                        │   │
│  │ Pay when you receive your order           │   │
│  └────────────────────────────────────────────┘   │
│                                                     │
└─────────────────────────────────────────────────────┘
```

---

## 3. Form Switching Animation

```
Initial State (Credit Card Selected):

┌─────────────────────────────────────────────────┐
│ PAYMENT FORMS CONTAINER                         │
├─────────────────────────────────────────────────┤
│                                                 │
│  ✓ CREDIT CARD FORM (ACTIVE/VISIBLE)          │
│    Card Holder Name: [_________________]       │
│    Card Number:      [_________________]       │
│    Expiry / CVV:     [_______] [____]          │
│                                                 │
│  ✗ PayPal Form (hidden)                       │
│  ✗ Bank Transfer Form (hidden)                │
│  ✗ COD Form (hidden)                          │
│                                                 │
└─────────────────────────────────────────────────┘


User clicks PayPal → Animation:

  Fade out Credit Card Form
           ↓
  Slide in PayPal Form
           ↓
  
┌─────────────────────────────────────────────────┐
│ PAYMENT FORMS CONTAINER                         │
├─────────────────────────────────────────────────┤
│                                                 │
│  ✗ Credit Card Form (hidden)                  │
│                                                 │
│  ✓ PAYPAL FORM (ACTIVE/VISIBLE)               │
│    PayPal Email: [_______________________]     │
│    ℹ️ You will be redirected to PayPal...      │
│                                                 │
│  ✗ Bank Transfer Form (hidden)                │
│  ✗ COD Form (hidden)                          │
│                                                 │
└─────────────────────────────────────────────────┘
```

---

## 4. Credit Card Validation Flow

```
User Input                Validation Logic              Output
─────────────────────────────────────────────────────────────────────

"John" (typed)        ├─→ Check length (< 3)    ❌ ERROR: too short
                      └─→ Show error message


"John Doe" (complete) ├─→ Check length (≥ 3)    ✅ VALID: Name ok
                      ├─→ Check letters only    ✅ VALID: Only letters
                      └─→ Green border shown


"4532123456789010"    ├─→ Check 16 digits       ✅ VALID: Right length
(card number)         ├─→ Luhn algorithm        ✅ VALID: Checksum ok
                      ├─→ Auto-format           "4532 1234 5678 9010"
                      └─→ Green border shown


"12/25" (expiry)      ├─→ Check MM/YY format    ✅ VALID: Format ok
                      ├─→ Valid month (1-12)    ✅ VALID: December ok
                      ├─→ Not expired           ✅ VALID: Future date
                      └─→ Green border shown


"123" (CVV)           ├─→ Check 3-4 digits      ✅ VALID: Correct length
                      └─→ Green border shown


Form Submission:      ├─→ All fields valid?     ✅ YES → SUBMIT
                      └─→ Show errors & block   ❌ NO → Prevent submit
```

---

## 5. Real-Time Validation Workflow

```
User Types in Card Number Field
  ↓
Input Event Triggered
  ↓
Remove Non-Numeric Characters
  ↓
Format with Spaces Every 4 Digits
  ↓
Display Formatted Value: "4532 1234 5678 9010"
  ↓
Validate Card Number
  ├─→ Check length (must be 16)
  ├─→ Run Luhn algorithm
  └─→ Determine valid/invalid
  ↓
Update Visual Feedback
  ├─→ Valid: Green border, show checkmark
  └─→ Invalid: Red border, show error message
  ↓
Update Form Submission State
  ├─→ All fields valid: Enable submit button
  └─→ Any field invalid: Disable submit button
```

---

## 6. Error Handling Flow

```
User Submits Form with Errors
  ↓
Payment Validation Function Called
  ├─→ Check payment method type
  │    ├─→ "credit_card" → Validate credit card
  │    ├─→ "paypal" → Validate PayPal email
  │    ├─→ "bank_transfer" → Check checkbox
  │    └─→ "cod" → Check checkbox
  │
  ├─→ For each field in selected method:
  │    ├─→ Validate according to rules
  │    ├─→ If invalid:
  │    │    ├─→ Add .error class to input
  │    │    ├─→ Show error message below field
  │    │    └─→ Track validation failure
  │    └─→ If valid:
  │         ├─→ Remove .error class
  │         └─→ Clear error message
  │
  ├─→ All fields valid?
  │    ├─→ YES → Allow form submission
  │    └─→ NO → Block submission, show toast
  │
  ├─→ User Sees:
  │    ├─→ Red borders on invalid fields
  │    ├─→ Error messages (red text) below fields
  │    ├─→ Toast notification with error
  │    └─→ Submit button remains disabled
  │
  └─→ User Corrects Errors
       └─→ Real-time feedback helps fix
```

---

## 7. Validation Rules Tree

```
┌─ PAYMENT METHOD ─────────────────────────────────────────┐
│                                                           │
├─ Credit Card ─────────────────────────────────────────┐  │
│  │                                                    │  │
│  ├─ Card Holder Name                                │  │
│  │  ├─ Required (not empty)                         │  │
│  │  ├─ Min 3 characters                             │  │
│  │  └─ Letters and spaces only                      │  │
│  │                                                    │  │
│  ├─ Card Number                                     │  │
│  │  ├─ Required (not empty)                         │  │
│  │  ├─ Exactly 16 digits                            │  │
│  │  └─ Valid Luhn checksum                          │  │
│  │                                                    │  │
│  ├─ Expiry Date                                     │  │
│  │  ├─ Required (not empty)                         │  │
│  │  ├─ Format MM/YY                                 │  │
│  │  ├─ Valid month (01-12)                          │  │
│  │  └─ Not expired                                  │  │
│  │                                                    │  │
│  └─ CVV                                             │  │
│     ├─ Required (not empty)                         │  │
│     └─ 3 or 4 digits                                │  │
│                                                    │  │
├─────────────────────────────────────────────────────┘  │
│                                                           │
├─ PayPal ────────────────────────────────────────────┐  │
│  │                                                   │  │
│  └─ PayPal Email                                   │  │
│     ├─ Required (not empty)                        │  │
│     └─ Valid email format                          │  │
│                                                   │  │
├─────────────────────────────────────────────────────┘  │
│                                                           │
├─ Bank Transfer ──────────────────────────────────────┐  │
│  │                                                   │  │
│  └─ Confirmation Checkbox                          │  │
│     └─ Must be checked                             │  │
│                                                   │  │
├─────────────────────────────────────────────────────┘  │
│                                                           │
├─ Cash on Delivery ────────────────────────────────────┐  │
│  │                                                   │  │
│  └─ Agreement Checkbox                             │  │
│     └─ Must be checked                             │  │
│                                                   │  │
└─────────────────────────────────────────────────────┘  │
│                                                           │
└───────────────────────────────────────────────────────────┘
```

---

## 8. State Diagram

```
                    ┌────────────────────┐
                    │  Initial State     │
                    │ Credit Card Active │
                    └─────────┬──────────┘
                              │
                              ↓
                 ┌────────────────────────┐
                 │ User Clicks Method     │
                 │ (Any payment method)   │
                 └────────┬───────────────┘
                          │
                          ↓
         ┌────────────────────────────────┐
         │ Method Selected State          │
         │ (Visual highlight on card)     │
         └────────┬───────────────────────┘
                  │
                  ↓
    ┌─────────────────────────────────┐
    │ Form Appears State              │
    │ (Smooth animation)              │
    └────────┬────────────────────────┘
             │
             ↓
    ┌─────────────────────────────────┐
    │ User Input State                │
    │ (Real-time validation)          │
    └────┬─────────────────┬──────────┘
         │                 │
    Valid│                 │Invalid
         ↓                 ↓
    ┌──────────┐      ┌────────────┐
    │ Valid    │      │ Invalid    │
    │ State    │      │ State      │
    │ ✓ Green  │      │ ✗ Red      │
    └────┬─────┘      └────┬───────┘
         │                 │
         └──────┬──────────┘
                │ User Fixes Errors
                ↓
    ┌───────────────────────────────┐
    │ Ready to Submit State         │
    │ All fields valid, green       │
    └────────┬─────────────────────┘
             │
             ↓
    ┌───────────────────────────────┐
    │ Form Submitted State          │
    │ (Processing payment)          │
    └────────┬─────────────────────┘
             │
             ↓
    ┌───────────────────────────────┐
    │ Confirmation State            │
    │ (Order confirmed modal)        │
    └───────────────────────────────┘
```

---

## 9. Data Flow Diagram

```
                   ┌──────────────┐
                   │ User Input   │
                   │ (Keyboard)   │
                   └──────┬───────┘
                          │
                          ↓
                  ┌───────────────┐
                  │ Event Handler │
                  │ (input, blur) │
                  └───────┬───────┘
                          │
                          ↓
          ┌───────────────────────────┐
          │ Input Processor           │
          │ (Format, clean, trim)     │
          └───────┬───────────────────┘
                  │
                  ↓
      ┌──────────────────────────────┐
      │ Validation Function          │
      │ (Check rules, show errors)   │
      └───────┬──────────────────────┘
              │
    ┌─────────┴─────────┐
    │                   │
Valid│                   │Invalid
    │                   │
    ↓                   ↓
┌─────────┐        ┌──────────┐
│ Update  │        │ Update   │
│ UI      │        │ UI       │
│ (Green) │        │ (Red)    │
└────┬────┘        └────┬─────┘
     │                  │
     └────────┬─────────┘
              │
              ↓
    ┌──────────────────────────┐
    │ Update Form State        │
    │ (Enable/disable submit)  │
    └──────────────────────────┘
              │
              ↓
    ┌──────────────────────────┐
    │ Ready for Submit         │
    │ (If all valid)           │
    └──────────────────────────┘
```

---

## 10. Integration Points

```
CHECKOUT PAGE
│
├─ Billing Address Form
├─ Shipping Address Form  
├─ Order Notes
│
└─ PAYMENT METHOD SECTION ←─────────┐
   │                                 │
   ├─ Payment Methods (4 options)   │
   │  ├─ Credit Card ────→ Form ─┐
   │  ├─ PayPal ────────→ Form ─┤─→ Validation ─→ Submit
   │  ├─ Bank Transfer ─→ Form ─┤
   │  └─ COD ────────→ Form ─┘
   │
   └─ Place Order Button
      │
      ↓
   auth-system/checkout-api.php
      │
      ├─ Process Payment
      ├─ Create Order
      └─ Send Confirmation
         │
         ↓
      order-confirmation.php
         │
         ↓
      Order Status Page
```

---

These diagrams show the complete flow, state transitions, validation processes, and data movement through the payment method system.
