# Payment Method Validation - Test Cases

## Test Credit Card Validation

### Valid Test Cases
```
Test Case 1: Valid Credit Card
Card Holder: John Doe
Card Number: 4532123456789010 (valid Luhn)
Expiry: 12/25 (future date)
CVV: 123
Expected: ✅ PASS - All fields valid

Test Case 2: Valid Credit Card - 17 chars
Card Holder: Mary Jane Smith
Card Number: 5425233010103442 (valid Luhn)
Expiry: 06/26 (future date)
CVV: 456
Expected: ✅ PASS - All fields valid

Test Case 3: Valid 4-digit CVV
Card Holder: Robert Johnson
Card Number: 378282246310005 (valid Luhn, 15 digits)
Expiry: 09/27
CVV: 1234
Expected: ✅ PASS - All fields valid
```

### Invalid Test Cases

#### Card Holder Name
```
Test: Empty card holder
Card Holder: [empty]
Expected: ❌ FAIL - "Card holder name is required"

Test: Too short name
Card Holder: Jo
Expected: ❌ FAIL - "Card holder name must be at least 3 characters"

Test: Numbers in name
Card Holder: John Doe 123
Expected: ❌ FAIL - "Card holder name can only contain letters"

Test: Special characters
Card Holder: John@Doe
Expected: ❌ FAIL - "Card holder name can only contain letters"
```

#### Card Number
```
Test: Empty card number
Card Number: [empty]
Expected: ❌ FAIL - "Card number is required"

Test: Less than 16 digits
Card Number: 4532 1234 5678 90
Expected: ❌ FAIL - "Card number must be 16 digits"

Test: Invalid Luhn checksum
Card Number: 4532 1234 5678 9011 (invalid checksum)
Expected: ❌ FAIL - "Invalid card number"

Test: Non-numeric
Card Number: ABCD 1234 5678 9010
Expected: ❌ FAIL - (only digits accepted)
```

#### Expiry Date
```
Test: Empty expiry
Expiry: [empty]
Expected: ❌ FAIL - "Expiry date is required"

Test: Wrong format
Expiry: 12-25 (dash instead of slash)
Expected: ❌ FAIL - "Expiry date must be in MM/YY format"

Test: Invalid month
Expiry: 13/25
Expected: ❌ FAIL - "Invalid month"

Test: Expired date (current month/year: 12/24)
Expiry: 11/24
Expected: ❌ FAIL - "Card has expired"

Test: Expired card same month/year
Expiry: 12/24 (if current is 12/24)
Expected: ❌ FAIL - "Card has expired"
```

#### CVV
```
Test: Empty CVV
CVV: [empty]
Expected: ❌ FAIL - "CVV is required"

Test: Only 2 digits
CVV: 12
Expected: ❌ FAIL - "CVV must be 3 or 4 digits"

Test: 5 digits
CVV: 12345
Expected: ❌ FAIL - (accepts only 4 max)

Test: Non-numeric
CVV: ABC
Expected: ❌ FAIL - (only digits accepted)
```

---

## Test PayPal Validation

### Valid Test Cases
```
Test Case 1: Valid PayPal Email
Email: user@example.com
Expected: ✅ PASS - Valid email format

Test Case 2: Valid with subdomain
Email: user@mail.example.co.uk
Expected: ✅ PASS - Valid email format

Test Case 3: Plus addressing
Email: user+tag@example.com
Expected: ✅ PASS - Valid email format
```

### Invalid Test Cases
```
Test: Empty email
Email: [empty]
Expected: ❌ FAIL - "PayPal email is required"

Test: No @ symbol
Email: userexample.com
Expected: ❌ FAIL - "Please enter a valid email address"

Test: No domain
Email: user@
Expected: ❌ FAIL - "Please enter a valid email address"

Test: No top-level domain
Email: user@example
Expected: ❌ FAIL - "Please enter a valid email address"

Test: Space in email
Email: user @example.com
Expected: ❌ FAIL - (spaces not allowed)

Test: Multiple @ symbols
Email: user@@example.com
Expected: ❌ FAIL - "Please enter a valid email address"
```

---

## Test Bank Transfer Validation

### Valid Test Cases
```
Test Case 1: Checkbox checked
Confirm: ☑ I confirm I will transfer the amount
Expected: ✅ PASS - Checkbox confirmed

Test Case 2: User acknowledges bank details
Display: Bank Transfer Information shown
Action: User reviews and checks box
Expected: ✅ PASS - Ready to place order
```

### Invalid Test Cases
```
Test: Checkbox not checked
Confirm: ☐ I confirm I will transfer the amount
Expected: ❌ FAIL - "You must confirm to proceed with bank transfer"

Test: Form submitted without checking
Click: Place Order
Confirm: ☐ (unchecked)
Expected: ❌ FAIL - Form submission blocked
```

---

## Test Cash on Delivery Validation

### Valid Test Cases
```
Test Case 1: Checkbox checked
Agree: ☑ I understand and agree to pay on delivery
Expected: ✅ PASS - COD terms accepted

Test Case 2: User reads terms and agrees
Display: COD Terms shown
Action: User checks box
Expected: ✅ PASS - Ready to place order
```

### Invalid Test Cases
```
Test: Checkbox not checked
Agree: ☐ I understand and agree to pay on delivery
Expected: ❌ FAIL - "You must agree to the terms to proceed"

Test: Form submitted without checking
Click: Place Order
Agree: ☐ (unchecked)
Expected: ❌ FAIL - Form submission blocked
```

---

## Test Method Switching

```
Test Case 1: Switch from Credit Card to PayPal
1. Credit Card form is visible
2. Click on PayPal method
3. Expected: ✅ PayPal form appears, credit card errors cleared

Test Case 2: Switch from PayPal to Bank Transfer
1. PayPal form is visible
2. Click on Bank Transfer method
3. Expected: ✅ Bank Transfer form appears with checkbox

Test Case 3: Switch to COD
1. Any form is visible
2. Click on Cash on Delivery method
3. Expected: ✅ COD form appears with terms

Test Case 4: Return to Credit Card
1. Another payment form is visible
2. Click on Credit Card method
3. Expected: ✅ Credit Card form appears
```

---

## Test Form Auto-Formatting

```
Test: Card Number Auto-Format
Input: 4532123456789010
Expected: 4532 1234 5678 9010 (spaces added every 4 digits)

Test: Expiry Auto-Format
Input: 1225
Expected: 12/25 (slash added after 2 digits)

Test: Non-numeric in card number
Input: 4532-1234-5678-9010
Expected: 45321234567890 (non-digits removed, then formatted)
```

---

## Integration Tests

```
Test Case 1: Complete Credit Card Flow
1. Load checkout page
2. Fill all billing details
3. Click Credit Card method
4. Enter valid credit card info
5. Submit form
Expected: ✅ Order placed successfully

Test Case 2: Complete PayPal Flow
1. Load checkout page
2. Fill all billing details
3. Click PayPal method
4. Enter valid PayPal email
5. Submit form
Expected: ✅ Order placed successfully

Test Case 3: Complete Bank Transfer Flow
1. Load checkout page
2. Fill all billing details
3. Click Bank Transfer method
4. Check confirmation box
5. Submit form
Expected: ✅ Order placed successfully

Test Case 4: Complete COD Flow
1. Load checkout page
2. Fill all billing details
3. Click Cash on Delivery method
4. Check agreement box
5. Submit form
Expected: ✅ Order placed successfully
```

---

## Edge Cases

```
Test: Rapid method switching
Action: Click between methods rapidly
Expected: ✅ UI updates correctly, no crashes

Test: Copy-paste large text into card holder
Paste: Very long text (100+ chars)
Expected: ✅ Handled gracefully, validation works

Test: Paste valid card number with spaces
Paste: 4532 1234 5678 9010
Expected: ✅ Spaces preserved or normalized correctly

Test: Tab through fields
Tab through all payment fields
Expected: ✅ Validation triggers on blur for each field

Test: Browser back button after validation errors
Steps: Fill invalid data, see errors, click back
Expected: ✅ Can return to form, errors still show
```

---

## Valid Test Card Numbers (Luhn Algorithm)

Use these for testing:

```
Visa: 4532123456789010
Visa: 4111111111111111
Visa: 4012888888881881

Mastercard: 5425233010103442
Mastercard: 5105105105105100
Mastercard: 2221000010000003

American Express: 378282246310005
American Express: 371449635398431

Discover: 6011111111111117
Discover: 6011000990139424
```

---

## Performance Tests

```
Test: Real-time validation performance
Action: Type quickly in each field
Expected: ✅ Validation runs smoothly (no lag)

Test: Large form submission
Action: Submit form with all fields filled
Expected: ✅ Processing completes within 3-5 seconds

Test: Error message display speed
Action: Type invalid data
Expected: ✅ Error appears within 100ms
```

---

## Browser Compatibility Tests

- [ ] Chrome (latest)
- [ ] Firefox (latest)
- [ ] Safari (latest)
- [ ] Edge (latest)
- [ ] Mobile Chrome
- [ ] Mobile Safari

---

## Accessibility Tests

- [ ] Tab navigation works through all fields
- [ ] Error messages are announced to screen readers
- [ ] Color contrast meets WCAG standards
- [ ] All fields have proper labels
- [ ] Focus states are visible
