# 📧 PHPMailer Manual Installation (No Composer)

## Download PHPMailer Directly

### Step 1: Download Files
Go to: https://github.com/PHPMailer/PHPMailer/releases

**Download the latest release** (e.g., PHPMailer 6.9.x):
- Click the `.zip` file
- Extract to: `C:\xampp\htdocs\interior\auth-system\PHPMailer\`

### Step 2: Folder Structure
After extraction, you should have:
```
auth-system/
  ├── PHPMailer/
  │   ├── src/
  │   │   ├── PHPMailer.php
  │   │   ├── SMTP.php
  │   │   └── Exception.php
  │   ├── LICENSE
  │   └── README.md
  ├── EmailService.php
  └── register.php
```

---

## Simple Alternative: Download Just 3 Files

Instead of the whole repo, download only these 3 files:

### **File 1: PHPMailer.php**
- **From**: https://raw.githubusercontent.com/PHPMailer/PHPMailer/master/src/PHPMailer.php
- **Save to**: `C:\xampp\htdocs\interior\auth-system\PHPMailer\PHPMailer.php`

### **File 2: SMTP.php**
- **From**: https://raw.githubusercontent.com/PHPMailer/PHPMailer/master/src/SMTP.php
- **Save to**: `C:\xampp\htdocs\interior\auth-system\PHPMailer\SMTP.php`

### **File 3: Exception.php**
- **From**: https://raw.githubusercontent.com/PHPMailer/PHPMailer/master/src/Exception.php
- **Save to**: `C:\xampp\htdocs\interior\auth-system\PHPMailer\Exception.php`

---

## Update EmailService.php

Once files are in place, update your `EmailService.php`:

```php
<?php
class EmailService {
    
    // Try PHPMailer first, fallback to mail()
    public static function sendEmail($to, $subject, $body, $isHtml = true) {
        try {
            // Try PHPMailer if available
            if (self::usePHPMailer()) {
                return self::sendWithPHPMailer($to, $subject, $body, $isHtml);
            }
        } catch (Exception $e) {
            error_log("PHPMailer error: " . $e->getMessage());
        }
        
        // Fallback to PHP mail()
        return self::sendWithPHPMail($to, $subject, $body, $isHtml);
    }
    
    // Check if PHPMailer is available
    private static function usePHPMailer() {
        return file_exists(__DIR__ . '/PHPMailer/PHPMailer.php');
    }
    
    // Send using PHPMailer
    private static function sendWithPHPMailer($to, $subject, $body, $isHtml) {
        require_once(__DIR__ . '/PHPMailer/PHPMailer.php');
        require_once(__DIR__ . '/PHPMailer/SMTP.php');
        require_once(__DIR__ . '/PHPMailer/Exception.php');
        
        $mail = new \PHPMailer\PHPMailer\PHPMailer(true);
        
        try {
            // SMTP Configuration
            $mail->isSMTP();
            $mail->Host = 'smtp.gmail.com';  // Change based on provider
            $mail->SMTPAuth = true;
            $mail->Username = 'your-email@gmail.com';  // Your email
            $mail->Password = 'your-app-password';      // App password
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
            $mail->Port = 587;
            
            // Email details
            $mail->setFrom('your-email@gmail.com', 'Interior Design');
            $mail->addAddress($to);
            $mail->Subject = $subject;
            $mail->isHTML($isHtml);
            $mail->Body = $body;
            
            // Send
            return $mail->send();
            
        } catch (Exception $e) {
            error_log("Message could not be sent. Mailer Error: {$mail->ErrorInfo}");
            return false;
        }
    }
    
    // Fallback: Send using PHP mail()
    private static function sendWithPHPMail($to, $subject, $body, $isHtml) {
        $headers = "MIME-Version: 1.0\r\n";
        $headers .= $isHtml ? "Content-type: text/html; charset=UTF-8\r\n" : "";
        $headers .= "From: noreply@interiordesign.local\r\n";
        
        return mail($to, $subject, $body, $headers);
    }
}
```

---

## Gmail Setup (Recommended)

### Step 1: Enable 2-Factor Authentication
1. Go to: https://myaccount.google.com/security
2. Enable "2-Step Verification"

### Step 2: Generate App Password
1. Go to: https://myaccount.google.com/apppasswords
2. Select: Phone → Gmail
3. Click "Generate"
4. Copy the 16-character password

### Step 3: Update EmailService.php
```php
$mail->Username = 'your-email@gmail.com';
$mail->Password = 'xxxx xxxx xxxx xxxx';  // The 16-char password (without spaces)
```

---

## Alternative: Outlook/Microsoft

```php
$mail->Host = 'smtp-mail.outlook.com';
$mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
$mail->Port = 587;
$mail->Username = 'your-email@outlook.com';
$mail->Password = 'your-password';
```

---

## Alternative: Mailtrap (Testing)

Free for testing without real email:

1. Go to: https://mailtrap.io
2. Sign up (free)
3. Get SMTP credentials
4. Update:
```php
$mail->Host = 'smtp.mailtrap.io';
$mail->Port = 2525;
$mail->Username = 'your-mailtrap-username';
$mail->Password = 'your-mailtrap-password';
```

---

## Test It Works

Create: `C:\xampp\htdocs\interior\test-phpmailer-manual.php`

```php
<?php
require_once 'auth-system/EmailService.php';

$result = EmailService::sendEmail(
    'test@example.com',
    'PHPMailer Test',
    '<h1>Hello!</h1><p>PHPMailer is working!</p>',
    true
);

if ($result) {
    echo "✅ Email sent successfully!";
} else {
    echo "❌ Email failed. Check server logs.";
}
?>
```

Visit: http://localhost/interior/test-phpmailer-manual.php

---

## Folder Structure Verification

```bash
# Check files exist
dir C:\xampp\htdocs\interior\auth-system\PHPMailer\
```

Should show:
```
PHPMailer.php
SMTP.php
Exception.php
```

---

## Troubleshooting

### **"Class not found" Error**
- Check path in `require_once` statements
- Use absolute path: `__DIR__ . '/PHPMailer/PHPMailer.php'`

### **Gmail "App password" Not Working**
- Go to: https://myaccount.google.com/apppasswords
- Make sure 2-Factor Authentication is enabled
- Regenerate password if needed

### **SMTP Connection Failed**
- Check firewall blocking port 587
- Try port 465 instead (ENCRYPTION_SMTPS)
- Test with Mailtrap first (port 2525)

### **Email Not Received**
- Check spam/junk folder
- Check server error logs: `C:\xampp\php\error.log`
- Verify credentials are correct

---

## Quick Setup Checklist

- [ ] Downloaded PHPMailer files to `auth-system/PHPMailer/`
- [ ] Created/Updated `EmailService.php`
- [ ] Set SMTP credentials (Gmail/Outlook/Mailtrap)
- [ ] Tested with `test-phpmailer-manual.php`
- [ ] Emails received successfully ✅

---

## Integration Points

### In register.php
```php
// OTP will now send via PHPMailer automatically
$result = EmailService::sendEmailVerificationOTP($email, $otp);
if ($result) {
    echo "OTP sent to your email!";
}
```

### In login.php
```php
// 2FA sends via PHPMailer
EmailService::send2FAOTP($user_email, $otp_code);
```

### In password reset
```php
// Password reset emails send via PHPMailer
EmailService::sendPasswordResetEmail($email, $reset_token);
```

---

**Status: Ready to use PHPMailer without Composer!** 🚀
