# 📧 PHPMailer Manual Installation - Complete Setup

Since Composer didn't work, here's your **no-dependency alternative** for PHPMailer:

---

## 🎯 What You Need to Do (4 Simple Steps)

### **Step 1: Download PHPMailer Files** (5 minutes)
Run this in your workspace:
```bash
download-phpmailer.bat
```

Or manually download 3 files from GitHub to:
```
C:\xampp\htdocs\interior\auth-system\PHPMailer\
```

See: [PHPMAILER_QUICK_START.md](PHPMAILER_QUICK_START.md)

### **Step 2: Get Gmail App Password** (2 minutes)
1. Go to: https://myaccount.google.com/apppasswords
2. Select: Phone → Gmail
3. Generate and copy 16-character password

### **Step 3: Update EmailService.php** (1 minute)
Edit: `auth-system/EmailService.php`

Line ~53-54:
```php
$mail->Username = 'your-real-email@gmail.com';  // ← Your email
$mail->Password = 'xxxx xxxx xxxx xxxx';         // ← App password (no spaces)
```

Line ~57:
```php
$mail->setFrom('your-real-email@gmail.com', 'Interior Design');
```

### **Step 4: Test It** (1 minute)
Visit: http://localhost/interior/verify-phpmailer.php

Or run: http://localhost/interior/test-send-email.php

---

## 📁 Files Created for You

| File | Purpose |
|------|---------|
| `download-phpmailer.bat` | Auto-download PHPMailer files |
| `PHPMAILER_QUICK_START.md` | Step-by-step setup guide |
| `PHPMAILER_MANUAL_INSTALL.md` | Detailed manual installation |
| `verify-phpmailer.php` | Check your setup status |
| `EmailService.php` | Updated to work with/without Composer |

---

## 🔧 How It Works

Your `EmailService.php` now:
1. **Checks** if PHPMailer files exist
2. **Uses** PHPMailer if available
3. **Falls back** to PHP mail() if needed
4. **Logs** all emails in dev mode

```php
// Automatic detection - no configuration needed!
if (self::phpmailerAvailable()) {
    return self::sendWithPHPMailer($to, $subject, $body);
}
return self::sendWithPHPMail($to, $subject, $body);
```

---

## ✅ Verification Checklist

- [ ] Ran `download-phpmailer.bat`
- [ ] Confirmed 3 files exist in `auth-system/PHPMailer/`
- [ ] Created Gmail app password
- [ ] Updated `EmailService.php` with credentials
- [ ] Visited `verify-phpmailer.php` (shows green ✓)
- [ ] Ran `test-send-email.php` successfully
- [ ] Email received in inbox ✅

---

## 📝 Your Registration Flow Now Works Like This

```
User fills form → Clicks Register
    ↓
EmailService::generateOTP() → Creates 6-digit code
    ↓
EmailService::sendEmailVerificationOTP()
    ↓
PHPMailer detects files → Uses Gmail SMTP
    ↓
Email sent to user's inbox
    ↓
User enters OTP → Account verified ✅
```

---

## 🚀 Next: Use in Your Code

Your `register.php` already has this:

```php
// Generate OTP
$otp = EmailService::generateOTP();

// Send via email (automatically uses PHPMailer!)
EmailService::sendEmailVerificationOTP($email, $name, $otp);
```

No additional configuration needed!

---

## 🐛 Troubleshooting

### Files not downloading?
→ Use Option B in [PHPMAILER_QUICK_START.md](PHPMAILER_QUICK_START.md)
→ Manually download from GitHub links

### "Authentication failed"?
→ Make sure Gmail app password is correct
→ Verify 2-Factor Authentication is enabled
→ Check password has no spaces

### Email not received?
→ Check SPAM folder
→ Verify email address is correct
→ Check `error.log` for PHP errors

### Verify-phpmailer.php shows FAIL?
→ PHPMailer files missing
→ Run `download-phpmailer.bat`
→ Check folder path is exactly: `auth-system/PHPMailer/`

---

## 📚 Documentation

- **Quick Start**: [PHPMAILER_QUICK_START.md](PHPMAILER_QUICK_START.md)
- **Detailed Setup**: [PHPMAILER_MANUAL_INSTALL.md](PHPMAILER_MANUAL_INSTALL.md)
- **SSL Certificate Fix**: [FIX_SSL_CERTIFICATE.md](FIX_SSL_CERTIFICATE.md)

---

## 💡 Key Points

✅ **No Composer required** - Just 3 PHP files
✅ **Automatic detection** - Works with or without PHPMailer
✅ **Fallback support** - Uses PHP mail() if PHPMailer fails
✅ **Already configured** - register.php and login.php ready to use
✅ **Gmail SMTP** - Free, reliable, production-ready

---

## 🎉 Status

**EmailService.php**: ✅ Updated and ready
**Register Flow**: ✅ OTP sending integrated
**Fallback System**: ✅ PHP mail() backup available
**Documentation**: ✅ Complete setup guides provided

**Next Step**: Download files and add Gmail credentials!

---

**Ready to send real emails?** Start with [PHPMAILER_QUICK_START.md](PHPMAILER_QUICK_START.md) 🚀
