# 🚀 Quick Manual PHPMailer Installation Guide

## Step 1: Download PHPMailer Files (2 minutes)

### Option A: Download Full Release (Recommended)
1. Go to: https://github.com/PHPMailer/PHPMailer/releases
2. Download the latest `.zip` file
3. Extract to: `C:\xampp\htdocs\interior\auth-system\PHPMailer\`

### Option B: Download 3 Essential Files (Faster)

Right-click and "Save link as..." for each:

1. **PHPMailer.php**
   - From: https://raw.githubusercontent.com/PHPMailer/PHPMailer/master/src/PHPMailer.php
   - To: `C:\xampp\htdocs\interior\auth-system\PHPMailer\PHPMailer.php`

2. **SMTP.php**
   - From: https://raw.githubusercontent.com/PHPMailer/PHPMailer/master/src/SMTP.php
   - To: `C:\xampp\htdocs\interior\auth-system\PHPMailer\SMTP.php`

3. **Exception.php**
   - From: https://raw.githubusercontent.com/PHPMailer/PHPMailer/master/src/Exception.php
   - To: `C:\xampp\htdocs\interior\auth-system\PHPMailer\Exception.php`

---

## Step 2: Get Gmail Credentials (1 minute)

### A. Enable 2-Factor Authentication
1. Go to: https://myaccount.google.com/security
2. Click "2-Step Verification"
3. Follow the setup

### B. Generate App Password
1. Go to: https://myaccount.google.com/apppasswords
2. Select: Phone → Gmail
3. Click "Generate"
4. **Copy the 16-character password** (e.g., `abcd efgh ijkl mnop`)

---

## Step 3: Update EmailService.php (1 minute)

Edit: `C:\xampp\htdocs\interior\auth-system\EmailService.php`

Find these lines:
```php
$mail->Username = 'your-email@gmail.com';          // ⚠️ UPDATE THIS
$mail->Password = 'your-app-password';             // ⚠️ UPDATE THIS
```

Replace with your info:
```php
$mail->Username = 'your-real-email@gmail.com';
$mail->Password = 'xxxx xxxx xxxx xxxx';  // Remove spaces: xxxxxxxxxxxxxxxxxx
```

Also update the "From" email:
```php
$mail->setFrom('your-real-email@gmail.com', 'Interior Design');
```

---

## Step 4: Test It Works (1 minute)

Create file: `C:\xampp\htdocs\interior\test-send-email.php`

```php
<?php
require_once 'auth-system/EmailService.php';

// Test sending
$result = EmailService::sendEmailVerificationOTP(
    'your-test-email@gmail.com',
    'Test User',
    '123456'
);

if ($result) {
    echo "✅ Email sent successfully!";
} else {
    echo "❌ Email failed. Check error logs.";
}
?>
```

Visit: http://localhost/interior/test-send-email.php

Check your email inbox for the test message!

---

## Step 5: Use in Registration (Already Done!)

Your `register.php` already has this code:

```php
// Generate and send OTP
$otp = EmailService::generateOTP();
EmailService::sendEmailVerificationOTP($user_email, $user_name, $otp);
```

It will **automatically**:
- Use PHPMailer if files exist
- Fallback to PHP mail() if PHPMailer fails
- Log all emails in dev mode

---

## Folder Structure Check

Your files should be organized like:
```
auth-system/
├── EmailService.php          ← Updated version
├── PHPMailer/               ← Folder (create if missing)
│   ├── PHPMailer.php       ← Downloaded file
│   ├── SMTP.php            ← Downloaded file
│   └── Exception.php        ← Downloaded file
├── register.php
├── login.php
└── other files...
```

---

## Troubleshooting

### "Class not found" Error
- [ ] Check folder exists: `C:\xampp\htdocs\interior\auth-system\PHPMailer\`
- [ ] Check 3 files are there: `PHPMailer.php`, `SMTP.php`, `Exception.php`
- [ ] Try refresh page (Ctrl+F5)

### "Authentication failed" Error  
- [ ] Go to: https://myaccount.google.com/apppasswords
- [ ] Generate a **NEW** app password
- [ ] Remove spaces when copying: `xxxx xxxx xxxx xxxx` → `xxxxxxxxxxxxxxxx`
- [ ] Update EmailService.php
- [ ] Test again

### Email Never Arrives
- [ ] Check **SPAM** folder
- [ ] Check email address is correct
- [ ] Check credentials in EmailService.php
- [ ] Look for errors in: `C:\xampp\php\error.log`

### Can't Generate App Password
- [ ] 2-Factor must be enabled first
- [ ] Gmail account must be @gmail.com (not business account)
- [ ] If business account, use your actual password instead

---

## Alternative Providers

### Outlook
```php
$mail->Host = 'smtp-mail.outlook.com';
$mail->Port = 587;
$mail->Username = 'your-email@outlook.com';
$mail->Password = 'your-outlook-password';
```

### Mailtrap (Free Testing)
```php
$mail->Host = 'smtp.mailtrap.io';
$mail->Port = 2525;
$mail->Username = 'mailtrap-username';
$mail->Password = 'mailtrap-password';
```

Go to: https://mailtrap.io (free account)

---

## ✅ Verification Checklist

- [ ] Downloaded 3 PHPMailer files to auth-system/PHPMailer/
- [ ] Created Gmail app password (16 characters)
- [ ] Updated EmailService.php with your email and password
- [ ] Created test-send-email.php
- [ ] Ran test and received email
- [ ] Register.php will now send real OTPs via email ✅

---

## What Happens Next

When user registers:
1. Fills email field
2. Clicks "Register"
3. OTP generated (6 digits)
4. Email sent via PHPMailer (Gmail SMTP)
5. User receives email in inbox
6. Enters OTP to complete registration
7. Account verified! ✅

---

**Status: Ready to send real emails!** 🎉
