# Real-Time Consultation Status Updates - Quick Test Guide

## 🧪 Step-by-Step Testing Instructions

### Prerequisites
- Two browser windows/tabs open
- One logged in as ADMIN
- One logged in as CUSTOMER
- Customer has at least one pending consultation

---

## 📋 Test Case 1: Admin Approves Consultation

### Setup
1. **Window 1 (Admin)**: Open http://localhost/interior/admin-dashboard.php
2. **Window 2 (Customer)**: Open http://localhost/interior/customer-dashboard.php
3. Click "Your Consultations" tab on customer dashboard
4. You should see a consultation with status **"Pending"** (yellow badge)

### Execution
1. **In Admin Window**:
   - Scroll to "Consultations Requiring Action" section
   - Find the consultation by the customer
   - Toggle "Send Email on Action" checkbox (optional)
   - Click the **"✓ Approve"** button
   - Confirm the action

2. **Expected Result in Customer Window**:
   - Within **5 seconds**, the status badge should change to **"Approved"** (green)
   - A notification toast appears: "✨ Your [type] consultation is now **Approved**!"
   - The badge animates with a subtle pulse effect
   - Status changes without page reload

### Verification
- ✅ Status changed from pending to approved
- ✅ Badge color changed to green
- ✅ Notification appeared
- ✅ No page refresh needed

---

## 📋 Test Case 2: Admin Declines Consultation

### Setup
1. Create a new consultation request (if you don't have another pending one)
2. Keep both windows open and ready

### Execution
1. **In Admin Window**:
   - Find another consultation
   - Toggle "Send Email on Action" checkbox (optional)
   - Click the **"✗ Decline"** button
   - Confirm the action

2. **Expected Result in Customer Window**:
   - Within **5 seconds**, status badge changes to **"Declined"** (red)
   - Notification toast appears: "✨ Your [type] consultation is now **Declined**!"
   - Animation plays

### Verification
- ✅ Status changed to declined
- ✅ Badge color changed to red
- ✅ Notification appeared

---

## 📋 Test Case 3: Email Toggle Control

### Test A: Email Enabled
1. **In Admin Window**:
   - Ensure "Send Email on Action" is **CHECKED** ✓
   - Click Approve on a consultation
   - Check email_queue or spam folder

### Test B: Email Disabled
1. **In Admin Window**:
   - **UNCHECK** "Send Email on Action" ✗
   - Click Decline on a consultation
   - Check that email is NOT sent (check database query results)

### Verification
- ✅ Email sends when toggle is ON
- ✅ Email doesn't send when toggle is OFF
- ✅ Status still updates correctly in both cases

---

## 📋 Test Case 4: Polling Interval Test

### Execution
1. Open Browser Developer Tools (F12) on Customer Window
2. Go to **Network** tab
3. Keep watching the network requests
4. You should see requests to `/api/get-consultation-status.php` every **5 seconds**

### Verification
- ✅ Requests appear approximately every 5 seconds
- ✅ Response contains consultation data
- ✅ Response includes all necessary fields (id, status, consultation_type, etc.)

---

## 📋 Test Case 5: Multiple Consultations

### Setup
1. Create 3-4 different consultation requests
2. Keep customer dashboard open with "Your Consultations" tab visible

### Execution
1. **In Admin Window**:
   - Approve one consultation
   - Decline another consultation
   - Leave one as pending

2. **Expected Result**:
   - Each consultation card updates independently
   - Only changed consultations animate
   - Pending consultations remain unchanged
   - Multiple notifications may appear (one per change)

### Verification
- ✅ Multiple statuses update correctly
- ✅ Only changed items animate
- ✅ All consultations visible and accurate

---

## 🔍 Database Verification

### Check Status Updates
```sql
SELECT id, consultation_type, status, created_at, updated_at 
FROM consultations 
ORDER BY id DESC 
LIMIT 5;
```

**Expected Results:**
- `status` field contains: pending, approved, or declined
- `updated_at` timestamp changes when admin takes action
- `updated_at` is more recent than `created_at` for approved/declined items

### Check Email Queue (if emails failed to send)
```sql
SELECT id, consultation_id, recipient_email, email_type, status, attempts, sent_at 
FROM email_queue 
ORDER BY created_at DESC 
LIMIT 10;
```

---

## 🐛 Troubleshooting

### Issue: Status doesn't update in customer dashboard

**Solution 1**: Check polling is running
- Open Browser Console (F12 → Console tab)
- Look for no errors
- Should see successful API responses every 5 seconds

**Solution 2**: Check API response
- Open Network tab (F12 → Network)
- Look for `get-consultation-status.php` requests
- Response should show updated status in JSON

**Solution 3**: Manual refresh
- Press F5 to reload the page
- If status appears after reload, polling might be delayed
- Check browser console for JavaScript errors

### Issue: Email not sending even with toggle ON

**Solution 1**: Check email configuration
- Visit [configure-mail.php](configure-mail.php)
- Follow SMTP setup instructions (Gmail or SendGrid recommended)

**Solution 2**: Check email queue
- Visit [admin-manage-emails.php](admin-manage-emails.php)
- Look for queued emails
- Try manual "Resend" button

**Solution 3**: Check email logs
- Verify email_queue table has entries
- Check email status and attempt count
- Look at error messages

### Issue: Notifications don't appear

**Solution 1**: Check console
- Open F12 → Console
- Look for JavaScript errors
- Should see no errors related to notifications

**Solution 2**: Check HTML
- Right-click page → Inspect Element
- Look for `<div id="consultationAlert"></div>`
- Should exist and be visible

### Issue: Polling stops working

**Solution 1**: Check page is still active
- Click on customer dashboard tab to ensure it has focus
- Some browsers pause polling on inactive tabs

**Solution 2**: Check for JavaScript errors
- Open F12 → Console
- Look for any error messages
- Refresh page if needed

**Solution 3**: Check session
- Ensure user is still logged in
- If session expired, you need to re-login

---

## 📊 Performance Monitoring

### Check API Response Time
1. Open Network tab (F12 → Network)
2. Look for `get-consultation-status.php` requests
3. Check response time in milliseconds
4. Should be **< 100ms** typically (very fast)

### Check Network Load
1. Open Network tab (F12 → Network)
2. Filter by "Fetch/XHR"
3. Monitor polling requests
4. Each request should be **< 1KB** in size

### Check CPU/Memory
1. Open Performance tab (F12 → Performance)
2. Let it run for 1 minute
3. Should not see significant CPU spikes
4. Memory usage should be stable

---

## ✅ Final Checklist

Before declaring testing complete:

- [ ] Admin can approve and status updates in customer dashboard within 5 seconds
- [ ] Admin can decline and status updates in customer dashboard within 5 seconds
- [ ] Status badges change color correctly
- [ ] Animations play smoothly
- [ ] Notifications appear and auto-dismiss
- [ ] Email toggle works for both approve and decline
- [ ] Multiple consultations update independently
- [ ] Database timestamps update correctly
- [ ] API returns correct JSON format
- [ ] Polling interval is consistent (~5 seconds)
- [ ] No JavaScript errors in console
- [ ] Mobile view is responsive
- [ ] Works across multiple browser tabs
- [ ] Session authentication is required

---

## 🎓 Understanding the Architecture

### Client Side (Customer Dashboard)
```
Page Load
   ↓
JavaScript initializes
   ↓
startConsultationPolling() called
   ↓
setInterval every 5 seconds
   ↓
fetchConsultationUpdates() → API call
   ↓
Compare new status with old status (via data attributes)
   ↓
If changed → updateConsultationDisplay()
   ↓
Update badge, show animation, show notification
```

### Server Side (Backend)
```
Admin clicks Approve/Decline
   ↓
POST to /api/approve-consultation.php or /api/decline-consultation.php
   ↓
Validate admin session
   ↓
UPDATE consultations SET status = 'approved/declined', updated_at = NOW()
   ↓
Send email (if toggle enabled)
   ↓
Response: { success: true, message: "..." }
```

### Polling API
```
Customer dashboard polls every 5 seconds
   ↓
GET /api/get-consultation-status.php
   ↓
Validate customer session
   ↓
SELECT * FROM consultations WHERE email = ?
   ↓
Response: { success: true, consultations: [...] }
   ↓
JavaScript compares and updates display
```

---

## 📞 Support

If you encounter any issues:
1. Check browser console for errors (F12 → Console)
2. Check network tab for failed requests (F12 → Network)
3. Verify database has updated status (PhpMyAdmin)
4. Review this troubleshooting guide
5. Check logs in `/config/` or root directory

**Documentation**: See [CONSULTATION_REALTIME_UPDATE.md](CONSULTATION_REALTIME_UPDATE.md)

---

**Last Updated**: January 2024
**Status**: Ready for Testing ✅
