## 🎯 QUICK SETUP - PHPMailer Without Composer

### Your situation:
❌ Composer SSL certificate failed  
✅ But you can still use PHPMailer manually!

---

## 4-Step Setup (5 minutes total)

### 1️⃣ Download PHPMailer Files
```
Double-click: download-phpmailer.bat
```
Or manually save 3 files to: `C:\xampp\htdocs\interior\auth-system\PHPMailer\`
- PHPMailer.php
- SMTP.php  
- Exception.php

### 2️⃣ Get Gmail App Password
1. Go to: https://myaccount.google.com/apppasswords
2. Select: Phone → Gmail
3. Click Generate
4. Copy the 16-character password

### 3️⃣ Update EmailService.php
File: `C:\xampp\htdocs\interior\auth-system\EmailService.php`

Find line ~53:
```php
$mail->Username = 'your-email@gmail.com';  // ← Replace with your email
$mail->Password = 'your-app-password';     // ← Replace with app password
```

### 4️⃣ Test It Works
Visit: http://localhost/interior/verify-phpmailer.php

---

## What Gets Updated

| Component | Status |
|-----------|--------|
| EmailService.php | ✅ Already updated for PHPMailer |
| register.php | ✅ Already sends OTP via email |
| login.php | ✅ Ready for 2FA emails |
| Database | ✅ OTP tables exist |

---

## Your Registration Flow

```
User visits: /auth-system/register.php
    ↓
Fills email + password
    ↓
Clicks "Register"
    ↓
EmailService::generateOTP() → "123456"
    ↓
EmailService::sendEmailVerificationOTP() → Uses Gmail SMTP
    ↓
User receives OTP in email inbox
    ↓
Enters OTP on form
    ↓
Account verified ✅
```

---

## Files Ready for You

📄 [PHPMAILER_QUICK_START.md](PHPMAILER_QUICK_START.md) - Detailed setup guide
📄 [PHPMAILER_MANUAL_INSTALL.md](PHPMAILER_MANUAL_INSTALL.md) - All options
📄 [PHPMAILER_NO_COMPOSER_SETUP.md](PHPMAILER_NO_COMPOSER_SETUP.md) - Complete overview

🔧 [download-phpmailer.bat](download-phpmailer.bat) - Auto-download files
🔍 [verify-phpmailer.php](verify-phpmailer.php) - Check your setup

---

## Start Here

1. Run: `download-phpmailer.bat`
2. Get Gmail app password: https://myaccount.google.com/apppasswords
3. Edit: `auth-system/EmailService.php` (lines 53-57)
4. Visit: http://localhost/interior/verify-phpmailer.php

✅ Done! Your registration system now sends real emails!
