# Team Management Quick Start Guide

## Access Team Management Panel

### Step 1: Login to Admin Dashboard
- Navigate to: `admin-dashboard.php`
- Login with admin credentials

### Step 2: Click "Team Members" in Sidebar
- You'll see the Team Members navigation option
- All current team members display in a grid

## Adding a New Team Member

### Steps:
1. Click **"+ Add Member"** button (top right of Team Members section)
2. Fill in the form:
   - **Name**: Team member's full name
   - **Designation**: Job title/role
   - **Twitter URL**: (Optional) https://twitter.com/username
   - **LinkedIn URL**: (Optional) https://linkedin.com/in/username
   - **Profile Image**: Upload photo (JPG, PNG, GIF, WebP) - Max 5MB
3. Click **"Add Member"**
4. ✅ Member automatically appears on team.php

## Editing a Team Member

### Steps:
1. Find the team member card in the grid
2. Click **"Edit"** button on the card
3. Update any field:
   - Name
   - Designation
   - Social media URLs
   - Upload new image (optional)
4. Click **"Update Member"**
5. ✅ Changes reflect immediately on team.php

## Deleting a Team Member

### Steps:
1. Find the team member card
2. Click **"Delete"** button
3. Confirm deletion in popup
4. ✅ Member removed from database and team.php

## Frontend Display (team.php)

### What Users See:
- Team members displayed in responsive grid
- Card layout with:
  - Member photo (200px height)
  - Full name
  - Designation (highlighted in gold)
  - Social media icons (Twitter, LinkedIn)
  - Hover effects

### Responsive Behavior:
- **Desktop**: 3 columns
- **Tablet**: 2 columns
- **Mobile**: 1 column

## Database Integration

### Table Name: `team_members`

### Fields:
| Field | Type | Notes |
|-------|------|-------|
| id | INT | Auto-increment primary key |
| name | VARCHAR(100) | Team member name |
| designation | VARCHAR(100) | Job title |
| image_path | VARCHAR(255) | Path to uploaded image |
| twitter_url | VARCHAR(255) | Twitter profile URL |
| linkedin_url | VARCHAR(255) | LinkedIn profile URL |
| created_at | TIMESTAMP | Auto-set on creation |
| updated_at | TIMESTAMP | Auto-updated on change |

## File Locations

- **Admin Panel**: `/admin-dashboard.php` (Team Members section)
- **Frontend Page**: `/team.php`
- **Backend API**: `/api/manage-team.php`
- **Images**: `/assets/img/team/`
- **Configuration**: `/config/db.php` (already connected)

## Troubleshooting

### Members not appearing?
- Refresh team.php page
- Check database connection in config/db.php
- Verify team_members table exists

### Image not uploading?
- Check file size (max 5MB)
- Ensure file format is: JPG, PNG, GIF, or WebP
- Verify `/assets/img/team/` directory has write permissions

### Changes not syncing?
- Confirm changes are saved in admin dashboard
- Refresh team.php in browser
- Check browser cache (Ctrl+Shift+R)

## Performance Notes
- Images are automatically optimized on upload
- Database queries indexed for fast loading
- Grid layout uses CSS Grid for responsive design
- No manual refresh needed - automatic on page load

## Security
✅ Admin-only access (session verification)
✅ File type validation
✅ File size limits (5MB)
✅ SQL injection prevention
✅ XSS prevention (HTML escaping)

## Support Features
- Automatic table creation on first load
- Default team data initialization
- Image cleanup on member deletion
- Real-time updates without page reload
- Comprehensive error messages
