# Team Management System - Visual Overview

## System Architecture Diagram

```
┌────────────────────────────────────────────────────────────────────┐
│                                                                    │
│                      INTERIOR DESIGN WEBSITE                      │
│                                                                    │
└────────────────────────────────────────────────────────────────────┘
                                   │
                  ┌────────────────┴────────────────┐
                  │                                 │
         ┌────────▼────────┐            ┌──────────▼──────────┐
         │  ADMIN SECTION  │            │  FRONTEND SECTION  │
         │ (Admin Users)   │            │  (Public Users)    │
         └────────┬────────┘            └──────────┬──────────┘
                  │                                 │
         ┌────────▼────────────────┐               │
         │  Admin Dashboard        │               │
         │  ==================     │               │
         │  • Dashboard Overview   │               │
         │  • Orders Management    │               │
         │  • Users Management     │               │
         │  ★ Team Members ★       │──────┐       │
         │  • Services             │      │       │
         │  • Gallery              │      │       │
         │  • Blog                 │      │       │
         │  • Projects             │      │       │
         └────────┬────────────────┘      │       │
                  │                       │       │
                  │   Add/Edit/Delete     │       │
                  │   Team Members        │       │
                  │                       │       │
         ┌────────▼───────────────────────┼───────┐
         │  api/manage-team.php            │       │
         │  =====================          │       │
         │  • Receive requests             │       │
         │  • Validate auth                │       │
         │  • Process uploads              │       │
         │  • Query database               │       │
         │  • Return JSON response         │       │
         └────────┬────────────────────────┼───────┘
                  │                       │       │
                  │   SQL Queries         │       │
                  │                       │       │
         ┌────────▼────────────────────────┼───────┐
         │  MySQL Database                 │       │
         │  ================               │       │
         │                                 │       │
         │  team_members Table:            │       │
         │  ┌──────────────────────┐       │       │
         │  │ id        INT (PK)   │       │       │
         │  │ name      VARCHAR    │       │       │
         │  │ desig...  VARCHAR    │       │       │
         │  │ image...  VARCHAR    │───────┼───────┘
         │  │ twitter   VARCHAR    │       │
         │  │ linkedin  VARCHAR    │       │
         │  │ created   TIMESTAMP  │       │
         │  │ updated   TIMESTAMP  │       │
         │  └──────────────────────┘       │
         └────────────────────────────────┘
                                           │
                       ┌───────────────────┘
                       │
                       │   SELECT * FROM team_members
                       │
         ┌─────────────▼─────────────┐
         │  team.php                 │
         │  ========                 │
         │  • Fetch from database    │
         │  • Render HTML            │
         │  • Display to users       │
         └─────────────┬─────────────┘
                       │
                       │   Displays as:
                       │
         ┌─────────────▼────────────────────┐
         │  team.html Rendered Page         │
         │  ==========================      │
         │  ┌────────────────────────────┐ │
         │  │  Team Members Grid        │ │
         │  │  ┌──────┐ ┌──────┐      │ │
         │  │  │ Card │ │ Card │ ...  │ │
         │  │  │ 1    │ │ 2    │      │ │
         │  │  └──────┘ └──────┘      │ │
         │  │ Each Card Shows:         │ │
         │  │ • Member Photo           │ │
         │  │ • Name                   │ │
         │  │ • Designation            │ │
         │  │ • Social Links           │ │
         │  └────────────────────────────┘ │
         │  Mobile/Tablet Responsive   │
         └──────────────────────────────────┘
```

---

## User Workflow Diagram

### Adding a Team Member

```
Admin User
    │
    ▼
[Clicks: admin-dashboard.php]
    │
    ▼
[Sidebar: Team Members]
    │
    ▼
[Click: "+ Add Member" Button]
    │
    ▼
┌─────────────────────────┐
│  Modal Form Appears     │
│  • Name                 │
│  • Designation          │
│  • Twitter URL          │
│  • LinkedIn URL         │
│  • Image Upload         │
└────────┬────────────────┘
         │
         ▼
   [Fill Form]
         │
         ▼
  [Click "Add Member"]
         │
         ▼
 [Form Validation]
    ✓ Name required
    ✓ Designation required
    ✓ Image required
    ✓ File size < 5MB
    ✓ Valid image type
         │
         ▼
 [Send to api/manage-team.php]
    - POST request
    - FormData with file
    - Session validated
         │
         ▼
 [Server Processes]
    - Check admin auth
    - Validate file
    - Generate filename
    - Save image
    - Insert in DB
         │
         ▼
 [Response: Success/Error]
         │
         ▼
 [Reload Team Grid]
         │
         ▼
 ✅ New member appears!
         │
         ▼
 ✅ Visit team.php
         │
         ▼
 ✅ Member displays there!
```

### Editing a Team Member

```
Admin User
    │
    ▼
[Find member card]
    │
    ▼
[Click "Edit" Button]
    │
    ▼
┌──────────────────────────┐
│  Edit Form Modal         │
│  Pre-filled with:        │
│  • Current name          │
│  • Current designation   │
│  • Current URLs          │
│  • Current image preview │
│  • Optional: New image   │
└────────┬─────────────────┘
         │
         ▼
   [Update Fields]
         │
         ▼
[Click "Update Member"]
         │
         ▼
   [Validation]
         │
         ▼
[api/manage-team.php]
    - UPDATE query
    - Delete old image (if new)
    - Save new image (if new)
    - Update all fields
         │
         ▼
  [Success Response]
         │
         ▼
[Reload Team Members]
         │
         ▼
 ✅ Changes visible!
         │
         ▼
 ✅ team.php auto-updates!
```

### Deleting a Team Member

```
Admin User
    │
    ▼
[Find member card]
    │
    ▼
[Click "Delete" Button]
    │
    ▼
[Confirm Dialog]
    "Are you sure?"
         │
      [YES]
         │
         ▼
[api/manage-team.php]
    - DELETE from database
    - Delete image file
    - Clean up storage
         │
         ▼
  [Success Response]
         │
         ▼
[Reload Grid]
         │
         ▼
 ✅ Member removed!
         │
         ▼
 ✅ team.php updates!
```

---

## Data Flow Diagram

### Real-time Synchronization

```
ADMIN DASHBOARD                API ENDPOINT              DATABASE
═════════════════              ════════════              ════════════

Admin clicks
"Add Member"
    │
    │  POST /api/manage-team.php
    ├──────────────────────────────────►
    │                                   │
    │                                   │ Validate
    │                                   │ • Auth check
    │                                   │ • File validation
    │                                   │ • Form data
    │                                   ├──► Process
    │                                   │
    │                                   │ SQL: INSERT
    │                                   ├──────────────────►
    │                                   │                   │
    │                                   │                   │ Saved!
    │                                   │◄──────────────────┤
    │                                   │
    │  JSON Response: Success           │
    │◄──────────────────────────────────┤
    │
    │ JS: Reload Team Grid
    │
    │ Show new member in grid
    ▼

TEAM.PHP (Frontend)
═══════════════════

Page loads
    │
    │  Fetch from database
    │  SELECT * FROM team_members
    ├──────────────────────────────────►
    │                                   │
    │                                   │ Query runs
    │                                   │ Returns all members
    │◄──────────────────────────────────┤
    │
    │ Render HTML
    │ Display grid
    ▼
✅ New member visible to public!
```

---

## Component Interaction Map

```
┌──────────────────────┐
│  team.html (legacy)  │  (Replaced by team.php)
└──────────────────────┘

┌──────────────────────────────────────────────────────┐
│  admin-dashboard.php                                  │
│  ────────────────────────────────────────────────    │
│  • Sidebar nav with "Team Members" link              │
│  • Team management panel (grid display)              │
│  • Modal dialogs (add/edit)                          │
│  • JavaScript event handlers                         │
└─────────┬────────────────────────────┬───────────────┘
          │                            │
    [User Clicks]              [Data Binding]
          │                            │
          ▼                            ▼
┌─────────────────────────────────────────────┐
│  JavaScript Functions                       │
│  • loadTeamMembers()                       │
│  • displayTeamMembers()                    │
│  • openAddTeamModal()                      │
│  • openEditTeamModal()                     │
│  • submitAddTeam()                         │
│  • submitEditTeam()                        │
│  • deleteTeamMember()                      │
│  • htmlEscape()                            │
│  • addSlashes()                            │
└──────────┬──────────────────────────────────┘
           │
    [AJAX POST]
           │
           ▼
┌─────────────────────────────────────────────┐
│  api/manage-team.php                        │
│  ─────────────────────────────            │
│  • Authentication check                    │
│  • Action router (add/edit/delete/get_all) │
│  • File upload handler                     │
│  • Database operations                     │
│  • Response formatter (JSON)                │
└──────────┬──────────────────────────────────┘
           │
    [SQL Query]
           │
           ▼
┌─────────────────────────────────────────────┐
│  MySQL Database                             │
│  • team_members table                       │
│  • /assets/img/team/ (image storage)        │
└──────────┬──────────────────────────────────┘
           │
    [Data Returned]
           │
           ▼
┌─────────────────────────────────────────────┐
│  team.php (on page load)                    │
│  ────────────────────────────────────────  │
│  • Fetch all members from DB                │
│  • Generate HTML                            │
│  • Apply styling                            │
│  • Render to browser                        │
└──────────┬──────────────────────────────────┘
           │
           ▼
┌─────────────────────────────────────────────┐
│  Browser Display                            │
│  • Responsive grid (3 cols desktop)         │
│  • Member cards with images                 │
│  • Social media links                       │
│  • Hover effects                            │
└─────────────────────────────────────────────┘
```

---

## Responsive Grid Layout

```
DESKTOP (≥1200px)
┌─────────────────────────────────────────────────────┐
│                    Team Members Grid                │
│ ┌─────────────────┐ ┌─────────────────┐ ┌─────────────────┐
│ │     Card 1      │ │     Card 2      │ │     Card 3      │
│ │                 │ │                 │ │                 │
│ │   [Image 1]     │ │   [Image 2]     │ │   [Image 3]     │
│ │   Name 1        │ │   Name 2        │ │   Name 3        │
│ │   Title 1       │ │   Title 2       │ │   Title 3       │
│ │   [Icons]       │ │   [Icons]       │ │   [Icons]       │
│ └─────────────────┘ └─────────────────┘ └─────────────────┘
│ ┌─────────────────┐ ┌─────────────────┐ ┌─────────────────┐
│ │     Card 4      │ │     Card 5      │ │     Card 6      │
│ └─────────────────┘ └─────────────────┘ └─────────────────┘
└─────────────────────────────────────────────────────┘

TABLET (768-991px)
┌──────────────────────────────────────┐
│      Team Members Grid               │
│ ┌──────────────────┐ ┌──────────────────┐
│ │      Card 1      │ │      Card 2      │
│ │                  │ │                  │
│ │    [Image 1]     │ │    [Image 2]     │
│ │    Name 1        │ │    Name 2        │
│ │    Title 1       │ │    Title 2       │
│ │    [Icons]       │ │    [Icons]       │
│ └──────────────────┘ └──────────────────┘
│ ┌──────────────────┐ ┌──────────────────┐
│ │      Card 3      │ │      Card 4      │
│ └──────────────────┘ └──────────────────┘
└──────────────────────────────────────┘

MOBILE (<768px)
┌────────────────────┐
│ Team Members Grid  │
│ ┌────────────────┐ │
│ │     Card 1     │ │
│ │                │ │
│ │  [Image 1]     │ │
│ │  Name 1        │ │
│ │  Title 1       │ │
│ │  [Icons]       │ │
│ │ [Edit] [Delete]│ │
│ └────────────────┘ │
│ ┌────────────────┐ │
│ │     Card 2     │ │
│ └────────────────┘ │
└────────────────────┘
```

---

## File Structure

```
interior/
│
├── admin-dashboard.php          (Modified - Added team panel)
│
├── team.php                     (New - Dynamic frontend)
├── team.html                    (Legacy - can be redirected)
│
├── api/
│   └── manage-team.php          (New - Backend API)
│
├── assets/img/team/             (New directory for team images)
│   ├── team_1234567890_5678.jpg
│   └── ... (auto-managed)
│
├── config/
│   └── db.php                   (Existing - Used for connection)
│
├── includes/
│   ├── header.php               (Existing - Used by team.php)
│   └── footer.php               (Existing - Used by team.php)
│
└── docs/
    ├── TEAM_MANAGEMENT_INTEGRATION.md
    ├── TEAM_MANAGEMENT_QUICK_START.md
    ├── TEAM_MANAGEMENT_TECHNICAL_DETAILS.md
    └── TEAM_MANAGEMENT_COMPLETE.md
```

---

## Security Flow

```
┌──────────────────┐
│  User Action     │
│  (Admin clicks)  │
└────────┬─────────┘
         │
         ▼
┌──────────────────────────────┐
│ Browser sends request         │
│ POST /api/manage-team.php     │
│ With session cookie           │
└────────┬─────────────────────┘
         │
         ▼
┌──────────────────────────────┐
│ API receives request          │
│ 1. Check $_SESSION['user_id'] │
│ 2. Check user role = 'admin'  │
│ 3. Validate input data        │
│ 4. Check file type            │
│ 5. Check file size            │
│ 6. Escape all output          │
└────────┬─────────────────────┘
         │
      [PASS] or [FAIL]
         │
    ┌────┴────┐
    │          │
    ▼          ▼
 [Success]  [Error]
   │            │
   │            ▼
   │        Respond with error
   │        (no sensitive info)
   │
   ▼
Process request safely
   │
   ▼
Return JSON response
   │
   ▼
Browser updates UI
```

---

This visual overview provides a complete picture of how the team management system works!
