# ✅ QUICK TEST CHECKLIST

## 🎯 3-Minute Setup & Test

### Step 1: Database Setup (30 seconds)
```
1. Open: http://localhost/interior/auth-system/migrate-cart.php
2. Should see: ✅ Cart table created successfully!
3. Done!
```

### Step 2: Register (1 minute)
```
1. Open: http://localhost/interior/auth-system/register.php
2. Fill form:
   - Name: testuser
   - Email: test@example.com
   - Password: test123
   - Role: ⭐ CUSTOMER ⭐ (IMPORTANT!)
3. Click Register
4. See: Account created successfully!
```

### Step 3: Test Shopping (1.5 minutes)
```
1. Open: http://localhost/interior/shop.php
2. Login with: testuser / test123
3. Should see: 8 products with prices
4. Click any "➕ ADD TO CART"
5. Should see: GREEN TOAST "✅ Product added to cart successfully"
6. ⭐ PAGE SHOULD NOT RELOAD! ⭐
7. Go to: http://localhost/interior/cart.php
8. Should see: Your product with quantity and price
```

---

## 📋 Detailed Test Cases

### ✅ Test 1: Add Single Product
**Steps:**
1. Go to shop.php
2. Click ADD TO CART on Product #1
3. **Expected:** Green toast appears, no page reload
4. Go to cart.php
5. **Expected:** Product appears with qty=1

### ✅ Test 2: Add Multiple Different Products
**Steps:**
1. Go to shop.php
2. Add Product #1 (qty=2)
3. Add Product #3 (qty=1)
4. Go to cart.php
5. **Expected:** 2 items in cart, quantities correct

### ✅ Test 3: Same Product Multiple Times
**Steps:**
1. Go to shop.php
2. Add Product #1 (qty=1)
3. Add Product #1 again (qty=1)
4. Go to cart.php
5. **Expected:** Product #1 appears once with qty=2 (not duplicate entries)

### ✅ Test 4: Remove Item
**Steps:**
1. Have items in cart
2. Go to cart.php
3. Click 🗑️ Remove on any item
4. Confirm deletion
5. **Expected:** Green toast, item disappears, no page reload, total updates

### ✅ Test 5: Empty Cart Message
**Steps:**
1. Remove all items from cart
2. Go to cart.php
3. **Expected:** See message "🛒 Your Cart is Empty"

### ✅ Test 6: Cart Persistence
**Steps:**
1. Add products to cart
2. Go to shop.php, click "Logout"
3. Login again with same account
4. Go to cart.php
5. **Expected:** Items still there!

### ✅ Test 7: Session Security
**Steps:**
1. Open 2 browser windows (or incognito)
2. Login as different users
3. Add items in window 1
4. Check cart in window 2
5. **Expected:** Different carts for each user!

### ✅ Test 8: Admin Cannot Shop
**Steps:**
1. Logout
2. Register new admin account (Role = ADMIN)
3. Login as admin
4. Go to shop.php
5. **Expected:** See error "⛔ Admin users cannot shop"

### ✅ Test 9: Quantity Selector
**Steps:**
1. Go to shop.php
2. Change quantity to 5 in Product #1
3. Click ADD TO CART
4. Go to cart.php
5. **Expected:** Product shows qty=5 (not qty=1)

### ✅ Test 10: Cart Total Calculation
**Steps:**
1. Add Product #1 (Rs. 10,000) × qty 1
2. Add Product #2 (Rs. 12,000) × qty 1
3. Go to cart.php
4. **Expected:** 
   - Subtotal: Rs. 22,000
   - Shipping: Rs. 500
   - Tax (5%): Rs. 1,125
   - Total: Rs. 23,625

---

## 🐛 Quick Fixes

| Problem | Solution |
|---------|----------|
| **Page reloads on add** | JavaScript not working - check F12 console |
| **Can't add to cart** | Not logged in as CUSTOMER - check session |
| **Empty cart** | Migration not run - go to migrate-cart.php |
| **Items disappear** | Session expired - login again |
| **Images missing** | Check path: `assets/img/product/product_1_*.jpg` |

---

## 📱 Browser Console Testing

```javascript
// Copy-paste these in F12 Console to debug:

// 1. Check if fetch is working
fetch('auth-system/cart-api.php?action=get')
  .then(r => r.json())
  .then(d => console.log(d))

// 2. Check session
console.log(document.cookie)

// 3. Manually add to cart
const fd = new FormData();
fd.append('product_id', 1);
fd.append('product_name', 'Test Product');
fd.append('price', 10000);
fd.append('quantity', 1);
fetch('auth-system/cart-api.php?action=add', {method: 'POST', body: fd})
  .then(r => r.json())
  .then(d => console.log(d))
```

---

## 🎬 Success Indicators

✅ You'll know it's working when:
- [ ] Shop page loads with 8 products
- [ ] ADD TO CART button responds instantly
- [ ] Green toast appears without page reload
- [ ] Cart page shows items you added
- [ ] Remove button works without page reload
- [ ] Cart total updates automatically
- [ ] Login/logout works and items persist
- [ ] Admin users see error message

---

## 🔍 Debugging Tips

1. **F12 Console:**
   - Look for red errors
   - Check "Network" tab for API requests
   - Verify responses are JSON

2. **Check Logs:**
   - `php error_log` for PHP errors
   - MySQL error logs for database issues

3. **Test API Directly:**
   - Open: `http://localhost/interior/auth-system/cart-api.php?action=get`
   - Should return JSON, not HTML

4. **Verify Database:**
   - Run: `SELECT * FROM cart;` in phpMyAdmin
   - Should show your cart items

---

## ⏱️ Expected Performance

- Add to cart: < 1 second
- Toast display: 3 seconds
- Remove item: < 1 second
- Load cart: < 2 seconds
- No page reloads at all ✨

---

**Ready to test? Start with Step 1! 🚀**
