# 🐛 Common Issues & Solutions

## Issue 1: "User not authenticated" Error

### ❌ Problem:
When trying to add products to cart, you get:
```
Error: User not authenticated. Please login first.
```

### ✅ Solution:
1. Make sure you're logged in
   - Visit: `http://localhost/interior/auth-system/login.php`
   - Enter your credentials
   - Click Login

2. Make sure you selected "Customer" during registration
   - If not, logout and register as Customer

3. Check if cookies are enabled
   - Browser → Settings → Cookies (enable them)

4. Clear browser cache
   - Press: `Ctrl + Shift + Delete`
   - Clear all data
   - Refresh page

---

## Issue 2: "Only customers can add items" Error

### ❌ Problem:
You logged in but can't add products:
```
Error: Only customers can add items to cart.
```

### ✅ Solution:
You're logged in as **Admin**, not Customer:

1. Logout:
   - Click account menu
   - Click "Logout"

2. Login again with Customer role:
   - Visit: `http://localhost/interior/auth-system/login.php`
   - Use a customer account
   - (If you only have admin, register new customer account)

3. Or register as Customer:
   - Visit: `http://localhost/interior/auth-system/register.php`
   - Fill in details
   - Select **Customer** from dropdown (important!)
   - Click Register

---

## Issue 3: Cart Items Not Showing

### ❌ Problem:
You add products to cart, but `cart.php` shows empty cart.

### ✅ Solutions:

**Check 1: Database Migration**
- Did migration run successfully?
- Visit: `http://localhost/interior/auth-system/migrate-cart.php`
- Should show: "Cart table created successfully"
- If error, check database connection

**Check 2: You're Logged In**
- `cart.php` requires login
- Visit: `http://localhost/interior/auth-system/login.php`
- Login first, then go to `cart.php`

**Check 3: Added Items to Cart**
- Visit: `http://localhost/interior/shop.php`
- Add some products to cart first
- Then go to: `http://localhost/interior/cart.php`

**Check 4: Database Connection**
- Check `auth-system/config/db.php`
- Make sure database credentials are correct:
  ```php
  $servername = "localhost";
  $username = "root";
  $password = "";
  $dbname = "interior";  // Your database name
  ```

---

## Issue 4: AJAX Request Fails (404 Error)

### ❌ Problem:
Adding to cart doesn't work, browser console shows 404 error.

### ✅ Solution:

**Check 1: File Path**
- Make sure `auth-system/cart-api.php` exists
- Location: `c:\xampp\htdocs\interior\auth-system\cart-api.php`

**Check 2: Console Error**
- Open DevTools: Press `F12`
- Go to Console tab
- Look for red errors
- Check Network tab for 404 on cart-api.php request

**Check 3: Path in Code**
- Check `shop.php` line with:
  ```javascript
  this.apiUrl = 'auth-system/cart-api.php';
  ```
- Make sure this path is correct for your setup

**Check 4: Server Running**
- Make sure XAMPP is running
- Apache should be running
- MySQL should be running

---

## Issue 5: Button Not Responding

### ❌ Problem:
Click "ADD TO CART" but nothing happens.

### ✅ Solutions:

**Check 1: JavaScript Enabled**
- Make sure JavaScript is enabled in browser
- Browser → Settings → Privacy & Security → Scripts

**Check 2: jQuery Loaded**
- Open DevTools: `F12`
- Console tab
- Type: `$` and press Enter
- Should return a function, not error

**Check 3: Console Errors**
- DevTools → Console tab
- Look for red errors
- Share error message for debugging

**Check 4: Network Issues**
- DevTools → Network tab
- Click "ADD TO CART"
- Look for requests to cart-api.php
- Check if response is 200 OK or error

---

## Issue 6: Toast Notification Not Showing

### ❌ Problem:
"ADD TO CART" works but no notification appears.

### ✅ Solutions:

**Check 1: CSS Loading**
- Open DevTools: `F12`
- Elements tab
- Find `<div id="toastNotification">`
- Check if it has display style

**Check 2: JavaScript Error**
- Console tab
- Look for errors in showToast() function
- Check if styling classes exist

**Check 3: Display Issue**
- Toast might be displaying but offscreen
- Modify CSS in shop.php around line with:
  ```css
  .toast-notification {
      position: fixed;
      top: 30px;
      right: 30px;
  }
  ```

---

## Issue 7: Cart Count Shows 0 or Wrong Number

### ❌ Problem:
You added 5 items but cart shows 0 or wrong count.

### ✅ Solutions:

**Check 1: Database Issue**
- Items might not be saving to database
- Check database:
  1. Open phpMyAdmin
  2. Select database
  3. Click `cart` table
  4. Do you see any rows?

**Check 2: User ID Mismatch**
- Make sure user_id is saved correctly
- In phpMyAdmin:
  1. Browse `cart` table
  2. Check `user_id` column
  3. Compare with your logged-in user ID

**Check 3: Browser Cache**
- Clear cache: `Ctrl + Shift + Delete`
- Refresh page: `Ctrl + F5` (hard refresh)

**Check 4: Check Localhost URL**
- Make sure you're on: `http://localhost/interior/`
- NOT: `http://127.0.0.1/` (different domain = different session)

---

## Issue 8: Remove Button Not Working

### ❌ Problem:
Click "Remove" but item stays in cart.

### ✅ Solutions:

**Check 1: Check Console**
- DevTools → Console
- Look for JavaScript errors
- Look for error responses from API

**Check 2: Check Network**
- DevTools → Network tab
- Click "Remove" button
- Look for POST to cart-api.php?action=remove
- Check response status (should be 200)

**Check 3: Database Permission**
- Make sure user can DELETE from database
- Check database user permissions in phpMyAdmin

**Check 4: Check Item Ownership**
- In cart.php, right-click → Inspect
- Find the remove button
- Check `data-cart-id` attribute
- Verify this ID exists in database for your user

---

## Issue 9: Migration Script Doesn't Run

### ❌ Problem:
Visit `http://localhost/interior/auth-system/migrate-cart.php`
Nothing happens or shows blank page.

### ✅ Solutions:

**Check 1: PHP Running**
- Make sure XAMPP is running
- Control Panel → Start Apache & MySQL

**Check 2: Check Database Connection**
- Test connection in `config/db.php`
- Try accessing phpMyAdmin: `http://localhost/phpmyadmin`
- If it fails, database isn't running

**Check 3: Manual SQL**
- If migration fails, run manually in phpMyAdmin:
  1. Go to: `http://localhost/phpmyadmin`
  2. Select your database
  3. Click "SQL" tab
  4. Copy-paste this:
  ```sql
  CREATE TABLE IF NOT EXISTS cart (
      id INT AUTO_INCREMENT PRIMARY KEY,
      user_id INT NOT NULL,
      product_id INT NOT NULL,
      product_name VARCHAR(255) NOT NULL,
      price DECIMAL(10, 2) NOT NULL,
      image VARCHAR(255),
      quantity INT NOT NULL DEFAULT 1,
      created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
      updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
      FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
      INDEX (user_id),
      INDEX (product_id)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
  ```
  5. Click "Go"

**Check 4: Error Messages**
- If getting error, note the exact message
- Often tells you what's wrong (e.g., "table already exists")

---

## Issue 10: Styling Looks Broken

### ❌ Problem:
Shop and cart pages don't look nice.

### ✅ Solutions:

**Check 1: CSS Files Loading**
- DevTools → Network tab
- Refresh page
- Look for CSS files
- Check if they have status 200 (not 404)

**Check 2: Bootstrap CSS**
- Make sure `assets/css/bootstrap.min.css` exists
- In shop.php, find: `<link rel="stylesheet" href="assets/css/bootstrap.min.css">`

**Check 3: Custom CSS**
- Make sure `<style>` sections have valid CSS
- Check for syntax errors (missing semicolons, braces)

**Check 4: Browser Cache**
- Clear cache: `Ctrl + Shift + Delete`
- Close and reopen browser
- Hard refresh: `Ctrl + F5`

---

## Issue 11: "Unauthorized" Error When Removing

### ❌ Problem:
Try to remove item from cart:
```
Error: Unauthorized access
```

### ✅ Solutions:

**Check 1: Verify Item ID**
- Item ID might be invalid
- Check if cart_id is correct number

**Check 2: User Session**
- Session might have expired
- Login again: `http://localhost/interior/auth-system/login.php`

**Check 3: Item Ownership**
- Item might belong to different user
- Clear all cookies and login fresh

**Check 4: Database Check**
- In phpMyAdmin, browse `cart` table
- Verify item exists with correct user_id

---

## Issue 12: Page Keeps Reloading (Not Real-Time)

### ❌ Problem:
Shop and cart pages keep reloading instead of real-time updates.

### ✅ Solutions:

**Check 1: Links vs Buttons**
- Make sure all product actions use `<button>` not `<a>` tags
- If using `<a>` tags, they'll navigate (page reload)

**Check 2: JavaScript Enabled**
- AJAX requires JavaScript
- Check if enabled: Browser → Settings → Privacy & Security

**Check 3: Event Listeners**
- Check if event listeners are attached
- DevTools → Console
- Type: `cartDisplay` and press Enter
- Should show the CartDisplay object

---

## Issue 13: Database Table Doesn't Exist

### ❌ Problem:
When adding to cart, get error:
```
Error: ... table 'interior.cart' doesn't exist
```

### ✅ Solution:

**You need to run the migration:**

1. Visit: `http://localhost/interior/auth-system/migrate-cart.php`
   - Should show: "Cart table created successfully"

2. If still doesn't work, manual creation:
   - Open phpMyAdmin: `http://localhost/phpmyadmin`
   - Select your database (e.g., "interior")
   - Click "SQL" tab
   - Paste the CREATE TABLE query
   - Click "Go"

3. Verify table exists:
   - phpMyAdmin → Your database
   - Scroll down table list
   - Should see "cart" table

---

## Issue 14: "Connection Refused" Error

### ❌ Problem:
Can't access any page:
```
Connection refused / 127.0.0.1 refused to connect
```

### ✅ Solution:

**Start XAMPP:**
1. Open XAMPP Control Panel
2. Click "Start" for Apache
3. Click "Start" for MySQL
4. Both should show "Running" in green
5. Try again: `http://localhost/interior/`

---

## Issue 15: Blank Page or No Content

### ❌ Problem:
Page loads but shows nothing or blank page.

### ✅ Solutions:

**Check 1: Session Validation**
- `cart.php` checks if logged in
- If not logged in, redirects to login
- Make sure you're authenticated

**Check 2: Database Issue**
- Database might be offline
- Check XAMPP → MySQL running?
- Check connection in `config/db.php`

**Check 3: PHP Errors**
- DevTools → Network tab
- Click on shop.php request
- Click "Response" tab
- Look for PHP error messages

**Check 4: Check Browser Console**
- DevTools → Console
- Look for JavaScript errors
- Red errors will show what's wrong

---

## Quick Diagnostic Checklist

```
[ ] 1. XAMPP running (Apache + MySQL)?
[ ] 2. Database exists and has users table?
[ ] 3. User registered and logged in?
[ ] 4. User registered as CUSTOMER (not admin)?
[ ] 5. Migration ran successfully?
[ ] 6. Cart table exists in database?
[ ] 7. Browser has JavaScript enabled?
[ ] 8. No errors in DevTools Console (F12)?
[ ] 9. Network requests showing 200 status?
[ ] 10. Session cookies enabled in browser?
```

If all checked, system should work! ✅

---

## Getting Help

1. **Check Browser Console** (F12)
   - Most errors shown here
   - Copy error text

2. **Check Network Tab** (F12)
   - Watch AJAX requests
   - Note any 404 or 500 errors

3. **Check phpMyAdmin**
   - Verify database and tables exist
   - Check if data is being saved

4. **Check File Paths**
   - Make sure all files exist in correct locations
   - Use File Explorer to verify

5. **Read Error Messages**
   - Most errors are self-explanatory
   - Google the exact error message

---

## Still Stuck?

1. Make sure all 4 files are created:
   - `shop.php`
   - `cart.php`
   - `auth-system/cart-api.php`
   - `auth-system/migrate-cart.php`

2. Run migration: `http://localhost/interior/auth-system/migrate-cart.php`

3. Register as customer: `http://localhost/interior/auth-system/register.php`

4. Test each part:
   - Login: ✅ Works?
   - Shop page loads: ✅ Works?
   - Add to cart: ✅ Works?
   - View cart: ✅ Works?
   - Remove item: ✅ Works?

If any step fails, focus on that specific issue using solutions above.

---

**Happy debugging!** 🐛✅
