# UPI Payment Quick Reference

## ⚡ Quick Start

### 1. View the UPI Payment Feature
```
URL: http://localhost/interior/checkout.php
Steps:
  1. Login as customer
  2. Add items to cart
  3. Go to checkout
  4. Select "🇮🇳 UPI" payment
  5. See QR code with amount displayed
```

### 2. Update Your Merchant UPI ID
```
File: checkout.php
Line: 2605

Find:
  const merchantUPI = 'merchant@upi';

Replace with:
  const merchantUPI = '9876543210@okhdfcbank';
```

### 3. How Customer Pays
```
Option A: Scan QR Code
├─ QR code shows amount (Rs. 11,500)
├─ Scan with Google Pay/PhonePe
├─ Pay in app
├─ Click "Confirm Payment Done"
└─ Order placed ✅

Option B: Enter UPI ID
├─ Enter: 9876543210@okhdfcbank
├─ Click "Open UPI App"
├─ Amount pre-filled in app
├─ Complete payment
├─ Click "Confirm Payment Done"
└─ Order placed ✅
```

---

## 🎨 What Was Added

### HTML Components
```html
<div id="form-upi">
  <img id="upiQrCode">              <!-- QR Code -->
  <input name="upi_id">             <!-- UPI ID input -->
  <button id="upiPayBtn">           <!-- Open UPI App -->
  <button id="upiManualBtn">        <!-- Confirm Payment -->
  <div id="upiPaymentStatus">       <!-- Status message -->
</div>
```

### CSS Classes
```css
.upi-qr-container      /* Main container */
.upi-qr-image         /* QR code image (250x250) */
.upi-amount-display   /* Gold amount box */
.upi-amount-value     /* "Rs. 11,500" text */
.upi-pay-btn          /* Green button */
.upi-manual-btn       /* Light green button */
.upi-status           /* Status animation */
```

### JavaScript Functions
```javascript
generateUPIQRCode()    /* Create QR with amount */
initUPIPayment()       /* Setup UPI form */
showUPIStatus(status)  /* Show payment status */
```

---

## 💰 Amount Display

### Where Amount Appears
```
1. Order Summary Section
   ↓
   Total: Rs. 11,500

2. UPI Payment Box
   ↓
   Amount to Pay: Rs. 11,500

3. QR Code (Embedded)
   ↓
   Scanned by UPI app → Auto-fills payment

4. UPI App (When opened)
   ↓
   Payee: Interior Design Store
   Amount: Rs. 11,500
```

### How Amount is Generated
```php
Subtotal:  Rs. 10,000  (products)
+ Tax 10%: Rs.  1,000  (10% of subtotal)
+ Shipping: Rs.   500  (flat rate)
─────────────────────
Total:     Rs. 11,500  ← This is what shows in QR
```

---

## 🔧 Configuration

### Merchant UPI ID Setup

**What is Merchant UPI ID?**
- Your UPI address where payments come
- Format: `9876543210@bankname` or `email@upi`

**How to Get One:**
```
Option 1: Bank Account
├─ Open HDFC/ICICI/SBI app
├─ Go to UPI settings
├─ Create UPI ID
├─ Usually: 9876543210@okhdfcbank
└─ Copy to checkout.php

Option 2: Google Pay Business
├─ Sign up on google.com/pay/business
├─ Verify business
├─ Get UPI: business@googleplay
└─ Copy to checkout.php

Option 3: PayTM
├─ Create Paytm Merchant account
├─ Get UPI: yourname@paytm
└─ Copy to checkout.php
```

**Where to Put It:**
```javascript
// checkout.php, line ~2605
const merchantUPI = '9876543210@okhdfcbank';
```

---

## 🧪 Testing Checklist

- [ ] QR code displays on UPI form
- [ ] QR code contains amount information
- [ ] Amount shown in UPI box (Rs. 11,500)
- [ ] UPI ID input accepts format: `9876543210@bank`
- [ ] UPI ID input rejects invalid format
- [ ] "Open UPI App" button works on mobile
- [ ] "Confirm Payment Done" button enables checkout
- [ ] Payment status updates correctly
- [ ] Success message shows after confirmation
- [ ] Order is placed with UPI as payment method

---

## 🎯 Payment Flow Diagram

```
┌─────────────────────────────────────────┐
│ Customer at Checkout Page               │
└──────────────┬──────────────────────────┘
               │
               ├─→ Select "🇮🇳 UPI" Payment
               │
┌──────────────▼──────────────────────────┐
│ UPI Form Displays                       │
├─────────────────────────────────────────┤
│  QR Code with Amount                    │
│  [QR showing: Rs. 11,500]              │
│                                         │
│  OR Enter UPI ID                        │
│  [Input: 9876543210@okhdfcbank]        │
│                                         │
│  [Open UPI App]  [Confirm Payment]     │
└──────────────┬──────────────────────────┘
               │
        ┌──────┴──────┐
        │             │
   Scan QR    Manual UPI ID
        │             │
        └──────┬──────┘
               │
┌──────────────▼──────────────────────────┐
│ UPI App Opens                           │
│  ├─ Merchant: Interior Design Store     │
│  ├─ Amount: Rs. 11,500                  │
│  └─ [Pay] Button                        │
└──────────────┬──────────────────────────┘
               │
               ├─→ User Confirms Payment
               │
┌──────────────▼──────────────────────────┐
│ Return to Checkout Page                 │
│ [✓ Confirm Payment Done] Button         │
└──────────────┬──────────────────────────┘
               │
               ├─→ Click "Confirm Payment Done"
               │
┌──────────────▼──────────────────────────┐
│ Order Placed ✅                          │
│ Status: UPI Payment Confirmed           │
│ Amount: Rs. 11,500                      │
│ Order ID: #1234567                      │
└─────────────────────────────────────────┘
```

---

## 🚀 Integration with Payment Gateways

### To Make It Real (Accept Actual Payments)

Choose one of these payment gateways:

**Option 1: Razorpay** (Recommended)
```
Cost: 2% + Rs. 0 per transaction
Setup: 5 minutes
Features: UPI, Cards, Wallets, Auto-reconciliation
```

**Option 2: PayU**
```
Cost: 1.5% - 2.5%
Setup: 3-5 days
Features: Full UPI support, Settlement within 2 hours
```

**Option 3: Instamojo**
```
Cost: 0% + Rs. 0 (UPI)
Setup: 15 minutes
Features: Instant settlement, No approval needed
```

---

## 📊 Current Implementation Status

| Feature | Status | Details |
|---------|--------|---------|
| UPI Form | ✅ Complete | Shows QR + UPI ID input |
| QR Generation | ✅ Complete | Dynamic, with amount |
| Amount Display | ✅ Complete | Shows Rs. 11,500 |
| Payment Verification | ⚠️ Manual | User clicks "Confirm" |
| Database Storage | ❌ Needed | Store UPI payment method |
| Payment Gateway | ❌ Optional | Razorpay/PayU integration |
| Email Confirmation | ❌ Needed | Send after order placed |
| Real Settlement | ❌ Needed | Complete payment flow |

---

## 📝 Notes for Implementation

### Phase 1: ✅ DONE
- [x] UPI payment form UI
- [x] QR code generation
- [x] Amount display
- [x] Payment verification (manual)
- [x] Responsive design

### Phase 2: TODO
- [ ] Database schema for UPI orders
- [ ] Payment gateway integration
- [ ] Automatic payment verification
- [ ] Order confirmation emails
- [ ] Admin dashboard updates

### Phase 3: TODO
- [ ] Real settlement reconciliation
- [ ] Refund handling
- [ ] Transaction reports
- [ ] Webhook handlers
- [ ] Live mode testing

---

## 🆘 Troubleshooting

| Issue | Solution |
|-------|----------|
| QR not showing | Check internet (API needs connection) |
| QR opens wrong app | Ensure correct merchant UPI ID |
| Amount incorrect | Verify calculation in PHP ($total) |
| UPI app not opening | Only works on mobile with UPI app |
| Confirmation stuck | Manually integrate payment gateway |

---

## 📞 Support Resources

- **QRServer Docs:** https://qr-server.com/
- **UPI Specification:** https://www.npci.org.in/
- **Razorpay Docs:** https://razorpay.com/docs/
- **PayU Docs:** https://payu.in/
- **Test UPI Apps:** Google Pay, PhonePe, Paytm

---

**Last Updated:** December 31, 2025  
**Version:** 1.0  
**Status:** Ready for Testing
