# UPI Payment - Visual Guide & Examples

## 📱 UI Layout

### Desktop View
```
┌─────────────────────────────────────────────────────────────┐
│                    CHECKOUT PAGE                            │
├──────────────────────────┬──────────────────────────────────┤
│                          │   ORDER SUMMARY                  │
│  BILLING DETAILS         │   ┌──────────────────┐          │
│  ┌──────────────────────┐│   │ Items (3)        │          │
│  │ Name, Address, etc   ││   │ Subtotal: 10,000 │          │
│  └──────────────────────┘│   │ Tax (10%): 1,000 │          │
│                          │   │ Shipping: 500    │          │
│  PAYMENT METHOD          │   │──────────────────│          │
│  ┌──────────────────────┐│   │ TOTAL: 11,500 💰│          │
│  │ ○ Credit Card        ││   └──────────────────┘          │
│  │ ○ PayPal            ││                                  │
│  │ ○ Bank Transfer     ││                                  │
│  │ ○ Cash on Delivery  ││                                  │
│  │ ● UPI 🇮🇳            ││  UPI PAYMENT FORM              │
│  └──────────────────────┘│  ┌──────────────────┐          │
│                          │  │ Scan to Pay      │          │
│  UPI FORM                │  │  ┌──────────────┐│          │
│  ┌──────────────────────┐│  │  │              ││          │
│  │ [QR CODE HERE]       ││  │  │  QR CODE     ││          │
│  │ Rs. 11,500          ││  │  │              ││          │
│  │                     ││  │  └──────────────┘│          │
│  │ UPI ID:             ││  │ Rs. 11,500 ✓    │          │
│  │ [____________]      ││  └──────────────────┘          │
│  │                     ││                                  │
│  │[Open UPI App]       ││  [💳 Open UPI]  [✓ Confirm]    │
│  │[Confirm Payment]    ││                                  │
│  └──────────────────────┘│                                  │
└──────────────────────────┴──────────────────────────────────┘
```

### Mobile View
```
┌─────────────────────────┐
│   CHECKOUT PAGE         │
├─────────────────────────┤
│ BILLING DETAILS         │
│ ┌─────────────────────┐ │
│ │ Name, Address, ...  │ │
│ └─────────────────────┘ │
│                         │
│ PAYMENT METHOD          │
│ ┌─────────────────────┐ │
│ │ ○ Credit Card       │ │
│ │ ○ PayPal            │ │
│ │ ○ Bank Transfer     │ │
│ │ ○ COD               │ │
│ │ ● UPI 🇮🇳           │ │
│ └─────────────────────┘ │
│                         │
│ UPI PAYMENT             │
│ ┌─────────────────────┐ │
│ │  Scan to Pay        │ │
│ │  ┌─────────────────┐│ │
│ │  │   QR CODE       ││ │
│ │  │   (250×250)     ││ │
│ │  │                 ││ │
│ │  └─────────────────┘│ │
│ │                     │ │
│ │ Amount to Pay:      │ │
│ │ 💰 Rs. 11,500      │ │
│ └─────────────────────┘ │
│                         │
│ UPI ID (Optional):      │
│ ┌─────────────────────┐ │
│ │9876543210@bank      │ │
│ └─────────────────────┘ │
│                         │
│ ┌─────────────────────┐ │
│ │ 💳 Open UPI App    │ │
│ └─────────────────────┘ │
│ ┌─────────────────────┐ │
│ │ ✓ Confirm Payment   │ │
│ └─────────────────────┘ │
│                         │
│ [Status Message]        │
│                         │
│ ORDER SUMMARY           │
│ ┌─────────────────────┐ │
│ │ Subtotal: 10,000   │ │
│ │ Tax: 1,000         │ │
│ │ Shipping: 500      │ │
│ │─────────────────────│ │
│ │ TOTAL: Rs.11,500  │ │
│ └─────────────────────┘ │
│                         │
│ [Place Order Button]    │
└─────────────────────────┘
```

---

## 🎨 Color Scheme

### UPI Interface Colors
```
Primary Gold:        #d4a574  (Main brand color)
Dark Gold:           #b8905a  (Hover state)

QR Code Box:
  Background:        white
  Border:            #d4a574
  Shadow:            rgba(0,0,0,0.1)

Amount Box:
  Background:        linear-gradient(135deg, #d4a574, #b8905a)
  Text Color:        white
  Font Size:         1.8rem (bold)

Button - Open UPI:
  Background:        linear-gradient(135deg, #4CAF50, #45a049)
  Text Color:        white
  Hover:             translate(-2px) + shadow

Button - Confirm:
  Background:        #e8f5e9 (light green)
  Border:            #4CAF50
  Text Color:        #2e7d32
  Hover:             #c8e6c9

Status Messages:
  Waiting:           #e3f2fd (blue)
  Success:           #e8f5e9 (green)
  Error:             #ffebee (red)
```

---

## 🔄 Payment Flow with States

### State Diagram
```
┌──────────────────┐
│   Initial State  │
│  • QR generated  │
│  • Amount shown  │
└────────┬─────────┘
         │
    User selects UPI
         │
    ┌────▼─────────┐
    │              │
Scan QR      Enter UPI ID
    │              │
    └────┬─────────┘
         │
    ┌────▼────────────────────┐
    │  User Opens UPI App      │
    │  • Amount pre-filled     │
    │  • User pays             │
    └────┬─────────────────────┘
         │
    ┌────▼──────────────────────┐
    │ Return to Checkout        │
    │ Status: "Waiting..."      │
    └────┬───────────────────────┘
         │
    Click "Confirm Payment Done"
         │
    ┌────▼──────────────────────┐
    │ Payment Verified ✅        │
    │ Status: "Processing..."   │
    └────┬───────────────────────┘
         │
    ┌────▼──────────────────────┐
    │ Order Placed ✅           │
    │ Status: "Success! ✅"     │
    └───────────────────────────┘
```

---

## 💵 Amount Calculation Example

### Order Scenario
```
Customer Cart:
├─ Nordic Wooden Chair
│  └─ Rs. 12,000 × 1 = Rs. 12,000
│
├─ Coffee Table
│  └─ Rs. 8,000 × 1 = Rs. 8,000
│
└─ Bookshelf
   └─ Rs. 5,000 × 1 = Rs. 5,000

CALCULATION:
─────────────────────────────
Subtotal:        Rs. 25,000
Tax (10%):       Rs. 2,500
Shipping Fee:    Rs. 500
─────────────────────────────
TOTAL:           Rs. 28,000
═════════════════════════════
```

### QR Code for This Order
```
QR String:
upi://pay?
  pa=9876543210@okhdfcbank
  &pn=Interior Design Store
  &am=28000
  &tn=Order Payment
  &tr=ORDER-1704067200000

QR Code Display:
┌─────────────────┐
│ Scan to Pay     │
│ ┌─────────────┐ │
│ │             │ │
│ │  QR CODE    │ │
│ │             │ │
│ └─────────────┘ │
│                 │
│ Amount to Pay:  │
│ 💰 Rs. 28,000  │
└─────────────────┘
```

---

## 📲 UPI Deep Linking Examples

### Format
```
upi://pay?
  pa=<UPI_ID>                 (Payee UPI Address)
  &pn=<NAME>                  (Payee Name)
  &am=<AMOUNT>                (Amount in paise/rupees)
  &tn=<DESCRIPTION>           (Transaction Note)
  &tr=<REFERENCE>             (Transaction Reference)
```

### Real Examples

**Example 1: HDFC Bank**
```
upi://pay?
  pa=9876543210@okhdfcbank
  &pn=Interior Design Store
  &am=11500
  &tn=Order Payment
  &tr=ORDER-20231231-001
```

**Example 2: Google Pay Business**
```
upi://pay?
  pa=business@googleplay
  &pn=Interior Design Store
  &am=28000
  &tn=Purchase Order #1234
  &tr=ORDER-20231231-002
```

**Example 3: Paytm**
```
upi://pay?
  pa=yourname@paytm
  &pn=Interior Design
  &am=15000
  &tn=Payment for furniture
  &tr=TXN-20231231-003
```

---

## ✅ Validation Examples

### UPI ID Format Validation

**Valid UPI IDs:**
```
✓ 9876543210@okhdfcbank
✓ 9876543210@icici
✓ 9876543210@sbi
✓ business@ybl
✓ merchant@upi
✓ user@ibl
✓ name@paytm
```

**Invalid UPI IDs:**
```
✗ 9876543210 (missing @bank)
✗ @okhdfcbank (missing phone)
✗ 98765 43210@bank (spaces)
✗ 9876543210.okhdfcbank (wrong separator)
✗ 9876543210@123 (invalid bank code)
```

### Amount Validation
```
VALID AMOUNTS:
✓ Rs. 11,500   (normal order)
✓ Rs. 100      (minimum)
✓ Rs. 99,99,999 (maximum practical)

INVALID AMOUNTS:
✗ Rs. 0        (no amount)
✗ -Rs. 100     (negative)
✗ Rs. 0.50     (decimals - UPI uses rupees/paise)
```

---

## 🔔 Status Messages

### User Sees These Status Messages

**Step 1: Initial**
```
Scan the QR Code with any UPI App
(Google Pay, PhonePe, Paytm, BHIM, etc.)
```

**Step 2: UPI App Opened**
```
⏳ Opening UPI app... Please complete the payment.
```

**Step 3: Processing**
```
⏳ Verifying payment...
```

**Step 4: Success**
```
✅ Payment received! Your order will be placed shortly.
```

**Step 5: Error**
```
❌ Payment verification failed. Please try again.
```

---

## 🧮 Code Example: QR Generation

### JavaScript Code
```javascript
function generateUPIQRCode() {
  // Get order total from PHP
  const totalAmount = 11500; // Rs. 11,500
  
  // Merchant details
  const merchantUPI = '9876543210@okhdfcbank';
  const merchantName = 'Interior Design Store';
  const transactionRef = 'ORDER-' + new Date().getTime();
  
  // Build UPI string
  const upiString = `upi://pay?pa=${merchantUPI}&pn=${encodeURIComponent(merchantName)}&am=${totalAmount}&tn=Order%20Payment&tr=${transactionRef}`;
  
  // Generate QR code
  const qrCodeUrl = `https://api.qrserver.com/v1/create-qr-code/?size=250x250&data=${encodeURIComponent(upiString)}`;
  
  // Display QR
  const qrImage = document.getElementById('upiQrCode');
  qrImage.src = qrCodeUrl;
  
  // Display amount
  const amountEl = document.getElementById('upiAmount');
  amountEl.textContent = 'Rs. ' + totalAmount.toLocaleString();
}
```

### Result
- QR code image (250×250 pixels)
- Shows exact amount
- Scans to payment app
- No user input needed

---

## 🌐 Supported UPI Apps (India)

```
┌─────────────────────────────────────────┐
│ UPI Apps That Scan Our QR               │
├─────────────────────────────────────────┤
│                                         │
│  Google Pay (GPay)                      │
│  PhonePe                                │
│  Paytm                                  │
│  BHIM (NPCI)                            │
│  WhatsApp Payments                      │
│  Amazon Pay                             │
│  Mobikwik                               │
│  Airtel Payments                        │
│  Axis Pay                               │
│  HDFC PayZapp                           │
│  ICICI Pockets                          │
│  & many more...                         │
│                                         │
│  ✓ All NPCI-registered UPI apps        │
│  ✓ Work with standard UPI format       │
│  ✓ Accept QR code payments             │
│                                         │
└─────────────────────────────────────────┘
```

---

## 📊 Data Flow Diagram

```
CUSTOMER BROWSER
│
├─ Selects UPI Payment
│  │
│  └─> triggerPaymentMethodChange()
│
├─ switchPaymentForm('upi')
│  │
│  └─> Show UPI form
│
├─ initUPIPayment()
│  │
│  ├─> generateUPIQRCode()
│  │   │
│  │   ├─ Get total amount: Rs. 11,500
│  │   │
│  │   ├─ Build UPI string
│  │   │   (pa=merchant, am=11500, ...)
│  │   │
│  │   └─ Call QRServer API
│  │       │
│  │       └─> Generate QR image
│  │           └─> Display in UI
│  │
│  └─> Setup event listeners
│      ├─ "Open UPI App" button
│      └─ "Confirm Payment" button
│
├─ User Scans QR / Enters UPI ID
│  │
│  └─> Opens UPI app with amount
│
├─ User Confirms Payment
│  │
│  └─> Returns to checkout page
│
└─ Click "Confirm Payment Done"
   │
   └─> showUPIStatus('success')
       └─> Set window.upiPaymentVerified = true
           └─> Enable checkout button
```

---

## 🎯 Testing Scenarios

### Scenario 1: QR Code Scanning
```
┌─────────────────────────────────────────┐
│ Step 1: Customer at Checkout            │
│ • Selects UPI payment                   │
│ • Sees QR code with amount              │
│ ✓ Amount shows: Rs. 11,500             │
├─────────────────────────────────────────┤
│ Step 2: Scan QR with Phone              │
│ • Opens Google Pay / PhonePe            │
│ • Amount pre-filled: Rs. 11,500        │
│ • Merchant shown: Interior Design Store │
│ ✓ UPI app shows correct details        │
├─────────────────────────────────────────┤
│ Step 3: Complete Payment                │
│ • User confirms in UPI app              │
│ • Payment successful                    │
│ ✓ Transaction goes to merchant UPI     │
├─────────────────────────────────────────┤
│ Step 4: Return to Checkout              │
│ • Customer clicks "Confirm Payment Done"│
│ • Status shows success                  │
│ ✓ Order placed with UPI method         │
└─────────────────────────────────────────┘
```

### Scenario 2: Manual UPI Entry
```
┌─────────────────────────────────────────┐
│ Step 1: Customer Enter UPI ID           │
│ • Types: 9876543210@okhdfcbank         │
│ • Validates format                      │
│ ✓ Input accepted                       │
├─────────────────────────────────────────┤
│ Step 2: Click "Open UPI App"            │
│ • Browser opens: upi://pay?am=11500... │
│ • UPI app launches on mobile            │
│ • Amount pre-filled: Rs. 11,500        │
│ ✓ UPI app ready for payment            │
├─────────────────────────────────────────┤
│ Step 3: Complete Payment                │
│ • User confirms amount                  │
│ • Payment processed                     │
│ ✓ Money transferred to merchant        │
├─────────────────────────────────────────┤
│ Step 4: Confirm in Checkout             │
│ • Returns to checkout page              │
│ • Clicks "Confirm Payment Done"         │
│ ✓ Order finalized                      │
└─────────────────────────────────────────┘
```

---

**Document Version:** 1.0  
**Last Updated:** December 31, 2025  
**Status:** Complete ✅
