<?php
session_start();
require_once __DIR__ . '/config/db.php';

$page_title = 'About Us - Faren Interior Design';
$page_description = 'Learn about our team and company story';

$user_name = isset($_SESSION['user_name']) ? htmlspecialchars($_SESSION['user_name']) : '';
$user_role = isset($_SESSION['user_role']) ? $_SESSION['user_role'] : '';
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Faren Interior Design</title>
    <meta name="author" content="themeholy">
    <meta name="description" content="Faren   - Architecture & Interior Design Template">
    <meta name="keywords" content="Faren   - Architecture & Interior Design Template">
    <meta name="robots" content="INDEX,FOLLOW">
    <meta name="viewport" content="width=device-width,initial-scale=1,shrink-to-fit=no">
    <link rel="apple-touch-icon" sizes="57x57" href="assets/img/favicons/apple-icon-57x57.png">
    <link rel="apple-touch-icon" sizes="60x60" href="assets/img/favicons/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="assets/img/favicons/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="assets/img/favicons/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="assets/img/favicons/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="assets/img/favicons/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="assets/img/favicons/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="assets/img/favicons/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="assets/img/favicons/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192" href="assets/img/favicons/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="32x32" href="assets/img/favicons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="assets/img/favicons/favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="assets/img/favicons/favicon-16x16.png">
    <link rel="manifest" href="assets/img/favicons/manifest.json">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="assets/img/favicons/ms-icon-144x144.png">
    <meta name="theme-color" content="#ffffff">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="../../css2-1?family=DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <link rel="stylesheet" href="assets/css/swiper-bundle.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <script src="assets/js/auth-ui-global.js"></script>
</head>

<body id="show-grid">
    <!-- header -->
     <?php include 'header-section.html'; ?>
    <!-- about outcompany -->
    <div class="overflow-hidden overflow-hidden space-top">
       <style>
        /* ================================
   MODERN ABOUT SECTION � PREMIUM STYLE
=================================== */

.about-area2 {
    position: relative;
    padding: 20px 0;
}

.about-area3 .title-area .sec-title {
    font-weight: 700;
    line-height: 1.2;
    letter-spacing: -0.5px;
}

.about-box-wrap {
    margin-top: 25px;
    display: grid;
    gap: 22px;
}

.about-box {
    display: flex;
    gap: 18px;
    padding: 22px 25px;
    border-radius: 16px;
    background: #ffffff;
    border: 1px solid #f0f0f0;
    transition: all .35s ease;
    box-shadow: 0 6px 20px rgba(0,0,0,0.04);
}

.about-box:hover {
    transform: translateY(-6px);
    box-shadow: 0 12px 35px rgba(0,0,0,0.10);
    background: #ffffff;
}

.about-box .box-icon {
    width: 60px;
    height: 60px;
    min-width: 60px;
    border-radius: 12px;
    background: #f7f7f7;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all .35s ease;
}

.about-box:hover .box-icon {
    transform: scale(1.12);
    background: #121212;
}

.about-box .box-icon img {
    width: 32px;
    height: auto;
    transition: all .35s ease;
}

.about-box:hover .box-icon img {
    filter: brightness(0) invert(1);
}

.about-box .box-title {
    font-size: 20px;
    font-weight: 700;
    margin-bottom: 4px;
}

.about-box p {
    margin: 0;
    font-size: 15px;
    opacity: .75;
}

/* ================================
       RIGHT-SIDE IMAGE AREA
=================================== */

.img-box5 {
    position: relative;
}

.img-box5 .img1 img {
    border-radius: 22px;
    box-shadow: 0 15px 35px rgba(0,0,0,0.08);
    transition: transform .5s ease, box-shadow .5s ease;
}

.img-box5:hover .img1 img {
    transform: translateY(-8px);
    box-shadow: 0 25px 55px rgba(0,0,0,0.12);
}

/* ================================
          RESPONSIVE DESIGN
=================================== */

@media (max-width: 992px) {
    .about-box {
        padding: 20px;
    }
    .about-box .box-title {
        font-size: 18px;
    }
}

@media (max-width: 768px) {
    .about-area3 .title-area {
        text-align: center !important;
        margin-top: -70px;
    }
    .about-box {
        flex-direction: column;
        text-align: center;
        align-items: center;
    }
    .about-box .box-icon {
        margin-bottom: 10px;
    }
}

/* MOBILE OPTIMIZATION: Remove top blank space for mobile view */
@media (max-width: 599px) and (min-width: 480px) {
    .container[style*="padding-top: 190px"] {
        padding-top: 60px !important;
    }
}

@media (max-width: 479px) and (min-width: 380px) {
    .container[style*="padding-top: 190px"] {
        padding-top: 0px !important;
        margin-top: -60px !important;
    }
}

@media (max-width: 379px) {
    .container[style*="padding-top: 190px"] {
        padding-top: 40px !important;
    }
}

       </style>
         
        <div class="container" style="padding-top: 190px;">
            <div class="about-area2">
                <div class="row align-items-center flex-row-reverse">
                    <div class="col-xl-7">
                        <div class="about-area3">
                            <div class="title-area mb-30 text-center text-sm-start">
                                <span class="sub-title style3 text-anime">More About Our Interior Studio</span>
                                <h2 class="sec-title style4 split-text">Designing Thoughtful Interior Spaces</h2>
                            </div>

                            <div class="about-box-wrap">

                                <div class="about-box wow fadeInUp" data-wow-delay=".4s">
                                      <div class="box-icon">
                                           <img src="assets/img/icon/about_1_1.svg" alt="Icon">
                                        </div>
                                      <div class="media-body">
                                        <h3 class="box-title">Customized Interior Solutions</h3>
                                           <p>We design personalized interiors that reflect your lifestyle, preferences, and functional needs,
                ensuring harmony between aesthetics and comfort.
                                            </p>
                                        </div>
                                  </div>

                             <div class="about-box wow fadeInUp" data-wow-delay=".5s">
                             <div class="box-icon">
                             <img src="assets/img/icon/about_1_2.svg" alt="Icon">
                                         </div>
                                <div class="media-body">
                                       <h3 class="box-title">Client-Focused Design Process</h3>
                               <p>
                               Our collaborative approach keeps you involved at every stage, from concept development to final
                               styling, delivering interiors that truly feel like home.
                                       </p>
                                    </div>
                                  </div>

                    <div class="about-box wow fadeInUp" data-wow-delay=".7s">
                     <div class="box-icon">
                     <img src="assets/img/icon/about_1_3.svg" alt="Icon">
                      </div>
                      <div class="media-body">
                     <h3 class="box-title">3D Visualization & Space Planning</h3>
                        <p>
                           Detailed 3D renders and smart space planning help you visualize layouts, materials, and finishes
                          before execution begins.
                      </p>
                      </div>
                     </div>

                </div>
                        </div>
                    </div>
                    <div class="col-xl-5">
                        <div class="img-box5">
                            <div class="img1 global-img img-anim-left"><img class="w-100"
                                    src="assets/img/normal/about_6_1.jpg" alt="About"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Experience with -->
    <div class="counter-area2 space-bottom overflow-hidden" style="margin-top: -70px;">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="title-area text-center text-md-start"><span
                            class="sub-title style3 text-anime">Experience with 120k Visitors</span>
                        <h2 class="sec-title style4 split-text">Our Featured Facilities</h2>
                        <p class="wow fadeInUp" data-wow-delay=".3s">Our practice is Designing Complete
                            EnvironmentsTM�exceptional buildings, communities and places�in special situations, where a
                            unique historic or natural environment requires an especially thoughtful and innovative
                            solution.</p>
                    </div>
                </div>
                <div class="counter-card_wrapp style3">
                    <div class="counter-card style5 wow fadeInUp" data-wow-delay=".2s">
                        <h3 class="box-number"><span class="counter-number">98</span>%</h3>
                        <p class="box-text">happy customer</p>
                    </div>
                    <div class="counter-card style5 wow fadeInUp" data-wow-delay=".4s">
                        <h3 class="box-number"><span class="counter-number">4.9</span></h3>
                        <p class="box-text">average reviews</p>
                    </div>
                    <div class="counter-card style5 wow fadeInUp" data-wow-delay=".5s">
                        <h3 class="box-number"><span class="counter-number">1.6</span>k+</h3>
                        <p class="box-text">Complete Project</p>
                    </div>
                    <div class="counter-card style5 wow fadeInUp" data-wow-delay=".6s">
                        <h3 class="box-number"><span class="counter-number">126</span></h3>
                        <p class="box-text">Award Win</p>
                    </div>
                </div>
            </div>
            <div class="shape-mockup d-none d-md-block" data-bottom="0%" data-right="0%"><img
                    src="assets/img/normal/counter-img.jpg" alt=""></div>
        </div>
    </div>

    
    <!-- OUR SERVICES -->
    <section class="position-relative overflow-hidden space" id="service-sec" style="margin-top: -70px;">
<style>
/* ============================
   UNIQUE SERVICE SECTION DESIGN
=============================== */

#service-sec {
    position: relative;
}

/* WRAPPER */
#service-sec .service-item {
    background: rgba(255,255,255,0.12);
    backdrop-filter: blur(8px);
    border-radius: 18px;
    padding: 32px 28px;
    border: 1px solid rgba(255,255,255,0.18);
    transition: all .35s ease;
    box-shadow: 0 0 0 rgba(0,0,0,0);
}

/* Hover Effects */
#service-sec .service-item:hover {
    transform: translateY(-12px);
    background: rgba(255,255,255,0.18);
    border-color: var(--theme-color, #00c19d);
    box-shadow: 0 18px 45px rgba(0,0,0,0.18);
}

/* Icon Styling */
#service-sec .service-item .box-icon img {
    width: 64px;
    height: 64px;
    transition: transform .35s ease;
}

/* Icon Lift on Hover */
#service-sec .service-item:hover .box-icon img {
    transform: translateY(-6px) scale(1.1);
}

/* Title */
#service-sec .service-item .box-title {
    font-size: 22px;
    font-weight: 700;
    margin: 18px 0 10px;
    transition: color .3s ease;
}

/* Title Glow */
#service-sec .service-item:hover .box-title {
    color: var(--theme-color, #00c19d);
    text-shadow: 0 0 6px rgba(0,193,157,0.4);
}

/* Text */
#service-sec .service-item .box-text {
    font-size: 16px;
    color: #ddd;
    line-height: 1.6;
}

/* Read More Button */
#service-sec .service-item .line-btn {
    font-weight: 600;
    margin-top: 10px;
    display: inline-flex;
    align-items: center;
    gap: 6px;
    transition: .3s ease;
}

#service-sec .service-item .line-btn:hover {
    letter-spacing: .7px;
    color: var(--theme-color, #00c19d);
}

/* RESPONSIVE */
@media(max-width: 992px){
    #service-sec .service-item {
        margin: 0 auto;
        max-width: 420px;
    }
}
@media(max-width: 576px){
    #service-sec .service-item {
        padding: 26px 22px;
        border-radius: 16px;
    }
    #service-sec .service-item .box-title {
        font-size: 20px;
    }
}
</style>

        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <div class="title-area">
                        <h2 class="sec-title style3 split-text">Our Services...</h2>
                    </div>
                </div>
            </div>
            <div class="service-area3">
                <div class="row gy-4 justify-content-center">
                    <div class="col-md-6 col-xl-4">
                        <div class="service-item wow fadeInUp" data-wow-delay=".1s">
                            <div class="box-content">
                                <div class="box-icon"><img src="assets/img/icon/service_3_1.svg" alt="Icon"></div>
                                <h3 class="box-title">
                                 <a href="interior-design.html">Interior Design & Space Planning</a>
                                </h3>
                                <p class="box-text">
                                    We design refined interior spaces through thoughtful planning, material selection,
                                    and layout optimization to create functional and visually elegant environments.
                                </p>
                                <a href="interior-design.html" class="line-btn">
                                  Read More <i class="fa-regular fa-arrow-right"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-xl-4">
                        <div class="service-item wow fadeInUp" data-wow-delay=".3s">
                            <div class="box-content">
                                <div class="box-icon"><img src="assets/img/icon/service_3_1.svg" alt="Icon"></div>
                                <h3 class="box-title">
                                 <a href="interior-projects.html">Residential & Commercial Interiors</a>
                                </h3>
                                <p class="box-text">
                                Creating bespoke residential and commercial interiors that balance comfort,
                                aesthetics, and functionality while reflecting the client’s lifestyle and brand.
                                </p>
                                <a href="interior-projects.html" class="line-btn">
                                  Read More <i class="fa-regular fa-arrow-right"></i>
                                </a>        
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-xl-4">
                        <div class="service-item wow fadeInUp" data-wow-delay=".5s">
                            <div class="box-content">
                                <div class="box-icon"><img src="assets/img/icon/service_3_1.svg" alt="Icon"></div>
                                <h3 class="box-title">
                                <a href="3d-visualization.html">3D Interior Visualization</a>
                                </h3>
                                <p class="box-text">
                                High-quality 3D interior visualizations that bring design concepts to life,
                                helping clients experience space, lighting, and materials before execution.
                                </p>
                                <a href="3d-visualization.html" class="line-btn">
                                     Read More <i class="fa-regular fa-arrow-right"></i>
                                </a>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- GALLERY SECTION -->
    <!-- <div class="overflow-hidden space overflow-hidden" data-bg-src="assets/img/bg/gallery_bg_1.jpg">

        <style>
/* ==========================================================================
   PREMIUM PROJECT GALLERY � CUSTOM UNIQUE DESIGN
   ========================================================================== */

/* Section Base */
#project-sec {
    position: relative;
    padding-top: 80px;
}

/* Title Enhancement */
#project-sec .title-area .sec-title {
    font-size: 36px;
    letter-spacing: -0.5px;
}

/* ------------------------
   FILTER MENU STYLING
------------------------ */
.filter-menu .tab-btn {
    padding: 10px 26px;
    border-radius: 30px;
    border: 1px solid rgba(255,255,255,0.4);
    backdrop-filter: blur(4px);
    transition: 0.3s ease;
}

.filter-menu .tab-btn:hover,
.filter-menu .tab-btn.active {
    background: #fff;
    color: #000;
    border-color: #fff;
    transform: translateY(-3px);
}

/* ------------------------
   GALLERY CARD
------------------------ */
.gallery-card.style2 {
    position: relative;
    overflow: hidden;
    border-radius: 20px;
    background: #000;
    transition: .35s ease-out;
    transform: translateY(0);
}

/* Hover Lift */
.gallery-card.style2:hover {
    transform: translateY(-8px);
    box-shadow: 0 18px 40px rgba(0,0,0,0.25);
}

/* Image Styling */
.gallery-card .box-img {
    position: relative;
    overflow: hidden;
    border-radius: 20px;
}

.gallery-card img {
    width: 100%;
    height: auto;
    transition: .6s ease;
    transform: scale(1);
}

/* Hover Zoom */
.gallery-card:hover img {
    transform: scale(1.08);
    opacity: 0.95;
}

/* Plus Icon Button */
.gallery-card .icon-btn {
    background: rgba(255,255,255,0.2);
    border: 1px solid rgba(255,255,255,0.6);
    backdrop-filter: blur(6px);
    width: 50px;
    height: 50px;
    border-radius: 50%;
    transition: .3s ease;
}

.gallery-card:hover .icon-btn {
    background: #fff;
    color: #000;
    transform: scale(1.15);
}

/* ------------------------
   BOTTOM TITLE OVERLAY
------------------------ */
.gallery-card .gallery-content {
    padding: 22px 10px 20px;
    text-align: center;
    background: transparent;
}

.gallery-card .gallery-content .box-title {
    font-size: 20px;
    font-weight: 600;
    margin-top: 12px;
    letter-spacing: -0.3px;
}

/* ------------------------
   DOT SHAPE ANIMATION
------------------------ */
.gallery-card .shape {
    position: absolute;
    bottom: 12px;
    right: 12px;
    display: flex;
    gap: 5px;
}

.gallery-card .shape .dot {
    width: 7px;
    height: 7px;
    background: rgba(255,255,255,0.6);
    border-radius: 50%;
    opacity: 0;
    animation: dotWave 1.4s infinite ease-in-out;
}

.gallery-card .shape .dot:nth-child(1) { animation-delay: 0s; }
.gallery-card .shape .dot:nth-child(2) { animation-delay: 0.25s; }
.gallery-card .shape .dot:nth-child(3) { animation-delay: 0.5s; }
.gallery-card .shape .dot:nth-child(4) { animation-delay: 0.75s; }

@keyframes dotWave {
    0%,100% { opacity: 0; transform: translateY(0); }
    50%     { opacity: 1; transform: translateY(-4px); }
}

/* ------------------------
    RESPONSIVE DESIGN
------------------------ */

/* Tablet */
@media (max-width: 992px) {
    .gallery-card.style2 {
        border-radius: 16px;
    }
    .gallery-card img {
        transform: scale(1.02);
    }
}

/* Mobile */
@media (max-width: 576px) {
    #project-sec {
        padding-top: 50px;
    }
    .gallery-card .gallery-content .box-title {
        font-size: 18px;
    }
    .filter-menu .tab-btn {
        padding: 8px 18px;
        margin-bottom: 8px;
    }
}
</style>
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-7">
                    <div class="title-area text-center"><span class="sub-title style2 text-anime">recent gallery</span>
                        <h2 class="sec-title split-text">Through a Unique Combination of <span
                                class="text-theme">Engineering</span></h2>
                    </div>
                    <div class="filter-menu indicator-active mb-60 filter-menu-active"><button data-filter="*"
                            class="tab-btn active" type="button">View All</button> <button data-filter=".cat1"
                            class="tab-btn" type="button">Interior</button> <button data-filter=".cat2" class="tab-btn"
                            type="button">Architecture</button> <button data-filter=".cat3" class="tab-btn"
                            type="button">Building</button> <button data-filter=".cat4" class="tab-btn"
                            type="button">Exterior</button> <button data-filter=".cat5" class="tab-btn"
                            type="button">Shape</button></div>
                </div>
            </div>
            <div class="row gy-4 gallery-row filter-active">
                <div class="col-lg-6 col-xl-4 col-xxl-auto filter-item cat2 cat5">
                    <div class="gallery-card">
                        <div class="box-img global-img"><img class="wow clippy-img"
                                src="assets/img/gallery/gallery_2_1.jpg" alt="gallery image"> <a
                                href="assets/img/gallery/gallery_2_1.jpg" class="icon-btn th-popup-image"><i
                                    class="far fa-plus"></i></a>
                            <div class="shape">
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                            </div>
                        </div>
                        <div class="gallery-content">
                            <h2 class="box-title">Open Kitchen Interior Design</h2>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-xl-4 col-xxl-auto filter-item cat3 cat2">
                    <div class="gallery-card">
                        <div class="box-img global-img"><img class="wow clippy-img"
                                src="assets/img/gallery/gallery_2_2.jpg" alt="gallery image"> <a
                                href="assets/img/gallery/gallery_2_2.jpg" class="icon-btn th-popup-image"><i
                                    class="far fa-plus"></i></a>
                            <div class="shape">
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                            </div>
                        </div>
                        <div class="gallery-content">
                            <h2 class="box-title">Open Kitchen Interior Design</h2>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-xl-4 col-xxl-auto filter-item cat3 cat5">
                    <div class="gallery-card">
                        <div class="box-img global-img"><img class="wow clippy-img"
                                src="assets/img/gallery/gallery_2_3.jpg" alt="gallery image"> <a
                                href="assets/img/gallery/gallery_2_3.jpg" class="icon-btn th-popup-image"><i
                                    class="far fa-plus"></i></a>
                            <div class="shape">
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                            </div>
                        </div>
                        <div class="gallery-content">
                            <h2 class="box-title">Open Kitchen Interior Design</h2>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-xl-4 col-xxl-auto filter-item cat1 cat5">
                    <div class="gallery-card">
                        <div class="box-img global-img"><img class="wow clippy-img"
                                src="assets/img/gallery/gallery_2_4.jpg" alt="gallery image"> <a
                                href="assets/img/gallery/gallery_2_4.jpg" class="icon-btn th-popup-image"><i
                                    class="far fa-plus"></i></a>
                            <div class="shape">
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                            </div>
                        </div>
                        <div class="gallery-content">
                            <h2 class="box-title">Open Kitchen Interior Design</h2>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-xl-4 col-xxl-auto filter-item cat4 cat2 cat1">
                    <div class="gallery-card">
                        <div class="box-img global-img"><img class="wow clippy-img"
                                src="assets/img/gallery/gallery_2_5.jpg" alt="gallery image"> <a
                                href="assets/img/gallery/gallery_2_5.jpg" class="icon-btn th-popup-image"><i
                                    class="far fa-plus"></i></a>
                            <div class="shape">
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                            </div>
                        </div>
                        <div class="gallery-content">
                            <h2 class="box-title">Open Kitchen Interior Design</h2>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 col-xl-4 col-xxl-auto filter-item cat4 cat3 cat1">
                    <div class="gallery-card">
                        <div class="box-img global-img"><img class="wow clippy-img"
                                src="assets/img/gallery/gallery_2_6.jpg" alt="gallery image"> <a
                                href="assets/img/gallery/gallery_2_6.jpg" class="icon-btn th-popup-image"><i
                                    class="far fa-plus"></i></a>
                            <div class="shape">
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                                <div class="dot"></div>
                            </div>
                        </div>
                        <div class="gallery-content">
                            <h2 class="box-title">Open Kitchen Interior Design</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div> -->
    <!-- WHY CHOOSE US -->
    <section class="choose-area overflow-hidden space-top overflow-hidden" style="margin-top: -70px;">
        <style>
/* =============================
   UNIQUE CHOOSE-US SECTION CSS
=============================== */

/* Section Background Overlay */
.choose-area {
    position: relative;
    padding-top: 90px;
    padding-bottom: 60px;
}

/* CHOOSE BOX */
.choose-box {
    background: rgba(255,255,255,0.08);
    backdrop-filter: blur(10px);
    border-radius: 18px;
    padding: 32px 28px;
    border: 1px solid rgba(255,255,255,0.18);
    transition: all .35s ease;
    height: 100%;
    position: relative;
    overflow: hidden;
}

/* NEON BORDER ON HOVER */
.choose-box:hover {
    border-color: #00f5b9;
    box-shadow: 0 0 18px rgba(0,245,185,0.45);
    transform: translateY(-12px);
}

/* ICON */
.choose-box .box-icon img {
    width: 68px;
    height: 68px;
    transition: all .3s ease;
    filter: drop-shadow(0 0 6px rgba(255,255,255,0.3));
}

/* Icon animation on hover */
.choose-box:hover .box-icon img {
    transform: scale(1.15) translateY(-6px);
    filter: drop-shadow(0 0 12px rgba(0,245,185,0.8));
}

/* Titles */
.choose-box .box-title {
    font-size: 22px;
    font-weight: 700;
    margin: 18px 0 10px;
    color: #fff;
    transition: .3s ease;
}

/* Neon title glow */
.choose-box:hover .box-title {
    color: #00f5b9;
    text-shadow: 0 0 12px rgba(0,245,185,.7);
}

/* Text */
.choose-box .box-text {
    color: #e0e0e0;
    line-height: 1.6;
    font-size: 16px;
}

/* Slide Spacing Fix */
#chooseSlide .swiper-slide {
    height: auto;
}

/* Progressbar Style */
.swiper-pagination-progressbar {
    height: 4px !important;
    background: rgba(255,255,255,0.15) !important;
}
.swiper-pagination-progressbar-fill {
    background: linear-gradient(90deg, #00f5b9, #00ffaa) !important;
}

/* RESPONSIVE */
@media(max-width: 992px){
    .choose-box {
        padding: 26px 22px;
    }
    .choose-box .box-title {
        font-size: 20px;
    }
}
@media(max-width: 576px){
    .choose-box {
        text-align: center;
    }
    .choose-box .box-icon img {
        width: 58px;
    }
}
</style>
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-7">
                    <div class="title-area text-center" style="margin-top: -70px;"><span class="sub-title style4 text-white">Why Choose Us</span>
                        <h3 class="sec-title split-text text-white">Why Should You Choose Us</h3>
                    </div>
                </div>
            </div>
            <hr class="">
            <div class="slider-wrap mt-60">
                <div class="swiper th-slider has-shadow" id="chooseSlide"
                    data-slider-options='{"loop":false,"paginationType": "progressbar","spaceBetween": 70,"mousewheel": {"enabled": true,"sensitivity": 4,"releaseOnEdges":true},"breakpoints": {"0":{"slidesPerView": 1},"576": {"slidesPerView": 1},"768": {"slidesPerView": 2},"992": {"slidesPerView": 2},"1200": {"slidesPerView": 3},"1400": {"slidesPerView": 4}}}'>
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                            <div class="choose-box">
                                <div class="box-icon"><img src="assets/img/icon/choose_2_1.svg" alt="img"></div>
                                <div class="box-content">
                                    <h3 class="box-title text-white">Design Excellence</h3>
                                    <p class="box-text">We blend creativity with technical mastery to deliver iconic,
                                        functional, and timeless architecture...</p>
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="choose-box">
                                <div class="box-icon"><img src="assets/img/icon/choose_2_2.svg" alt="img"></div>
                                <div class="box-content">
                                    <h3 class="box-title text-white">Client-Centered Approach</h3>
                                    <p class="box-text">We blend creativity with technical mastery to deliver iconic,
                                        functional, and timeless architecture...</p>
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="choose-box">
                                <div class="box-icon"><img src="assets/img/icon/choose_2_3.svg" alt="img"></div>
                                <div class="box-content">
                                    <h3 class="box-title text-white">Customer-Focused Design</h3>
                                    <p class="box-text">We blend creativity with technical mastery to deliver iconic,
                                        functional, and timeless architecture...</p>
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="choose-box">
                                <div class="box-icon"><img src="assets/img/icon/choose_2_4.svg" alt="img"></div>
                                <div class="box-content">
                                    <h3 class="box-title text-white">Sustainable Innovation</h3>
                                    <p class="box-text">We blend creativity with technical mastery to deliver iconic,
                                        functional, and timeless architecture...</p>
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="choose-box">
                                <div class="box-icon"><img src="assets/img/icon/choose_2_1.svg" alt="img"></div>
                                <div class="box-content">
                                    <h3 class="box-title text-white">Design Excellence</h3>
                                    <p class="box-text">We blend creativity with technical mastery to deliver iconic,
                                        functional, and timeless architecture...</p>
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="choose-box">
                                <div class="box-icon"><img src="assets/img/icon/choose_2_2.svg" alt="img"></div>
                                <div class="box-content">
                                    <h3 class="box-title text-white">Client-Centered Approach</h3>
                                    <p class="box-text">We blend creativity with technical mastery to deliver iconic,
                                        functional, and timeless architecture...</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- <div class="marquee-content style2 positive-relative overflow-hidden">
                <div class="marquee">
                    <div class="marquee-group style3">
                        <div class="item"><img src="assets/img/shape/timeline.png" alt=""></div>
                        <div class="item"><img src="assets/img/shape/timeline.png" alt=""></div>
                    </div>
                    <div aria-hidden="true" class="marquee-group style3">
                        <div class="item"><img src="assets/img/shape/timeline.png" alt=""></div>
                        <div class="item"><img src="assets/img/shape/timeline.png" alt=""></div>
                    </div>
                </div>
            </div> -->
        </div>
    </section>
    <!-- FAQ SECTION -->
    <!-- <div class="overflow-hidden space overflow-hidden" id="faq-sec">
        <style>
/* ============================================
   UNIQUE & RESPONSIVE FAQ SECTION DESIGN
   ============================================ */

/* FAQ Section Spacing */
#faq-sec {
    padding: 70px 0;
    position: relative;
}

/* Title Styling */
#faq-sec .sub-title {
    font-size: 15px;
    text-transform: uppercase;
    color: #2b8a62;
    font-weight: 600;
    letter-spacing: 1px;
}

#faq-sec .sec-title {
    font-size: 38px;
    font-weight: 700;
    line-height: 1.3;
}

#faq-sec .text-theme {
    color: #2b8a62;
}

/* ============================================
   ACCORDION CARD
   ============================================ */
#faq-sec .accordion-card {
    background: #ffffff;
    border-radius: 12px;
    margin-bottom: 18px;
    padding: 0;
    box-shadow: 0px 4px 16px rgba(0,0,0,0.06);
    overflow: hidden;
    transition: 0.3s ease;
}

#faq-sec .accordion-card.active,
#faq-sec .accordion-card:hover {
    transform: translateY(-3px);
}

/* Header Button */
#faq-sec .accordion-button {
    background: #f3f6f4;
    padding: 16px 20px;
    font-size: 17px;
    font-weight: 600;
    color: #222;
    border-radius: 0;
    border: none;
    box-shadow: none;
    transition: 0.3s ease;
}

#faq-sec .accordion-button:not(.collapsed) {
    background: #2b8a62;
    color: #fff;
}

#faq-sec .accordion-button::after {
    filter: brightness(0) invert(0.5);
}

#faq-sec .accordion-button:not(.collapsed)::after {
    filter: brightness(0) invert(1);
}

/* Accordion Body */
#faq-sec .accordion-body {
    padding: 18px 22px;
    background: #ffffff;
    border-left: 3px solid #2b8a62;
}

#faq-sec .faq-text {
    color: #555;
    line-height: 1.7;
    font-size: 15px;
    margin: 0;
}

/* ============================================
   RIGHT SIDE IMAGE
   ============================================ */
#faq-sec .faq-image img {
    width: 100%;
    height: auto;
    border-radius: 14px;
    object-fit: cover;
    box-shadow: 0px 6px 26px rgba(0,0,0,0.15);
    transition: transform 0.4s ease;
}

#faq-sec .faq-image:hover img {
    transform: scale(1.03);
}

/* Background Image Shape */
#faq-sec .shape-mockup img {
    width: 370px;
    opacity: 0.15;
}

/* ============================================
   RESPONSIVE DESIGN
   ============================================ */

/* Tablet */
@media (max-width: 992px) {
    #faq-sec {
        padding: 60px 0;
    }
    #faq-sec .sec-title {
        font-size: 32px;
    }
    #faq-sec .faq-image {
        margin-top: 30px;
    }
}

/* Mobile */
@media (max-width: 576px) {
    #faq-sec {
        padding: 45px 0;
    }
    #faq-sec .sec-title {
        font-size: 26px;
        text-align: center;
    }
    #faq-sec .sub-title {
        text-align: center;
        display: block;
        margin-bottom: 10px;
    }
    #faq-sec .accordion-button {
        font-size: 16px;
        padding: 14px 16px;
    }
    #faq-sec .accordion-body {
        font-size: 14px;
        padding: 14px 16px;
    }
    #faq-sec .faq-image img {
        border-radius: 10px;
    }
}

</style>
        <div class="container">
            <div class="row gx-0 align-items-center flex-row-reverse">
                <div class="col-xl-6 mt-35 mt-xl-0">
                    <div class="pe-xl-5 me-xl-5">
                        <div class="title-area mb-40"><span class="sub-title text-anime">FAQ�S</span>
                            <h2 class="sec-title style4 split-text">Functional Architect Design Studios.</h2>
                        </div>
                        <div class="accordion-area accordion" id="faqAccordion3">
                            <div class="accordion-card wow fadeInUp" data-wow-delay=".1s">
                                <div class="accordion-header" id="collapse-item-1"><button
                                        class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapse-1" aria-expanded="false" aria-controls="collapse-1">1.
                                        What does an architect do??</button></div>
                                <div id="collapse-1" class="accordion-collapse collapse"
                                    aria-labelledby="collapse-item-1" data-bs-parent="#faqAccordion3">
                                    <div class="accordion-body">
                                        <p class="faq-text">Most medical centers offer charity programs, counseling, and
                                            financial assistance for those in need. Non-Muslims are welcome to visit
                                            mosques. They should dress modestly and remove their shoes upon entering.
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-card active wow fadeInUp" data-wow-delay=".3s">
                                <div class="accordion-header" id="collapse-item-2"><button class="accordion-button"
                                        type="button" data-bs-toggle="collapse" data-bs-target="#collapse-2"
                                        aria-expanded="true" aria-controls="collapse-2">2. What is the difference
                                        between an architect and an engineer??</button></div>
                                <div id="collapse-2" class="accordion-collapse collapse show"
                                    aria-labelledby="collapse-item-2" data-bs-parent="#faqAccordion3">
                                    <div class="accordion-body">
                                        <p class="faq-text">Most medical centers offer charity programs, counseling, and
                                            financial assistance for those in need. Non-Muslims are welcome to visit
                                            mosques. They should dress modestly and remove their shoes upon entering.
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-card wow fadeInUp" data-wow-delay=".5s">
                                <div class="accordion-header" id="collapse-item-3"><button
                                        class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapse-3" aria-expanded="false" aria-controls="collapse-3">3.
                                        Do I need an architect for my project?</button></div>
                                <div id="collapse-3" class="accordion-collapse collapse"
                                    aria-labelledby="collapse-item-3" data-bs-parent="#faqAccordion3">
                                    <div class="accordion-body">
                                        <p class="faq-text">Most medical centers offer charity programs, counseling, and
                                            financial assistance for those in need. Non-Muslims are welcome to visit
                                            mosques. They should dress modestly and remove their shoes upon entering.
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-card wow fadeInUp" data-wow-delay=".7s">
                                <div class="accordion-header" id="collapse-item-4"><button
                                        class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapse-4" aria-expanded="false" aria-controls="collapse-4">4.
                                        How much does it cost to hire an architect?</button></div>
                                <div id="collapse-4" class="accordion-collapse collapse"
                                    aria-labelledby="collapse-item-4" data-bs-parent="#faqAccordion3">
                                    <div class="accordion-body">
                                        <p class="faq-text">Most medical centers offer charity programs, counseling, and
                                            financial assistance for those in need. Non-Muslims are welcome to visit
                                            mosques. They should dress modestly and remove their shoes upon entering.
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-card wow fadeInUp" data-wow-delay=".8s">
                                <div class="accordion-header" id="collapse-item-5"><button
                                        class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapse-5" aria-expanded="false" aria-controls="collapse-5">5.
                                        What is sustainable or green architecture??</button></div>
                                <div id="collapse-5" class="accordion-collapse collapse"
                                    aria-labelledby="collapse-item-5" data-bs-parent="#faqAccordion3">
                                    <div class="accordion-body">
                                        <p class="faq-text">Most medical centers offer charity programs, counseling, and
                                            financial assistance for those in need. Non-Muslims are welcome to visit
                                            mosques. They should dress modestly and remove their shoes upon entering.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6">
                    <div class="faq-image img-anim-left"><img src="assets/img/normal/faq-img2.png" alt=""></div>
                </div>
            </div>
        </div>
    </div> -->
    <!-- TESTIMONIAL SECTION -->
    <section class="testi-area2 overflow-hidden space overflow-hidden" id="testi-sec">
        <div class="container">
            <div class="row justify-content-between align-items-center">
                <div class="col-md">
                    <div class="title-area text-center text-md-start">
                        <h2 class="sec-title style3">Customer Feedback</h2>
                    </div>
                </div>
                <div class="col-md-auto">
                    <div class="sec-btn mt-n3 mt-md-0 d-none d-md-block">
                        <div class="icon-box"><button data-slider-prev="#testiSlider4"
                                class="slider-arrow style3 default slider-prev"><img
                                    src="assets/img/icon/right-arrow4.svg" alt=""></button> <button
                                data-slider-next="#testiSlider4" class="slider-arrow style3 default slider-next"><img
                                    src="assets/img/icon/left-arrow4.svg" alt=""></button></div>
                    </div>
                </div>
            </div>
            <div class="slider-wrap">

<style>

/* ===========================================
   ULTRA UNIQUE � PREMIUM TESTIMONIAL DESIGN
=========================================== */

/* MAIN CARD */
.testi-grid {
    background: #0c0c0f;
    padding: 55px 45px;
    border-radius: 24px;
    position: relative;
    overflow: hidden;
    border: 1px solid rgba(255,255,255,0.08);
    box-shadow: 0 20px 40px rgba(0,0,0,0.45);
    transition: all .45s cubic-bezier(.25,.8,.25,1);
}

/* MAGNETIC HOVER */
.testi-grid:hover {
    transform: translateY(-14px) scale(1.03);
    border-color: #00ffbf;
}

/* DIAGONAL LIGHT BEAM */
.testi-grid::before {
    content: "";
    position: absolute;
    top: -120%;
    left: -120%;
    width: 220%;
    height: 220%;
    background: linear-gradient(
        55deg,
        transparent 0%,
        rgba(0,255,191,0.12) 40%,
        rgba(0,255,191,0.18) 60%,
        transparent 100%
    );
    transform: rotate(0deg);
    transition: transform .9s ease-out;
}

.testi-grid:hover::before {
    transform: rotate(30deg);
}

/* EDGE NEON OUTLINE */
.testi-grid::after {
    content: "";
    position: absolute;
    inset: 0;
    border-radius: 24px;
    border: 2px solid transparent;
    background: linear-gradient(120deg,#00ffbf,#0077ff) border-box;
    -webkit-mask: linear-gradient(#fff 0 0) padding-box, 
    linear-gradient(#fff 0 0);
    -webkit-mask-composite: xor;
    mask-composite: exclude;
    opacity: 0;
    transition: opacity .45s ease;
}

.testi-grid:hover::after {
    opacity: 1;
}

/* AVATAR */
.testi-grid .box-author .img {
    width: 115px;
    height: 115px;
    border-radius: 50%;
    object-fit: cover;
    position: relative;
    z-index: 2;
    border: 4px solid rgba(255,255,255,0.18);
    transition: .3s ease;
}

/* HALO */
.testi-grid .box-author .img::before {
    content: "";
    position: absolute;
    inset: -12px;
    border-radius: 50%;
    background: radial-gradient(circle, rgba(0,255,191,0.55), transparent 70%);
    z-index: -1;
    filter: blur(20px);
    opacity: 0;
    transition: .3s ease;
}

.testi-grid:hover .box-author .img::before {
    opacity: 1;
}

/* QUOTE ICON */
.testi-grid .box-quote img {
    width: 64px;
    position: absolute;
    bottom: -8px;
    right: -8px;
    opacity: .85;
}

/* CONTENT TEXT */
.testi-grid .box-text {
    margin: 28px 0 20px;
    font-size: 19px;
    line-height: 1.7;
    color: #d9d9d9;
    font-weight: 400;
}

/* AUTHOR NAME */
.testi-grid .box-title {
    font-size: 24px;
    font-weight: 700;
    color: #ffffff;
}

/* ROLE */
.testi-grid .box-desig {
    font-size: 15px;
    opacity: .75;
}

/* RATING */
.box-rating .rating {
    color: #00ffbf;
    font-weight: bold;
}

.box-rating .review i {
    color: #ffd700;
    font-size: 17px;
    margin-left: 2px;
}

/* ARROWS */
.slider-arrow.style3 img {
    width: 40px;
    transition: .3s ease;
    filter: brightness(0.85);
}

.slider-arrow.style3:hover img {
    transform: scale(1.2);
    filter: brightness(1);
}

/* RESPONSIVE */
@media(max-width: 992px) {
    .testi-grid { padding: 40px 28px; text-align: center; }
    .box-author { display: flex; justify-content: center; margin-bottom: 15px; }
}

@media(max-width: 576px) {
    .testi-grid { padding: 30px 22px; }
    .testi-grid .box-author .img { width: 90px; height: 90px; }
}

</style>

                <div class="swiper th-slider has-shadow" id="testiSlider4"
                    data-slider-options='{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"1"},"992":{"slidesPerView":"1"},"1200":{"slidesPerView":"1"}}}'>
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                            <div class="testi-grid">
                                <div class="box-author"><img class="img" src="assets/img/testimonial/testi_4_1.png"
                                        alt="Avater">
                                    <div class="box-quote"><img src="assets/img/icon/quote4.svg" alt=""></div>
                                </div>
                                <div class="box-content">
                                    <p class="box-text">Working with Faren Design was a seamless experience from start
                                        to finish. Their architects not only understood our vision but enhanced it with
                                        creative ideas and smart, sustainable solutions. The result was a space that�s
                                        both beautiful and highly functional. We couldn't be happier with the outcome
                                        and the professionalism shown throughout the process.</p>
                                    <div class="box-profile">
                                        <div class="box-info">
                                            <h3 class="box-title">Alex James</h3><span class="box-desig">Company
                                                Owner</span>
                                        </div>
                                        <div class="box-rating"><span class="rating">4.9/5.0</span> <span
                                                class="review"><i class="fa-solid fa-star"></i><i
                                                    class="fa-solid fa-star"></i><i class="fa-solid fa-star"></i><i
                                                    class="fa-solid fa-star"></i><i class="fa-solid fa-star"></i></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="testi-grid">
                                <div class="box-author"><img class="img" src="assets/img/testimonial/testi_4_2.png"
                                        alt="Avater">
                                    <div class="box-quote"><img src="assets/img/icon/quote4.svg" alt=""></div>
                                </div>
                                <div class="box-content">
                                    <p class="box-text">Working with Faren Design was a seamless experience from start
                                        to finish. Their architects not only understood our vision but enhanced it with
                                        creative ideas and smart, sustainable solutions. The result was a space that�s
                                        both beautiful and highly functional. We couldn't be happier with the outcome
                                        and the professionalism shown throughout the process.</p>
                                    <div class="box-profile">
                                        <div class="box-info">
                                            <h3 class="box-title">MIchel Smith</h3><span class="box-desig">Company
                                                Owner</span>
                                        </div>
                                        <div class="box-rating"><span class="rating">4.9/5.0</span> <span
                                                class="review"><i class="fa-solid fa-star"></i><i
                                                    class="fa-solid fa-star"></i><i class="fa-solid fa-star"></i><i
                                                    class="fa-solid fa-star"></i><i class="fa-solid fa-star"></i></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="testi-grid">
                                <div class="box-author"><img class="img" src="assets/img/testimonial/testi_4_1.png"
                                        alt="Avater">
                                    <div class="box-quote"><img src="assets/img/icon/quote4.svg" alt=""></div>
                                </div>
                                <div class="box-content">
                                    <p class="box-text">Working with Faren Design was a seamless experience from start
                                        to finish. Their architects not only understood our vision but enhanced it with
                                        creative ideas and smart, sustainable solutions. The result was a space that�s
                                        both beautiful and highly functional. We couldn't be happier with the outcome
                                        and the professionalism shown throughout the process.</p>
                                    <div class="box-profile">
                                        <div class="box-info">
                                            <h3 class="box-title">Alex James</h3><span class="box-desig">Company
                                                Owner</span>
                                        </div>
                                        <div class="box-rating"><span class="rating">4.9/5.0</span> <span
                                                class="review"><i class="fa-solid fa-star"></i><i
                                                    class="fa-solid fa-star"></i><i class="fa-solid fa-star"></i><i
                                                    class="fa-solid fa-star"></i><i class="fa-solid fa-star"></i></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- BRAND SECTION -->
    <div class="overflow-hidden space-bottom bg-smoke2 overflow-hidden" style="margin-top: -70px;">
        <style>
/* ============================================================
   ULTRA-PREMIUM BRAND SLIDER DESIGN � UPGRADED VERSION
   ============================================================ */

.space-bottom {
    padding: 90px 0;
    position: relative;
}

/* Title styling */
.space-bottom .sec-title {
    font-size: 42px;
    font-weight: 900;
    letter-spacing: -1px;
}

.space-bottom .text-theme {
    color: #9b0500;
}

/* ============================================================
   BRAND CARD (3D + GLASS + NEON GLOW)
   ============================================================ */

.brand-card {
    background: rgba(255,255,255,0.18);
    backdrop-filter: blur(14px);
    border-radius: 20px;
    padding: 32px;
    text-align: center;
    transition: 0.45s cubic-bezier(.25,.46,.45,.94);
    position: relative;
    overflow: hidden;
    border: 1px solid rgba(255,255,255,0.25);

    /* 3D hover tilt */
    transform-style: preserve-3d;
}

/* Card lift + neon glow */
.brand-card:hover {
    transform: translateY(-12px) rotateX(6deg) rotateY(-6deg);
    border-color: transparent;
    background: linear-gradient(#ffffff20, #ffffff20)
                padding-box,
                linear-gradient(135deg, #009f6f, #4cf6a5) border-box;
    box-shadow: 0 22px 45px rgba(43, 185, 123, 0.35);
}

/* ============================================================
   Floating Glow Halo (Animation)
   ============================================================ */

.brand-card::after {
    content: "";
    position: absolute;
    width: 180%;
    height: 180%;
    background: radial-gradient(circle, rgba(43,185,123,0.25), transparent 70%);
    top: -40%;
    left: -40%;
    transform: scale(0.8);
    opacity: 0;
    transition: 0.4s ease-out;
}

.brand-card:hover::after {
    opacity: 1;
    transform: scale(1);
}

/* ============================================================
   LOGO STYLE
   ============================================================ */

/* Base logo */
.brand-card img.original {
    width: 120px;
    transition: 0.45s ease;
    transform: translateZ(20px); /* 3D effect */
}

/* Floating animation */
.brand-card:hover img.original {
    transform: translateZ(40px) scale(1.14);
}

/* Grayscale version */
.brand-card img.gray {
    width: 120px;
    position: absolute;
    inset: 0;
    margin: auto;
    opacity: 0.35;
    filter: grayscale(100%);
    transition: 0.4s ease;
}

/* Fade grayscale on hover */
.brand-card:hover img.gray {
    opacity: 0;
}

/* ============================================================
   BRAND CARD AUTO FLOAT ANIMATION
   ============================================================ */

@keyframes brandFloat {
    0%   { transform: translateY(0px); }
    50%  { transform: translateY(-8px); }
    100% { transform: translateY(0px); }
}

.brand-card {
    animation: brandFloat 4s ease-in-out infinite;
}

/* Staggered delay per card */
#brandSlider1 .swiper-slide:nth-child(1) .brand-card { animation-delay: .1s; }
#brandSlider1 .swiper-slide:nth-child(2) .brand-card { animation-delay: .3s; }
#brandSlider1 .swiper-slide:nth-child(3) .brand-card { animation-delay: .5s; }
#brandSlider1 .swiper-slide:nth-child(4) .brand-card { animation-delay: .7s; }
#brandSlider1 .swiper-slide:nth-child(5) .brand-card { animation-delay: .9s; }

/* ============================================================
   RESPONSIVE DESIGN
   ============================================================ */

@media (max-width: 992px) {
    .brand-card {
        padding: 26px;
    }
    .brand-card img.original,
    .brand-card img.gray {
        width: 100px;
    }
}

@media (max-width: 576px) {
    .space-bottom {
        padding: 60px 0;
    }

    .brand-card {
        padding: 20px;
        border-radius: 16px;
        transform: translateY(0) !important;
        animation: none; /* disable floating on small screens */
    }

    .brand-card img.original,
    .brand-card img.gray {
        width: 88px;
    }
}
</style>
        <div class="container">
            <div class="title-area text-center"><span class="sub-title style3 text-anime">experience with 1,20000+
                    Visitors</span>
                <h2 class="sec-title split-text">Our Trusted <span class="text-theme">Brands</span></h2>
            </div>
            <div class="slider-area" style="margin-bottom: -160px;">
                <div class="swiper th-slider" id="brandSlider1"
                    data-slider-options='{"breakpoints":{"0":{"slidesPerView":1},"476":{"slidesPerView":"2"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"},"1400":{"slidesPerView":"5"}}}'>
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                            <div class="brand-card"><a href=""><img class="original"
                                        src="assets/img/brand/brand_1_1.svg" alt="Brand Logo"> <img class="gray"
                                        src="assets/img/brand/brand_1_1.svg" alt="Brand Logo"></a></div>
                        </div>
                        <div class="swiper-slide">
                            <div class="brand-card"><a href=""><img class="original"
                                        src="assets/img/brand/brand_1_2.svg" alt="Brand Logo"> <img class="gray"
                                        src="assets/img/brand/brand_1_2.svg" alt="Brand Logo"></a></div>
                        </div>
                        <div class="swiper-slide">
                            <div class="brand-card"><a href=""><img class="original"
                                        src="assets/img/brand/brand_1_3.svg" alt="Brand Logo"> <img class="gray"
                                        src="assets/img/brand/brand_1_3.svg" alt="Brand Logo"></a></div>
                        </div>
                        <div class="swiper-slide">
                            <div class="brand-card"><a href=""><img class="original"
                                        src="assets/img/brand/brand_1_4.svg" alt="Brand Logo"> <img class="gray"
                                        src="assets/img/brand/brand_1_4.svg" alt="Brand Logo"></a></div>
                        </div>
                        <div class="swiper-slide">
                            <div class="brand-card"><a href=""><img class="original"
                                        src="assets/img/brand/brand_1_5.svg" alt="Brand Logo"> <img class="gray"
                                        src="assets/img/brand/brand_1_5.svg" alt="Brand Logo"></a></div>
                        </div>
                        <div class="swiper-slide">
                            <div class="brand-card"><a href=""><img class="original"
                                        src="assets/img/brand/brand_1_1.svg" alt="Brand Logo"> <img class="gray"
                                        src="assets/img/brand/brand_1_1.svg" alt="Brand Logo"></a></div>
                        </div>
                        <div class="swiper-slide">
                            <div class="brand-card"><a href=""><img class="original"
                                        src="assets/img/brand/brand_1_2.svg" alt="Brand Logo"> <img class="gray"
                                        src="assets/img/brand/brand_1_2.svg" alt="Brand Logo"></a></div>
                        </div>
                        <div class="swiper-slide">
                            <div class="brand-card"><a href=""><img class="original"
                                        src="assets/img/brand/brand_1_3.svg" alt="Brand Logo"> <img class="gray"
                                        src="assets/img/brand/brand_1_3.svg" alt="Brand Logo"></a></div>
                        </div>
                        <div class="swiper-slide">
                            <div class="brand-card"><a href=""><img class="original"
                                        src="assets/img/brand/brand_1_4.svg" alt="Brand Logo"> <img class="gray"
                                        src="assets/img/brand/brand_1_4.svg" alt="Brand Logo"></a></div>
                        </div>
                        <div class="swiper-slide">
                            <div class="brand-card"><a href=""><img class="original"
                                        src="assets/img/brand/brand_1_5.svg" alt="Brand Logo"> <img class="gray"
                                        src="assets/img/brand/brand_1_5.svg" alt="Brand Logo"></a></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- FOOTER SECTION -->
    <!-- FOOTER SECTION - MODERN AESTHETIC DESIGN -->
    
    <div class="scroll-top"><svg class="progress-circle svg-content" width="100%" height="100%" viewbox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"
                style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 307.919;">
            </path>
        </svg></div>
    <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <script src="assets/js/swiper-bundle.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/jquery.counterup.min.js"></script>
    <script src="assets/js/circle-progress.js"></script>
    <script src="assets/js/jquery-ui.min.js"></script>
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/isotope.pkgd.min.js"></script>
    <script src="assets/js/nice-select.min.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/threesixty.min.js"></script>
    <script src="assets/js/panolens.min.js"></script>
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.min.js"></script>
    <script src="assets/js/SplitText.js"></script>
    <script src="assets/js/SplitType.js"></script>
    <script src="assets/js/lenis.min.js"></script>
    <script src="assets/js/CustomEase.min.js"></script>
    <script src="assets/js/main.js"></script>
    <script src="assets/js/jquery-3.6.0.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script>
        function updateCartCount() {
            fetch('auth-system/cart-api.php?action=get_count')
                .then(res => res.json())
                .then(data => {
                    document.getElementById('cart-count').textContent = data.count || 0;
                })
                .catch(() => {
                    document.getElementById('cart-count').textContent = 0;
                });
        }
        updateCartCount();
    </script>
</body>
</html>
<?php include 'footer-section.html'; ?>