<?php
session_start();
require_once 'config/db.php';

// Check if admin
if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'admin') {
    header('Location: login.php');
    exit;
}

// Handle mark as read
if (isset($_GET['mark_read'])) {
    $id = intval($_GET['mark_read']);
    $connection->query("UPDATE contact_messages SET status = 'read' WHERE id = $id");
    header("Location: admin-contact-messages.php");
    exit;
}

// Handle delete
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    if ($connection->query("DELETE FROM contact_messages WHERE id = $id")) {
        $delete_msg = "Message deleted successfully";
    }
}

// Get all messages
$search = '';
if (isset($_GET['search'])) {
    $search = trim($_GET['search']);
    $search_like = '%' . $connection->real_escape_string($search) . '%';
    $result = $connection->query("
        SELECT * FROM contact_messages 
        WHERE name LIKE '$search_like' OR email LIKE '$search_like' OR subject LIKE '$search_like'
        ORDER BY created_at DESC
    ");
} else {
    $result = $connection->query("SELECT * FROM contact_messages ORDER BY created_at DESC");
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Messages - Admin</title>
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <style>
        body {
            background: #f5f5f5;
            font-family: 'DM Sans', sans-serif;
        }
        .admin-container {
            padding: 30px;
            max-width: 1200px;
            margin: 0 auto;
        }
        .header {
            background: linear-gradient(135deg, #d4a574 0%, #b8956f 100%);
            color: white;
            padding: 30px;
            border-radius: 10px;
            margin-bottom: 30px;
        }
        .message-card {
            background: white;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
            border-left: 4px solid #d4a574;
            transition: all 0.3s ease;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        .message-card:hover {
            box-shadow: 0 4px 16px rgba(0,0,0,0.15);
            transform: translateY(-2px);
        }
        .message-card.new {
            background: #fffbf0;
            border-left-color: #ff9800;
        }
        .badge {
            display: inline-block;
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            margin-right: 10px;
        }
        .badge-new {
            background: #ff9800;
            color: white;
        }
        .badge-read {
            background: #4CAF50;
            color: white;
        }
        .badge-responded {
            background: #2196F3;
            color: white;
        }
        .message-meta {
            display: flex;
            gap: 20px;
            margin-bottom: 15px;
            flex-wrap: wrap;
        }
        .meta-item {
            font-size: 14px;
        }
        .meta-label {
            font-weight: 600;
            color: #666;
        }
        .message-content {
            background: #f9f9f9;
            padding: 15px;
            border-radius: 5px;
            margin: 15px 0;
            line-height: 1.6;
        }
        .action-buttons {
            display: flex;
            gap: 10px;
            margin-top: 15px;
        }
        .btn {
            padding: 8px 16px;
            border-radius: 5px;
            border: none;
            cursor: pointer;
            font-size: 13px;
            font-weight: 600;
            text-decoration: none;
            display: inline-block;
            transition: all 0.3s ease;
        }
        .btn-primary {
            background: #d4a574;
            color: white;
        }
        .btn-primary:hover {
            background: #b8956f;
        }
        .btn-danger {
            background: #f44336;
            color: white;
        }
        .btn-danger:hover {
            background: #da190b;
        }
        .search-box {
            margin-bottom: 30px;
        }
        .search-box input {
            padding: 12px 20px;
            border: 2px solid #d4a574;
            border-radius: 5px;
            width: 100%;
            max-width: 400px;
            font-size: 14px;
        }
        .empty-state {
            text-align: center;
            padding: 60px 20px;
            color: #999;
        }
    </style>
</head>
<body>
    <div class="admin-container">
        <div class="header">
            <h1>📧 Contact Messages</h1>
            <p>Manage all contact form submissions</p>
        </div>

        <?php if (isset($delete_msg)): ?>
            <div style="background: #d4edda; color: #155724; padding: 15px; border-radius: 5px; margin-bottom: 20px;">
                <?php echo htmlspecialchars($delete_msg); ?>
            </div>
        <?php endif; ?>

        <div class="search-box">
            <form method="GET" style="display: flex; gap: 10px;">
                <input type="text" name="search" placeholder="Search by name, email, or subject..." value="<?php echo htmlspecialchars($search); ?>">
                <button type="submit" class="btn btn-primary">Search</button>
                <?php if (!empty($search)): ?>
                    <a href="admin-contact-messages.php" class="btn btn-primary">Clear</a>
                <?php endif; ?>
            </form>
        </div>

        <?php if ($result->num_rows > 0): ?>
            <div style="margin-bottom: 20px; color: #666;">
                Found <strong><?php echo $result->num_rows; ?></strong> message(s)
            </div>

            <?php while ($msg = $result->fetch_assoc()): ?>
                <div class="message-card <?php echo $msg['status'] === 'new' ? 'new' : ''; ?>">
                    <div style="display: flex; justify-content: space-between; align-items: start; margin-bottom: 15px;">
                        <div>
                            <span class="badge badge-<?php echo htmlspecialchars($msg['status']); ?>">
                                <?php echo ucfirst(htmlspecialchars($msg['status'])); ?>
                            </span>
                        </div>
                        <div style="font-size: 12px; color: #999;">
                            <?php echo date('M d, Y H:i', strtotime($msg['created_at'])); ?>
                        </div>
                    </div>

                    <div class="message-meta">
                        <div class="meta-item">
                            <span class="meta-label">From:</span>
                            <span><?php echo htmlspecialchars($msg['name']); ?></span>
                        </div>
                        <div class="meta-item">
                            <span class="meta-label">Email:</span>
                            <a href="mailto:<?php echo htmlspecialchars($msg['email']); ?>">
                                <?php echo htmlspecialchars($msg['email']); ?>
                            </a>
                        </div>
                        <div class="meta-item">
                            <span class="meta-label">Phone:</span>
                            <a href="tel:<?php echo htmlspecialchars($msg['phone']); ?>">
                                <?php echo htmlspecialchars($msg['phone']); ?>
                            </a>
                        </div>
                        <div class="meta-item">
                            <span class="meta-label">Service:</span>
                            <span><?php echo htmlspecialchars($msg['subject']); ?></span>
                        </div>
                    </div>

                    <div>
                        <strong style="color: #333;">Message:</strong>
                    </div>
                    <div class="message-content">
                        <?php echo nl2br(htmlspecialchars($msg['message'])); ?>
                    </div>

                    <div class="action-buttons">
                        <?php if ($msg['status'] === 'new'): ?>
                            <a href="?mark_read=<?php echo $msg['id']; ?>" class="btn btn-primary">Mark as Read</a>
                        <?php endif; ?>
                        <a href="?delete=<?php echo $msg['id']; ?>" class="btn btn-danger" onclick="return confirm('Are you sure?')">Delete</a>
                    </div>
                </div>
            <?php endwhile; ?>
        <?php else: ?>
            <div class="empty-state">
                <h3>No Messages Found</h3>
                <p>No contact form submissions yet.</p>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>
