<?php
// Email Queue Management - store unsent emails to database
// This creates a table to store pending emails that can be sent later

require_once '../config/db.php';

// Create email queue table if it doesn't exist
$create_table_sql = "
CREATE TABLE IF NOT EXISTS email_queue (
    id INT PRIMARY KEY AUTO_INCREMENT,
    consultation_id INT,
    recipient_email VARCHAR(255) NOT NULL,
    subject VARCHAR(255) NOT NULL,
    body LONGTEXT NOT NULL,
    email_type VARCHAR(50), -- 'consultation_confirmation', 'approval', 'decline'
    status VARCHAR(20) DEFAULT 'pending', -- 'pending', 'sent', 'failed'
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    sent_at TIMESTAMP NULL,
    attempts INT DEFAULT 0,
    last_attempt TIMESTAMP NULL,
    error_message TEXT
)
";

if ($connection->query($create_table_sql)) {
    echo "Email queue table created successfully\n";
} else {
    if (strpos($connection->error, 'already exists') === false) {
        echo "Error creating table: " . $connection->error . "\n";
    }
}

?>
