<?php
session_start();
header('Content-Type: application/json');

// Check if user is admin
if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'admin') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

$host = 'localhost';
$db = 'zemaraim_interior';
$user = 'zemaraim';
$password = '8wwxk]-X3Kx]CJ]5';

$connection = new mysqli($host, $user, $password, $db);

if ($connection->connect_error) {
    echo json_encode(['success' => false, 'message' => 'Database connection failed']);
    exit;
}

$consultation_id = intval($_POST['consultation_id'] ?? 0);

if ($consultation_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid consultation ID']);
    exit;
}

$stmt = $connection->prepare("DELETE FROM consultations WHERE id = ?");
$stmt->bind_param("i", $consultation_id);

if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'Consultation deleted successfully']);
} else {
    echo json_encode(['success' => false, 'message' => 'Failed to delete consultation']);
}

$stmt->close();
$connection->close();
?>
