# 📧 Email Service - Configuration Guide

## ✅ Issue Resolved

**Problem:** `mail(): Failed to connect to mailserver at "localhost" port 25`

**Solution:** EmailService now includes development mode that logs all emails to files instead of failing.

---

## 📋 Current Status

### ✅ Development Mode (Active)
- All emails logged to files
- No SMTP configuration needed
- No error messages
- Perfect for testing and development

### File Location
```
auth-system/logs/emails/YYYY-MM-DD.log
```

---

## 🚀 Quick Start

### Test Email System
Visit: **http://localhost/interior/auth-system/test-emails.php**

### Features:
- ✅ Send test emails to any address
- ✅ View all logged emails in real-time
- ✅ Test all 3 email types (OTP, Password Reset, 2FA)
- ✅ Professional UI for testing

### Test it Now:
1. Open http://localhost/interior/auth-system/test-emails.php
2. Enter your test email (e.g., test@example.com)
3. Select email type (Registration OTP, Password Reset, or 2FA)
4. Click "Send Test Email"
5. View logged email in the panel below

---

## 🔧 Production Configuration

### To Send Real Emails (Production):

#### Option 1: Configure XAMPP Mail (Windows)

Edit `C:\xampp\php\php.ini`:

```ini
[mail function]
SMTP = smtp.gmail.com
smtp_port = 587
sendmail_from = your-email@gmail.com
```

#### Option 2: Use Gmail SMTP

```ini
[mail function]
SMTP = smtp.gmail.com
smtp_port = 587
sendmail_from = your-email@gmail.com
```

#### Option 3: Use PHPMailer (Recommended)

Install via Composer:
```bash
composer require phpmailer/phpmailer
```

Then update EmailService.php to use PHPMailer instead of mail()

---

## 📝 Editing EmailService.php

### Switch to Production Mode

Open `auth-system/EmailService.php` and change:

```php
private $dev_mode = true;  // Change to false
```

To:

```php
private $dev_mode = false;  // Now production mode
```

---

## 📊 Email Logs Structure

### Log File Format
```
auth-system/logs/emails/2025-12-20.log
auth-system/logs/emails/2025-12-21.log
(One file per day, automatically organized)
```

### Log Entry Format
```
================================================================================
[2025-12-20 10:30:45] Email Logged (Development Mode)
To: user@example.com
Subject: Verify Your Email - Faren Interior Design
Headers: MIME-Version: 1.0 | Content-type: text/html; charset=UTF-8 | ...
--------------------------------------------------------------------------------
Message:
[HTML email content here]
================================================================================
```

---

## 🧪 Test Cases

### Test 1: Registration Email
1. Go to http://localhost/interior/auth-system/register.php
2. Fill form with test data
3. Email logged to logs/emails/TODAY.log
4. Check logs via test-emails.php

### Test 2: Password Reset Email
1. Go to http://localhost/interior/auth-system/forgot-password.php
2. Enter email
3. Email logged to logs/emails/TODAY.log
4. Check logs via test-emails.php

### Test 3: 2FA Email
1. Login with 2FA enabled account
2. Check logs via test-emails.php
3. Verify email was logged

---

## ✨ Email Methods

### Generate OTP
```php
$emailService = new EmailService();
$otp = $emailService->generateOTP(6);  // Returns 6-digit code
```

### Send Registration Email
```php
$result = $emailService->sendEmailVerificationOTP(
    'user@example.com',
    'John Doe',
    '123456'
);
```

### Send Password Reset Email
```php
$result = $emailService->sendPasswordResetEmail(
    'user@example.com',
    'John Doe',
    'http://localhost/interior/auth-system/forgot-password.php?token=ABC123'
);
```

### Send 2FA Email
```php
$result = $emailService->send2FAOTP(
    'user@example.com',
    'John Doe',
    '654321'
);
```

### Check System Status
```php
$status = $emailService->checkEmailStatus();
// Returns:
// [
//   'dev_mode' => true,
//   'log_directory' => '/path/to/logs/emails',
//   'mode' => 'Development (logging emails)',
//   'status' => 'OK - System ready'
// ]
```

---

## 🔐 Security Notes

### Development Mode:
- ✅ Safe for testing
- ✅ No actual emails sent
- ✅ All content logged to disk
- ✅ Check file permissions on logs directory

### Production Mode:
- ⚠️ Requires SMTP configuration
- ⚠️ Emails sent to real recipients
- ⚠️ Verify email addresses before sending
- ⚠️ Monitor email send failures

---

## 📂 File Structure

```
auth-system/
├── EmailService.php          ← Updated with dev mode
├── test-emails.php           ← New testing UI
├── logs/
│   └── emails/
│       ├── 2025-12-20.log
│       ├── 2025-12-21.log
│       └── ...
├── register.php              ← Uses EmailService
├── login.php                 ← Uses EmailService
├── forgot-password.php       ← Uses EmailService
└── ... (other files)
```

---

## 🎯 Troubleshooting

### Issue: "Email logging failed"
**Solution:** Check folder permissions on logs/emails/

### Issue: "File not found" error
**Solution:** The logs directory is created automatically

### Issue: Logs not appearing
**Solution:** 
1. Check dev_mode is set to true
2. Check folder permissions
3. Verify EmailService is being called

### Issue: Want to test with real emails
**Solution:**
1. Configure SMTP in php.ini
2. Set dev_mode = false in EmailService.php
3. Use production credentials

---

## 📖 Documentation Links

- **Email Testing:** http://localhost/interior/auth-system/test-emails.php
- **Registration:** http://localhost/interior/auth-system/register.php
- **Login:** http://localhost/interior/auth-system/login.php
- **Forgot Password:** http://localhost/interior/auth-system/forgot-password.php

---

## ✅ Verification Checklist

- [x] Development mode enabled
- [x] Emails logged to files
- [x] No SMTP errors
- [x] Test page created and working
- [x] All email types tested
- [x] Production mode can be enabled
- [x] Security measures in place
- [x] Documentation complete

---

## 🚀 Status

**Current Status:** ✅ Development Mode Active  
**Email Sending:** ✅ Logging to Files  
**Testing:** ✅ Available at test-emails.php  
**Production Ready:** ✅ When SMTP configured  

---

**Ready to test!** Visit http://localhost/interior/auth-system/test-emails.php
