<?php
/**
 * PHPMailer Configuration for Real-Time OTP Verification
 * Replaces basic PHP mail() function with PHPMailer for reliable email delivery
 */

// Check if PHPMailer is installed via Composer
$autoload_path = __DIR__ . '/../../../vendor/autoload.php';
if (!file_exists($autoload_path)) {
    // PHPMailer not installed, provide installation instructions
    die("PHPMailer not installed. Run: composer require phpmailer/phpmailer");
}

require $autoload_path;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class PHPMailerConfig {
    
    public static function getSMTPConfig() {
        return array(
            // Gmail SMTP (Recommended for testing)
            'gmail' => array(
                'host' => 'mail.zemaraimgroups.com',
                'port' => 465,
                'secure' => 'PHPMailer::ENCRYPTION_SMTPS',
                'username' => 'info@zemaraimgroups.com',
                'password' => 'zemaraimgroups@123',  // Use App Password, not regular password
            ),
            
            // Outlook/Hotmail SMTP
            'outlook' => array(
                'host' => 'smtp-mail.outlook.com',
                'port' => 587,
                'secure' => 'tls',
                'username' => 'your-email@outlook.com',
                'password' => 'your-password',
            ),
            
            // SendGrid SMTP
            'sendgrid' => array(
                'host' => 'smtp.sendgrid.net',
                'port' => 587,
                'secure' => 'tls',
                'username' => 'apikey',
                'password' => 'your-sendgrid-api-key',
            ),
            
            // Mailgun SMTP
            'mailgun' => array(
                'host' => 'smtp.mailgun.org',
                'port' => 587,
                'secure' => 'tls',
                'username' => 'your-mailgun-username',
                'password' => 'your-mailgun-password',
            ),
            
            // Local XAMPP (if configured)
            'local' => array(
                'host' => 'localhost',
                'port' => 25,
                'secure' => '',
                'username' => '',
                'password' => '',
            ),
        );
    }
    
    /**
     * Get active SMTP configuration
     * Change this to use your preferred service
     */
    public static function getActiveConfig() {
        // Change 'gmail' to 'outlook', 'sendgrid', 'mailgun', or 'local'
        $provider = 'gmail';
        $all_configs = self::getSMTPConfig();
        return $all_configs[$provider] ?? $all_configs['gmail'];
    }
    
    /**
     * Send email using PHPMailer
     */
    public static function sendEmail($to_email, $to_name, $subject, $html_body, $text_body = null) {
        try {
            $config = self::getActiveConfig();
            
            // Create PHPMailer instance
            $mail = new PHPMailer(true);
            
            // Server settings
            $mail->isSMTP();
            $mail->Host = $config['host'];
            $mail->SMTPAuth = !empty($config['username']);
            $mail->Username = $config['username'];
            $mail->Password = $config['password'];
            $mail->SMTPSecure = $config['secure'] ?: PHPMailer::ENCRYPTION_STARTTLS;
            $mail->Port = $config['port'];
            
            // Enable debugging in development (disable in production)
            $mail->SMTPDebug = 0;  // Set to 2 for detailed debug output
            
            // Sender settings
            $mail->setFrom('info@zemaraimgroups.com', 'Faren Interior Design');
            $mail->addReplyTo('support@faren.com', 'Support Team');
            
            // Recipient
            $mail->addAddress($to_email, $to_name);
            
            // Content
            $mail->isHTML(true);
            $mail->Subject = $subject;
            $mail->Body = $html_body;
            
            if ($text_body) {
                $mail->AltBody = $text_body;
            }
            
            // Send email
            return $mail->send();
            
        } catch (Exception $e) {
            error_log("PHPMailer Error: " . $e->getMessage());
            return false;
        }
    }
}

?>
