# Interior Design - Authentication System Setup

## Quick Start Guide

### Step 1: Database Setup

1. **Open your browser** and visit:
   ```
   http://localhost/interior/auth-system/setup.php
   ```

2. This will automatically create:
   - Database: `interior_design`
   - Table: `users` (with fields: id, name, email, password, created_at, updated_at)

### Step 2: Update Database Credentials (if needed)

If your MySQL credentials are different, edit:
- File: `auth-system/config/db.php`
- Update: `DB_HOST`, `DB_USER`, `DB_PASS`, `DB_NAME`

### Step 3: Test the System

#### Login
- URL: `http://localhost/interior/auth-system/login.php`
- Or click "Login" button on homepage

#### Register
- URL: `http://localhost/interior/auth-system/register.php`
- Or click "Register" button on homepage

#### Dashboard
- After login, you'll be redirected to: `http://localhost/interior/auth-system/dashboard.php`
- Access your profile, projects, and bookings

#### Logout
- Click "Logout" in the sidebar to destroy session

## File Structure

```
auth-system/
├── config/
│   └── db.php              # Database configuration
├── login.php               # Login form & logic
├── register.php            # Registration form & logic
├── dashboard.php           # User dashboard (requires login)
├── logout.php              # Logout handler
├── setup.php               # Database setup tool
└── users.sql               # SQL schema reference
```

## Features

✅ **Registration**
- Full name, email, password validation
- Password hashing with PHP's `password_hash()`
- Email uniqueness check
- Minimum 6 character password
- Password confirmation

✅ **Login**
- Email & password validation
- Session-based authentication
- Secure password verification
- Remember user data in session

✅ **Dashboard**
- User profile information
- Session protection (redirects to login if not authenticated)
- User avatar with first letter
- Account details display
- Sidebar navigation menu
- Logout functionality

✅ **Security**
- Prepared statements to prevent SQL injection
- Password hashing with `PASSWORD_DEFAULT`
- Session management
- Input sanitization with `htmlspecialchars()`

## Session Variables

After login, the following session variables are set:
- `$_SESSION['user_id']` - User ID
- `$_SESSION['user_name']` - User name
- `$_SESSION['user_email']` - User email

## Troubleshooting

**Issue: "Connection failed" error**
- Ensure XAMPP MySQL server is running
- Check database credentials in `config/db.php`
- Run `setup.php` again

**Issue: "Email already registered"**
- The email is already in the database
- Try with a different email or check your username

**Issue: "Invalid password" after login**
- Password is case-sensitive
- Ensure Caps Lock is not on

**Issue: Dashboard shows empty values**
- Database might not have been created properly
- Run `setup.php` again

## Database Schema

```sql
CREATE TABLE users (
    id INT PRIMARY KEY AUTO_INCREMENT,
    name VARCHAR(100) NOT NULL,
    email VARCHAR(100) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);
```

## UI Features

- **Modern gradient backgrounds** (purple/blue theme)
- **Responsive design** with Bootstrap
- **Styled input fields** with focus effects
- **Animated buttons** with hover effects
- **Professional dashboard** with sidebar navigation
- **Mobile-friendly** layout

## Next Steps

1. Customize the dashboard with your own projects/bookings
2. Add password reset functionality
3. Implement email verification
4. Add user profile editing
5. Create project management system
6. Add booking system

---

**Created**: December 2025
**Status**: Ready for Production
