<?php
session_start();
require_once __DIR__ . '/config/db.php';

// Check if admin is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'admin') {
    header('Location: login.php');
    exit;
}

$page_title = 'Admin Dashboard — Interior Design';
$admin_name = $_SESSION['user_name'];
$admin_email = $_SESSION['user_email'];

// Get admin stats
$users_query = $conn->query("SELECT COUNT(*) as total_customers FROM users WHERE role = 'customer'");
$customers = $users_query->fetch_assoc()['total_customers'];

$admins_query = $conn->query("SELECT COUNT(*) as total_admins FROM users WHERE role = 'admin'");
$admins = $admins_query->fetch_assoc()['total_admins'];

include '../header-section.php';
?>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'DM Sans', sans-serif;
            background: linear-gradient(135deg, #f5f5f5 0%, #efefef 100%);
            min-height: 100vh;
        }

        .dashboard-wrapper {
            display: flex;
            min-height: calc(100vh - 300px);
        }

        /* SIDEBAR */
        .admin-sidebar {
            width: 280px;
            background: linear-gradient(180deg, #1a1a1a 0%, #2d2416 100%);
            padding: 40px 20px;
            color: white;
            position: sticky;
            max-height: 600px;
            overflow-y: auto;
            box-shadow: 4px 0 15px rgba(0, 0, 0, 0.3);
        }

        .admin-logo {
            font-size: 24px;
            font-weight: 700;
            color: #d4a33a;
            margin-bottom: 40px;
            text-align: center;
            letter-spacing: 1px;
        }

        .admin-menu {
            list-style: none;
        }

        .admin-menu li {
            margin-bottom: 8px;
        }

        .admin-menu a {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 14px 16px;
            color: #ccc;
            text-decoration: none;
            border-radius: 8px;
            transition: all 0.3s ease;
            font-weight: 500;
        }

        .admin-menu a:hover,
        .admin-menu a.active {
            background: linear-gradient(135deg, #d4a33a 0%, #b8905a 100%);
            color: white;
            padding-left: 20px;
        }

        .admin-menu i {
            font-size: 18px;
            min-width: 24px;
        }

        .admin-logout {
            position: absolute;
            bottom: 20px;
            left: 20px;
            right: 20px;
        }

        .admin-logout a {
            display: block;
            width: 100%;
            padding: 12px;
            background: #dc3545;
            color: white;
            text-decoration: none;
            border-radius: 8px;
            text-align: center;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .admin-logout a:hover {
            background: #c82333;
            transform: translateY(-2px);
        }

        /* MAIN CONTENT */
        .admin-content {
            flex: 1;
            margin-left: 30px;
            padding: 40px;
        }

        .admin-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 40px;
            flex-wrap: wrap;
            gap: 20px;
        }

        .admin-title h1 {
            font-size: 32px;
            color: #1a1a1a;
            margin-bottom: 8px;
        }

        .admin-title p {
            color: #666;
            font-size: 14px;
        }

        .admin-profile {
            display: flex;
            align-items: center;
            gap: 16px;
            background: white;
            padding: 12px 20px;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        }

        .admin-avatar {
            width: 44px;
            height: 44px;
            border-radius: 50%;
            background: linear-gradient(135deg, #d4a33a, #b8905a);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 18px;
        }

        .admin-info h3 {
            font-size: 14px;
            color: #1a1a1a;
            margin-bottom: 2px;
        }

        .admin-info p {
            font-size: 12px;
            color: #999;
        }

        /* STATS GRID */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 24px;
            margin-bottom: 40px;
        }

        .stat-card {
            background: white;
            padding: 28px;
            border-radius: 14px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            border-left: 4px solid #d4a33a;
            transition: all 0.3s ease;
        }

        .stat-card:hover {
            transform: translateY(-8px);
            box-shadow: 0 12px 28px rgba(0, 0, 0, 0.15);
        }

        .stat-icon {
            font-size: 32px;
            color: #d4a33a;
            margin-bottom: 12px;
        }

        .stat-label {
            font-size: 13px;
            color: #999;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 8px;
            font-weight: 600;
        }

        .stat-value {
            font-size: 36px;
            color: #1a1a1a;
            font-weight: 700;
        }

        /* CONTENT SECTION */
        .content-section {
            background: white;
            padding: 32px;
            border-radius: 14px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            margin-left: -300px
        }

        .content-section h2 {
            font-size: 24px;
            color: #1a1a1a;
            margin-bottom: 24px;
            border-bottom: 2px solid #f0f0f0;
            padding-bottom: 16px;
        }

        .welcome-message {
            font-size: 16px;
            line-height: 1.8;
            color: #555;
            margin-bottom: 20px;
        }

        .feature-list {
            list-style: none;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 16px;
        }

        .feature-list li {
            padding: 16px;
            background: #f9f9f9;
            border-radius: 8px;
            border-left: 3px solid #d4a33a;
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .feature-list i {
            font-size: 20px;
            color: #d4a33a;
        }

        .feature-list span {
            font-weight: 500;
            color: #333;
        }

        /* RESPONSIVE */
        @media (max-width: 1200px) {
            .admin-sidebar {
                width: 240px;
            }

            .admin-content {
                margin-left: 240px;
                padding: 30px;
            }

            .stats-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        @media (max-width: 768px) {
            .dashboard-wrapper {
                flex-direction: column;
            }

            .admin-sidebar {
                position: relative;
                width: 100%;
                height: auto;
                padding: 20px;
                border-bottom: 2px solid #444;
                margin-bottom: 20px;
            }

            .admin-content {
                margin-left: 0;
                padding: 20px;
            }

            .admin-header {
                flex-direction: column;
            }

            .admin-title h1 {
                font-size: 24px;
            }

            .stats-grid {
                grid-template-columns: 1fr;
            }

            .admin-logout {
                position: static;
                margin-top: 20px;
            }

            .content-section {
                padding: 20px;
            }
        }
    </style>

    <div class="dashboard-wrapper">
        <!-- SIDEBAR -->
        <aside class="admin-sidebar">
            <div class="admin-logo"><i class="fas fa-crown"></i> FAREN ADMIN</div>

            <ul class="admin-menu">
                <li><a href="admin-dashboard.php" class="active"><i class="fas fa-chart-line"></i> Dashboard</a></li>
                <li><a href="#"><i class="fas fa-users"></i> Customers</a></li>
                <li><a href="#"><i class="fas fa-tasks"></i> Projects</a></li>
                <li><a href="#"><i class="fas fa-calendar"></i> Appointments</a></li>
                <li><a href="#"><i class="fas fa-file-pdf"></i> Reports</a></li>
                <li><a href="#"><i class="fas fa-cog"></i> Settings</a></li>
            </ul>

            <div class="admin-logout">
                <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
            </div>
        </aside>

        <!-- MAIN CONTENT -->
        <main class="admin-content">
            <div class="admin-header">
                <div class="admin-title">
                    <h1>Welcome, Admin! 👋</h1>
                    <p><?php echo date('l, F j, Y'); ?></p>
                </div>
                <div class="admin-profile">
                    <div class="admin-avatar"><?php echo strtoupper(substr($admin_name, 0, 1)); ?></div>
                    <div class="admin-info">
                        <h3><?php echo htmlspecialchars($admin_name); ?></h3>
                        <p><?php echo htmlspecialchars($admin_email); ?></p>
                    </div>
                </div>
            </div>

            <!-- STATISTICS CARDS -->
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-icon"><i class="fas fa-users"></i></div>
                    <div class="stat-label">Total Customers</div>
                    <div class="stat-value"><?php echo $customers; ?></div>
                </div>

                <div class="stat-card">
                    <div class="stat-icon"><i class="fas fa-user-shield"></i></div>
                    <div class="stat-label">Total Admins</div>
                    <div class="stat-value"><?php echo $admins; ?></div>
                </div>

                <div class="stat-card">
                    <div class="stat-icon"><i class="fas fa-briefcase"></i></div>
                    <div class="stat-label">Active Projects</div>
                    <div class="stat-value">12</div>
                </div>

                <div class="stat-card">
                    <div class="stat-icon"><i class="fas fa-calendar-check"></i></div>
                    <div class="stat-label">Upcoming Appointments</div>
                    <div class="stat-value">5</div>
                </div>
            </div>

            <!-- WELCOME SECTION -->
            <div class="content-section">
                <h2><i class="fas fa-info-circle"></i> Quick Guide</h2>

                <p class="welcome-message">
                    Welcome to your Admin Dashboard! Here you can manage your interior design projects, track customer interactions, and monitor your business metrics.
                </p>

                <h3 style="font-size: 16px; color: #1a1a1a; margin-bottom: 16px; margin-top: 24px;">Key Features:</h3>

                <ul class="feature-list">
                    <li><i class="fas fa-check-circle"></i> <span>Manage customer profiles and inquiries</span></li>
                    <li><i class="fas fa-check-circle"></i> <span>Track project status and timelines</span></li>
                    <li><i class="fas fa-check-circle"></i> <span>Schedule and manage appointments</span></li>
                    <li><i class="fas fa-check-circle"></i> <span>Generate performance reports</span></li>
                    <li><i class="fas fa-check-circle"></i> <span>Manage design portfolio</span></li>
                    <li><i class="fas fa-check-circle"></i> <span>View financial analytics</span></li>
                </ul>
            </div>
        </main>
    </div>

<?php
include 'footer.php';
?>
