<?php
/**
 * Real-Time Verification Configuration
 * Master configuration for all real-time verification features
 */

return array(
    
    // Real-Time Verification Settings
    'realtime_verification' => array(
        'enabled' => true,
        'api_endpoint' => '/interior/auth-system/api-realtime-verify.php',
        'debounce_delay' => 500,  // milliseconds
        'auto_format' => true,
        'show_feedback' => true,
    ),
    
    // Email Verification Settings
    'email_verification' => array(
        'enabled' => true,
        'check_duplicate' => true,
        'valid_domains' => array(),  // Leave empty to allow all
        'blocked_domains' => array('tempmail.com', 'guerrillamail.com'),  // Block disposable emails
        'dns_check' => false,  // Check if email domain has MX records
    ),
    
    // OTP Settings
    'otp' => array(
        'length' => 6,
        'expiry_minutes' => 10,
        'max_attempts' => 5,
        'lock_minutes' => 15,  // Lock after max attempts for X minutes
        'resend_cooldown' => 60,  // Seconds between resend requests
        'alphanumeric' => false,  // Use only digits (true for 6-digit codes)
    ),
    
    // Password Validation Settings
    'password' => array(
        'min_length' => 8,
        'require_uppercase' => true,
        'require_lowercase' => true,
        'require_numbers' => true,
        'require_special' => false,
        'special_chars' => '!@#$%^&*',
        'strength_levels' => array(
            'weak' => 2,
            'fair' => 3,
            'good' => 4,
            'strong' => 5,
        ),
    ),
    
    // Phone Validation Settings
    'phone' => array(
        'enabled' => true,
        'min_length' => 10,
        'max_length' => 15,
        'allow_plus' => true,
        'allow_spaces' => true,
        'allow_hyphens' => true,
        'country_code' => '',  // Leave empty to allow any country
    ),
    
    // Login Verification Settings
    'login_verification' => array(
        'enabled' => true,
        'check_email_exists' => true,
        'check_role_match' => true,
        'prevent_multiple_attempts' => true,
        'max_login_attempts' => 5,
        'lockout_minutes' => 15,
        'track_ip' => true,
    ),
    
    // Two-Factor Authentication (2FA) Settings
    'two_factor_auth' => array(
        'enabled' => true,
        'optional' => true,  // Users can choose to enable/disable
        'default_enabled' => false,
        'methods' => array('email', 'sms'),  // Available 2FA methods
        'email_enabled' => true,
        'sms_enabled' => false,
        'otp_length' => 6,
        'otp_expiry_minutes' => 5,
    ),
    
    // Session Settings
    'session' => array(
        'timeout_minutes' => 30,
        'idle_timeout_minutes' => 15,
        'remember_me_days' => 30,
        'single_session' => false,  // Only one session per user at a time
    ),
    
    // Rate Limiting
    'rate_limiting' => array(
        'enabled' => true,
        'check_email_rate' => 3,  // Requests per minute
        'send_otp_rate' => 2,  // Requests per minute
        'verify_otp_rate' => 10,  // Requests per minute
        'login_rate' => 5,  // Requests per minute
        'check_password_rate' => 20,  // Requests per minute
    ),
    
    // Security Settings
    'security' => array(
        'require_email_verification' => true,
        'email_already_verified' => false,
        'password_hash_algo' => PASSWORD_BCRYPT,
        'password_hash_cost' => 10,
        'token_length' => 64,
        'token_algorithm' => 'sha256',
        'https_only' => false,  // Require HTTPS for sensitive operations
        'csrf_protection' => true,
        'sql_injection_prevention' => true,
        'xss_prevention' => true,
    ),
    
    // Logging Settings
    'logging' => array(
        'enabled' => true,
        'log_dir' => __DIR__ . '/logs',
        'log_file' => 'verification.log',
        'log_level' => 'info',  // debug, info, warning, error
        'log_ip' => true,
        'log_user_agent' => true,
        'log_failed_attempts' => true,
    ),
    
    // Notification Settings
    'notifications' => array(
        'email_on_registration' => true,
        'email_on_login' => false,
        'email_on_password_change' => true,
        'email_on_suspicious_activity' => true,
        'email_on_2fa_enable' => true,
    ),
    
    // UI/UX Settings
    'ui' => array(
        'show_password_strength' => true,
        'show_otp_timer' => true,
        'show_field_validation' => true,
        'auto_focus_next_field' => true,
        'highlight_invalid_fields' => true,
        'smooth_transitions' => true,
        'dark_mode' => false,
    ),
    
    // Email Configuration
    'email' => array(
        'from_email' => 'noreply@faren.com',
        'from_name' => 'Faren Interior Design',
        'reply_to' => 'support@faren.com',
        'use_smtp' => false,
        'smtp_host' => 'smtp.gmail.com',
        'smtp_port' => 587,
        'smtp_username' => '',
        'smtp_password' => '',
        'smtp_encryption' => 'tls',
    ),
    
    // Development Settings
    'development' => array(
        'debug_mode' => false,
        'log_api_calls' => false,
        'mock_email_sending' => true,
        'email_log_dir' => __DIR__ . '/logs/emails',
        'show_error_details' => false,
        'test_mode' => false,
    ),
);
?>
