<?php
session_start();
require_once __DIR__ . '/config/db.php';

// Check if customer is logged in
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'customer') {
    header('Location: login.php');
    exit;
}

$customer_id = $_SESSION['user_id'];
$customer_name = $_SESSION['user_name'];
$customer_email = $_SESSION['user_email'];

$page_title = 'Schedule Consultation — Interior Design';

?>

<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    .consultation-wrapper {
        min-height: calc(100vh - 300px);
        padding: 40px 20px;
        background: linear-gradient(135deg, #f5f5f5 0%, #efefef 100%);
    }

    .consultation-container {
        max-width: 800px;
        margin: 0 auto;
    }

    .consultation-header {
        background: white;
        padding: 40px;
        border-radius: 14px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        margin-bottom: 30px;
        text-align: center;
    }

    .consultation-header h1 {
        font-size: 32px;
        color: #1a1a1a;
        margin-bottom: 12px;
    }

    .consultation-header p {
        color: #666;
        font-size: 16px;
    }

    .consultation-form {
        background: white;
        padding: 40px;
        border-radius: 14px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
    }

    .form-section {
        margin-bottom: 32px;
    }

    .form-section-title {
        font-size: 18px;
        font-weight: 700;
        color: #1a1a1a;
        margin-bottom: 20px;
        padding-bottom: 12px;
        border-bottom: 2px solid #e0e0e0;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-group label {
        display: block;
        margin-bottom: 8px;
        font-weight: 600;
        color: #333;
        font-size: 14px;
    }

    .form-group input,
    .form-group select,
    .form-group textarea {
        width: 100%;
        padding: 12px 16px;
        border: 2px solid #e0e0e0;
        border-radius: 8px;
        font-family: 'DM Sans', sans-serif;
        font-size: 14px;
        transition: all 0.3s ease;
    }

    .form-group input:focus,
    .form-group select:focus,
    .form-group textarea:focus {
        outline: none;
        border-color: #d4a33a;
        box-shadow: 0 0 0 3px rgba(212, 163, 58, 0.1);
    }

    .form-group textarea {
        resize: vertical;
        min-height: 120px;
    }

    .form-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 16px;
    }

    .message {
        padding: 16px;
        border-radius: 8px;
        margin-bottom: 24px;
        font-size: 14px;
    }

    .message.success {
        background: #d1e7dd;
        color: #0f5132;
        border-left: 4px solid #198754;
    }

    .message.error {
        background: #f8d7da;
        color: #842029;
        border-left: 4px solid #dc3545;
    }

    .btn {
        padding: 14px 32px;
        border: none;
        border-radius: 8px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        font-size: 14px;
        display: inline-block;
    }

    .btn-primary {
        background: linear-gradient(135deg, #d4a33a, #b8905a);
        color: white;
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 20px rgba(212, 163, 58, 0.3);
    }

    .btn-secondary {
        background: #e0e0e0;
        color: #333;
        margin-left: 10px;
    }

    .btn-secondary:hover {
        background: #d0d0d0;
    }

    .form-actions {
        display: flex;
        gap: 12px;
        margin-top: 32px;
    }

    .info-box {
        background: #e3f2fd;
        border-left: 4px solid #1976d2;
        padding: 16px;
        border-radius: 8px;
        margin-bottom: 24px;
        color: #1565c0;
    }

    .back-link {
        color: #d4a33a;
        text-decoration: none;
        font-weight: 600;
        margin-bottom: 20px;
        display: inline-block;
    }

    .back-link:hover {
        text-decoration: underline;
    }

    @media (max-width: 768px) {
        .consultation-wrapper {
            padding: 20px;
        }

        .consultation-header {
            padding: 24px;
        }

        .consultation-header h1 {
            font-size: 24px;
        }

        .consultation-form {
            padding: 24px;
        }

        .form-row {
            grid-template-columns: 1fr;
        }

        .form-actions {
            flex-direction: column;
        }

        .btn-secondary {
            margin-left: 0;
        }
    }
</style>

<div class="consultation-wrapper">
    <div class="consultation-container">
        <a href="customer-dashboard.php" class="back-link">← Back to Dashboard</a>

        <div class="consultation-header">
            <h1>📅 Schedule Your Consultation</h1>
            <p>Book an appointment with our design team</p>
        </div>

        <form id="consultationForm" class="consultation-form">
            <div id="formMessage"></div>

            <div class="info-box">
                <strong>💡 Tip:</strong> Fill in your details below and our team will verify your information via email. You'll receive confirmation and additional details about your consultation appointment.
            </div>

            <!-- PERSONAL INFORMATION -->
            <div class="form-section">
                <div class="form-section-title">Personal Information</div>

                <div class="form-row">
                    <div class="form-group">
                        <label>First Name *</label>
                        <input type="text" name="first_name" placeholder="Enter your first name" required>
                    </div>
                    <div class="form-group">
                        <label>Last Name *</label>
                        <input type="text" name="last_name" placeholder="Enter your last name" required>
                    </div>
                </div>

                <div class="form-group">
                    <label>Email Address *</label>
                    <input type="email" name="email" placeholder="Enter your email" value="<?php echo htmlspecialchars($customer_email); ?>" required>
                </div>

                <div class="form-group">
                    <label>Phone Number *</label>
                    <input type="tel" name="phone" placeholder="+92 XXX XXXXXXX" required>
                </div>

                <div class="form-group">
                    <label>Address *</label>
                    <textarea name="address" placeholder="Enter your complete address" required></textarea>
                </div>
            </div>

            <!-- CONSULTATION DETAILS -->
            <div class="form-section">
                <div class="form-section-title">Consultation Details</div>

                <div class="form-group">
                    <label>Type of Consultation *</label>
                    <select name="consultation_type" required>
                        <option value="">Select consultation type</option>
                        <option value="home_design">Home Interior Design</option>
                        <option value="office_design">Office Interior Design</option>
                        <option value="commercial_design">Commercial Interior Design</option>
                        <option value="renovation">Renovation & Remodeling</option>
                        <option value="other">Other</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Preferred Date *</label>
                    <input type="date" name="preferred_date" required min="<?php echo date('Y-m-d'); ?>">
                </div>

                <div class="form-group">
                    <label>Preferred Time *</label>
                    <select name="preferred_time" required>
                        <option value="">Select preferred time</option>
                        <option value="09:00">09:00 AM</option>
                        <option value="10:00">10:00 AM</option>
                        <option value="11:00">11:00 AM</option>
                        <option value="12:00">12:00 PM</option>
                        <option value="14:00">02:00 PM</option>
                        <option value="15:00">03:00 PM</option>
                        <option value="16:00">04:00 PM</option>
                        <option value="17:00">05:00 PM</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>Project Description *</label>
                    <textarea name="project_description" placeholder="Tell us about your project, budget, and any specific requirements..." required></textarea>
                </div>

                <div class="form-group">
                    <label>Budget Range *</label>
                    <select name="budget_range" required>
                        <option value="">Select budget range</option>
                        <option value="10000-50000">Rs. 10,000 - Rs. 50,000</option>
                        <option value="50000-100000">Rs. 50,000 - Rs. 100,000</option>
                        <option value="100000-500000">Rs. 100,000 - Rs. 500,000</option>
                        <option value="500000+">Rs. 500,000+</option>
                    </select>
                </div>

                <div class="form-group">
                    <label>How did you hear about us?</label>
                    <select name="source">
                        <option value="">Select source</option>
                        <option value="google">Google Search</option>
                        <option value="social_media">Social Media</option>
                        <option value="referral">Referral</option>
                        <option value="website">Website</option>
                        <option value="other">Other</option>
                    </select>
                </div>
            </div>

            <div class="form-actions">
                <button type="submit" class="btn btn-primary">Request Consultation</button>
                <button type="reset" class="btn btn-secondary">Clear Form</button>
            </div>
        </form>
    </div>
</div>

<!-- VERIFICATION MODAL -->
<div id="verificationModal" class="modal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.6); z-index: 1000; align-items: center; justify-content: center;">
    <div style="background: white; padding: 40px; border-radius: 14px; max-width: 500px; width: 100%; box-shadow: 0 20px 60px rgba(0,0,0,0.3);">
        <h2 style="font-size: 24px; color: #1a1a1a; margin-bottom: 16px;">Verify Your Email</h2>
        <p style="color: #666; margin-bottom: 24px;">We've sent a verification link to your email. Please check your inbox and click the link to confirm your consultation request.</p>
        <div style="padding: 16px; background: #e3f2fd; border-left: 4px solid #1976d2; border-radius: 8px; margin-bottom: 24px;">
            <strong>Email:</strong> <span id="verificationEmail"></span>
        </div>
        <button onclick="closeVerificationModal()" class="btn btn-primary" style="width: 100%;">Done</button>
    </div>
</div>

<script>
    document.getElementById('consultationForm').addEventListener('submit', async function(e) {
        e.preventDefault();

        const formData = new FormData(this);
        const messageDiv = document.getElementById('formMessage');

        try {
            const response = await fetch('api/submit-consultation.php', {
                method: 'POST',
                body: formData
            });

            const data = await response.json();

            if (data.success) {
                messageDiv.innerHTML = '<div class="message success">✅ ' + data.message + '</div>';
                document.getElementById('verificationEmail').textContent = formData.get('email');
                setTimeout(() => {
                    openVerificationModal();
                }, 1000);
                this.reset();
                setTimeout(() => {
                    window.location.href = 'customer-dashboard.php';
                }, 3000);
            } else {
                messageDiv.innerHTML = '<div class="message error">❌ ' + data.message + '</div>';
            }
        } catch (error) {
            messageDiv.innerHTML = '<div class="message error">❌ Error: ' + error.message + '</div>';
        }
    });

    function openVerificationModal() {
        document.getElementById('verificationModal').style.display = 'flex';
    }

    function closeVerificationModal() {
        document.getElementById('verificationModal').style.display = 'none';
    }
</script>

<?php include 'footer.php'; ?>
