<?php
session_start();
require_once __DIR__ . '/config/db.php';

// Redirect if not logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$user_id = $_SESSION['user_id'];
$user_name = $_SESSION['user_name'] ?? 'User';
$user_email = $_SESSION['user_email'] ?? '';
$page_title = 'Dashboard';

// Get user projects/info from database
$stmt = $conn->prepare('SELECT * FROM users WHERE id = ?');
$stmt->bind_param('i', $user_id);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dashboard — Interior Design</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="../assets/css/fontawesome.min.css">
    <link rel="stylesheet" href="../assets/css/style.css">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'DM Sans', sans-serif;
            background: linear-gradient(135deg, #0f0f0f 0%, #1a1a1a 50%, #2a2118 100%);
            min-height: 100vh;
        }
        .main-header {
            margin-bottom: 0;
        }
        .dashboard-wrapper {
            display: flex;
            min-height: calc(100vh - 200px);
            background: linear-gradient(135deg, #0f0f0f 0%, #1a1a1a 50%, #2a2118 100%);
        }
        .sidebar {
            width: 280px;
            background: linear-gradient(180deg, #ffffff 0%, #f9f9f9 100%);
            box-shadow: 5px 0 30px rgba(212, 165, 116, 0.1);
            padding: 30px 20px;
            overflow-y: auto;
            position: sticky;
            height: 100vh;
            left: 0;
            top: 0;
        }
        .sidebar-logo {
            margin-bottom: 40px;
            text-align: center;
            border-bottom: 2px solid #D4A574;
            padding-bottom: 20px;
        }
        .sidebar-logo h3 {
            color: #D4A574;
            font-weight: 700;
            font-size: 26px;
            letter-spacing: 1px;
        }
        .sidebar-menu {
            list-style: none;
        }
        .sidebar-menu li {
            margin-bottom: 12px;
        }
        .sidebar-menu a {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 14px 16px;
            color: #666;
            text-decoration: none;
            border-radius: 8px;
            transition: all 0.3s ease;
            font-weight: 500;
            border-left: 3px solid transparent;
        }
        .sidebar-menu a:hover,
        .sidebar-menu a.active {
            background: linear-gradient(90deg, rgba(212, 165, 116, 0.1) 0%, transparent 100%);
            color: #D4A574;
            border-left-color: #D4A574;
        }
        .sidebar-menu i {
            width: 20px;
            text-align: center;
            font-size: 16px;
        }
        .main-content {
            flex: 1;
            padding: 40px;
            overflow-y: auto;
            margin-left: 280px;
        }
        .top-bar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            padding: 25px 30px;
            border-radius: 12px;
            margin-bottom: 25px;
            box-shadow: 0 10px 40px rgba(212, 165, 116, 0.15);
            border: 1px solid rgba(212, 165, 116, 0.2);
        }
        .welcome-text h2 {
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 5px;
            background: linear-gradient(135deg, #D4A574 0%, #b8905a 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        .welcome-text p {
            color: #999;
            font-size: 14px;
        }
        .user-profile {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .user-avatar {
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #D4A574 0%, #b8905a 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 700;
            font-size: 20px;
            box-shadow: 0 5px 15px rgba(212, 165, 116, 0.3);
        }
        .dashboard-cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
            gap: 30px;
            margin-bottom: 40px;
        }
        .card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            padding: 35px;
            border-radius: 12px;
            box-shadow: 0 10px 40px rgba(212, 165, 116, 0.1);
            border: 1px solid rgba(212, 165, 116, 0.2);
            transition: all 0.3s ease;
        }
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 50px rgba(212, 165, 116, 0.25);
            border-color: rgba(212, 165, 116, 0.5);
        }
        .card-icon {
            font-size: 48px;
            color: #D4A574;
            margin-bottom: 20px;
        }
        .card-title {
            color: #ffffffff;
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 12px;
        }
        .card-text {
            color: #ffffffff;
            font-size: 14px;
            line-height: 1.6;
        }
        .profile-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 10px 40px rgba(212, 165, 116, 0.1);
            border: 1px solid rgba(212, 165, 116, 0.2);
        }
        .profile-card h3 {
            color: #1a1a1a;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px solid #D4A574;
        }
        .profile-info {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
        }
        .info-item {
            padding: 20px;
            background: linear-gradient(135deg, rgba(212, 165, 116, 0.05) 0%, transparent 100%);
            border-radius: 10px;
            border: 1px solid rgba(212, 165, 116, 0.15);
            transition: all 0.3s ease;
        }
        .info-item:hover {
            border-color: rgba(212, 165, 116, 0.4);
            background: linear-gradient(135deg, rgba(212, 165, 116, 0.1) 0%, transparent 100%);
        }
        .info-label {
            color: #999;
            font-size: 12px;
            text-transform: uppercase;
            font-weight: 700;
            letter-spacing: 0.5px;
            margin-bottom: 8px;
        }
        .info-value {
            color: #1a1a1a;
            font-size: 17px;
            font-weight: 700;
            color: #D4A574;
        }
        .logout-btn {
            padding: 12px 24px;
            background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
            color: white;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-weight: 700;
            transition: all 0.3s ease;
            box-shadow: 0 5px 15px rgba(220, 53, 69, 0.3);
        }
        .logout-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(220, 53, 69, 0.4);
        }
        @media (max-width: 768px) {
            .sidebar {
                position: relative;
                width: 100%;
                height: auto;
                margin-bottom: 20px;
            }
            .main-content {
                margin-left: 0;
                padding: 20px;
            }
            .top-bar {
                flex-direction: column;
                gap: 20px;
            }
            .profile-info {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <?php include 'header.php'; ?>
    
    <div class="dashboard-wrapper">
        <!-- Sidebar -->
        <div class="sidebar">
            <div class="sidebar-logo">
                <h3>Faren</h3>
            </div>
            <ul class="sidebar-menu">
                <li><a href="dashboard.php" class="active"><i class="fas fa-home"></i> Dashboard</a></li>
                <li><a href="#profile"><i class="fas fa-user"></i> Profile</a></li>
                <li><a href="#projects"><i class="fas fa-project-diagram"></i> Projects</a></li>
                <li><a href="#bookings"><i class="fas fa-calendar"></i> Bookings</a></li>
                <li><a href="#contact"><i class="fas fa-envelope"></i> Contact</a></li>
                <li><a href="#settings"><i class="fas fa-cog"></i> Settings</a></li>
                <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
            </ul>
        </div>

        <!-- Main Content -->
        <div class="main-content">
            <!-- Top Bar -->
            <div class="top-bar">
                <div class="welcome-text">
                    <h2>Welcome, <?php echo htmlspecialchars($user_name); ?>! 👋</h2>
                    <p>Here's your design dashboard</p>
                </div>
                <div class="user-profile">
                    <div class="user-avatar"><?php echo strtoupper(substr($user_name, 0, 1)); ?></div>
                    <div>
                        <div style="font-weight: 600; color: #333;"><?php echo htmlspecialchars($user_name); ?></div>
                        <div style="font-size: 12px; color: #999;"><?php echo htmlspecialchars($user_email); ?></div>
                    </div>
                </div>
            </div>

            <!-- Dashboard Cards -->
            <div class="dashboard-cards">
                <div class="card" style="background: #0f0f0f;">
                    <div class="card-icon"><i class="fas fa-pencil-ruler"></i></div>
                    <div class="card-title">My Projects</div>
                    <div class="card-text">View and manage all your interior design projects</div>
                </div>
                <div class="card" style="background: #0f0f0f;">
                    <div class="card-icon"><i class="fas fa-calendar-check"></i></div>
                    <div class="card-title">Upcoming Bookings</div>
                    <div class="card-text">Schedule and manage your design consultations</div>
                </div>
                <div class="card" style="background: #0f0f0f;">
                    <div class="card-icon"><i class="fas fa-star"></i></div>
                    <div class="card-title">Saved Designs</div>
                    <div class="card-text">Your collection of favorite interior designs</div>
                </div>
            </div>

            <!-- Profile Information -->
            <div class="profile-card">
                <h3>Account Information</h3>
                <div class="profile-info">
                    <div class="info-item">
                        <div class="info-label"><i class="fas fa-user"></i> Full Name</div>
                        <div class="info-value"><?php echo htmlspecialchars($user['name'] ?? 'N/A'); ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label"><i class="fas fa-envelope"></i> Email Address</div>
                        <div class="info-value"><?php echo htmlspecialchars($user['email'] ?? 'N/A'); ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label"><i class="fas fa-phone"></i> Phone Number</div>
                        <div class="info-value"><?php echo htmlspecialchars($user['phone'] ?? 'N/A'); ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label"><i class="fas fa-calendar"></i> Member Since</div>
                        <div class="info-value"><?php echo date('F d, Y', strtotime($user['created_at'] ?? 'now')); ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label"><i class="fas fa-sync"></i> Last Updated</div>
                        <div class="info-value"><?php echo date('F d, Y H:i', strtotime($user['updated_at'] ?? 'now')); ?></div>
                    </div>
                    <div class="info-item">
                        <div class="info-label"><i class="fas fa-user-shield"></i> Status</div>
                        <div class="info-value" style="color: #28a745;">Active</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="../assets/js/bootstrap.min.js"></script>
    <?php include 'footer.php'; ?>
</body>
</html>
