<?php
// Header HTML for Auth Pages
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo isset($page_title) ? $page_title : 'Faren - Interior Design'; ?></title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="../assets/css/fontawesome.min.css">
    <style>
        .top-header {
            width: 100%;
            background: #000000;
            padding: 6px 0;
        }
        .top-header-inner,
        .top-header-inner a,
        .top-header-inner i {
            color: #ffffff !important;
        }
        .top-header-inner a:hover,
        .top-header-inner i:hover {
            color: #f44646 !important;
        }
        .top-header-inner {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 5%;
        }
        .welcome-text {
            color: #ffffff !important;
            font-size: 15px;
            font-weight: 500;
        }
        .social-icons a {
            color: #ffffff;
            margin-left: 15px;
            font-size: 16px;
            transition: .3s;
        }
        .social-icons a:hover {
            color: #d4a33a;
            transform: scale(1.15);
        }
        .contact-strip {
            width: 100%;
            background: #ffffff;
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            padding: 15px 10px;
            align-items: center;
            border-bottom: 3px solid #d4a33a;
        }
        .contact-item {
            display: flex;
            align-items: center;
            gap: 12px;
        }
        .contact-icon {
            font-size: 26px;
            color: #d4a33a;
        }
        .contact-title {
            margin: 0;
            font-size: 16px;
            font-weight: 700;
            color: #000;
        }
        .contact-text {
            margin: 0;
            font-size: 15px;
            color: #666;
        }
        .auth-buttons {
            display: flex !important;
            gap: 12px;
            justify-content: center;
        }
        .auth-btn {
            padding: 10px 20px;
            border-radius: 4px;
            font-weight: 600;
            font-size: 14px;
            text-decoration: none;
            transition: all 0.3s ease;
            border: 2px solid #d4a33a;
        }
        .login-btn {
            background-color: #d4a33a;
            color: #ffffff;
        }
        .login-btn:hover {
            background-color: #ffffff;
            color: #d4a33a;
        }
        .register-btn {
            background-color: transparent;
            color: #d4a33a;
        }
        .register-btn:hover {
            background-color: #d4a33a;
            color: #ffffff;
        }
        @media(max-width: 992px) {
            .contact-strip {
                grid-template-columns: repeat(2, 1fr);
                row-gap: 15px;
            }
        }
        @media(max-width: 600px) {
            .top-header {
                display: none !important;
            }
            .contact-strip {
                display: none !important;
            }
        }
    </style>
</head>
<body>
    <!-- Top Header -->
    <div class="top-header">
        <div class="container-fluid top-header-inner">
            <div class="welcome-text">
                Welcome to Faren Architecture & Interior Design
            </div>
            <div class="social-icons">
                <a href="#"><i class="fa-brands fa-facebook-f"></i></a>
                <a href="#"><i class="fa-brands fa-twitter"></i></a>
                <a href="#"><i class="fa-brands fa-instagram"></i></a>
                <a href="#"><i class="fa-brands fa-whatsapp"></i></a>
                <a href="#"><i class="fa-brands fa-youtube"></i></a>
            </div>
        </div>
    </div>

    <!-- Contact Strip -->
    <div class="contact-strip" style="padding-left: 135px;">
        <div class="contact-item">
            <i class="fa-solid fa-phone contact-icon"></i>
            <div>
                <p class="contact-title">Call Us:</p>
                <p class="contact-text">+00 (123) 666 000 666</p>
            </div>
        </div>

        <div class="contact-item">
            <i class="fa-solid fa-envelope contact-icon"></i>
            <div>
                <p class="contact-title">Mail Us:</p>
                <p class="contact-text">info@faren.com</p>
            </div>
        </div>

        <div class="contact-item">
            <i class="fa-solid fa-location-dot contact-icon"></i>
            <div>
                <p class="contact-title">Location:</p>
                <p class="contact-text">Coimbatore, Tamil Nadu</p>
            </div>
        </div>

        <div class="contact-item auth-buttons">
            <a href="../index.php" class="auth-btn login-btn">Home</a>
            <a href="dashboard.php" class="auth-btn register-btn">Dashboard</a>
        </div>
    </div>

    


