<?php
/**
 * Database Migration - Add Phone Column
 * Run this file once in your browser to add the phone column
 * URL: http://localhost/interior/auth-system/migrate.php
 */

require_once __DIR__ . '/config/db.php';

$success_messages = [];
$error_messages = [];

// Check if role column exists
$check_role = $conn->query("SHOW COLUMNS FROM users LIKE 'role'");
if ($check_role->num_rows == 0) {
    $sql = "ALTER TABLE users ADD COLUMN role ENUM('customer', 'admin') DEFAULT 'customer'";
    if ($conn->query($sql) === TRUE) {
        $success_messages[] = "✓ Added 'role' column successfully";
    } else {
        $error_messages[] = "✗ Error adding 'role' column: " . $conn->error;
    }
} else {
    $success_messages[] = "✓ 'role' column already exists";
}

// Check if status column exists
$check_status = $conn->query("SHOW COLUMNS FROM users LIKE 'status'");
if ($check_status->num_rows == 0) {
    $sql = "ALTER TABLE users ADD COLUMN status ENUM('active', 'inactive') DEFAULT 'active'";
    if ($conn->query($sql) === TRUE) {
        $success_messages[] = "✓ Added 'status' column successfully";
    } else {
        $error_messages[] = "✗ Error adding 'status' column: " . $conn->error;
    }
} else {
    $success_messages[] = "✓ 'status' column already exists";
}

// Check if phone column exists
$check_phone = $conn->query("SHOW COLUMNS FROM users LIKE 'phone'");
if ($check_phone->num_rows == 0) {
    $sql = "ALTER TABLE users ADD COLUMN phone VARCHAR(20)";
    if ($conn->query($sql) === TRUE) {
        $success_messages[] = "✓ Added 'phone' column successfully";
    } else {
        $error_messages[] = "✗ Error adding 'phone' column: " . $conn->error;
    }
} else {
    $success_messages[] = "✓ 'phone' column already exists";
}

$conn->close();
?>
