<?php
session_start();
require_once __DIR__ . '/config/db.php';

echo "<h2>Setting Up Test Accounts</h2>";

// Check if users table exists
$check_table = $conn->query("SHOW TABLES LIKE 'users'");
if ($check_table->num_rows === 0) {
    echo "<p style='color: red;'><strong>Error:</strong> Users table doesn't exist. Creating it now...</p>";
    
    $sql = "CREATE TABLE IF NOT EXISTS users (
        id INT PRIMARY KEY AUTO_INCREMENT,
        name VARCHAR(100) NOT NULL,
        email VARCHAR(100) UNIQUE NOT NULL,
        phone VARCHAR(20),
        password VARCHAR(255) NOT NULL,
        role ENUM('admin', 'customer') DEFAULT 'customer',
        status VARCHAR(20) DEFAULT 'active',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )";
    
    if ($conn->query($sql)) {
        echo "<p style='color: green;'><strong>✓ Users table created successfully!</strong></p>";
    } else {
        echo "<p style='color: red;'><strong>Error creating table:</strong> " . $conn->error . "</p>";
    }
}

// Create test admin account
$admin_email = 'admin@faren.com';
$admin_password = password_hash('admin123', PASSWORD_DEFAULT);
$admin_name = 'Admin User';
$admin_phone = '1234567890';
$admin_role = 'admin';

// Check if admin exists
$check_admin = $conn->prepare("SELECT id FROM users WHERE email = ? AND role = ?");
$check_admin->bind_param("ss", $admin_email, $admin_role);
$check_admin->execute();
$result = $check_admin->get_result();

if ($result->num_rows === 0) {
    $stmt = $conn->prepare("INSERT INTO users (name, email, phone, password, role, status) VALUES (?, ?, ?, ?, ?, ?)");
    $status = 'active';
    $stmt->bind_param("ssssss", $admin_name, $admin_email, $admin_phone, $admin_password, $admin_role, $status);
    
    if ($stmt->execute()) {
        echo "<p style='color: green;'><strong>✓ Admin account created successfully!</strong></p>";
    } else {
        echo "<p style='color: red;'><strong>Error:</strong> " . $stmt->error . "</p>";
    }
    $stmt->close();
} else {
    echo "<p style='color: blue;'>✓ Admin account already exists</p>";
}

// Create test customer account
$customer_email = 'customer@faren.com';
$customer_password = password_hash('customer123', PASSWORD_DEFAULT);
$customer_name = 'John Doe';
$customer_phone = '9876543210';
$customer_role = 'customer';

// Check if customer exists
$check_customer = $conn->prepare("SELECT id FROM users WHERE email = ? AND role = ?");
$check_customer->bind_param("ss", $customer_email, $customer_role);
$check_customer->execute();
$result = $check_customer->get_result();

if ($result->num_rows === 0) {
    $stmt = $conn->prepare("INSERT INTO users (name, email, phone, password, role, status) VALUES (?, ?, ?, ?, ?, ?)");
    $status = 'active';
    $stmt->bind_param("ssssss", $customer_name, $customer_email, $customer_password, $customer_role, $status);
    
    if ($stmt->execute()) {
        echo "<p style='color: green;'><strong>✓ Customer account created successfully!</strong></p>";
    } else {
        echo "<p style='color: red;'><strong>Error:</strong> " . $stmt->error . "</p>";
    }
    $stmt->close();
} else {
    echo "<p style='color: blue;'>✓ Customer account already exists</p>";
}

echo "<hr>";
echo "<h3>📋 Test Account Credentials:</h3>";
echo "<p><strong>Admin Account:</strong></p>";
echo "<ul>";
echo "<li>Email: <code>admin@faren.com</code></li>";
echo "<li>Password: <code>admin123</code></li>";
echo "<li>Role: <code>Admin</code></li>";
echo "</ul>";

echo "<p><strong>Customer Account:</strong></p>";
echo "<ul>";
echo "<li>Email: <code>customer@faren.com</code></li>";
echo "<li>Password: <code>customer123</code></li>";
echo "<li>Role: <code>Customer</code></li>";
echo "</ul>";

echo "<hr>";
echo "<p><a href='login.php' style='background: #D4A574; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; display: inline-block;'>← Back to Login</a></p>";

$conn->close();
?>
