<?php
/**
 * Database Setup Script
 * Run this file once in your browser to create the database and users table
 * URL: http://localhost/interior/auth-system/setup.php
 */

$db_host = 'localhost';
$db_user = 'zemaraim';
$db_pass = '8wwxk]-X3Kx]CJ]5';
$db_name = 'zemaraim_interior';

// Create connection to MySQL server
$conn = new mysqli($db_host, $db_user, $db_pass);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Create database
$sql = "CREATE DATABASE IF NOT EXISTS " . $db_name;
if ($conn->query($sql) === TRUE) {
    echo "<p style='color: green;'>✓ Database created successfully</p>";
} else {
    echo "<p style='color: red;'>✗ Error creating database: " . $conn->error . "</p>";
}

// Select the database
$conn->select_db($db_name);

// Create users table
$sql = "CREATE TABLE IF NOT EXISTS users (
    id INT PRIMARY KEY AUTO_INCREMENT,
    name VARCHAR(100) NOT NULL,
    email VARCHAR(100) UNIQUE NOT NULL,
    phone VARCHAR(20),
    password VARCHAR(255) NOT NULL,
    role ENUM('customer', 'admin') DEFAULT 'customer',
    status ENUM('active', 'inactive') DEFAULT 'active',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
)";

if ($conn->query($sql) === TRUE) {
    echo "<p style='color: green;'>✓ Users table created successfully</p>";
} else {
    echo "<p style='color: red;'>✗ Error creating table: " . $conn->error . "</p>";
}

// Add columns if table already exists (for existing installations)
$alter_sql_role = "ALTER TABLE users ADD COLUMN role ENUM('customer', 'admin') DEFAULT 'customer'";
$alter_sql_status = "ALTER TABLE users ADD COLUMN status ENUM('active', 'inactive') DEFAULT 'active'";

// Try to add role column if it doesn't exist
@$conn->query($alter_sql_role);

// Try to add status column if it doesn't exist
@$conn->query($alter_sql_status);

echo "<p style='color: blue;'>✓ Database schema updated with role and status columns</p>";

$conn->close();

echo "<hr>";
echo "<p><strong>Setup Complete!</strong></p>";
echo "<p><a href='login.php'>Go to Login Page</a></p>";
echo "<p><a href='../index.html'>Back to Home</a></p>";
?>
