<?php
session_start();
require_once __DIR__ . '/config/db.php';

$page_title = 'Verify Consultation — Interior Design';
include 'header.php';

$verified = false;
$message = 'Verifying your email...';
$status = 'pending';

if (isset($_GET['token']) && isset($_GET['id'])) {
    $token = $_GET['token'];
    $consultation_id = intval($_GET['id']);

    // Check token and verify
    $query = "SELECT * FROM consultations WHERE id = ? AND verification_token = ? AND token_expiry > NOW()";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("is", $consultation_id, $token);
    $stmt->execute();
    $result = $stmt->get_result();
    $consultation = $result->fetch_assoc();

    if ($consultation) {
        // Update consultation status to verified
        $update_query = "UPDATE consultations SET status = 'verified', verified_at = NOW() WHERE id = ?";
        $update_stmt = $conn->prepare($update_query);
        $update_stmt->bind_param("i", $consultation_id);
        
        if ($update_stmt->execute()) {
            $verified = true;
            $message = 'Email verified successfully! Our team will contact you soon.';
            $status = 'success';
        } else {
            $message = 'Error verifying email. Please try again.';
            $status = 'error';
        }
    } else {
        $message = 'Verification link is invalid or has expired. Please request a new consultation.';
        $status = 'error';
    }
} else {
    $message = 'Invalid verification link.';
    $status = 'error';
}
?>

<style>
    .verification-wrapper {
        min-height: calc(100vh - 300px);
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 40px 20px;
        background: linear-gradient(135deg, #f5f5f5 0%, #efefef 100%);
    }

    .verification-card {
        background: white;
        padding: 60px;
        border-radius: 14px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        max-width: 500px;
        width: 100%;
        text-align: center;
    }

    .verification-icon {
        font-size: 64px;
        margin-bottom: 24px;
    }

    .verification-card h1 {
        font-size: 28px;
        color: #1a1a1a;
        margin-bottom: 16px;
    }

    .verification-card p {
        color: #666;
        font-size: 16px;
        line-height: 1.8;
        margin-bottom: 32px;
    }

    .status-success {
        color: #0f5132;
    }

    .status-error {
        color: #842029;
    }

    .btn {
        padding: 14px 32px;
        border: none;
        border-radius: 8px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        font-size: 14px;
        text-decoration: none;
        display: inline-block;
    }

    .btn-primary {
        background: linear-gradient(135deg, #d4a33a, #b8905a);
        color: white;
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 20px rgba(212, 163, 58, 0.3);
    }

    @media (max-width: 768px) {
        .verification-card {
            padding: 40px 24px;
        }

        .verification-icon {
            font-size: 48px;
        }

        .verification-card h1 {
            font-size: 22px;
        }

        .verification-card p {
            font-size: 14px;
        }
    }
</style>

<div class="verification-wrapper">
    <div class="verification-card">
        <?php if ($verified): ?>
            <div class="verification-icon">✅</div>
            <h1 class="status-success">Email Verified!</h1>
            <p class="status-success"><?php echo htmlspecialchars($message); ?></p>
            <p style="color: #666; font-size: 14px; margin-bottom: 24px;">Your consultation request is now confirmed. We will review your details and contact you within 24 hours to schedule your appointment.</p>
        <?php else: ?>
            <div class="verification-icon">❌</div>
            <h1 class="status-error">Verification Failed</h1>
            <p class="status-error"><?php echo htmlspecialchars($message); ?></p>
            <p style="color: #666; font-size: 14px; margin-bottom: 24px;">If you need to schedule a consultation again, please visit your dashboard and submit a new request.</p>
        <?php endif; ?>
        
        <a href="customer-dashboard.php" class="btn btn-primary">Back to Dashboard</a>
    </div>
</div>

<?php include 'footer.php'; ?>
