-- Database Backup
-- Generated: 2026-01-03 10:23:45
-- Database: interior

SET FOREIGN_KEY_CHECKS = 0;

DROP TABLE IF EXISTS `consultations`;
CREATE TABLE `consultations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `first_name` varchar(100) NOT NULL,
  `last_name` varchar(100) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `address` text NOT NULL,
  `consultation_type` varchar(50) NOT NULL,
  `preferred_date` date NOT NULL,
  `preferred_time` time NOT NULL,
  `project_description` text NOT NULL,
  `budget_range` varchar(50) NOT NULL,
  `source` varchar(50) DEFAULT NULL,
  `verification_token` varchar(255) DEFAULT NULL,
  `token_expiry` datetime DEFAULT NULL,
  `status` enum('pending','verified','scheduled','completed','cancelled') DEFAULT 'pending',
  `verified_at` datetime DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_status` (`status`),
  KEY `idx_email` (`email`),
  KEY `idx_verification_token` (`verification_token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `order_number` varchar(50) NOT NULL,
  `total_amount` decimal(10,2) NOT NULL,
  `status` enum('pending','processing','completed','cancelled') DEFAULT 'pending',
  `payment_method` varchar(50) DEFAULT NULL,
  `shipping_address` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_number` (`order_number`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `team_members`;
CREATE TABLE `team_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `image_path` varchar(255) DEFAULT NULL,
  `twitter_url` varchar(255) DEFAULT NULL,
  `linkedin_url` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_created` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `team_members` VALUES ('1', 'Jake Saper', 'CEO & Founder', 'assets/img/team/team_1_1.png', 'https://twitter.com/', 'https://linkedin.com/', '2025-12-26 14:10:23', '2025-12-26 14:10:23');
INSERT INTO `team_members` VALUES ('2', 'Mari Doly', 'Chief Architect', 'assets/img/team/team_1_2.png', 'https://twitter.com/', 'https://linkedin.com/', '2025-12-26 14:10:23', '2025-12-26 14:10:23');
INSERT INTO `team_members` VALUES ('3', 'Michel Smith', 'General Manager', 'assets/img/team/team_1_3.png', 'https://twitter.com/', 'https://linkedin.com/', '2025-12-26 14:10:23', '2025-12-26 14:10:23');
INSERT INTO `team_members` VALUES ('4', 'Elis Mike', 'Assistant Architect', 'assets/img/team/team_1_4.png', 'https://twitter.com/', 'https://linkedin.com/', '2025-12-26 14:10:24', '2025-12-26 14:10:24');
INSERT INTO `team_members` VALUES ('5', 'Johone Smith', 'Johone Smith', 'assets/img/team/team_1_5.png', 'https://twitter.com/', 'https://linkedin.com/', '2025-12-26 14:10:24', '2025-12-26 14:10:24');
INSERT INTO `team_members` VALUES ('6', 'Tony Mari', 'Chief Planner', 'assets/img/team/team_1_6.png', 'https://twitter.com/', 'https://linkedin.com/', '2025-12-26 14:10:24', '2025-12-26 14:10:24');
INSERT INTO `team_members` VALUES ('7', 'halith', 'Chief Planner', 'assets/img/team/team_1766738870_6936.jpg', 'https://twitter.com/', 'https://linkedin.com/', '2025-12-26 14:17:50', '2025-12-26 14:17:50');

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `otp` varchar(6) DEFAULT NULL,
  `otp_expiry` datetime DEFAULT NULL,
  `is_verified` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

SET FOREIGN_KEY_CHECKS = 1;
