-- Database Backup
-- Generated: 2026-01-03 10:26:38
-- Database: interior_design

SET FOREIGN_KEY_CHECKS = 0;

DROP TABLE IF EXISTS `audit_logs`;
CREATE TABLE `audit_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `action` varchar(100) NOT NULL,
  `details` text DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_user` (`user_id`),
  KEY `idx_action` (`action`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `blogs`;
CREATE TABLE `blogs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `category` varchar(100) NOT NULL,
  `author` varchar(100) NOT NULL,
  `day` varchar(2) NOT NULL,
  `month` varchar(20) NOT NULL,
  `image_path` varchar(500) NOT NULL,
  `content` longtext DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_category` (`category`),
  KEY `idx_author` (`author`),
  KEY `idx_created` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `blogs` VALUES ('1', 'Are custom-made sofas a good choice for premium quality interior design?', 'Interior', 'Johon Smith', '18', 'JUNE', 'assets/img/blog/blog-grid-2.jpg', 'Custom-made sofas can be an excellent choice for premium interior design...', '2025-12-29 11:38:09', '2025-12-29 11:38:09');
INSERT INTO `blogs` VALUES ('2', 'What are the latest trends in outdoor living spaces for 2025?', 'Interior', 'Johon Smith', '18', 'JUNE', 'assets/img/blog/blog-grid-3.jpg', 'Outdoor living spaces have evolved significantly...', '2025-12-29 11:38:09', '2025-12-29 11:38:09');
INSERT INTO `blogs` VALUES ('3', 'How does proper lighting enhance the ambiance of a room?', 'Design', 'Johon Smith', '18', 'JUNE', 'assets/img/blog/blog-grid-5.jpg', 'Proper lighting is crucial in creating the right ambiance...', '2025-12-29 11:38:09', '2025-12-29 11:38:09');

DROP TABLE IF EXISTS `cart`;
CREATE TABLE `cart` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_name` varchar(255) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `quantity` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `product_id` (`product_id`),
  CONSTRAINT `cart_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `cart` VALUES ('45', '6', '2', 'Elegant Wooden Chair', '12000.00', 'assets/img/product/product_1_2.jpg', '3', '2025-12-23 19:04:16', '2025-12-31 11:19:12');
INSERT INTO `cart` VALUES ('48', '16', '2', 'Elegant Wooden Chair', '12000.00', 'assets/img/product/product_1_2.jpg', '1', '2025-12-26 18:23:18', '2025-12-26 18:23:18');
INSERT INTO `cart` VALUES ('49', '17', '2', 'Elegant Wooden Chair', '12000.00', 'assets/img/product/product_1_2.jpg', '1', '2025-12-30 14:55:53', '2025-12-30 14:55:53');
INSERT INTO `cart` VALUES ('50', '17', '3', 'Rounded Dining Table', '14000.00', 'assets/img/product/product_1_3.jpg', '1', '2025-12-30 14:56:05', '2025-12-30 14:56:05');
INSERT INTO `cart` VALUES ('55', '17', '1', 'Nordic Wooden Chair', '10000.00', 'assets/img/product/product_1_1.jpg', '1', '2025-12-31 11:39:25', '2025-12-31 11:39:25');

DROP TABLE IF EXISTS `consultations`;
CREATE TABLE `consultations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `first_name` varchar(100) DEFAULT NULL,
  `last_name` varchar(100) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `consultation_type` varchar(50) DEFAULT NULL,
  `preferred_date` date DEFAULT NULL,
  `preferred_time` time DEFAULT NULL,
  `project_description` text DEFAULT NULL,
  `budget_range` varchar(50) DEFAULT NULL,
  `source` varchar(50) DEFAULT NULL,
  `verification_token` varchar(255) DEFAULT NULL,
  `token_expiry` datetime DEFAULT NULL,
  `verification_status` enum('pending','verified','scheduled','completed','cancelled') DEFAULT 'pending',
  `status` enum('pending','verified','scheduled','completed','cancelled') DEFAULT 'pending',
  `verified_at` datetime DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_status` (`status`),
  KEY `idx_email` (`email`),
  CONSTRAINT `consultations_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `consultations` VALUES ('14', '6', NULL, 'Mohamed', 'S', 'mohamedhalith117@gmail.com', '+919080468168', 'vedhalai', 'renovation', '2026-01-23', '14:00:00', 'fwFQ', '200k-500k', 'google', NULL, NULL, 'pending', '', NULL, NULL, NULL, '2026-01-03 12:22:50', '2026-01-03 12:23:40');
INSERT INTO `consultations` VALUES ('15', '6', NULL, 'Mohamed', 'halith', 'mohamedhalith117@gmail.com', '+919080468168', 'ved', 'renovation', '2026-01-23', '13:00:00', 'rfgvbhjn', '500k+', 'friend', NULL, NULL, 'pending', '', NULL, NULL, NULL, '2026-01-03 12:45:45', '2026-01-03 12:47:43');
INSERT INTO `consultations` VALUES ('16', '6', NULL, 'Mohamed', 'S', 'mohamedhalith117@gmail.com', '+919080468168', 'vedhalai', 'furniture', '2026-02-04', '12:00:00', 'fwEH', '50k-100k', 'website', NULL, NULL, 'pending', '', NULL, NULL, NULL, '2026-01-03 13:13:12', '2026-01-03 13:13:36');
INSERT INTO `consultations` VALUES ('17', '6', NULL, 'Mohamed', 'halith', 'mohamedhalith117@gmail.com', '+919080468168', 'srdtvbnk', 'furniture', '2026-02-03', '12:00:00', 'aerstdyuiiop', '10k-50k', 'website', NULL, NULL, 'pending', '', NULL, NULL, NULL, '2026-01-03 13:23:40', '2026-01-03 13:24:00');
INSERT INTO `consultations` VALUES ('18', '6', NULL, 'Mohamed', 's', 'mohamedhalith117@gmail.com', '+919080468168', 'eBH', 'residential', '2026-01-31', '15:00:00', 'SDFNH', '200k-500k', 'friend', NULL, NULL, 'pending', '', NULL, NULL, NULL, '2026-01-03 13:27:16', '2026-01-03 13:27:27');

DROP TABLE IF EXISTS `contact_messages`;
CREATE TABLE `contact_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT 0,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `message` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_email` (`email`),
  KEY `idx_created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `coupons`;
CREATE TABLE `coupons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `discount_type` varchar(20) NOT NULL,
  `discount_value` decimal(10,2) NOT NULL,
  `min_purchase` decimal(10,2) DEFAULT NULL,
  `max_usage` int(11) DEFAULT NULL,
  `current_usage` int(11) DEFAULT 0,
  `is_active` tinyint(1) DEFAULT 1,
  `expires_at` datetime DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `coupons` VALUES ('1', 'WELCOME10', '10% off on first purchase', 'percentage', '10.00', '0.00', '100', '0', '1', '2026-01-17 18:57:20', '2025-12-18 18:57:20', '2025-12-18 18:57:20');

DROP TABLE IF EXISTS `email_queue`;
CREATE TABLE `email_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `consultation_id` int(11) DEFAULT NULL,
  `recipient_email` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `body` longtext NOT NULL,
  `email_type` varchar(50) DEFAULT NULL,
  `status` varchar(20) DEFAULT 'pending',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `sent_at` timestamp NULL DEFAULT NULL,
  `attempts` int(11) DEFAULT 0,
  `last_attempt` timestamp NULL DEFAULT NULL,
  `error_message` text DEFAULT NULL,
  `retry_count` int(11) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `email_queue` VALUES ('1', '5', 'mohamedhalith117@gmail.com', 'Consultation Request Received - Interior Design Solutions', '<html><head><style>body { font-family: Segoe UI, Arial, sans-serif; line-height: 1.6; color: #333; }.container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }.header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }.content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }.confirmation-badge { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #c3e6cb; text-align: center; font-weight: bold; }.details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }.detail-row { margin: 10px 0; }.label { font-weight: 600; color: #8b6f47; }.next-steps { background: #e7f3ff; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }</style></head><body><div class=\"container\"><div class=\"header\"><h1 style=\"margin: 0; font-size: 28px;\">Thank You!</h1></div><div class=\"content\"><p>Hello <strong>Mohamed</strong>,</p><p>We have received your consultation request and appreciate your interest in Interior Design Solutions.</p><div class=\"confirmation-badge\">Your request has been received</div><h3 style=\"color: #8b6f47;\">Your Consultation Details:</h3><div class=\"details\"><div class=\"detail-row\"><span class=\"label\">Consultation Type:</span> Residential</div><div class=\"detail-row\"><span class=\"label\">Preferred Date:</span> December 28, 2026</div><div class=\"detail-row\"><span class=\"label\">Preferred Time:</span> 14:00</div><div class=\"detail-row\"><span class=\"label\">Budget Range:</span> 50k-100k</div></div><div class=\"next-steps\"><h3 style=\"margin-top: 0; color: #0066cc;\">What happens next?</h3><ul><li>Our team will review your consultation request</li><li>We will contact you within 24 hours to confirm the appointment</li><li>We will discuss your project requirements in detail</li><li>You will receive a customized proposal</li></ul></div><p>If you have any questions before we contact you, please reply to this email.</p><p>Best regards,<br>Interior Design Solutions Team</p></div></div></body></html>', 'consultation_confirmation', 'failed', '2025-12-30 15:38:03', '2025-12-30 15:49:06', '1', NULL, NULL, '0');
INSERT INTO `email_queue` VALUES ('2', '4', 'mohamedhalith117@gmail.com', 'Your Consultation Request Has Been Approved - Interior Design Solutions', '<html><head><style>body { font-family: Segoe UI, Arial, sans-serif; line-height: 1.6; color: #333; }.container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }.header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }.content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }.approval-badge { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #c3e6cb; text-align: center; font-weight: bold; }.details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }.label { font-weight: 600; color: #8b6f47; }.next-steps { background: #e7f3ff; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }</style></head><body><div class=\"container\"><div class=\"header\"><h1 style=\"margin: 0; font-size: 28px;\">Consultation Approved!</h1></div><div class=\"content\"><p>Hello <strong>Mohamed S</strong>,</p><p>Great news! Your consultation request has been approved by our Interior Design Solutions team.</p><div class=\"approval-badge\">Your consultation has been approved</div><h3 style=\"color: #8b6f47;\">Your Consultation Details:</h3><div class=\"details\"><div>Consultation Type: Residential</div><div>Preferred Date: February 25, 2026</div><div>Budget Range: 200k-500k</div></div><div class=\"next-steps\"><h3 style=\"margin-top: 0; color: #0066cc;\">What happens next?</h3><ul><li>Our team will contact you within 24 hours</li><li>We will discuss your project requirements</li><li>You will receive a customized proposal</li></ul></div><p>If you have any questions, please contact us.</p><p>Best regards,<br>Interior Design Solutions Team</p></div></div></body></html>', 'approval', 'failed', '2025-12-30 15:40:54', '2025-12-30 15:49:04', '1', NULL, NULL, '0');
INSERT INTO `email_queue` VALUES ('3', '4', 'mohamedhalith117@gmail.com', 'Your Consultation Request Has Been Approved - Interior Design Solutions', '<html><head><style>body { font-family: Segoe UI, Arial, sans-serif; line-height: 1.6; color: #333; }.container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }.header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }.content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }.approval-badge { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #c3e6cb; text-align: center; font-weight: bold; }.details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }.label { font-weight: 600; color: #8b6f47; }.next-steps { background: #e7f3ff; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }</style></head><body><div class=\"container\"><div class=\"header\"><h1 style=\"margin: 0; font-size: 28px;\">Consultation Approved!</h1></div><div class=\"content\"><p>Hello <strong>Mohamed S</strong>,</p><p>Great news! Your consultation request has been approved by our Interior Design Solutions team.</p><div class=\"approval-badge\">Your consultation has been approved</div><h3 style=\"color: #8b6f47;\">Your Consultation Details:</h3><div class=\"details\"><div>Consultation Type: Residential</div><div>Preferred Date: February 25, 2026</div><div>Budget Range: 200k-500k</div></div><div class=\"next-steps\"><h3 style=\"margin-top: 0; color: #0066cc;\">What happens next?</h3><ul><li>Our team will contact you within 24 hours</li><li>We will discuss your project requirements</li><li>You will receive a customized proposal</li></ul></div><p>If you have any questions, please contact us.</p><p>Best regards,<br>Interior Design Solutions Team</p></div></div></body></html>', 'approval', 'failed', '2025-12-30 15:41:58', '2025-12-30 15:49:01', '1', NULL, NULL, '0');
INSERT INTO `email_queue` VALUES ('4', '5', 'mohamedhalith117@gmail.com', 'Your Consultation Request Has Been Approved - Interior Design Solutions', '<html><head><style>body { font-family: Segoe UI, Arial, sans-serif; line-height: 1.6; color: #333; }.container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }.header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }.content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }.approval-badge { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #c3e6cb; text-align: center; font-weight: bold; }.details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }.label { font-weight: 600; color: #8b6f47; }.next-steps { background: #e7f3ff; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }</style></head><body><div class=\"container\"><div class=\"header\"><h1 style=\"margin: 0; font-size: 28px;\">Consultation Approved!</h1></div><div class=\"content\"><p>Hello <strong>Mohamed S</strong>,</p><p>Great news! Your consultation request has been approved by our Interior Design Solutions team.</p><div class=\"approval-badge\">Your consultation has been approved</div><h3 style=\"color: #8b6f47;\">Your Consultation Details:</h3><div class=\"details\"><div>Consultation Type: Residential</div><div>Preferred Date: December 28, 2026</div><div>Budget Range: 50k-100k</div></div><div class=\"next-steps\"><h3 style=\"margin-top: 0; color: #0066cc;\">What happens next?</h3><ul><li>Our team will contact you within 24 hours</li><li>We will discuss your project requirements</li><li>You will receive a customized proposal</li></ul></div><p>If you have any questions, please contact us.</p><p>Best regards,<br>Interior Design Solutions Team</p></div></div></body></html>', 'approval', 'failed', '2025-12-30 15:42:09', '2025-12-30 15:48:57', '1', NULL, NULL, '0');
INSERT INTO `email_queue` VALUES ('5', '3', 'mohamedhalith117@gmail.com', 'Your Consultation Request Has Been Approved - Interior Design Solutions', '<html><head><style>body { font-family: Segoe UI, Arial, sans-serif; line-height: 1.6; color: #333; }.container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }.header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }.content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }.approval-badge { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #c3e6cb; text-align: center; font-weight: bold; }.details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }.label { font-weight: 600; color: #8b6f47; }.next-steps { background: #e7f3ff; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }</style></head><body><div class=\"container\"><div class=\"header\"><h1 style=\"margin: 0; font-size: 28px;\">Consultation Approved!</h1></div><div class=\"content\"><p>Hello <strong>Mohamed S</strong>,</p><p>Great news! Your consultation request has been approved by our Interior Design Solutions team.</p><div class=\"approval-badge\">Your consultation has been approved</div><h3 style=\"color: #8b6f47;\">Your Consultation Details:</h3><div class=\"details\"><div>Consultation Type: Renovation</div><div>Preferred Date: December 03, 2026</div><div>Budget Range: 50k-100k</div></div><div class=\"next-steps\"><h3 style=\"margin-top: 0; color: #0066cc;\">What happens next?</h3><ul><li>Our team will contact you within 24 hours</li><li>We will discuss your project requirements</li><li>You will receive a customized proposal</li></ul></div><p>If you have any questions, please contact us.</p><p>Best regards,<br>Interior Design Solutions Team</p></div></div></body></html>', 'approval', 'failed', '2025-12-30 15:45:55', '2025-12-30 15:49:53', '3', '2025-12-30 15:49:53', NULL, '0');
INSERT INTO `email_queue` VALUES ('6', '6', 'mohamedhalith117@gmail.com', 'Consultation Request Received - Interior Design Solutions', '<html><head><style>body { font-family: Segoe UI, Arial, sans-serif; line-height: 1.6; color: #333; }.container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }.header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }.content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }.confirmation-badge { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #c3e6cb; text-align: center; font-weight: bold; }.details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }.detail-row { margin: 10px 0; }.label { font-weight: 600; color: #8b6f47; }.next-steps { background: #e7f3ff; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }</style></head><body><div class=\"container\"><div class=\"header\"><h1 style=\"margin: 0; font-size: 28px;\">Thank You!</h1></div><div class=\"content\"><p>Hello <strong>Mohamed</strong>,</p><p>We have received your consultation request and appreciate your interest in Interior Design Solutions.</p><div class=\"confirmation-badge\">Your request has been received</div><h3 style=\"color: #8b6f47;\">Your Consultation Details:</h3><div class=\"details\"><div class=\"detail-row\"><span class=\"label\">Consultation Type:</span> Furniture</div><div class=\"detail-row\"><span class=\"label\">Preferred Date:</span> December 31, 2025</div><div class=\"detail-row\"><span class=\"label\">Preferred Time:</span> 13:00</div><div class=\"detail-row\"><span class=\"label\">Budget Range:</span> 100k-200k</div></div><div class=\"next-steps\"><h3 style=\"margin-top: 0; color: #0066cc;\">What happens next?</h3><ul><li>Our team will review your consultation request</li><li>We will contact you within 24 hours to confirm the appointment</li><li>We will discuss your project requirements in detail</li><li>You will receive a customized proposal</li></ul></div><p>If you have any questions before we contact you, please reply to this email.</p><p>Best regards,<br>Interior Design Solutions Team</p></div></div></body></html>', 'consultation_confirmation', 'failed', '2025-12-30 15:56:18', '2026-01-03 13:00:52', '1', NULL, NULL, '6');
INSERT INTO `email_queue` VALUES ('7', '6', 'mohamedhalith117@gmail.com', 'Your Consultation Request Has Been Approved - Interior Design Solutions', '<html><head><style>body { font-family: Segoe UI, Arial, sans-serif; line-height: 1.6; color: #333; }.container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }.header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }.content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }.approval-badge { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #c3e6cb; text-align: center; font-weight: bold; }.details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }.label { font-weight: 600; color: #8b6f47; }.next-steps { background: #e7f3ff; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }</style></head><body><div class=\"container\"><div class=\"header\"><h1 style=\"margin: 0; font-size: 28px;\">Consultation Approved!</h1></div><div class=\"content\"><p>Hello <strong>Mohamed S</strong>,</p><p>Great news! Your consultation request has been approved by our Interior Design Solutions team.</p><div class=\"approval-badge\">Your consultation has been approved</div><h3 style=\"color: #8b6f47;\">Your Consultation Details:</h3><div class=\"details\"><div>Consultation Type: Furniture</div><div>Preferred Date: December 31, 2025</div><div>Budget Range: 100k-200k</div></div><div class=\"next-steps\"><h3 style=\"margin-top: 0; color: #0066cc;\">What happens next?</h3><ul><li>Our team will contact you within 24 hours</li><li>We will discuss your project requirements</li><li>You will receive a customized proposal</li></ul></div><p>If you have any questions, please contact us.</p><p>Best regards,<br>Interior Design Solutions Team</p></div></div></body></html>', 'approval', 'failed', '2025-12-30 15:56:40', '2026-01-03 13:00:55', '1', NULL, NULL, '6');
INSERT INTO `email_queue` VALUES ('8', '7', 'mohamedhalith117@gmail.com', 'Consultation Request Received - Interior Design Solutions', '<html><head><style>body { font-family: Segoe UI, Arial, sans-serif; line-height: 1.6; color: #333; }.container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }.header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }.content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }.confirmation-badge { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #c3e6cb; text-align: center; font-weight: bold; }.details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }.detail-row { margin: 10px 0; }.label { font-weight: 600; color: #8b6f47; }.next-steps { background: #e7f3ff; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }</style></head><body><div class=\"container\"><div class=\"header\"><h1 style=\"margin: 0; font-size: 28px;\">Thank You!</h1></div><div class=\"content\"><p>Hello <strong>Mohamed</strong>,</p><p>We have received your consultation request and appreciate your interest in Interior Design Solutions.</p><div class=\"confirmation-badge\">Your request has been received</div><h3 style=\"color: #8b6f47;\">Your Consultation Details:</h3><div class=\"details\"><div class=\"detail-row\"><span class=\"label\">Consultation Type:</span> Residential</div><div class=\"detail-row\"><span class=\"label\">Preferred Date:</span> December 31, 2025</div><div class=\"detail-row\"><span class=\"label\">Preferred Time:</span> 12:00</div><div class=\"detail-row\"><span class=\"label\">Budget Range:</span> 100k-200k</div></div><div class=\"next-steps\"><h3 style=\"margin-top: 0; color: #0066cc;\">What happens next?</h3><ul><li>Our team will review your consultation request</li><li>We will contact you within 24 hours to confirm the appointment</li><li>We will discuss your project requirements in detail</li><li>You will receive a customized proposal</li></ul></div><p>If you have any questions before we contact you, please reply to this email.</p><p>Best regards,<br>Interior Design Solutions Team</p></div></div></body></html>', 'consultation_confirmation', 'failed', '2025-12-30 16:11:18', '2026-01-03 13:00:57', '1', NULL, NULL, '6');
INSERT INTO `email_queue` VALUES ('9', '7', 'mohamedhalith117@gmail.com', 'Consultation Request Status Update - Interior Design Solutions', '\r\n    <html>\r\n    <head>\r\n        <style>\r\n            body { font-family: \'Segoe UI\', Arial, sans-serif; line-height: 1.6; color: #333; }\r\n            .container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }\r\n            .header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }\r\n            .content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }\r\n            .decline-badge { background: #fee2e2; color: #991b1b; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #fecaca; text-align: center; font-weight: bold; font-size: 18px; }\r\n            .details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }\r\n            .detail-row { margin: 10px 0; }\r\n            .label { font-weight: 600; color: #8b6f47; }\r\n            .next-steps { background: #fef3c7; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }\r\n            .footer { text-align: center; padding: 20px; color: #999; font-size: 12px; border-top: 1px solid #e0e0e0; margin-top: 20px; }\r\n        </style>\r\n    </head>\r\n    <body>\r\n        <div class=\"container\">\r\n            <div class=\"header\">\r\n                <h1 style=\"margin: 0; font-size: 28px;\">Consultation Request Update</h1>\r\n            </div>\r\n            \r\n            <div class=\"content\">\r\n                <p>Hello <strong>Mohamed s</strong>,</p>\r\n                \r\n                <p>Thank you for submitting your consultation request with Interior Design Solutions.</p>\r\n                \r\n                <div class=\"decline-badge\">\r\n                    Status: Request Not Approved at This Time\r\n                </div>\r\n                \r\n                <h3 style=\"color: #8b6f47; margin-top: 30px;\">Your Consultation Details:</h3>\r\n                <div class=\"details\">\r\n                    <div class=\"detail-row\">\r\n                        <span class=\"label\">Consultation Type:</span> Residential\r\n                    </div>\r\n                    <div class=\"detail-row\">\r\n                        <span class=\"label\">Preferred Date:</span> December 31, 2025\r\n                    </div>\r\n                </div>\r\n                \r\n                <div class=\"next-steps\">\r\n                    <h3 style=\"margin-top: 0; color: #8b6f47;\">What you can do:</h3>\r\n                    <ul style=\"margin: 10px 0; padding-left: 20px;\">\r\n                        <li>Feel free to reach out to us directly if you have questions</li>\r\n                        <li>You can submit a new consultation request in the future</li>\r\n                        <li>Contact us to discuss alternative options</li>\r\n                        <li>Visit our website to explore our services and portfolio</li>\r\n                    </ul>\r\n                </div>\r\n                \r\n                <p>We appreciate your interest in our services and hope to work with you in the future. If you have any questions, please don\'t hesitate to contact us.</p>\r\n                \r\n                <p>\r\n                    Best regards,<br>\r\n                    <strong>Interior Design Solutions Team</strong><br>\r\n                    <em>Creating spaces you\'ll love</em>\r\n                </p>\r\n                \r\n                <div class=\"footer\">\r\n                    <p>This is an automated email. Please do not reply directly to this message.</p>\r\n                    <p>&copy; 2025 Interior Design Solutions. All rights reserved.</p>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </body>\r\n    </html>\r\n    ', 'decline', 'failed', '2025-12-30 16:12:24', '2026-01-03 13:00:59', '1', NULL, NULL, '6');
INSERT INTO `email_queue` VALUES ('10', '7', 'mohamedhalith117@gmail.com', 'Consultation Request Status Update - Interior Design Solutions', '\r\n    <html>\r\n    <head>\r\n        <style>\r\n            body { font-family: \'Segoe UI\', Arial, sans-serif; line-height: 1.6; color: #333; }\r\n            .container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }\r\n            .header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }\r\n            .content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }\r\n            .decline-badge { background: #fee2e2; color: #991b1b; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #fecaca; text-align: center; font-weight: bold; font-size: 18px; }\r\n            .details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }\r\n            .detail-row { margin: 10px 0; }\r\n            .label { font-weight: 600; color: #8b6f47; }\r\n            .next-steps { background: #fef3c7; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }\r\n            .footer { text-align: center; padding: 20px; color: #999; font-size: 12px; border-top: 1px solid #e0e0e0; margin-top: 20px; }\r\n        </style>\r\n    </head>\r\n    <body>\r\n        <div class=\"container\">\r\n            <div class=\"header\">\r\n                <h1 style=\"margin: 0; font-size: 28px;\">Consultation Request Update</h1>\r\n            </div>\r\n            \r\n            <div class=\"content\">\r\n                <p>Hello <strong>Mohamed s</strong>,</p>\r\n                \r\n                <p>Thank you for submitting your consultation request with Interior Design Solutions.</p>\r\n                \r\n                <div class=\"decline-badge\">\r\n                    Status: Request Not Approved at This Time\r\n                </div>\r\n                \r\n                <h3 style=\"color: #8b6f47; margin-top: 30px;\">Your Consultation Details:</h3>\r\n                <div class=\"details\">\r\n                    <div class=\"detail-row\">\r\n                        <span class=\"label\">Consultation Type:</span> Residential\r\n                    </div>\r\n                    <div class=\"detail-row\">\r\n                        <span class=\"label\">Preferred Date:</span> December 31, 2025\r\n                    </div>\r\n                </div>\r\n                \r\n                <div class=\"next-steps\">\r\n                    <h3 style=\"margin-top: 0; color: #8b6f47;\">What you can do:</h3>\r\n                    <ul style=\"margin: 10px 0; padding-left: 20px;\">\r\n                        <li>Feel free to reach out to us directly if you have questions</li>\r\n                        <li>You can submit a new consultation request in the future</li>\r\n                        <li>Contact us to discuss alternative options</li>\r\n                        <li>Visit our website to explore our services and portfolio</li>\r\n                    </ul>\r\n                </div>\r\n                \r\n                <p>We appreciate your interest in our services and hope to work with you in the future. If you have any questions, please don\'t hesitate to contact us.</p>\r\n                \r\n                <p>\r\n                    Best regards,<br>\r\n                    <strong>Interior Design Solutions Team</strong><br>\r\n                    <em>Creating spaces you\'ll love</em>\r\n                </p>\r\n                \r\n                <div class=\"footer\">\r\n                    <p>This is an automated email. Please do not reply directly to this message.</p>\r\n                    <p>&copy; 2025 Interior Design Solutions. All rights reserved.</p>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </body>\r\n    </html>\r\n    ', 'decline', 'failed', '2025-12-30 16:12:25', '2026-01-03 13:01:01', '1', NULL, NULL, '6');
INSERT INTO `email_queue` VALUES ('11', '8', 'mohamedhalith117@gmail.com', 'Consultation Request Received - Interior Design Solutions', '<html><head><style>body { font-family: Segoe UI, Arial, sans-serif; line-height: 1.6; color: #333; }.container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }.header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }.content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }.confirmation-badge { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #c3e6cb; text-align: center; font-weight: bold; }.details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }.detail-row { margin: 10px 0; }.label { font-weight: 600; color: #8b6f47; }.next-steps { background: #e7f3ff; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }</style></head><body><div class=\"container\"><div class=\"header\"><h1 style=\"margin: 0; font-size: 28px;\">Thank You!</h1></div><div class=\"content\"><p>Hello <strong>Mohamed</strong>,</p><p>We have received your consultation request and appreciate your interest in Interior Design Solutions.</p><div class=\"confirmation-badge\">Your request has been received</div><h3 style=\"color: #8b6f47;\">Your Consultation Details:</h3><div class=\"details\"><div class=\"detail-row\"><span class=\"label\">Consultation Type:</span> Residential</div><div class=\"detail-row\"><span class=\"label\">Preferred Date:</span> December 31, 2025</div><div class=\"detail-row\"><span class=\"label\">Preferred Time:</span> 13:00</div><div class=\"detail-row\"><span class=\"label\">Budget Range:</span> 100k-200k</div></div><div class=\"next-steps\"><h3 style=\"margin-top: 0; color: #0066cc;\">What happens next?</h3><ul><li>Our team will review your consultation request</li><li>We will contact you within 24 hours to confirm the appointment</li><li>We will discuss your project requirements in detail</li><li>You will receive a customized proposal</li></ul></div><p>If you have any questions before we contact you, please reply to this email.</p><p>Best regards,<br>Interior Design Solutions Team</p></div></div></body></html>', 'consultation_confirmation', 'failed', '2025-12-30 16:28:43', '2026-01-03 13:01:03', '1', NULL, NULL, '1');
INSERT INTO `email_queue` VALUES ('12', '8', 'mohamedhalith117@gmail.com', 'Your Consultation Request Has Been Approved - Interior Design Solutions', '<html><head><style>body { font-family: Segoe UI, Arial, sans-serif; line-height: 1.6; color: #333; }.container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }.header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }.content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }.approval-badge { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #c3e6cb; text-align: center; font-weight: bold; }.details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }.label { font-weight: 600; color: #8b6f47; }.next-steps { background: #e7f3ff; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }</style></head><body><div class=\"container\"><div class=\"header\"><h1 style=\"margin: 0; font-size: 28px;\">Consultation Approved!</h1></div><div class=\"content\"><p>Hello <strong>Mohamed S</strong>,</p><p>Great news! Your consultation request has been approved by our Interior Design Solutions team.</p><div class=\"approval-badge\">Your consultation has been approved</div><h3 style=\"color: #8b6f47;\">Your Consultation Details:</h3><div class=\"details\"><div>Consultation Type: Residential</div><div>Preferred Date: December 31, 2025</div><div>Budget Range: 100k-200k</div></div><div class=\"next-steps\"><h3 style=\"margin-top: 0; color: #0066cc;\">What happens next?</h3><ul><li>Our team will contact you within 24 hours</li><li>We will discuss your project requirements</li><li>You will receive a customized proposal</li></ul></div><p>If you have any questions, please contact us.</p><p>Best regards,<br>Interior Design Solutions Team</p></div></div></body></html>', 'approval', 'failed', '2025-12-30 16:29:19', '2026-01-03 13:01:05', '1', NULL, NULL, '1');
INSERT INTO `email_queue` VALUES ('13', '9', 'mohamedhalith117@gmail.com', 'Your Consultation Request Has Been Approved - Interior Design Solutions', '<html><head><style>body { font-family: Segoe UI, Arial, sans-serif; line-height: 1.6; color: #333; }.container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }.header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }.content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }.approval-badge { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #c3e6cb; text-align: center; font-weight: bold; }.details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }.label { font-weight: 600; color: #8b6f47; }.next-steps { background: #e7f3ff; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }</style></head><body><div class=\"container\"><div class=\"header\"><h1 style=\"margin: 0; font-size: 28px;\">Consultation Approved!</h1></div><div class=\"content\"><p>Hello <strong>Mohamed S</strong>,</p><p>Great news! Your consultation request has been approved by our Interior Design Solutions team.</p><div class=\"approval-badge\">Your consultation has been approved</div><h3 style=\"color: #8b6f47;\">Your Consultation Details:</h3><div class=\"details\"><div>Consultation Type: Renovation</div><div>Preferred Date: January 12, 2026</div><div>Budget Range: 100k-200k</div></div><div class=\"next-steps\"><h3 style=\"margin-top: 0; color: #0066cc;\">What happens next?</h3><ul><li>Our team will contact you within 24 hours</li><li>We will discuss your project requirements</li><li>You will receive a customized proposal</li></ul></div><p>If you have any questions, please contact us.</p><p>Best regards,<br>Interior Design Solutions Team</p></div></div></body></html>', 'approval', 'failed', '2026-01-03 11:26:46', '2026-01-03 13:01:07', '1', NULL, NULL, '1');
INSERT INTO `email_queue` VALUES ('14', '10', 'mohamedhalith117@gmail.com', 'Your Consultation Request Has Been Approved - Interior Design Solutions', '<html><head><style>body { font-family: Segoe UI, Arial, sans-serif; line-height: 1.6; color: #333; }.container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }.header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }.content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }.approval-badge { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #c3e6cb; text-align: center; font-weight: bold; }.details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }.label { font-weight: 600; color: #8b6f47; }.next-steps { background: #e7f3ff; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }</style></head><body><div class=\"container\"><div class=\"header\"><h1 style=\"margin: 0; font-size: 28px;\">Consultation Approved!</h1></div><div class=\"content\"><p>Hello <strong>Mohamed S</strong>,</p><p>Great news! Your consultation request has been approved by our Interior Design Solutions team.</p><div class=\"approval-badge\">Your consultation has been approved</div><h3 style=\"color: #8b6f47;\">Your Consultation Details:</h3><div class=\"details\"><div>Consultation Type: Colors</div><div>Preferred Date: January 30, 2026</div><div>Budget Range: 200k-500k</div></div><div class=\"next-steps\"><h3 style=\"margin-top: 0; color: #0066cc;\">What happens next?</h3><ul><li>Our team will contact you within 24 hours</li><li>We will discuss your project requirements</li><li>You will receive a customized proposal</li></ul></div><p>If you have any questions, please contact us.</p><p>Best regards,<br>Interior Design Solutions Team</p></div></div></body></html>', 'approval', 'failed', '2026-01-03 11:50:18', '2026-01-03 13:10:15', '2', NULL, NULL, '1');
INSERT INTO `email_queue` VALUES ('15', '11', 'mohamedhalith117@gmail.com', 'Your Consultation Request Has Been Approved - Interior Design Solutions', '<html><head><style>body { font-family: Segoe UI, Arial, sans-serif; line-height: 1.6; color: #333; }.container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }.header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }.content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }.approval-badge { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #c3e6cb; text-align: center; font-weight: bold; }.details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }.label { font-weight: 600; color: #8b6f47; }.next-steps { background: #e7f3ff; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }</style></head><body><div class=\"container\"><div class=\"header\"><h1 style=\"margin: 0; font-size: 28px;\">Consultation Approved!</h1></div><div class=\"content\"><p>Hello <strong>Mohamed S</strong>,</p><p>Great news! Your consultation request has been approved by our Interior Design Solutions team.</p><div class=\"approval-badge\">Your consultation has been approved</div><h3 style=\"color: #8b6f47;\">Your Consultation Details:</h3><div class=\"details\"><div>Consultation Type: Renovation</div><div>Preferred Date: January 29, 2026</div><div>Budget Range: 100k-200k</div></div><div class=\"next-steps\"><h3 style=\"margin-top: 0; color: #0066cc;\">What happens next?</h3><ul><li>Our team will contact you within 24 hours</li><li>We will discuss your project requirements</li><li>You will receive a customized proposal</li></ul></div><p>If you have any questions, please contact us.</p><p>Best regards,<br>Interior Design Solutions Team</p></div></div></body></html>', 'approval', 'failed', '2026-01-03 11:55:08', '2026-01-03 13:01:11', '1', NULL, NULL, '1');
INSERT INTO `email_queue` VALUES ('16', '12', 'mohamedhalith117@gmail.com', 'Your Consultation Request Has Been Approved - Interior Design Solutions', '<html><head><style>body { font-family: Segoe UI, Arial, sans-serif; line-height: 1.6; color: #333; }.container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }.header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }.content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }.approval-badge { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #c3e6cb; text-align: center; font-weight: bold; }.details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }.label { font-weight: 600; color: #8b6f47; }.next-steps { background: #e7f3ff; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }</style></head><body><div class=\"container\"><div class=\"header\"><h1 style=\"margin: 0; font-size: 28px;\">Consultation Approved!</h1></div><div class=\"content\"><p>Hello <strong>Mohamed Halith S</strong>,</p><p>Great news! Your consultation request has been approved by our Interior Design Solutions team.</p><div class=\"approval-badge\">Your consultation has been approved</div><h3 style=\"color: #8b6f47;\">Your Consultation Details:</h3><div class=\"details\"><div>Consultation Type: Commercial</div><div>Preferred Date: January 15, 2026</div><div>Budget Range: 500k+</div></div><div class=\"next-steps\"><h3 style=\"margin-top: 0; color: #0066cc;\">What happens next?</h3><ul><li>Our team will contact you within 24 hours</li><li>We will discuss your project requirements</li><li>You will receive a customized proposal</li></ul></div><p>If you have any questions, please contact us.</p><p>Best regards,<br>Interior Design Solutions Team</p></div></div></body></html>', 'approval', 'failed', '2026-01-03 12:14:02', '2026-01-03 13:01:14', '1', NULL, NULL, '0');
INSERT INTO `email_queue` VALUES ('17', '0', 'test@example.com', 'Test Queue Subject', 'Test Queue Message', 'test', 'failed', '2026-01-03 12:15:18', '2026-01-03 13:01:16', '1', NULL, NULL, '0');
INSERT INTO `email_queue` VALUES ('18', '0', 'test@example.com', 'Test Queue Subject', 'Test Queue Message', 'test', 'failed', '2026-01-03 12:17:07', '2026-01-03 13:01:18', '1', NULL, NULL, '0');
INSERT INTO `email_queue` VALUES ('19', '0', 'test@example.com', 'Test Queue Subject', 'Test Queue Message', 'test', 'failed', '2026-01-03 12:17:39', '2026-01-03 13:01:20', '1', NULL, NULL, '0');
INSERT INTO `email_queue` VALUES ('20', '0', 'test@example.com', 'Test Queue Subject', 'Test Queue Message', 'test', 'failed', '2026-01-03 12:17:45', '2026-01-03 13:22:03', '3', NULL, NULL, '0');
INSERT INTO `email_queue` VALUES ('21', '0', 'test@example.com', 'Test Queue Subject', 'Test Queue Message', 'test', 'failed', '2026-01-03 12:18:07', '2026-01-03 13:01:24', '1', NULL, NULL, '0');
INSERT INTO `email_queue` VALUES ('22', '0', 'test@example.com', 'Test Queue Subject', 'Test Queue Message', 'test', 'failed', '2026-01-03 12:18:29', '2026-01-03 13:01:31', '2', NULL, NULL, '0');
INSERT INTO `email_queue` VALUES ('23', '13', 'mohamedhalith117@gmail.com', 'Your Consultation Request Has Been Approved - Interior Design Solutions', '<html><head><style>body { font-family: Segoe UI, Arial, sans-serif; line-height: 1.6; color: #333; }.container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }.header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }.content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }.approval-badge { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #c3e6cb; text-align: center; font-weight: bold; }.details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }.label { font-weight: 600; color: #8b6f47; }.next-steps { background: #e7f3ff; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }</style></head><body><div class=\"container\"><div class=\"header\"><h1 style=\"margin: 0; font-size: 28px;\">Consultation Approved!</h1></div><div class=\"content\"><p>Hello <strong>Mohamed halith</strong>,</p><p>Great news! Your consultation request has been approved by our Interior Design Solutions team.</p><div class=\"approval-badge\">Your consultation has been approved</div><h3 style=\"color: #8b6f47;\">Your Consultation Details:</h3><div class=\"details\"><div>Consultation Type: Commercial</div><div>Preferred Date: February 04, 2026</div><div>Budget Range: 200k-500k</div></div><div class=\"next-steps\"><h3 style=\"margin-top: 0; color: #0066cc;\">What happens next?</h3><ul><li>Our team will contact you within 24 hours</li><li>We will discuss your project requirements</li><li>You will receive a customized proposal</li></ul></div><p>If you have any questions, please contact us.</p><p>Best regards,<br>Interior Design Solutions Team</p></div></div></body></html>', 'approval', 'failed', '2026-01-03 12:20:03', '2026-01-03 13:01:29', '1', NULL, NULL, '0');
INSERT INTO `email_queue` VALUES ('24', '14', 'mohamedhalith117@gmail.com', 'Your Consultation Request Has Been Approved - Interior Design Solutions', '<html><head><style>body { font-family: Segoe UI, Arial, sans-serif; line-height: 1.6; color: #333; }.container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }.header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }.content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }.approval-badge { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #c3e6cb; text-align: center; font-weight: bold; }.details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }.label { font-weight: 600; color: #8b6f47; }.next-steps { background: #e7f3ff; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }</style></head><body><div class=\"container\"><div class=\"header\"><h1 style=\"margin: 0; font-size: 28px;\">Consultation Approved!</h1></div><div class=\"content\"><p>Hello <strong>Mohamed S</strong>,</p><p>Great news! Your consultation request has been approved by our Interior Design Solutions team.</p><div class=\"approval-badge\">Your consultation has been approved</div><h3 style=\"color: #8b6f47;\">Your Consultation Details:</h3><div class=\"details\"><div>Consultation Type: Renovation</div><div>Preferred Date: January 23, 2026</div><div>Budget Range: 200k-500k</div></div><div class=\"next-steps\"><h3 style=\"margin-top: 0; color: #0066cc;\">What happens next?</h3><ul><li>Our team will contact you within 24 hours</li><li>We will discuss your project requirements</li><li>You will receive a customized proposal</li></ul></div><p>If you have any questions, please contact us.</p><p>Best regards,<br>Interior Design Solutions Team</p></div></div></body></html>', 'approval', 'failed', '2026-01-03 12:23:43', '2026-01-03 13:00:48', '1', NULL, NULL, '0');
INSERT INTO `email_queue` VALUES ('25', '15', 'mohamedhalith117@gmail.com', 'Your Consultation Request Has Been Approved - Interior Design Solutions', '<html><head><style>body { font-family: Segoe UI, Arial, sans-serif; line-height: 1.6; color: #333; }.container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }.header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }.content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }.approval-badge { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #c3e6cb; text-align: center; font-weight: bold; }.details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }.label { font-weight: 600; color: #8b6f47; }.next-steps { background: #e7f3ff; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }</style></head><body><div class=\"container\"><div class=\"header\"><h1 style=\"margin: 0; font-size: 28px;\">Consultation Approved!</h1></div><div class=\"content\"><p>Hello <strong>Mohamed halith</strong>,</p><p>Great news! Your consultation request has been approved by our Interior Design Solutions team.</p><div class=\"approval-badge\">Your consultation has been approved</div><h3 style=\"color: #8b6f47;\">Your Consultation Details:</h3><div class=\"details\"><div>Consultation Type: Renovation</div><div>Preferred Date: January 23, 2026</div><div>Budget Range: 500k+</div></div><div class=\"next-steps\"><h3 style=\"margin-top: 0; color: #0066cc;\">What happens next?</h3><ul><li>Our team will contact you within 24 hours</li><li>We will discuss your project requirements</li><li>You will receive a customized proposal</li></ul></div><p>If you have any questions, please contact us.</p><p>Best regards,<br>Interior Design Solutions Team</p></div></div></body></html>', 'approval', 'failed', '2026-01-03 12:47:45', '2026-01-03 13:14:10', '6', NULL, NULL, '0');
INSERT INTO `email_queue` VALUES ('26', '16', 'mohamedhalith117@gmail.com', 'Your Consultation Request Has Been Approved - Interior Design Solutions', '<html><head><style>body { font-family: Segoe UI, Arial, sans-serif; line-height: 1.6; color: #333; }.container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }.header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }.content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }.approval-badge { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #c3e6cb; text-align: center; font-weight: bold; }.details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }.label { font-weight: 600; color: #8b6f47; }.next-steps { background: #e7f3ff; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }</style></head><body><div class=\"container\"><div class=\"header\"><h1 style=\"margin: 0; font-size: 28px;\">Consultation Approved!</h1></div><div class=\"content\"><p>Hello <strong>Mohamed S</strong>,</p><p>Great news! Your consultation request has been approved by our Interior Design Solutions team.</p><div class=\"approval-badge\">Your consultation has been approved</div><h3 style=\"color: #8b6f47;\">Your Consultation Details:</h3><div class=\"details\"><div>Consultation Type: Furniture</div><div>Preferred Date: February 04, 2026</div><div>Budget Range: 50k-100k</div></div><div class=\"next-steps\"><h3 style=\"margin-top: 0; color: #0066cc;\">What happens next?</h3><ul><li>Our team will contact you within 24 hours</li><li>We will discuss your project requirements</li><li>You will receive a customized proposal</li></ul></div><p>If you have any questions, please contact us.</p><p>Best regards,<br>Interior Design Solutions Team</p></div></div></body></html>', 'approval', 'failed', '2026-01-03 13:13:38', '2026-01-03 13:24:55', '3', NULL, NULL, '0');
INSERT INTO `email_queue` VALUES ('27', '17', 'mohamedhalith117@gmail.com', 'Your Consultation Request Has Been Approved - Interior Design Solutions', '<html><head><style>body { font-family: Segoe UI, Arial, sans-serif; line-height: 1.6; color: #333; }.container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }.header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }.content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }.approval-badge { background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #c3e6cb; text-align: center; font-weight: bold; }.details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }.label { font-weight: 600; color: #8b6f47; }.next-steps { background: #e7f3ff; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }</style></head><body><div class=\"container\"><div class=\"header\"><h1 style=\"margin: 0; font-size: 28px;\">Consultation Approved!</h1></div><div class=\"content\"><p>Hello <strong>Mohamed halith</strong>,</p><p>Great news! Your consultation request has been approved by our Interior Design Solutions team.</p><div class=\"approval-badge\">Your consultation has been approved</div><h3 style=\"color: #8b6f47;\">Your Consultation Details:</h3><div class=\"details\"><div>Consultation Type: Furniture</div><div>Preferred Date: February 03, 2026</div><div>Budget Range: 10k-50k</div></div><div class=\"next-steps\"><h3 style=\"margin-top: 0; color: #0066cc;\">What happens next?</h3><ul><li>Our team will contact you within 24 hours</li><li>We will discuss your project requirements</li><li>You will receive a customized proposal</li></ul></div><p>If you have any questions, please contact us.</p><p>Best regards,<br>Interior Design Solutions Team</p></div></div></body></html>', 'approval', 'failed', '2026-01-03 13:24:02', '2026-01-03 13:25:01', '1', NULL, NULL, '0');
INSERT INTO `email_queue` VALUES ('28', '18', 'mohamedhalith117@gmail.com', 'Consultation Request Status Update - Interior Design Solutions', '\r\n    <html>\r\n    <head>\r\n        <style>\r\n            body { font-family: \'Segoe UI\', Arial, sans-serif; line-height: 1.6; color: #333; }\r\n            .container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }\r\n            .header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }\r\n            .content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }\r\n            .decline-badge { background: #fee2e2; color: #991b1b; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #fecaca; text-align: center; font-weight: bold; font-size: 18px; }\r\n            .details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }\r\n            .detail-row { margin: 10px 0; }\r\n            .label { font-weight: 600; color: #8b6f47; }\r\n            .next-steps { background: #fef3c7; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }\r\n            .footer { text-align: center; padding: 20px; color: #999; font-size: 12px; border-top: 1px solid #e0e0e0; margin-top: 20px; }\r\n        </style>\r\n    </head>\r\n    <body>\r\n        <div class=\"container\">\r\n            <div class=\"header\">\r\n                <h1 style=\"margin: 0; font-size: 28px;\">Consultation Request Update</h1>\r\n            </div>\r\n            \r\n            <div class=\"content\">\r\n                <p>Hello <strong>Mohamed s</strong>,</p>\r\n                \r\n                <p>Thank you for submitting your consultation request with Interior Design Solutions.</p>\r\n                \r\n                <div class=\"decline-badge\">\r\n                    Status: Request Not Approved at This Time\r\n                </div>\r\n                \r\n                <h3 style=\"color: #8b6f47; margin-top: 30px;\">Your Consultation Details:</h3>\r\n                <div class=\"details\">\r\n                    <div class=\"detail-row\">\r\n                        <span class=\"label\">Consultation Type:</span> Residential\r\n                    </div>\r\n                    <div class=\"detail-row\">\r\n                        <span class=\"label\">Preferred Date:</span> January 31, 2026\r\n                    </div>\r\n                </div>\r\n                \r\n                <div class=\"next-steps\">\r\n                    <h3 style=\"margin-top: 0; color: #8b6f47;\">What you can do:</h3>\r\n                    <ul style=\"margin: 10px 0; padding-left: 20px;\">\r\n                        <li>Feel free to reach out to us directly if you have questions</li>\r\n                        <li>You can submit a new consultation request in the future</li>\r\n                        <li>Contact us to discuss alternative options</li>\r\n                        <li>Visit our website to explore our services and portfolio</li>\r\n                    </ul>\r\n                </div>\r\n                \r\n                <p>We appreciate your interest in our services and hope to work with you in the future. If you have any questions, please don\'t hesitate to contact us.</p>\r\n                \r\n                <p>\r\n                    Best regards,<br>\r\n                    <strong>Interior Design Solutions Team</strong><br>\r\n                    <em>Creating spaces you\'ll love</em>\r\n                </p>\r\n                \r\n                <div class=\"footer\">\r\n                    <p>This is an automated email. Please do not reply directly to this message.</p>\r\n                    <p>&copy; 2025 Interior Design Solutions. All rights reserved.</p>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </body>\r\n    </html>\r\n    ', 'decline', 'pending', '2026-01-03 13:27:29', NULL, '0', NULL, NULL, '0');
INSERT INTO `email_queue` VALUES ('29', '18', 'mohamedhalith117@gmail.com', 'Consultation Request Status Update - Interior Design Solutions', '\r\n    <html>\r\n    <head>\r\n        <style>\r\n            body { font-family: \'Segoe UI\', Arial, sans-serif; line-height: 1.6; color: #333; }\r\n            .container { max-width: 600px; margin: 0 auto; padding: 20px; background: #f9f7f4; }\r\n            .header { background: linear-gradient(135deg, #8b6f47 0%, #6b5738 100%); color: white; padding: 30px; border-radius: 10px 10px 0 0; text-align: center; }\r\n            .content { background: white; padding: 30px; border-radius: 0 0 10px 10px; }\r\n            .decline-badge { background: #fee2e2; color: #991b1b; padding: 15px; border-radius: 8px; margin: 20px 0; border: 1px solid #fecaca; text-align: center; font-weight: bold; font-size: 18px; }\r\n            .details { background: #f9f7f4; padding: 20px; border-radius: 8px; margin: 20px 0; }\r\n            .detail-row { margin: 10px 0; }\r\n            .label { font-weight: 600; color: #8b6f47; }\r\n            .next-steps { background: #fef3c7; padding: 20px; border-radius: 8px; border-left: 4px solid #d4a574; }\r\n            .footer { text-align: center; padding: 20px; color: #999; font-size: 12px; border-top: 1px solid #e0e0e0; margin-top: 20px; }\r\n        </style>\r\n    </head>\r\n    <body>\r\n        <div class=\"container\">\r\n            <div class=\"header\">\r\n                <h1 style=\"margin: 0; font-size: 28px;\">Consultation Request Update</h1>\r\n            </div>\r\n            \r\n            <div class=\"content\">\r\n                <p>Hello <strong>Mohamed s</strong>,</p>\r\n                \r\n                <p>Thank you for submitting your consultation request with Interior Design Solutions.</p>\r\n                \r\n                <div class=\"decline-badge\">\r\n                    Status: Request Not Approved at This Time\r\n                </div>\r\n                \r\n                <h3 style=\"color: #8b6f47; margin-top: 30px;\">Your Consultation Details:</h3>\r\n                <div class=\"details\">\r\n                    <div class=\"detail-row\">\r\n                        <span class=\"label\">Consultation Type:</span> Residential\r\n                    </div>\r\n                    <div class=\"detail-row\">\r\n                        <span class=\"label\">Preferred Date:</span> January 31, 2026\r\n                    </div>\r\n                </div>\r\n                \r\n                <div class=\"next-steps\">\r\n                    <h3 style=\"margin-top: 0; color: #8b6f47;\">What you can do:</h3>\r\n                    <ul style=\"margin: 10px 0; padding-left: 20px;\">\r\n                        <li>Feel free to reach out to us directly if you have questions</li>\r\n                        <li>You can submit a new consultation request in the future</li>\r\n                        <li>Contact us to discuss alternative options</li>\r\n                        <li>Visit our website to explore our services and portfolio</li>\r\n                    </ul>\r\n                </div>\r\n                \r\n                <p>We appreciate your interest in our services and hope to work with you in the future. If you have any questions, please don\'t hesitate to contact us.</p>\r\n                \r\n                <p>\r\n                    Best regards,<br>\r\n                    <strong>Interior Design Solutions Team</strong><br>\r\n                    <em>Creating spaces you\'ll love</em>\r\n                </p>\r\n                \r\n                <div class=\"footer\">\r\n                    <p>This is an automated email. Please do not reply directly to this message.</p>\r\n                    <p>&copy; 2025 Interior Design Solutions. All rights reserved.</p>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </body>\r\n    </html>\r\n    ', 'decline', 'pending', '2026-01-03 13:27:29', NULL, '0', NULL, NULL, '0');

DROP TABLE IF EXISTS `favorites`;
CREATE TABLE `favorites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_name` varchar(255) NOT NULL,
  `product_price` decimal(10,2) NOT NULL,
  `product_image` varchar(255) DEFAULT NULL,
  `added_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_user_product` (`user_id`,`product_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_product_id` (`product_id`),
  CONSTRAINT `favorites_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `gallery`;
CREATE TABLE `gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `category` varchar(100) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `notifications`;
CREATE TABLE `notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) NOT NULL,
  `consultation_id` int(11) DEFAULT NULL,
  `type` enum('approval','decline','new_request') DEFAULT 'new_request',
  `message` text NOT NULL,
  `status` enum('unread','read') DEFAULT 'unread',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_admin_id` (`admin_id`),
  KEY `idx_status` (`status`),
  KEY `idx_created_at` (`created_at`),
  KEY `consultation_id` (`consultation_id`),
  CONSTRAINT `notifications_ibfk_1` FOREIGN KEY (`admin_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `notifications_ibfk_2` FOREIGN KEY (`consultation_id`) REFERENCES `consultations` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `notifications` VALUES ('1', '7', '15', 'approval', 'Consultation approved for Mohamed halith', 'read', '2026-01-03 12:47:45', '2026-01-03 12:47:58');
INSERT INTO `notifications` VALUES ('2', '7', '16', 'approval', 'Consultation approved for Mohamed S', 'read', '2026-01-03 13:13:38', '2026-01-03 13:24:20');
INSERT INTO `notifications` VALUES ('3', '7', '17', 'approval', 'Consultation approved for Mohamed halith', 'read', '2026-01-03 13:24:02', '2026-01-03 13:24:20');

DROP TABLE IF EXISTS `order_items`;
CREATE TABLE `order_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_name` varchar(255) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `quantity` int(11) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  CONSTRAINT `order_items_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `order_items` VALUES ('1', '3', '1', '0', '10000.00', '6', '60000.00', '2025-12-20 13:50:41');
INSERT INTO `order_items` VALUES ('2', '3', '2', '0', '12000.00', '1', '12000.00', '2025-12-20 13:50:41');
INSERT INTO `order_items` VALUES ('3', '4', '3', '0', '14000.00', '1', '14000.00', '2025-12-20 13:51:52');
INSERT INTO `order_items` VALUES ('4', '5', '3', '0', '14000.00', '1', '14000.00', '2025-12-20 13:59:32');
INSERT INTO `order_items` VALUES ('6', '7', '1', '0', '10000.00', '2', '20000.00', '2025-12-20 18:49:52');
INSERT INTO `order_items` VALUES ('7', '8', '2', '0', '12000.00', '1', '12000.00', '2025-12-22 10:44:05');
INSERT INTO `order_items` VALUES ('8', '9', '2', '0', '12000.00', '1', '12000.00', '2025-12-22 14:02:19');
INSERT INTO `order_items` VALUES ('10', '11', '2', '0', '12000.00', '1', '12000.00', '2025-12-22 20:09:17');
INSERT INTO `order_items` VALUES ('11', '12', '2', '0', '12000.00', '3', '36000.00', '2025-12-23 11:57:29');
INSERT INTO `order_items` VALUES ('12', '13', '2', '0', '12000.00', '1', '12000.00', '2025-12-23 12:05:50');
INSERT INTO `order_items` VALUES ('13', '14', '3', '0', '14000.00', '1', '14000.00', '2025-12-23 14:38:18');
INSERT INTO `order_items` VALUES ('14', '14', '2', '0', '12000.00', '1', '12000.00', '2025-12-23 14:38:18');
INSERT INTO `order_items` VALUES ('15', '15', '2', '0', '12000.00', '1', '12000.00', '2025-12-23 14:42:06');
INSERT INTO `order_items` VALUES ('16', '16', '3', '0', '14000.00', '1', '14000.00', '2025-12-23 14:44:33');
INSERT INTO `order_items` VALUES ('17', '17', '8', '0', '16000.00', '1', '16000.00', '2025-12-23 14:45:41');

DROP TABLE IF EXISTS `order_tracking`;
CREATE TABLE `order_tracking` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `status` varchar(50) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  CONSTRAINT `order_tracking_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `first_name` varchar(100) NOT NULL,
  `last_name` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `billing_country` varchar(100) NOT NULL,
  `billing_address` varchar(255) NOT NULL,
  `billing_city` varchar(100) NOT NULL,
  `billing_postcode` varchar(20) NOT NULL,
  `shipping_country` varchar(100) DEFAULT NULL,
  `shipping_address` varchar(255) DEFAULT NULL,
  `shipping_city` varchar(100) DEFAULT NULL,
  `shipping_postcode` varchar(20) DEFAULT NULL,
  `company` varchar(100) DEFAULT NULL,
  `order_notes` text DEFAULT NULL,
  `payment_method` varchar(50) NOT NULL,
  `subtotal` decimal(10,2) NOT NULL,
  `tax` decimal(10,2) NOT NULL,
  `shipping` decimal(10,2) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `status` varchar(50) DEFAULT 'pending',
  `tracking_number` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `orders` VALUES ('1', '6', 'John', 'Doe', 'j@test.com', '0300123', 'Pakistan', '123 St', 'Khi', '75000', 'Pakistan', '456 Ave', 'Lhr', '54000', 'Co', 'Note', 'card', '5000.00', '500.00', '500.00', '6000.00', 'delivered', NULL, '2025-12-20 13:46:32', '2026-01-03 13:38:56');
INSERT INTO `orders` VALUES ('2', '6', 'Test', 'Order', 'test@order.com', '0300555555', 'Pakistan', 'Test Address', 'Test City', '12345', 'Pakistan', 'Shipping Address', 'Shipping City', '54000', '', 'Test order', 'credit_card', '10000.00', '1000.00', '500.00', '11500.00', 'pending', NULL, '2025-12-20 13:49:31', '2025-12-20 13:49:31');
INSERT INTO `orders` VALUES ('3', '6', 'mohamed', 'halith', 'mohamedhalith117@gmail.com', '9080468168', 'Australia', 'ramnad', 'vedhalai', '623519', 'Australia', 'ramnad', 'vedhalai', '623519', '', '', 'credit_card', '72000.00', '7200.00', '500.00', '79700.00', 'pending', NULL, '2025-12-20 13:50:41', '2025-12-20 13:50:41');
INSERT INTO `orders` VALUES ('4', '6', 'mohamed', 'halith', 'mohamedhalith117@gmail.com', '9080468168', 'Australia', 'ramnad', 'vedhalai', '623519', 'Australia', 'ramnad', 'vedhalai', '623519', '', '', 'credit_card', '14000.00', '1400.00', '500.00', '15900.00', 'pending', NULL, '2025-12-20 13:51:52', '2025-12-20 13:51:52');
INSERT INTO `orders` VALUES ('5', '6', 'mohamed', 'halith', 'mohamedhalith117@gmail.com', '9080468168', 'Australia', 'ramnad', 'vedhalai', '623519', 'Australia', 'ramnad', 'vedhalai', '623519', '', '', 'credit_card', '14000.00', '1400.00', '500.00', '15900.00', 'pending', NULL, '2025-12-20 13:59:32', '2025-12-20 13:59:32');
INSERT INTO `orders` VALUES ('7', '6', 'pradeep', 'natarajan', 'pradeep@gmail.com', '9080468168', 'United Kingdom', 'ramnad', 'vedhalai', '623519', 'United Kingdom', 'ramnad', 'vedhalai', '623519', '', '', 'credit_card', '20000.00', '2000.00', '500.00', '22500.00', 'pending', NULL, '2025-12-20 18:49:52', '2025-12-20 18:49:52');
INSERT INTO `orders` VALUES ('8', '6', 'mohamed', 'halith', 'pradeep@gmail.com', '09080468168', 'United States', 'ramnad', 'vedhalai', '623519', 'United States', 'ramnad', 'vedhalai', '623519', '', '', 'credit_card', '12000.00', '1200.00', '500.00', '13700.00', 'pending', NULL, '2025-12-22 10:44:04', '2025-12-22 10:44:04');
INSERT INTO `orders` VALUES ('9', '6', 'mydeen', 'mydeen', 'mydeenabdulkader070@gmail.com', '9876543210', 'Australia', '9987bygbryg', 'paalaiyankottai', '975458', 'Australia', '9987bygbryg', 'paalaiyankottai', '975458', '', 'dwf', 'cod', '12000.00', '1200.00', '500.00', '13700.00', 'shipped', NULL, '2025-12-22 14:02:19', '2025-12-22 16:55:54');
INSERT INTO `orders` VALUES ('11', '6', 'mydeen', 'kader', 'mydeen@gmail.com', '9876543210', 'United States', '297', 'paalaiyankottai', '975458', 'United States', '297', 'paalaiyankottai', '975458', '', '', 'cod', '12000.00', '1200.00', '500.00', '13700.00', 'pending', NULL, '2025-12-22 20:09:17', '2025-12-22 20:09:17');
INSERT INTO `orders` VALUES ('12', '6', 'pradeep', 'natarajan', 'mydeen@gmail.com', '09080468168', 'United States', 'ramnad', 'paalaiyankottai', '975458', 'United States', 'ramnad', 'paalaiyankottai', '975458', '', '', 'credit_card', '36000.00', '3600.00', '500.00', '40100.00', 'pending', NULL, '2025-12-23 11:57:29', '2025-12-23 11:57:29');
INSERT INTO `orders` VALUES ('13', '6', 'amex', 'abdulkader', 'mydeen@gmail.com', '09080468168', 'United States', 'ramnad', 'paalaiyankottai', '975458', 'United States', 'ramnad', 'paalaiyankottai', '975458', '', '', 'credit_card', '12000.00', '1200.00', '500.00', '13700.00', 'pending', NULL, '2025-12-23 12:05:50', '2025-12-23 12:05:50');
INSERT INTO `orders` VALUES ('14', '6', 'mathew', 'D', 'mathew@gmail.com', '09090909090', 'Germany', '79876', 'ariyalur', '873567', 'Germany', '79876', 'ariyalur', '873567', '', '', 'paypal', '26000.00', '2600.00', '500.00', '29100.00', 'pending', NULL, '2025-12-23 14:38:18', '2025-12-23 14:38:18');
INSERT INTO `orders` VALUES ('15', '6', 'mathew', 'D', 'mathew@gmail.com', '09090909090', 'Germany', '79876', 'ariyalur', '873567', 'Germany', '79876', 'ariyalur', '873567', '', '', 'paypal', '12000.00', '1200.00', '500.00', '13700.00', 'pending', NULL, '2025-12-23 14:42:06', '2025-12-23 14:42:06');
INSERT INTO `orders` VALUES ('16', '6', 'mydeen', 's', 'rafiwar567432@gmail.com', '09090909090', 'Pakistan', 'pattukottai', 'paalaiyankottai', '578965', 'Pakistan', 'pattukottai', 'paalaiyankottai', '578965', '', '', 'cod', '14000.00', '1400.00', '500.00', '15900.00', 'pending', NULL, '2025-12-23 14:44:33', '2025-12-23 14:44:33');
INSERT INTO `orders` VALUES ('17', '6', 'vasa', 'r', 'vasa@gmail.com', '09090909090', 'United Kingdom', '36475', 'vgf', '468065', 'United Kingdom', '36475', 'vgf', '468065', '', '', 'paypal', '16000.00', '1600.00', '500.00', '18100.00', 'delivered', NULL, '2025-12-23 14:45:40', '2025-12-30 16:08:06');

DROP TABLE IF EXISTS `otp_verification`;
CREATE TABLE `otp_verification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(100) NOT NULL,
  `otp_code` varchar(10) NOT NULL,
  `purpose` enum('email_verification','password_reset','2fa') DEFAULT 'email_verification',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `expires_at` timestamp NULL DEFAULT NULL,
  `verified` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_email` (`email`),
  KEY `idx_otp` (`otp_code`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `otp_verification` VALUES ('1', 'mydeenabdulkader070@gmail.com', '006140', 'email_verification', '2025-12-20 15:23:38', '2025-12-20 11:03:38', '0');
INSERT INTO `otp_verification` VALUES ('2', 'mydeenabdulkader070@gmail.com', '592006', 'email_verification', '2025-12-20 15:27:30', '2025-12-20 11:07:30', '0');
INSERT INTO `otp_verification` VALUES ('3', 'iiidsumma1@gmail.com', '127697', 'email_verification', '2025-12-20 15:29:51', '2025-12-20 11:09:51', '0');
INSERT INTO `otp_verification` VALUES ('4', 'rafiwar35@gmail.com', '996871', 'email_verification', '2025-12-20 15:34:43', '2025-12-20 11:14:43', '0');
INSERT INTO `otp_verification` VALUES ('5', 'rafiwar35@gmail.com', '955136', 'email_verification', '2025-12-20 15:47:40', '2025-12-20 11:27:40', '0');
INSERT INTO `otp_verification` VALUES ('6', 'rafiwar35@gmail.com', '129602', 'email_verification', '2025-12-20 16:02:21', '2025-12-20 11:42:21', '0');
INSERT INTO `otp_verification` VALUES ('7', 'mohamedhalith117@gmail.com', '884788', 'password_reset', '2025-12-20 16:02:40', '2025-12-20 11:42:40', '0');
INSERT INTO `otp_verification` VALUES ('8', 'rafiwar35@gmail.com', '340745', 'email_verification', '2025-12-20 16:51:55', '2025-12-20 12:31:55', '0');
INSERT INTO `otp_verification` VALUES ('9', 'rafiwar35@gmail.com', '113425', 'email_verification', '2025-12-20 17:35:02', '2025-12-20 13:15:02', '0');
INSERT INTO `otp_verification` VALUES ('10', 'rafiwar35@gmail.com', '921663', 'email_verification', '2025-12-20 17:35:49', '2025-12-20 13:15:49', '0');
INSERT INTO `otp_verification` VALUES ('11', 'mydeenabdulkader070@gmail.com', '218539', 'email_verification', '2025-12-20 17:37:43', '2025-12-20 13:17:43', '0');
INSERT INTO `otp_verification` VALUES ('12', 'mydeenabdulkader070@gmail.com', '854873', 'email_verification', '2025-12-20 17:56:42', '2025-12-20 13:36:42', '0');
INSERT INTO `otp_verification` VALUES ('13', 'rafiwar35@gmail.com', '010428', 'email_verification', '2025-12-20 17:57:46', '2025-12-20 13:37:46', '0');
INSERT INTO `otp_verification` VALUES ('14', 'rafiwar35@gmail.com', '995949', 'email_verification', '2025-12-20 18:08:06', '2025-12-20 13:48:06', '0');
INSERT INTO `otp_verification` VALUES ('15', 'rafiwar35@gmail.com', '004041', 'email_verification', '2025-12-20 18:09:12', '2025-12-20 13:49:12', '0');
INSERT INTO `otp_verification` VALUES ('16', 'rafiwar35@gmail.com', '877667', 'email_verification', '2025-12-20 18:09:30', '2025-12-20 13:49:30', '0');
INSERT INTO `otp_verification` VALUES ('17', 'mohamedhalith118@gmail.com', '919175', 'email_verification', '2025-12-20 18:09:50', '2025-12-20 13:49:50', '0');
INSERT INTO `otp_verification` VALUES ('18', 'rafiwar35@gmail.com', '415393', 'email_verification', '2025-12-20 18:11:11', '2025-12-20 13:51:11', '0');
INSERT INTO `otp_verification` VALUES ('19', 'mohamedhalith118@gmail.com', '496132', 'email_verification', '2025-12-20 18:13:02', '2025-12-20 13:53:02', '0');
INSERT INTO `otp_verification` VALUES ('20', 'mohamedhalith118@gmail.com', '567169', 'email_verification', '2025-12-20 18:14:14', '2025-12-20 13:54:14', '0');
INSERT INTO `otp_verification` VALUES ('21', 'rafiwar35@gmail.com', '785643', 'email_verification', '2025-12-20 18:15:40', '2025-12-20 13:55:40', '0');
INSERT INTO `otp_verification` VALUES ('22', 'rafiwar35@gmail.com', '339482', 'email_verification', '2025-12-20 18:19:23', '2025-12-20 13:59:23', '0');
INSERT INTO `otp_verification` VALUES ('23', 'rafiwar35@gmail.com', '139094', 'email_verification', '2025-12-20 18:22:47', '2025-12-20 18:32:47', '0');
INSERT INTO `otp_verification` VALUES ('24', 'rafiwar35@gmail.com', '794358', 'password_reset', '2025-12-20 18:28:20', '2025-12-20 14:08:20', '0');
INSERT INTO `otp_verification` VALUES ('25', 'rafiwar35@gmail.com', '931193', 'password_reset', '2025-12-20 18:30:51', '2025-12-20 18:40:51', '0');
INSERT INTO `otp_verification` VALUES ('26', 'rafiwar35@gmail.com', '444457', 'password_reset', '2025-12-20 18:30:55', '2025-12-20 18:40:55', '0');
INSERT INTO `otp_verification` VALUES ('27', 'rafiwar35@gmail.com', '298363', 'password_reset', '2025-12-20 18:31:00', '2025-12-20 18:41:00', '0');
INSERT INTO `otp_verification` VALUES ('28', 'rafiwar35@gmail.com', '292114', 'password_reset', '2025-12-20 18:31:05', '2025-12-20 18:41:05', '0');
INSERT INTO `otp_verification` VALUES ('29', 'rafiwar35@gmail.com', '087814', 'password_reset', '2025-12-20 18:31:10', '2025-12-20 18:41:10', '0');
INSERT INTO `otp_verification` VALUES ('30', 'rafiwar35@gmail.com', '141439', 'password_reset', '2025-12-20 18:31:14', '2025-12-20 18:41:14', '0');
INSERT INTO `otp_verification` VALUES ('31', 'rafiwar35@gmail.com', '309625', 'password_reset', '2025-12-20 18:31:19', '2025-12-20 18:41:19', '0');
INSERT INTO `otp_verification` VALUES ('32', 'rafiwar35@gmail.com', '287885', 'password_reset', '2025-12-20 18:31:23', '2025-12-20 18:41:23', '0');
INSERT INTO `otp_verification` VALUES ('33', 'rafiwar35@gmail.com', '060181', 'password_reset', '2025-12-20 18:32:04', '2025-12-20 18:42:04', '0');
INSERT INTO `otp_verification` VALUES ('34', 'pradeep56784321@gmail.com', '135199', 'email_verification', '2025-12-26 16:25:13', '2025-12-26 16:35:13', '0');
INSERT INTO `otp_verification` VALUES ('35', 'khanhalith068@gmail.com', '710830', 'email_verification', '2025-12-26 18:09:01', '2025-12-26 18:19:01', '0');
INSERT INTO `otp_verification` VALUES ('36', 'khanhalith068@gmail.com', '907911', 'email_verification', '2025-12-26 18:11:14', '2025-12-26 18:21:14', '0');
INSERT INTO `otp_verification` VALUES ('37', 'khanhalith068@gmail.com', '617167', 'email_verification', '2025-12-26 18:21:51', '2025-12-26 18:31:51', '0');
INSERT INTO `otp_verification` VALUES ('38', 'mydeenabdulkader070@gmail.com', '424643', 'email_verification', '2025-12-29 16:40:19', '2025-12-29 16:50:19', '0');
INSERT INTO `otp_verification` VALUES ('39', 'mydeenabdulkader070@gmail.com', '212985', 'email_verification', '2025-12-29 16:40:32', '2025-12-29 16:50:32', '0');
INSERT INTO `otp_verification` VALUES ('40', 'mydeenabdulkader070@gmail.com', '819706', 'email_verification', '2025-12-29 16:40:36', '2025-12-29 16:50:36', '0');
INSERT INTO `otp_verification` VALUES ('41', 'mydeenabdulkader070@gmail.com', '969508', 'email_verification', '2025-12-29 16:40:40', '2025-12-29 16:50:40', '0');
INSERT INTO `otp_verification` VALUES ('42', 'mydeenabdulkader070@gmail.com', '481748', 'email_verification', '2025-12-29 16:40:45', '2025-12-29 16:50:45', '0');
INSERT INTO `otp_verification` VALUES ('43', 'mydeenabdulkader070@gmail.com', '935209', 'email_verification', '2025-12-29 16:40:50', '2025-12-29 16:50:50', '0');
INSERT INTO `otp_verification` VALUES ('44', 'mydeenabdulkader070@gmail.com', '637150', 'email_verification', '2025-12-29 16:40:54', '2025-12-29 16:50:54', '0');
INSERT INTO `otp_verification` VALUES ('45', 'mydeenabdulkader070@gmail.com', '318249', 'email_verification', '2025-12-29 16:40:58', '2025-12-29 16:50:58', '0');
INSERT INTO `otp_verification` VALUES ('46', 'mydeenabdulkader070@gmail.com', '875756', 'email_verification', '2025-12-29 16:41:14', '2025-12-29 16:51:14', '0');
INSERT INTO `otp_verification` VALUES ('47', 'test@example.com', '827143', 'email_verification', '2026-01-03 10:46:50', '2026-01-03 10:56:50', '0');

DROP TABLE IF EXISTS `password_resets`;
CREATE TABLE `password_resets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `token` varchar(255) NOT NULL,
  `email` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `expires_at` timestamp NULL DEFAULT NULL,
  `used` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `token` (`token`),
  KEY `idx_user` (`user_id`),
  KEY `idx_token` (`token`),
  CONSTRAINT `password_resets_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `product_events`;
CREATE TABLE `product_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) DEFAULT NULL,
  `action` varchar(20) DEFAULT NULL,
  `payload` longtext DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `product_events` VALUES ('1', '1', 'create', '{\\\"id\\\":\\\"1\\\",\\\"name\\\":\\\"sofa\\\",\\\"price\\\":\\\"20000.00\\\",\\\"description\\\":\\\"\\\",\\\"image_path\\\":\\\"assets\\\\/uploads\\\\/products\\\\/prod_1_1766494782.png\\\",\\\"stock\\\":\\\"0\\\"}', '2025-12-23 18:29:42');
INSERT INTO `product_events` VALUES ('2', '1', 'delete', '{\\\"id\\\":\\\"1\\\",\\\"name\\\":\\\"sofa\\\",\\\"price\\\":\\\"20000.00\\\",\\\"description\\\":\\\"\\\",\\\"image_path\\\":\\\"assets\\\\/uploads\\\\/products\\\\/prod_1_1766494782.png\\\",\\\"stock\\\":\\\"0\\\"}', '2025-12-23 18:30:27');

DROP TABLE IF EXISTS `products`;
CREATE TABLE `products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `price` decimal(10,2) DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `image_path` varchar(255) DEFAULT NULL,
  `stock` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `services`;
CREATE TABLE `services` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `team_members`;
CREATE TABLE `team_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `image_path` varchar(255) DEFAULT NULL,
  `twitter_url` varchar(255) DEFAULT NULL,
  `linkedin_url` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_created` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `team_members` VALUES ('1', 'Jake Saper', 'CEO & Founder', 'assets/img/team/team_1_1.png', 'https://twitter.com/', 'https://linkedin.com/', '2025-12-29 10:13:28', '2025-12-29 10:13:28');
INSERT INTO `team_members` VALUES ('2', 'Mari Doly', 'Chief Architect', 'assets/img/team/team_1_2.png', 'https://twitter.com/', 'https://linkedin.com/', '2025-12-29 10:13:28', '2025-12-29 10:13:28');
INSERT INTO `team_members` VALUES ('3', 'Michel Smith', 'General Manager', 'assets/img/team/team_1_3.png', 'https://twitter.com/', 'https://linkedin.com/', '2025-12-29 10:13:28', '2025-12-29 10:13:28');
INSERT INTO `team_members` VALUES ('4', 'Elis Mike', 'Assistant Architect', 'assets/img/team/team_1_4.png', 'https://twitter.com/', 'https://linkedin.com/', '2025-12-29 10:13:28', '2025-12-29 10:13:28');
INSERT INTO `team_members` VALUES ('7', 'Mohamed Halith S', 'Manager', 'assets/img/team/team_1766989806_8759.jpg', 'https://twitter.com/', 'https://linkedin.com/', '2025-12-29 12:00:06', '2025-12-29 12:00:06');

DROP TABLE IF EXISTS `upi_config`;
CREATE TABLE `upi_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(100) NOT NULL,
  `value` varchar(500) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `upi_config` VALUES ('1', 'UPI_ID', '9876543210@okhdfcbank', 'Merchant UPI ID', '2026-01-03 10:44:09', '2026-01-03 10:44:09');
INSERT INTO `upi_config` VALUES ('2', 'MERCHANT_NAME', 'Interior Design Store', 'Merchant Name', '2026-01-03 10:44:09', '2026-01-03 10:44:09');
INSERT INTO `upi_config` VALUES ('3', 'QR_CODE_SIZE', '250x250', 'QR Code Size', '2026-01-03 10:44:09', '2026-01-03 10:44:09');
INSERT INTO `upi_config` VALUES ('4', 'TRANSACTION_TIMEOUT', '600', 'Transaction Timeout in seconds', '2026-01-03 10:44:10', '2026-01-03 10:44:10');
INSERT INTO `upi_config` VALUES ('5', 'ENABLE_UPI', 'true', 'Enable UPI Payment', '2026-01-03 10:44:10', '2026-01-03 10:44:10');

DROP TABLE IF EXISTS `upi_payment_logs`;
CREATE TABLE `upi_payment_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) NOT NULL,
  `action` varchar(50) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_transaction_id` (`transaction_id`),
  KEY `idx_created_at` (`created_at`),
  CONSTRAINT `upi_payment_logs_ibfk_1` FOREIGN KEY (`transaction_id`) REFERENCES `upi_transactions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `upi_transactions`;
CREATE TABLE `upi_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `transaction_ref` varchar(100) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `upi_string` longtext NOT NULL,
  `qr_code_url` longtext DEFAULT NULL,
  `upi_id` varchar(100) DEFAULT NULL,
  `status` enum('pending','verified','completed','failed','expired') DEFAULT 'pending',
  `order_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `verified_at` timestamp NULL DEFAULT NULL,
  `completed_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `transaction_ref` (`transaction_ref`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_transaction_ref` (`transaction_ref`),
  KEY `idx_status` (`status`),
  KEY `idx_order_id` (`order_id`),
  CONSTRAINT `upi_transactions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `upi_transactions_ibfk_2` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `upi_transactions` VALUES ('2', '6', 'ORD-6-1767418956', '40100.00', 'upi://pay?pa=9876543210%40okhdfcbank&pn=Interior+Design+Store&am=40100&tn=Order+Payment&tr=ORD-6-1767418956', 'https://api.qrserver.com/v1/create-qr-code/?size=250x250&data=upi%3A%2F%2Fpay%3Fpa%3D9876543210%2540okhdfcbank%26pn%3DInterior%2BDesign%2BStore%26am%3D40100%26tn%3DOrder%2BPayment%26tr%3DORD-6-1767418956', '9876543210@okhdfcbank', 'pending', NULL, '2026-01-03 11:12:36', '2026-01-03 11:13:07', NULL);

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `email_verified` tinyint(1) DEFAULT 0,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `password_changed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `role` enum('customer','admin') NOT NULL DEFAULT 'customer',
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `two_factor_enabled` tinyint(1) DEFAULT 0,
  `two_factor_secret` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `users` VALUES ('6', 'Mohamed', 'mohamedhalith117@gmail.com', '0', NULL, '+919080468168', '$2y$10$UqNRTlED3dmIxqovvOH31ezKLq.g0/VeMvY5zndygxxcUSXdYfimu', '2025-12-20 15:00:56', '2025-12-18 14:43:28', '2025-12-29 14:49:16', 'customer', 'active', '0', NULL);
INSERT INTO `users` VALUES ('7', 'halith', 'iiidsumma@gmail.com', '0', NULL, '+919080468168', '$2y$10$8DceeNh27rjT5/bi8hIiJOePDbEFyx4YaGUnqeu6qoJJiNJLU/rIS', '2025-12-20 15:00:56', '2025-12-18 14:44:27', '2025-12-18 14:44:27', 'admin', 'active', '0', NULL);
INSERT INTO `users` VALUES ('12', 'Admin User', 'admin@fahren.com', '0', NULL, '1234567890', 'admin@fahren', '2025-12-20 15:00:56', '2025-12-20 14:45:57', '2025-12-29 16:44:00', 'admin', 'active', '0', NULL);
INSERT INTO `users` VALUES ('16', 'khan', 'khanhalith068@gmail.com', '1', '2025-12-26 13:52:49', '9090909090', '$2y$10$NDAsGZt5hf13JywOGIgf5.5kZiaOYF.wDvZteCLv2jAEuLi84lZ8a', '2025-12-26 18:22:49', '2025-12-26 18:22:49', '2025-12-26 18:22:49', 'customer', 'active', '0', NULL);
INSERT INTO `users` VALUES ('17', 'mydeen s', 'mydeenabdulkader070@gmail.com', '1', NULL, '+919090909090', '$2y$10$vi13tQU/f5paXyEicBfSke0cEPmkkAa7skIKjTTj51Ugxyrn0EdQi', '2025-12-29 16:41:45', '2025-12-29 16:41:45', '2025-12-29 16:41:45', 'customer', 'active', '0', NULL);

SET FOREIGN_KEY_CHECKS = 1;
