-- Database Backup
-- Generated: 2026-01-05 11:32:09
-- Database: zemaraim_interior

SET FOREIGN_KEY_CHECKS = 0;

DROP TABLE IF EXISTS `audit_logs`;
CREATE TABLE `audit_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `action` varchar(100) NOT NULL,
  `details` text DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_user` (`user_id`),
  KEY `idx_action` (`action`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `blogs`;
CREATE TABLE `blogs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `category` varchar(100) NOT NULL,
  `author` varchar(100) NOT NULL,
  `day` varchar(2) NOT NULL,
  `month` varchar(20) NOT NULL,
  `image_path` varchar(500) NOT NULL,
  `content` longtext DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_category` (`category`),
  KEY `idx_author` (`author`),
  KEY `idx_created` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `blogs` VALUES ('1', 'Are custom-made sofas a good choice for premium quality interior design?', 'Interior', 'Johon Smith', '18', 'JUNE', 'assets/img/blog/blog-grid-2.jpg', 'Custom-made sofas can be an excellent choice for premium interior design...', '2025-12-29 11:38:09', '2025-12-29 11:38:09');
INSERT INTO `blogs` VALUES ('2', 'What are the latest trends in outdoor living spaces for 2025?', 'Interior', 'Johon Smith', '18', 'JUNE', 'assets/img/blog/blog-grid-3.jpg', 'Outdoor living spaces have evolved significantly...', '2025-12-29 11:38:09', '2025-12-29 11:38:09');
INSERT INTO `blogs` VALUES ('3', 'How does proper lighting enhance the ambiance of a room?', 'Design', 'Johon Smith', '18', 'JUNE', 'assets/img/blog/blog-grid-5.jpg', 'Proper lighting is crucial in creating the right ambiance...', '2025-12-29 11:38:09', '2025-12-29 11:38:09');

DROP TABLE IF EXISTS `cart`;
CREATE TABLE `cart` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_name` varchar(255) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `quantity` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `product_id` (`product_id`),
  CONSTRAINT `cart_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `cart` VALUES ('48', '16', '2', 'Elegant Wooden Chair', '12000.00', 'assets/img/product/product_1_2.jpg', '1', '2025-12-26 18:23:18', '2025-12-26 18:23:18');
INSERT INTO `cart` VALUES ('49', '17', '1', 'Nordic Wooden Chair', '10000.00', 'assets/img/product/product_1_1.jpg', '1', '2025-12-30 17:05:15', '2025-12-30 17:05:15');
INSERT INTO `cart` VALUES ('50', '17', '2', 'Elegant Wooden Chair', '12000.00', 'assets/img/product/product_1_2.jpg', '1', '2025-12-30 17:05:35', '2025-12-30 17:05:35');

DROP TABLE IF EXISTS `consultations`;
CREATE TABLE `consultations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `first_name` varchar(100) DEFAULT NULL,
  `last_name` varchar(100) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `consultation_type` varchar(50) DEFAULT NULL,
  `preferred_date` date DEFAULT NULL,
  `preferred_time` time DEFAULT NULL,
  `project_description` text DEFAULT NULL,
  `budget_range` varchar(50) DEFAULT NULL,
  `source` varchar(50) DEFAULT NULL,
  `verification_token` varchar(255) DEFAULT NULL,
  `token_expiry` datetime DEFAULT NULL,
  `verification_status` enum('pending','approved','declined','scheduled','completed','cancelled') DEFAULT 'pending',
  `status` enum('pending','approved','declined','scheduled','completed','cancelled') DEFAULT 'pending',
  `verified_at` datetime DEFAULT NULL,
  `scheduled_at` datetime DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_status` (`status`),
  KEY `idx_email` (`email`),
  CONSTRAINT `consultations_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `consultations` VALUES ('1', '6', NULL, 'mohamed', 's', 'mohamedhalith117@gmail.com', '+919080468168', 'pattukottai', 'furniture', '2026-01-08', '13:00:00', 'hj', '50k-100k', 'advertisement', NULL, NULL, 'pending', 'approved', NULL, NULL, NULL, '2025-12-31 12:53:51', '2026-01-03 11:25:18');

DROP TABLE IF EXISTS `contact_messages`;
CREATE TABLE `contact_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT 0,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `message` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_email` (`email`),
  KEY `idx_created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `coupons`;
CREATE TABLE `coupons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `discount_type` varchar(20) NOT NULL,
  `discount_value` decimal(10,2) NOT NULL,
  `min_purchase` decimal(10,2) DEFAULT NULL,
  `max_usage` int(11) DEFAULT NULL,
  `current_usage` int(11) DEFAULT 0,
  `is_active` tinyint(1) DEFAULT 1,
  `expires_at` datetime DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `coupons` VALUES ('1', 'WELCOME10', '10% off on first purchase', 'percentage', '10.00', '0.00', '100', '0', '1', '2026-01-17 18:57:20', '2025-12-18 18:57:20', '2025-12-18 18:57:20');

DROP TABLE IF EXISTS `email_queue`;
CREATE TABLE `email_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `consultation_id` int(11) DEFAULT NULL,
  `recipient_email` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `body` longtext NOT NULL,
  `email_type` varchar(50) DEFAULT NULL,
  `status` varchar(20) DEFAULT 'pending',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `sent_at` timestamp NULL DEFAULT NULL,
  `attempts` int(11) DEFAULT 0,
  `last_attempt` timestamp NULL DEFAULT NULL,
  `error_message` text DEFAULT NULL,
  `retry_count` int(11) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `favorites`;
CREATE TABLE `favorites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_name` varchar(255) NOT NULL,
  `product_price` decimal(10,2) NOT NULL,
  `product_image` varchar(255) DEFAULT NULL,
  `added_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_user_product` (`user_id`,`product_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_product_id` (`product_id`),
  CONSTRAINT `favorites_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `gallery`;
CREATE TABLE `gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `category` varchar(100) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `notifications`;
CREATE TABLE `notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) NOT NULL,
  `consultation_id` int(11) DEFAULT NULL,
  `type` enum('approval','decline','new_request') DEFAULT 'new_request',
  `message` text NOT NULL,
  `status` enum('unread','read') DEFAULT 'unread',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_admin_id` (`admin_id`),
  KEY `idx_status` (`status`),
  KEY `idx_created_at` (`created_at`),
  KEY `consultation_id` (`consultation_id`),
  CONSTRAINT `notifications_ibfk_1` FOREIGN KEY (`admin_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `notifications_ibfk_2` FOREIGN KEY (`consultation_id`) REFERENCES `consultations` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `order_items`;
CREATE TABLE `order_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_name` varchar(255) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `quantity` int(11) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  CONSTRAINT `order_items_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `order_items` VALUES ('1', '3', '1', '0', '10000.00', '6', '60000.00', '2025-12-20 13:50:41');
INSERT INTO `order_items` VALUES ('2', '3', '2', '0', '12000.00', '1', '12000.00', '2025-12-20 13:50:41');
INSERT INTO `order_items` VALUES ('3', '4', '3', '0', '14000.00', '1', '14000.00', '2025-12-20 13:51:52');
INSERT INTO `order_items` VALUES ('4', '5', '3', '0', '14000.00', '1', '14000.00', '2025-12-20 13:59:32');
INSERT INTO `order_items` VALUES ('6', '7', '1', '0', '10000.00', '2', '20000.00', '2025-12-20 18:49:52');
INSERT INTO `order_items` VALUES ('7', '8', '2', '0', '12000.00', '1', '12000.00', '2025-12-22 10:44:05');
INSERT INTO `order_items` VALUES ('8', '9', '2', '0', '12000.00', '1', '12000.00', '2025-12-22 14:02:19');
INSERT INTO `order_items` VALUES ('10', '11', '2', '0', '12000.00', '1', '12000.00', '2025-12-22 20:09:17');
INSERT INTO `order_items` VALUES ('11', '12', '2', '0', '12000.00', '3', '36000.00', '2025-12-23 11:57:29');
INSERT INTO `order_items` VALUES ('12', '13', '2', '0', '12000.00', '1', '12000.00', '2025-12-23 12:05:50');
INSERT INTO `order_items` VALUES ('13', '14', '3', '0', '14000.00', '1', '14000.00', '2025-12-23 14:38:18');
INSERT INTO `order_items` VALUES ('14', '14', '2', '0', '12000.00', '1', '12000.00', '2025-12-23 14:38:18');
INSERT INTO `order_items` VALUES ('15', '15', '2', '0', '12000.00', '1', '12000.00', '2025-12-23 14:42:06');
INSERT INTO `order_items` VALUES ('16', '16', '3', '0', '14000.00', '1', '14000.00', '2025-12-23 14:44:33');
INSERT INTO `order_items` VALUES ('17', '17', '8', '0', '16000.00', '1', '16000.00', '2025-12-23 14:45:41');
INSERT INTO `order_items` VALUES ('18', '18', '1', '0', '10000.00', '1', '10000.00', '2025-12-26 16:32:38');
INSERT INTO `order_items` VALUES ('19', '19', '5', '0', '22000.00', '1', '22000.00', '2026-01-05 16:55:56');

DROP TABLE IF EXISTS `order_tracking`;
CREATE TABLE `order_tracking` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `status` varchar(50) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  CONSTRAINT `order_tracking_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `first_name` varchar(100) NOT NULL,
  `last_name` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `billing_country` varchar(100) NOT NULL,
  `billing_address` varchar(255) NOT NULL,
  `billing_city` varchar(100) NOT NULL,
  `billing_postcode` varchar(20) NOT NULL,
  `shipping_country` varchar(100) DEFAULT NULL,
  `shipping_address` varchar(255) DEFAULT NULL,
  `shipping_city` varchar(100) DEFAULT NULL,
  `shipping_postcode` varchar(20) DEFAULT NULL,
  `company` varchar(100) DEFAULT NULL,
  `order_notes` text DEFAULT NULL,
  `payment_method` varchar(50) NOT NULL,
  `subtotal` decimal(10,2) NOT NULL,
  `tax` decimal(10,2) NOT NULL,
  `shipping` decimal(10,2) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `status` varchar(50) DEFAULT 'pending',
  `tracking_number` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `orders` VALUES ('1', '6', 'John', 'Doe', 'j@test.com', '0300123', 'Pakistan', '123 St', 'Khi', '75000', 'Pakistan', '456 Ave', 'Lhr', '54000', 'Co', 'Note', 'card', '5000.00', '500.00', '500.00', '6000.00', 'pending', NULL, '2025-12-20 13:46:32', '2025-12-20 13:46:32');
INSERT INTO `orders` VALUES ('2', '6', 'Test', 'Order', 'test@order.com', '0300555555', 'Pakistan', 'Test Address', 'Test City', '12345', 'Pakistan', 'Shipping Address', 'Shipping City', '54000', '', 'Test order', 'credit_card', '10000.00', '1000.00', '500.00', '11500.00', 'pending', NULL, '2025-12-20 13:49:31', '2025-12-20 13:49:31');
INSERT INTO `orders` VALUES ('3', '6', 'mohamed', 'halith', 'mohamedhalith117@gmail.com', '9080468168', 'Australia', 'ramnad', 'vedhalai', '623519', 'Australia', 'ramnad', 'vedhalai', '623519', '', '', 'credit_card', '72000.00', '7200.00', '500.00', '79700.00', 'pending', NULL, '2025-12-20 13:50:41', '2025-12-20 13:50:41');
INSERT INTO `orders` VALUES ('4', '6', 'mohamed', 'halith', 'mohamedhalith117@gmail.com', '9080468168', 'Australia', 'ramnad', 'vedhalai', '623519', 'Australia', 'ramnad', 'vedhalai', '623519', '', '', 'credit_card', '14000.00', '1400.00', '500.00', '15900.00', 'pending', NULL, '2025-12-20 13:51:52', '2025-12-20 13:51:52');
INSERT INTO `orders` VALUES ('5', '6', 'mohamed', 'halith', 'mohamedhalith117@gmail.com', '9080468168', 'Australia', 'ramnad', 'vedhalai', '623519', 'Australia', 'ramnad', 'vedhalai', '623519', '', '', 'credit_card', '14000.00', '1400.00', '500.00', '15900.00', 'pending', NULL, '2025-12-20 13:59:32', '2025-12-20 13:59:32');
INSERT INTO `orders` VALUES ('7', '6', 'pradeep', 'natarajan', 'pradeep@gmail.com', '9080468168', 'United Kingdom', 'ramnad', 'vedhalai', '623519', 'United Kingdom', 'ramnad', 'vedhalai', '623519', '', '', 'credit_card', '20000.00', '2000.00', '500.00', '22500.00', 'pending', NULL, '2025-12-20 18:49:52', '2025-12-20 18:49:52');
INSERT INTO `orders` VALUES ('8', '6', 'mohamed', 'halith', 'pradeep@gmail.com', '09080468168', 'United States', 'ramnad', 'vedhalai', '623519', 'United States', 'ramnad', 'vedhalai', '623519', '', '', 'credit_card', '12000.00', '1200.00', '500.00', '13700.00', 'pending', NULL, '2025-12-22 10:44:04', '2025-12-22 10:44:04');
INSERT INTO `orders` VALUES ('9', '6', 'mydeen', 'mydeen', 'mydeenabdulkader070@gmail.com', '9876543210', 'Australia', '9987bygbryg', 'paalaiyankottai', '975458', 'Australia', '9987bygbryg', 'paalaiyankottai', '975458', '', 'dwf', 'cod', '12000.00', '1200.00', '500.00', '13700.00', 'shipped', NULL, '2025-12-22 14:02:19', '2025-12-22 16:55:54');
INSERT INTO `orders` VALUES ('11', '6', 'mydeen', 'kader', 'mydeen@gmail.com', '9876543210', 'United States', '297', 'paalaiyankottai', '975458', 'United States', '297', 'paalaiyankottai', '975458', '', '', 'cod', '12000.00', '1200.00', '500.00', '13700.00', 'pending', NULL, '2025-12-22 20:09:17', '2025-12-22 20:09:17');
INSERT INTO `orders` VALUES ('12', '6', 'pradeep', 'natarajan', 'mydeen@gmail.com', '09080468168', 'United States', 'ramnad', 'paalaiyankottai', '975458', 'United States', 'ramnad', 'paalaiyankottai', '975458', '', '', 'credit_card', '36000.00', '3600.00', '500.00', '40100.00', 'pending', NULL, '2025-12-23 11:57:29', '2025-12-23 11:57:29');
INSERT INTO `orders` VALUES ('13', '6', 'amex', 'abdulkader', 'mydeen@gmail.com', '09080468168', 'United States', 'ramnad', 'paalaiyankottai', '975458', 'United States', 'ramnad', 'paalaiyankottai', '975458', '', '', 'credit_card', '12000.00', '1200.00', '500.00', '13700.00', 'pending', NULL, '2025-12-23 12:05:50', '2025-12-23 12:05:50');
INSERT INTO `orders` VALUES ('14', '6', 'mathew', 'D', 'mathew@gmail.com', '09090909090', 'Germany', '79876', 'ariyalur', '873567', 'Germany', '79876', 'ariyalur', '873567', '', '', 'paypal', '26000.00', '2600.00', '500.00', '29100.00', 'pending', NULL, '2025-12-23 14:38:18', '2025-12-23 14:38:18');
INSERT INTO `orders` VALUES ('15', '6', 'mathew', 'D', 'mathew@gmail.com', '09090909090', 'Germany', '79876', 'ariyalur', '873567', 'Germany', '79876', 'ariyalur', '873567', '', '', 'paypal', '12000.00', '1200.00', '500.00', '13700.00', 'pending', NULL, '2025-12-23 14:42:06', '2025-12-23 14:42:06');
INSERT INTO `orders` VALUES ('16', '6', 'mydeen', 's', 'rafiwar567432@gmail.com', '09090909090', 'Pakistan', 'pattukottai', 'paalaiyankottai', '578965', 'Pakistan', 'pattukottai', 'paalaiyankottai', '578965', '', '', 'cod', '14000.00', '1400.00', '500.00', '15900.00', 'pending', NULL, '2025-12-23 14:44:33', '2025-12-23 14:44:33');
INSERT INTO `orders` VALUES ('17', '6', 'vasa', 'r', 'vasa@gmail.com', '09090909090', 'United Kingdom', '36475', 'vgf', '468065', 'United Kingdom', '36475', 'vgf', '468065', '', '', 'paypal', '16000.00', '1600.00', '500.00', '18100.00', 'delivered', NULL, '2025-12-23 14:45:40', '2026-01-05 16:58:09');
INSERT INTO `orders` VALUES ('18', '15', 'pradeep', 'natarajan', 'pradeep56784321@gmail.com', '1234567890', 'Pakistan', 'north street', 'pattukottai', '623678', 'Pakistan', 'north street', 'pattukottai', '623678', '', '', 'cod', '10000.00', '1000.00', '500.00', '11500.00', 'pending', NULL, '2025-12-26 16:32:38', '2025-12-26 16:32:38');
INSERT INTO `orders` VALUES ('19', '6', 'mohamed', 'halith', 'mohamedhalith117@gmail.com', '09090909090', 'India', '2/528', 'vedhalai', '623519', 'India', '2/528', 'vedhalai', '623519', '', ' fgnysmzfg', 'cod', '22000.00', '2200.00', '500.00', '24700.00', 'delivered', NULL, '2026-01-05 16:55:56', '2026-01-05 16:57:08');

DROP TABLE IF EXISTS `otp_verification`;
CREATE TABLE `otp_verification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(100) NOT NULL,
  `otp_code` varchar(10) NOT NULL,
  `purpose` enum('email_verification','password_reset','2fa') DEFAULT 'email_verification',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `expires_at` timestamp NULL DEFAULT NULL,
  `verified` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_email` (`email`),
  KEY `idx_otp` (`otp_code`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `otp_verification` VALUES ('1', 'mydeenabdulkader070@gmail.com', '006140', 'email_verification', '2025-12-20 15:23:38', '2025-12-20 11:03:38', '0');
INSERT INTO `otp_verification` VALUES ('2', 'mydeenabdulkader070@gmail.com', '592006', 'email_verification', '2025-12-20 15:27:30', '2025-12-20 11:07:30', '0');
INSERT INTO `otp_verification` VALUES ('3', 'iiidsumma1@gmail.com', '127697', 'email_verification', '2025-12-20 15:29:51', '2025-12-20 11:09:51', '0');
INSERT INTO `otp_verification` VALUES ('4', 'rafiwar35@gmail.com', '996871', 'email_verification', '2025-12-20 15:34:43', '2025-12-20 11:14:43', '0');
INSERT INTO `otp_verification` VALUES ('5', 'rafiwar35@gmail.com', '955136', 'email_verification', '2025-12-20 15:47:40', '2025-12-20 11:27:40', '0');
INSERT INTO `otp_verification` VALUES ('6', 'rafiwar35@gmail.com', '129602', 'email_verification', '2025-12-20 16:02:21', '2025-12-20 11:42:21', '0');
INSERT INTO `otp_verification` VALUES ('7', 'mohamedhalith117@gmail.com', '884788', 'password_reset', '2025-12-20 16:02:40', '2025-12-20 11:42:40', '0');
INSERT INTO `otp_verification` VALUES ('8', 'rafiwar35@gmail.com', '340745', 'email_verification', '2025-12-20 16:51:55', '2025-12-20 12:31:55', '0');
INSERT INTO `otp_verification` VALUES ('9', 'rafiwar35@gmail.com', '113425', 'email_verification', '2025-12-20 17:35:02', '2025-12-20 13:15:02', '0');
INSERT INTO `otp_verification` VALUES ('10', 'rafiwar35@gmail.com', '921663', 'email_verification', '2025-12-20 17:35:49', '2025-12-20 13:15:49', '0');
INSERT INTO `otp_verification` VALUES ('11', 'mydeenabdulkader070@gmail.com', '218539', 'email_verification', '2025-12-20 17:37:43', '2025-12-20 13:17:43', '0');
INSERT INTO `otp_verification` VALUES ('12', 'mydeenabdulkader070@gmail.com', '854873', 'email_verification', '2025-12-20 17:56:42', '2025-12-20 13:36:42', '0');
INSERT INTO `otp_verification` VALUES ('13', 'rafiwar35@gmail.com', '010428', 'email_verification', '2025-12-20 17:57:46', '2025-12-20 13:37:46', '0');
INSERT INTO `otp_verification` VALUES ('14', 'rafiwar35@gmail.com', '995949', 'email_verification', '2025-12-20 18:08:06', '2025-12-20 13:48:06', '0');
INSERT INTO `otp_verification` VALUES ('15', 'rafiwar35@gmail.com', '004041', 'email_verification', '2025-12-20 18:09:12', '2025-12-20 13:49:12', '0');
INSERT INTO `otp_verification` VALUES ('16', 'rafiwar35@gmail.com', '877667', 'email_verification', '2025-12-20 18:09:30', '2025-12-20 13:49:30', '0');
INSERT INTO `otp_verification` VALUES ('17', 'mohamedhalith118@gmail.com', '919175', 'email_verification', '2025-12-20 18:09:50', '2025-12-20 13:49:50', '0');
INSERT INTO `otp_verification` VALUES ('18', 'rafiwar35@gmail.com', '415393', 'email_verification', '2025-12-20 18:11:11', '2025-12-20 13:51:11', '0');
INSERT INTO `otp_verification` VALUES ('19', 'mohamedhalith118@gmail.com', '496132', 'email_verification', '2025-12-20 18:13:02', '2025-12-20 13:53:02', '0');
INSERT INTO `otp_verification` VALUES ('20', 'mohamedhalith118@gmail.com', '567169', 'email_verification', '2025-12-20 18:14:14', '2025-12-20 13:54:14', '0');
INSERT INTO `otp_verification` VALUES ('21', 'rafiwar35@gmail.com', '785643', 'email_verification', '2025-12-20 18:15:40', '2025-12-20 13:55:40', '0');
INSERT INTO `otp_verification` VALUES ('22', 'rafiwar35@gmail.com', '339482', 'email_verification', '2025-12-20 18:19:23', '2025-12-20 13:59:23', '0');
INSERT INTO `otp_verification` VALUES ('23', 'rafiwar35@gmail.com', '139094', 'email_verification', '2025-12-20 18:22:47', '2025-12-20 18:32:47', '0');
INSERT INTO `otp_verification` VALUES ('24', 'rafiwar35@gmail.com', '794358', 'password_reset', '2025-12-20 18:28:20', '2025-12-20 14:08:20', '0');
INSERT INTO `otp_verification` VALUES ('25', 'rafiwar35@gmail.com', '931193', 'password_reset', '2025-12-20 18:30:51', '2025-12-20 18:40:51', '0');
INSERT INTO `otp_verification` VALUES ('26', 'rafiwar35@gmail.com', '444457', 'password_reset', '2025-12-20 18:30:55', '2025-12-20 18:40:55', '0');
INSERT INTO `otp_verification` VALUES ('27', 'rafiwar35@gmail.com', '298363', 'password_reset', '2025-12-20 18:31:00', '2025-12-20 18:41:00', '0');
INSERT INTO `otp_verification` VALUES ('28', 'rafiwar35@gmail.com', '292114', 'password_reset', '2025-12-20 18:31:05', '2025-12-20 18:41:05', '0');
INSERT INTO `otp_verification` VALUES ('29', 'rafiwar35@gmail.com', '087814', 'password_reset', '2025-12-20 18:31:10', '2025-12-20 18:41:10', '0');
INSERT INTO `otp_verification` VALUES ('30', 'rafiwar35@gmail.com', '141439', 'password_reset', '2025-12-20 18:31:14', '2025-12-20 18:41:14', '0');
INSERT INTO `otp_verification` VALUES ('31', 'rafiwar35@gmail.com', '309625', 'password_reset', '2025-12-20 18:31:19', '2025-12-20 18:41:19', '0');
INSERT INTO `otp_verification` VALUES ('32', 'rafiwar35@gmail.com', '287885', 'password_reset', '2025-12-20 18:31:23', '2025-12-20 18:41:23', '0');
INSERT INTO `otp_verification` VALUES ('33', 'rafiwar35@gmail.com', '060181', 'password_reset', '2025-12-20 18:32:04', '2025-12-20 18:42:04', '0');
INSERT INTO `otp_verification` VALUES ('34', 'pradeep56784321@gmail.com', '135199', 'email_verification', '2025-12-26 16:25:13', '2025-12-26 16:35:13', '0');
INSERT INTO `otp_verification` VALUES ('35', 'khanhalith068@gmail.com', '710830', 'email_verification', '2025-12-26 18:09:01', '2025-12-26 18:19:01', '0');
INSERT INTO `otp_verification` VALUES ('36', 'khanhalith068@gmail.com', '907911', 'email_verification', '2025-12-26 18:11:14', '2025-12-26 18:21:14', '0');
INSERT INTO `otp_verification` VALUES ('37', 'khanhalith068@gmail.com', '617167', 'email_verification', '2025-12-26 18:21:51', '2025-12-26 18:31:51', '0');
INSERT INTO `otp_verification` VALUES ('38', 'pradeepnatarajan400@gmail.com', '331928', 'email_verification', '2025-12-29 17:15:39', '2025-12-29 17:25:39', '0');
INSERT INTO `otp_verification` VALUES ('39', 'john@gmail.com', '890703', 'email_verification', '2025-12-29 18:51:20', '2025-12-29 19:01:20', '0');
INSERT INTO `otp_verification` VALUES ('40', 'rafiwar56789@gmail.com', '699377', 'email_verification', '2025-12-30 10:02:45', '2025-12-30 10:12:45', '0');
INSERT INTO `otp_verification` VALUES ('41', 'rafi3568865@gmail.com', '767988', 'email_verification', '2025-12-30 10:08:16', '2025-12-30 10:18:16', '0');
INSERT INTO `otp_verification` VALUES ('42', 'vasa@gmail.com', '577024', 'email_verification', '2025-12-30 10:40:20', '2025-12-30 10:50:20', '0');
INSERT INTO `otp_verification` VALUES ('43', 'vasa@gmail.com', '362716', 'email_verification', '2025-12-30 10:40:58', '2025-12-30 10:50:58', '0');
INSERT INTO `otp_verification` VALUES ('44', 'vasa@gmail.com', '632535', 'email_verification', '2025-12-30 10:41:20', '2025-12-30 10:51:20', '0');
INSERT INTO `otp_verification` VALUES ('45', 'mohamedhalith117@gmail.com', '691237', 'password_reset', '2025-12-30 10:47:21', '2025-12-30 10:57:21', '0');
INSERT INTO `otp_verification` VALUES ('46', 'mak.60524013@gmail.com', '242349', 'email_verification', '2025-12-30 17:03:16', '2025-12-30 17:13:16', '0');
INSERT INTO `otp_verification` VALUES ('47', 'mak.6052413@gmail.com', '322776', 'email_verification', '2025-12-30 17:04:12', '2025-12-30 17:14:12', '0');

DROP TABLE IF EXISTS `password_resets`;
CREATE TABLE `password_resets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `token` varchar(255) NOT NULL,
  `email` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `expires_at` timestamp NULL DEFAULT NULL,
  `used` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `token` (`token`),
  KEY `idx_user` (`user_id`),
  KEY `idx_token` (`token`),
  CONSTRAINT `password_resets_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `product_events`;
CREATE TABLE `product_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) DEFAULT NULL,
  `action` varchar(20) DEFAULT NULL,
  `payload` longtext DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `product_events` VALUES ('1', '1', 'create', '{\\\"id\\\":\\\"1\\\",\\\"name\\\":\\\"sofa\\\",\\\"price\\\":\\\"20000.00\\\",\\\"description\\\":\\\"\\\",\\\"image_path\\\":\\\"assets\\\\/uploads\\\\/products\\\\/prod_1_1766494782.png\\\",\\\"stock\\\":\\\"0\\\"}', '2025-12-23 18:29:42');
INSERT INTO `product_events` VALUES ('2', '1', 'delete', '{\\\"id\\\":\\\"1\\\",\\\"name\\\":\\\"sofa\\\",\\\"price\\\":\\\"20000.00\\\",\\\"description\\\":\\\"\\\",\\\"image_path\\\":\\\"assets\\\\/uploads\\\\/products\\\\/prod_1_1766494782.png\\\",\\\"stock\\\":\\\"0\\\"}', '2025-12-23 18:30:27');

DROP TABLE IF EXISTS `products`;
CREATE TABLE `products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `price` decimal(10,2) DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `image_path` varchar(255) DEFAULT NULL,
  `stock` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `services`;
CREATE TABLE `services` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `team_members`;
CREATE TABLE `team_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `designation` varchar(100) NOT NULL,
  `image_path` varchar(255) DEFAULT NULL,
  `twitter_url` varchar(255) DEFAULT NULL,
  `linkedin_url` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_created` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `team_members` VALUES ('1', 'Jake Saper', 'CEO & Founder', 'assets/img/team/team_1_1.png', 'https://twitter.com/', 'https://linkedin.com/', '2025-12-29 10:13:28', '2025-12-29 10:13:28');
INSERT INTO `team_members` VALUES ('2', 'Mari Doly', 'Chief Architect', 'assets/img/team/team_1_2.png', 'https://twitter.com/', 'https://linkedin.com/', '2025-12-29 10:13:28', '2025-12-29 10:13:28');
INSERT INTO `team_members` VALUES ('3', 'Michel Smith', 'General Manager', 'assets/img/team/team_1_3.png', 'https://twitter.com/', 'https://linkedin.com/', '2025-12-29 10:13:28', '2025-12-29 10:13:28');
INSERT INTO `team_members` VALUES ('4', 'Elis Mike', 'Assistant Architect', 'assets/img/team/team_1_4.png', 'https://twitter.com/', 'https://linkedin.com/', '2025-12-29 10:13:28', '2025-12-29 10:13:28');
INSERT INTO `team_members` VALUES ('7', 'Mohamed Halith S', 'Manager', 'assets/img/team/team_1766989806_8759.jpg', 'https://twitter.com/', 'https://linkedin.com/', '2025-12-29 12:00:06', '2025-12-29 12:00:06');

DROP TABLE IF EXISTS `upi_config`;
CREATE TABLE `upi_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(100) NOT NULL,
  `value` varchar(500) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `upi_payment_logs`;
CREATE TABLE `upi_payment_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) NOT NULL,
  `action` varchar(50) DEFAULT NULL,
  `status` varchar(50) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_transaction_id` (`transaction_id`),
  KEY `idx_created_at` (`created_at`),
  CONSTRAINT `upi_payment_logs_ibfk_1` FOREIGN KEY (`transaction_id`) REFERENCES `upi_transactions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

DROP TABLE IF EXISTS `upi_transactions`;
CREATE TABLE `upi_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `transaction_ref` varchar(100) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `upi_string` longtext NOT NULL,
  `qr_code_url` longtext DEFAULT NULL,
  `upi_id` varchar(100) DEFAULT NULL,
  `status` enum('pending','verified','completed','failed','expired') DEFAULT 'pending',
  `order_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `verified_at` timestamp NULL DEFAULT NULL,
  `completed_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `transaction_ref` (`transaction_ref`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_transaction_ref` (`transaction_ref`),
  KEY `idx_status` (`status`),
  KEY `idx_order_id` (`order_id`),
  CONSTRAINT `upi_transactions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `upi_transactions_ibfk_2` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `upi_transactions` VALUES ('3', '6', 'ORD-6-1767611694', '24700.00', 'upi://pay?pa=mohamedhaith117%40okaxis&pn=Interior+Design+Store&am=24700&tn=Order+Payment&tr=ORD-6-1767611694', 'https://api.qrserver.com/v1/create-qr-code/?size=250x250&data=upi%3A%2F%2Fpay%3Fpa%3Dmohamedhaith117%2540okaxis%26pn%3DInterior%2BDesign%2BStore%26am%3D24700%26tn%3DOrder%2BPayment%26tr%3DORD-6-1767611694', NULL, 'pending', NULL, '2026-01-05 16:44:54', NULL, NULL);
INSERT INTO `upi_transactions` VALUES ('4', '6', 'ORD-6-1767611896', '24700.00', 'upi://pay?pa=mohamedhaith117%40okaxis&pn=Interior+Design+Store&am=24700&tn=Order+Payment&tr=ORD-6-1767611896', 'https://api.qrserver.com/v1/create-qr-code/?size=250x250&data=upi%3A%2F%2Fpay%3Fpa%3Dmohamedhaith117%2540okaxis%26pn%3DInterior%2BDesign%2BStore%26am%3D24700%26tn%3DOrder%2BPayment%26tr%3DORD-6-1767611896', NULL, 'pending', NULL, '2026-01-05 16:48:16', NULL, NULL);
INSERT INTO `upi_transactions` VALUES ('5', '6', 'ORD-6-1767611985', '24700.00', 'upi://pay?pa=mohamedhalith117%40okaxis&pn=Interior+Design+Store&am=24700&tn=Order+Payment&tr=ORD-6-1767611985', 'https://api.qrserver.com/v1/create-qr-code/?size=250x250&data=upi%3A%2F%2Fpay%3Fpa%3Dmohamedhalith117%2540okaxis%26pn%3DInterior%2BDesign%2BStore%26am%3D24700%26tn%3DOrder%2BPayment%26tr%3DORD-6-1767611985', NULL, 'pending', NULL, '2026-01-05 16:49:45', NULL, NULL);
INSERT INTO `upi_transactions` VALUES ('6', '6', 'ORD-6-1767612140', '24700.00', 'upi://pay?pa=mohamedhalith117%40okaxis&pn=Interior+Design+Store&am=24700&tn=Order+Payment&tr=ORD-6-1767612140', 'https://api.qrserver.com/v1/create-qr-code/?size=250x250&data=upi%3A%2F%2Fpay%3Fpa%3Dmohamedhalith117%2540okaxis%26pn%3DInterior%2BDesign%2BStore%26am%3D24700%26tn%3DOrder%2BPayment%26tr%3DORD-6-1767612140', 'mohamedhalith117@okaxis', 'pending', NULL, '2026-01-05 16:52:20', '2026-01-05 16:53:26', NULL);
INSERT INTO `upi_transactions` VALUES ('7', '6', 'ORD-6-1767612223', '24700.00', 'upi://pay?pa=mohamedhalith117%40okaxis&pn=Interior+Design+Store&am=24700&tn=Order+Payment&tr=ORD-6-1767612223', 'https://api.qrserver.com/v1/create-qr-code/?size=250x250&data=upi%3A%2F%2Fpay%3Fpa%3Dmohamedhalith117%2540okaxis%26pn%3DInterior%2BDesign%2BStore%26am%3D24700%26tn%3DOrder%2BPayment%26tr%3DORD-6-1767612223', 'mydeenabdulkader070@okhdfcbank', 'pending', NULL, '2026-01-05 16:53:43', '2026-01-05 16:54:00', NULL);

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `email_verified` tinyint(1) DEFAULT 0,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `password_changed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `role` enum('customer','admin') NOT NULL DEFAULT 'customer',
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `two_factor_enabled` tinyint(1) DEFAULT 0,
  `two_factor_secret` varchar(255) DEFAULT NULL,
  `avatar` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `users` VALUES ('6', 'Mohamed', 'mohamedhalith117@gmail.com', '0', NULL, '+919080468168', '$2y$10$UqNRTlED3dmIxqovvOH31ezKLq.g0/VeMvY5zndygxxcUSXdYfimu', '2025-12-20 15:00:56', '2025-12-18 14:43:28', '2026-01-05 15:38:37', 'customer', 'active', '0', NULL, 'avatar_6_1767607717.jpg');
INSERT INTO `users` VALUES ('7', 'halith', 'iiidsumma@gmail.com', '0', NULL, '+919080468168', '$2y$10$8DceeNh27rjT5/bi8hIiJOePDbEFyx4YaGUnqeu6qoJJiNJLU/rIS', '2025-12-20 15:00:56', '2025-12-18 14:44:27', '2025-12-18 14:44:27', 'admin', 'active', '0', NULL, NULL);
INSERT INTO `users` VALUES ('11', 'halith', 'h@gmail.com', '0', NULL, '+919080468168', '$2y$10$U91ctf30KnDWBqpFeI2yK.kloHK3VOinQ6EutUta5fHatagEhwvP6', '2025-12-20 15:00:56', '2025-12-20 14:43:04', '2025-12-20 14:43:04', 'customer', 'active', '0', NULL, NULL);
INSERT INTO `users` VALUES ('12', 'Admin User', 'admin@faren.com', '0', NULL, '1234567890', '$2y$10$WBaucFKS5lStFoadQz4H8eITILAreBwCrCaUrxZdX3nIsKWlVEpHy', '2025-12-20 15:00:56', '2025-12-20 14:45:57', '2025-12-20 14:45:57', 'admin', 'active', '0', NULL, NULL);
INSERT INTO `users` VALUES ('13', 'mydeenabdulkader', 'mydeen123@gmail.com', '0', NULL, '9090909090', '$2y$10$WbRRohD98.bXgeYATBNw4.m0oXD1TQhesO3BsUSWSJm.GIBRdyLIC', '2025-12-20 15:00:56', '2025-12-20 14:49:13', '2025-12-20 14:49:13', 'customer', 'active', '0', NULL, NULL);
INSERT INTO `users` VALUES ('15', 'pradeep', 'pradeep56784321@gmail.com', '1', '2025-12-26 11:59:11', '1234567890', '$2y$10$gHqiZ.ZitJUzOcEpsQv2BO90jEWjP8o6A6zW5NYSTBnICNk2ek24S', '2025-12-26 16:29:11', '2025-12-26 16:29:11', '2025-12-26 16:29:11', 'customer', 'active', '0', NULL, NULL);
INSERT INTO `users` VALUES ('16', 'khan', 'khanhalith068@gmail.com', '1', '2025-12-26 13:52:49', '9090909090', '$2y$10$NDAsGZt5hf13JywOGIgf5.5kZiaOYF.wDvZteCLv2jAEuLi84lZ8a', '2025-12-26 18:22:49', '2025-12-26 18:22:49', '2025-12-26 18:22:49', 'customer', 'active', '0', NULL, NULL);
INSERT INTO `users` VALUES ('17', 'Mydeen', 'mak.6052413@gmail.com', '1', NULL, '9080908090', '$2y$10$RmB0nYEc9BhVTrpPcQ1KBuKtaeapChRFYhJ3O2bp6cUzodigk97cq', '2025-12-30 17:04:28', '2025-12-30 17:04:28', '2025-12-30 17:04:28', 'customer', 'active', '0', NULL, NULL);

SET FOREIGN_KEY_CHECKS = 1;
