<?php
/**
 * Blog Page with Database Integration
 * Displays all blog posts from the database
 */

// Include database connection
require_once __DIR__ . '/config/db.php';

// Get all blog posts from database
$blogs = [];
$query = "SELECT id, title, category, author, day, month, image_path, created_at FROM blogs ORDER BY created_at DESC";
$result = $connection->query($query);

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $blogs[] = $row;
    }
}

// Close result
if ($result) {
    $result->free();
}
?>
<!doctype html>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Faren Interior Design</title>
    <meta name="author" content="themeholy">
    <meta name="description" content="Faren   - Architecture & Interior Design Template">
    <meta name="keywords" content="Faren   - Architecture & Interior Design Template">
    <meta name="robots" content="INDEX,FOLLOW">
    <meta name="viewport" content="width=device-width,initial-scale=1,shrink-to-fit=no">
    <link rel="apple-touch-icon" sizes="57x57" href="assets/img/favicons/apple-icon-57x57.png">
    <link rel="apple-touch-icon" sizes="60x60" href="assets/img/favicons/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="assets/img/favicons/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="assets/img/favicons/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="assets/img/favicons/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="assets/img/favicons/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="assets/img/favicons/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="assets/img/favicons/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="assets/img/favicons/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192" href="assets/img/favicons/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="32x32" href="assets/img/favicons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="assets/img/favicons/favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="assets/img/favicons/favicon-16x16.png">
    <link rel="manifest" href="assets/img/favicons/manifest.json">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="assets/img/favicons/ms-icon-144x144.png">
    <meta name="theme-color" content="#ffffff">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="../../css2-1?family=DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <link rel="stylesheet" href="assets/css/swiper-bundle.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <script src="assets/js/auth-ui-global.js"></script>
</head>

<body id="show-grid">
    <!-- Compact mobile header fallback: ensures header is visible on small screens -->
    <div class="mobile-header-fixed" aria-hidden="false">
        <div class="mobile-header-inner">
            <a href="index.php" class="mobile-logo"><img src="assets/img/logo-white.svg"
                    alt="Faren" /></a>
            <div id="mobile-welcome" style="display:none; margin-left:12px; font-size:14px; color:#333; white-space:nowrap; overflow:hidden; text-overflow:ellipsis; max-width:40%;">Welcome, <span id="mobile-welcome-name"></span></div>
            <button class="mobile-menu-btn" aria-label="Open menu">
                <span class="mh-bars">☰</span>
            </button>
        </div>
    </div>
    <style>
        .mobile-header-fixed {
            display: none;
        }

        /* Mobile: 320px to 768px */
        @media (max-width: 768px) {
            .mobile-header-fixed {
                display: block;
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                height: 56px;
                background: #000000;
                z-index: 11000;
                box-shadow: 0 2px 10px rgba(0, 0, 0, 0.06);
            }

            .mobile-header-inner {
                max-width: 100%;
                margin: 0;
                padding: 8px 12px;
                display: flex;
                align-items: center;
                justify-content: space-between;
                height: 100%;
            }

            .mobile-logo img {
                height: 40px;
                display: block;
                width: auto;
            }

            .mobile-menu-btn {
                background: aliceblue;
                border: none;
                font-size: 22px;
                padding: 6px 10px;
                cursor: pointer;
                z-index: 11001;
                position: relative;
            }

            #mobile-welcome {
                display: block !important;
            }

            /* push page content down so header doesn't overlap */
            body {
                padding-top: 56px;
            }

            /* Hide desktop header on mobile */
            .sticky-wrapper,
            .th-header {
                display: none !important;
            }

            /* Ensure menu wrapper works on mobile */
            .th-menu-wrapper {
                display: block;
                pointer-events: auto;
            }

            .th-menu-wrapper .th-menu-toggle {
                z-index: 11002;
            }
        }

        /* Tablet: 769px to 1024px */
        @media (min-width: 769px) and (max-width: 1024px) {
            .mobile-header-fixed {
                display: block;
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                height: 60px;
                background: #000000;
                z-index: 11000;
                box-shadow: 0 2px 10px rgba(0, 0, 0, 0.06);
            }

            .mobile-header-inner {
                max-width: 100%;
                margin: 0;
                padding: 10px 16px;
                display: flex;
                align-items: center;
                justify-content: space-between;
                height: 100%;
            }

            .mobile-logo img {
                height: 45px;
                display: block;
                width: auto;
            }

            .mobile-menu-btn {
                background: aliceblue;
                border: none;
                font-size: 24px;
                padding: 8px 12px;
                cursor: pointer;
                z-index: 11001;
                position: relative;
            }

            #mobile-welcome {
                display: block !important;
                font-size: 15px;
            }

            body {
                padding-top: 60px;
            }

            .sticky-wrapper,
            .th-header {
                display: none !important;
            }

            .th-menu-wrapper {
                display: block;
                pointer-events: auto;
            }

            .th-menu-wrapper .th-menu-toggle {
                z-index: 11002;
            }
        }

        /* Desktop: 1025px and above */
        @media (min-width: 1025px) {
            .mobile-header-fixed {
                display: none !important;
            }

            .mobile-menu-btn {
                display: none !important;
            }

            #mobile-welcome {
                display: none !important;
            }

            body {
                padding-top: 0 !important;
            }

            .sticky-wrapper,
            .th-header {
                display: block !important;
            }

            /* Hide mobile menu on desktop */
            .th-menu-wrapper {
                display: none !important;
            }
        }
    </style>
    <div class="cursor"></div>
    <div class="cursor2"></div>
    
    <div class="loader-wrap"><svg viewbox="0 0 1000 1000" preserveaspectratio="none">
            <path id="svg" d="M0,1005S175,995,500,995s500,5,500,5V0H0Z"></path>
        </svg>
        <div class="loader-wrap-heading">
            <div class="load-text"><span>L</span> <span>o</span> <span>a</span> <span>d</span> <span>i</span>
                <span>n</span> <span>g</span>
            </div>
        </div>
    </div>
    <div class="sidemenu-wrapper">
        <div class="sidemenu-content"><button class="closeButton sideMenuCls"><i class="far fa-times"></i></button>
            <div class="widget footer-widget mb-0">
                <div class="th-widget-about">
                    <div class="about-logo"><a href="index.php"><img src="assets/img/logo.svg" alt="Faren  "></a></div>
                    <p class="about-text">Minimal interiors often feel larger than they are. Neutral colors, natural
                        materials, and an uncluttered layout help reflect light and create an airy,</p>
                </div>
            </div>
            <div class="widget footer-widget">
                <h3 class="widget_title">Featured Blog</h3>
                <div class="recent-post-wrap">
                    <div class="recent-post">
                        <div class="media-img"><a href="blog-details.php"><img
                                    src="assets/img/blog/recent-post-1-1.jpg" alt="Blog Image"></a></div>
                        <div class="media-body">
                            <div class="recent-post-meta"><a href="blog.php">June 12, 2025</a> <a href="blog.php">6
                                    min read</a></div>
                            <h4 class="post-title"><a class="text-inherit" href="blog-details.php">Good choice for
                                    premium quality interior design?</a></h4>
                        </div>
                    </div>
                    <div class="recent-post">
                        <div class="media-img"><a href="blog-details.php"><img
                                    src="assets/img/blog/recent-post-1-2.jpg" alt="Blog Image"></a></div>
                        <div class="media-body">
                            <div class="recent-post-meta"><a href="blog.php">June 12, 2025</a> <a href="blog.php">6
                                    min read</a></div>
                            <h4 class="post-title"><a class="text-inherit" href="blog-details.php">Good choice for
                                    premium quality interior design?</a></h4>
                        </div>
                    </div>
                    <div class="recent-post">
                        <div class="media-img"><a href="blog-details.php"><img
                                    src="assets/img/blog/recent-post-1-3.jpg" alt="Blog Image"></a></div>
                        <div class="media-body">
                            <div class="recent-post-meta"><a href="blog.php">June 12, 2025</a> <a href="blog.php">6
                                    min read</a></div>
                            <h4 class="post-title"><a class="text-inherit" href="blog-details.php">Good choice for
                                    premium quality interior design?</a></h4>
                        </div>
                    </div>
                    <div class="recent-post">
                        <div class="media-img"><a href="blog-details.php"><img
                                    src="assets/img/blog/recent-post-1-4.jpg" alt="Blog Image"></a></div>
                        <div class="media-body">
                            <div class="recent-post-meta"><a href="blog.php">June 12, 2025</a> <a href="blog.php">6
                                    min read</a></div>
                            <h4 class="post-title"><a class="text-inherit" href="blog-details.php">Good choice for
                                    premium quality interior design?</a></h4>
                        </div>
                    </div>
                </div>
            </div>
            <div class="widget footer-widget">
                <h3 class="widget_title">Social Media:</h3>
                <div class="th-social"><a href="https://facebook.com"><i class="fab fa-facebook-f"></i></a> <a
                        href="https://twitter.com"><i class="fab fa-twitter"></i></a> <a href="https://pinterest.com"><i
                            class="fab fa-pinterest-p"></i></a> <a href="https://linkedin.com"><i
                            class="fab fa-linkedin-in"></i></a> <a href="https://linkedin.com"><i
                            class="fab fa-instagram"></i></a></div>
            </div>
        </div>
    </div>
    <div class="popup-search-box d-none d-lg-block"><button class="searchClose"><i class="fal fa-times"></i></button>
        <form action="#"><input type="text" placeholder="What are you looking for?"> <button type="submit"><i
                    class="fal fa-search"></i></button></form>
    </div>
    <div class="th-menu-wrapper">
        <div class="th-menu-area text-center"><button class="th-menu-toggle"><i class="fal fa-times"></i></button>
            <div class="  mobile-logo ">
                <div class="company-welcome" style="margin-bottom:8px; font-size:14px; color:var(--body-color);">Welcome to FAREN INTERIOR</div>
                <a href="index.php"><img src="assets/img/logo.svg" alt="Faren  "></a>
            </div>
            <div class="th-mobile-menu">
                <ul>
                    <li class="menu-item-has-children"><a href="index.php">Home</a>
                        
                    </li>
                    <li class="menu-item-has-children"><a href="about.php">About</a>
                        <ul class="sub-menu">
                            <li><a href="team.php">Team</a></li>
                            <li><a href="blog.php">Blog</a></li>
                            <li><a href="faq.php">FAQ</a></li>
                        </ul>
                    </li>
                    <li class="menu-item-has-children"><a href="service.php">Services</a>
                        <ul class="sub-menu">
                            <li><a href="commercial.php">Commercial</a></li>
                            <li><a href="exterior.php">Exterior</a></li>
                            <li><a href="decor.php">Decor & Art</a></li>
                            <li><a href="multipurpose.php">Residential</a></li>
                            
                        </ul>
                    </li>
                    <li class="menu-item-has-children"><a href="project.php">Projects</a>
                       
                    </li>
                    <li class="menu-item-has-children"><a href="gallery.php">gallery</a>
                    </li>
                    <li class="menu-item-has-children"><a href="shop.php">shop</a>
                        <ul class="sub-menu">
                            <li><a href="shop.php">Shop</a></li>
                            <li><a href="shop-details.php">Shop Details</a></li>
                        </ul>


                    <li class="menu-item-has-children"><a href="cart.php">cart</a>
                        <ul class="sub-menu">
                           
                            <li><a href="orders.php">orders</a></li>
                            <li><a href="checkout.php">Checkout</a></li>
                            <li><a href="my-wishlist.php">Wishlist</a></li>
                        </ul>
                    </li>
                    </li>
                    
                    </li>
                    <li><a href="contact.php">Contact</a></li>
                    
                </ul>
                
            </div>
        </div>
    </div>
    <style>
        /* Responsive styles for mobile auth buttons inside the mobile menu */
        .th-mobile-menu .mobile-auth-links button,
        .th-mobile-menu .mobile-user-item > .mobile-user-toggle,
        .th-mobile-menu .mobile-user-item .sub-menu button.mobile-logout {
            display: block;
            width: 100%;
            text-align: left;
            padding: 12px 16px;
            font-size: 16px;
            border: none;
            background: transparent;
            color: #111;
            cursor: pointer;
        }

        /* Primary style for Login/Register buttons */
        .th-mobile-menu .mobile-auth-links button {
            background: #d4a33a;
            color: #ffffff;
            border-radius: 6px;
            margin: 6px 0;
        }

        .th-mobile-menu .mobile-auth-links button:hover {
            opacity: 0.95;
        }

        /* Keep user submenu hidden by default and indented */
        .th-mobile-menu .mobile-user-item .sub-menu {
            display: none;
            padding-left: 12px;
            margin: 6px 0 12px 0;
        }

        /* Smaller devices adjustments */
        @media (max-width: 480px) {
            .th-mobile-menu .mobile-auth-links button,
            .th-mobile-menu .mobile-user-item > .mobile-user-toggle {
                font-size: 14px;
                padding: 10px 12px;
            }
        }
    </style>
    
    <header class="th-header header-layout8 header-absolute">
        <div class="top-header">
            <style>
                .top-header {
                    width: 100%;
                    background: #000000;
                    padding: 6px 0;
                }

                /* White text + icons */
                .top-header-inner,
                .top-header-inner a,
                .top-header-inner i {
                    color: #ffffff !important;
                }

                /* Hover turns black */
                .top-header-inner a:hover,
                .top-header-inner i:hover {
                    color: #f44646 !important;
                }

                /* Flex alignment stays same */
                .top-header-inner {
                    display: flex;
                    justify-content: space-between;
                    align-items: center;
                    padding: 0 5%;
                }


                .welcome-text {
                    color: #ffffff !important;
                    font-size: 15px;
                    font-weight: 500;
                }


                .social-icons a {
                    color: #111A1E;
                    margin-left: 15px;
                    font-size: 16px;
                    transition: .3s;
                }

                .social-icons a:hover {
                    color: #ffffff;
                    transform: scale(1.15);
                }

                /* Auth Buttons */
                .auth-buttons {
                    display: flex;
                    gap: 12px;
                    justify-content: center;
                }

                .auth-btn {
                    padding: 10px 20px;
                    border-radius: 4px;
                    font-weight: 600;
                    font-size: 14px;
                    text-decoration: none;
                    transition: all 0.3s ease;
                    border: 2px solid #d4a33a;
                }

                .login-btn {
                    background-color: #d4a33a;
                    color: #ffffff;
                }

                .login-btn:hover {
                    background-color: #ffffff;
                    color: #d4a33a;
                }

                .register-btn {
                    background-color: transparent;
                    color: #d4a33a;
                }

                .register-btn:hover {
                    background-color: #d4a33a;
                    color: #ffffff;
                }
            </style>
            <div class="container-fluid top-header-inner">

                <div class="welcome-text">
                    Welcome to Faren Interior Design
                </div>

                <div class="social-icons">
                    <a href="#"><i class="fa-brands fa-facebook-f"></i></a>
                    <a href="#"><i class="fa-brands fa-twitter"></i></a>
                    <a href="#"><i class="fa-brands fa-instagram"></i></a>
                    <a href="#"><i class="fa-brands fa-whatsapp"></i></a>
                    <a href="#"><i class="fa-brands fa-youtube"></i></a>
                </div>

            </div>
            <!--  -->
            <div class="contact-strip" style="padding-left: 135px;">
                <style>
                    .contact-strip {
                        width: 100%;
                        background: #ffffff;
                        display: grid;
                        grid-template-columns: repeat(4, 1fr);
                        padding: 7px 10px;
                        align-items: center;
                        border-bottom: 3px solid #d4a33a;
                    }

                    .strip-logo {
                        display: flex;
                        align-items: center;
                        justify-content: center;
                    }

                    .contact-item {
                        display: flex;
                        align-items: center;
                        gap: 12px;
                    }

                    .contact-icon {
                        font-size: 26px;
                        color: #d4a33a;
                    }

                    .contact-title {
                        margin: 0;
                        font-size: 16px;
                        font-weight: 700;
                        color: #000;
                    }

                    .contact-text {
                        margin: 0;
                        font-size: 15px;
                        color: #666;
                    }

                    /* ================= RESPONSIVE ================= */

                    /* Tablet */
                    @media(max-width: 992px) {
                        .contact-strip {
                            grid-template-columns: repeat(2, 1fr);
                            row-gap: 15px;
                        }
                    }

                    /* MOBILE — RESPONSIVE LAYOUT */
                    @media(max-width: 600px) {

                        /* Hide entire top header */
                        .top-header {
                            display: none;
                        }

                        /* Make contact strip mobile responsive */
                        .contact-strip {
                            display: grid;
                            grid-template-columns: 1fr;
                            gap: 10px;
                            padding: 10px;
                            padding-left: 10px !important;
                        }

                        /* Hide contact info items on mobile, keep only auth/profile */
                        .contact-strip>.contact-item:nth-child(1),
                        .contact-strip>.contact-item:nth-child(2),
                        .contact-strip>.contact-item:nth-child(3) {
                            display: none;
                        }

                        /* Auth buttons - stack vertically on mobile */
                        #auth-section {
                            display: flex;
                            flex-direction: row;
                            gap: 8px;
                            justify-content: center;
                            width: 100%;
                        }

                        .auth-btn {
                            padding: 8px 14px;
                            font-size: 12px;
                            flex: 1;
                            max-width: 120px;
                        }

                        /* User profile section - center on mobile */
                        #user-profile-section {
                            display: flex !important;
                            justify-content: center;
                            width: 100%;
                        }

                        /* User profile wrapper adjustments */
                        .user-profile-wrapper {
                            position: relative;
                            display: flex;
                            align-items: center;
                            gap: 8px;
                        }

                        /* Mobile avatar size */
                        .user-profile-wrapper>div:first-child {
                            width: 38px;
                            height: 38px;
                            font-size: 14px;
                        }

                        /* Mobile text sizing */
                        .user-profile-wrapper .contact-title {
                            font-size: 12px;
                        }

                        .user-profile-wrapper .contact-text {
                            font-size: 11px;
                        }

                        /* Dropdown positioning for mobile */
                        #userDropdown {
                            position: absolute;
                            top: 50px;
                            left: 0;
                            min-width: 160px;
                        }
                    }
                </style>

                <div class="contact-item">
                    <i class="fa-solid fa-phone contact-icon"></i>
                    <div>
                        <p class="contact-title">Call Us:</p>
                        <p class="contact-text">+00 (123) 666 000 666</p>
                    </div>
                </div>

                <div class="contact-item">
                    <i class="fa-solid fa-envelope contact-icon"></i>
                    <div>
                        <p class="contact-title">Mail Us:</p>
                        <p class="contact-text">info@feren.com</p>
                    </div>
                </div>

                <div class="contact-item">
                    <i class="fa-solid fa-location-dot contact-icon"></i>
                    <div>
                        <p class="contact-title">Location:</p>
                        <p class="contact-text">Coimbatore, Tamil Nadu</p>
                    </div>
                </div>

                <!-- Auth Section: Show login/register for non-logged-in users -->
                <div class="contact-item auth-buttons" id="auth-section" style="display: flex;">
                    <a href="auth-system/login.php" class="auth-btn login-btn">Login</a>
                    <a href="auth-system/register.php" class="auth-btn register-btn">Register</a>
                </div>

                <!-- User Profile Section with Dropdown: Show for logged-in users -->
                <div class="contact-item user-profile" id="user-profile-section" style="display: none !important;">
                    <div class="user-profile-wrapper"
                        style="position: relative; display: flex; align-items: center; gap: 10px;">
                        <div class="user-avatar-circle" style="width: 45px; height: 45px; background: #d4a33a; border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; cursor: pointer; overflow: hidden;">
                            <img id="user-avatar-img" src="" alt="User avatar" style="display:none; width:100%; height:100%; object-fit:cover;">
                            <span id="user-avatar">U</span>
                        </div>
                        <div style="cursor: pointer;">
                            <p class="contact-title" style="margin-bottom: 2px;">Welcome</p>
                            <p class="contact-text" id="user-name-display">User</p>
                        </div>

                        <!-- Dropdown Menu -->
                        <div id="userDropdown" style="
                display: none;
                position: absolute;
                top: 65px;
                left: 0;
                background: white;
                border: 1px solid #ddd;
                border-radius: 5px;
                box-shadow: 0 4px 12px rgba(0,0,0,0.15);
                min-width: 180px;
                z-index: 999;
            ">
                                <button type="button" class="dropdown-item" data-href="customer-dashboard.php">📊 Dashboard</button>
                                <button type="button" class="dropdown-item" data-href="auth-system/logout.php">🚪 Logout</button>
                        </div>
                    </div>
                </div>

                <script>
                    // Update auth UI based on localStorage and add dropdown functionality
                    document.addEventListener('DOMContentLoaded', function () {
                        const userProfile = document.querySelector('.user-profile-wrapper');
                        const dropdown = document.getElementById('userDropdown');

                        if (userProfile && dropdown) {
                            userProfile.addEventListener('click', function (e) {
                                e.stopPropagation();
                                dropdown.style.display = dropdown.style.display === 'none' ? 'block' : 'none';
                            });

                            // delegated handler for dropdown buttons (Dashboard / Logout)
                            dropdown.addEventListener('click', function (evt) {
                                const t = evt.target;
                                if (!t) return;
                                
                                // Dashboard button: route based on user role
                                if (t.matches('.dropdown-item') && t.textContent.includes('Dashboard')) {
                                    const role = localStorage.getItem('userRole');
                                    const target = role === 'admin' ? 'admin-dashboard.php' : 'customer-dashboard.php';
                                    window.location.href = target;
                                    return;
                                }
                                
                                // Other dropdown items
                                if (t.matches('.dropdown-item')) {
                                    const href = t.getAttribute('data-href');
                                    if (!href) return;
                                    // if logout, clear local state first
                                    if (href.indexOf('logout') !== -1) {
                                        localStorage.setItem('userLoggedIn', 'false');
                                        localStorage.removeItem('userName');
                                    }
                                    window.location.href = href;
                                }
                            });

                            document.addEventListener('click', function () {
                                dropdown.style.display = 'none';
                            });
                        }
                        try { updateMobileAvatar(); } catch (e) {}
                    });

                    // Update auth UI based on localStorage - runs immediately
                    (function updateAuthUI() {
                        const isLoggedIn = localStorage.getItem('userLoggedIn') === 'true';
                        const authSection = document.getElementById('auth-section');
                        const userProfileSection = document.getElementById('user-profile-section');
                        const mobileMenuList = document.querySelector('.th-mobile-menu ul');

                        function renderMobileAuth() {
                            if (!mobileMenuList) return;
                                if (isLoggedIn) {
                                const userName = localStorage.getItem('userName') || 'User';
                                mobileMenuList.insertAdjacentHTML('beforeend', `\n                                    <li class="mobile-user-item th-item-has-children">\n                                        <button type="button" class="mobile-user-toggle">\n                                            <span class="mobile-avatar">${(localStorage.getItem('userName')||'U').charAt(0).toUpperCase()}</span>\n                                            <span class="mobile-user-name">${userName}</span>\n                                        </button>\n                                        <ul class="sub-menu th-submenu">\n                                            <li><button type="button" class="mobile-dashboard th-submenu-btn">Dashboard</button></li>\n                                            <li><button type="button" data-href="auth-system/logout.php" class="mobile-logout th-submenu-btn">Logout</button></li>\n                                        </ul>\n                                    </li>`);
                            } else {
                                mobileMenuList.insertAdjacentHTML('beforeend', `\n                                    <li class="mobile-auth-links">\n                                        <button type="button" data-href="auth-system/login.php" class="mobile-login-btn">Login</button>\n                                    </li>\n                                    <li class="mobile-auth-links">\n                                        <button type="button" data-href="auth-system/register.php" class="mobile-register-btn">Register</button>\n                                    </li>`);
                            }
                        }

                        // clear any previous mobile auth items then re-render
                        if (mobileMenuList) {
                            mobileMenuList.querySelectorAll('.mobile-user-item, .mobile-auth-links').forEach(n => n.remove());
                        }

                        if (isLoggedIn) {
                            if (authSection) authSection.style.display = 'none';
                            if (userProfileSection) {
                                userProfileSection.style.display = 'flex';
                                const userName = localStorage.getItem('userName') || 'User';
                                const userNameDisplay = document.getElementById('user-name-display');
                                const userAvatar = document.getElementById('user-avatar');
                                const userAvatarImg = document.getElementById('user-avatar-img');
                                const profileWrapper = document.querySelector('.user-profile-wrapper');
                                if (userNameDisplay) userNameDisplay.textContent = userName;
                                const avatarUrl = localStorage.getItem('userAvatarUrl');
                                if (avatarUrl && userAvatarImg) {
                                    userAvatarImg.src = avatarUrl;
                                    userAvatarImg.style.display = 'block';
                                    if (userAvatar) userAvatar.style.display = 'none';
                                    if (profileWrapper) profileWrapper.classList.add('has-avatar');
                                } else {
                                    if (userAvatarImg) userAvatarImg.style.display = 'none';
                                    if (userAvatar) { userAvatar.style.display = 'inline-block'; userAvatar.textContent = userName.charAt(0).toUpperCase(); }
                                    if (profileWrapper) profileWrapper.classList.remove('has-avatar');
                                }
                            }
                        } else {
                            if (authSection) authSection.style.display = 'flex';
                            if (userProfileSection) userProfileSection.style.display = 'none';
                        }

                        renderMobileAuth();

                        // update mobile welcome strip (top header) when on small screens
                        (function updateMobileWelcome() {
                            const mw = document.getElementById('mobile-welcome');
                            const mwName = document.getElementById('mobile-welcome-name');
                            if (!mw) return;
                            if (isLoggedIn) {
                                const name = localStorage.getItem('userName') || 'User';
                                if (mwName) mwName.textContent = name;
                                mw.style.display = 'block';
                            } else {
                                mw.style.display = 'none';
                            }
                        })();

                        // update avatar images if uploaded
                        try { updateMobileAvatar(); } catch (e) {}

                        // attach delegated handlers for mobile auth buttons
                        if (mobileMenuList) {
                            mobileMenuList.addEventListener('click', function (e) {
                                const t = e.target;
                                // logout button: clear state then navigate to server logout
                                if (t && t.matches('.mobile-logout')) {
                                    localStorage.setItem('userLoggedIn', 'false');
                                    localStorage.removeItem('userName');
                                    const href = t.getAttribute('data-href') || 'auth-system/logout.php';
                                    window.location.href = href;
                                    return;
                                }
                                // mobile dashboard button: route based on stored userRole
                                if (t && t.matches('.mobile-dashboard')) {
                                    const role = localStorage.getItem('userRole');
                                    const target = role === 'admin' ? 'admin-dashboard.php' : 'customer-dashboard.php';
                                    const loggedInLocal = localStorage.getItem('userLoggedIn') === 'true';
                                    if (loggedInLocal) {
                                        window.location.href = target;
                                    } else {
                                        // Probe the target on the server to see if an active session allows access.
                                        // If the server returns 200 we navigate directly; otherwise fall back to login with next.
                                        fetch(target, { method: 'HEAD', credentials: 'same-origin', redirect: 'manual' })
                                            .then(function (resp) {
                                                if (resp && resp.status >= 200 && resp.status < 300) {
                                                    window.location.href = target;
                                                } else {
                                                    try { localStorage.setItem('redirectTo', target); } catch (e) {}
                                                    window.location.href = 'auth-system/login.php?next=' + encodeURIComponent(target);
                                                }
                                            })
                                            .catch(function () {
                                                try { localStorage.setItem('redirectTo', target); } catch (e) {}
                                                window.location.href = 'auth-system/login.php?next=' + encodeURIComponent(target);
                                            });
                                    }
                                    return;
                                }
                                // login/register buttons: navigate to pages
                                if (t && t.matches('.mobile-login-btn')) {
                                    const href = t.getAttribute('data-href') || 'auth-system/login.php';
                                    window.location.href = href;
                                    return;
                                }
                                if (t && t.matches('.mobile-register-btn')) {
                                    const href = t.getAttribute('data-href') || 'auth-system/register.php';
                                    window.location.href = href;
                                    return;
                                }
                                // toggle user sub-menu when clicking the user button
                                if (t && t.matches('.mobile-user-toggle')) {
                                    const li = t.closest('li');
                                    if (!li) return;
                                    const submenu = li.querySelector('.sub-menu');
                                    if (submenu) submenu.style.display = submenu.style.display === 'block' ? 'none' : 'block';
                                }
                            });
                        }
                    })();

                    // Listen for storage changes across tabs and update mobile menu as well
                    window.addEventListener('storage', function () {
                        const isLoggedIn = localStorage.getItem('userLoggedIn') === 'true';
                        const authSection = document.getElementById('auth-section');
                        const userProfileSection = document.getElementById('user-profile-section');
                        const mobileMenuList = document.querySelector('.th-mobile-menu ul');

                        // update header sections
                        if (isLoggedIn) {
                            if (authSection) authSection.style.display = 'none';
                            if (userProfileSection) {
                                userProfileSection.style.display = 'flex';
                                const userName = localStorage.getItem('userName') || 'User';
                                const userNameDisplay = document.getElementById('user-name-display');
                                const userAvatar = document.getElementById('user-avatar');
                                if (userNameDisplay) userNameDisplay.textContent = userName;
                                if (userAvatar) userAvatar.textContent = userName.charAt(0).toUpperCase();
                            }
                        } else {
                            if (authSection) authSection.style.display = 'flex';
                            if (userProfileSection) userProfileSection.style.display = 'none';
                        }

                        // update mobile menu auth links
                        if (mobileMenuList) {
                            // remove old mobile auth items
                            mobileMenuList.querySelectorAll('.mobile-user-item, .mobile-auth-links').forEach(n => n.remove());
                            if (isLoggedIn) {
                                const userName = localStorage.getItem('userName') || 'User';
                                mobileMenuList.insertAdjacentHTML('beforeend', `\n                                    <li class="mobile-user-item th-item-has-children">\n                                        <button type="button" class="mobile-user-toggle">\n                                            <span class="mobile-avatar">${(localStorage.getItem('userName')||'U').charAt(0).toUpperCase()}</span>\n                                            <span class="mobile-user-name">${userName}</span>\n                                        </button>\n                                        <ul class="sub-menu th-submenu">\n                                            <li><button type="button" class="mobile-dashboard th-submenu-btn">Dashboard</button></li>\n                                            <li><button type="button" data-href="auth-system/logout.php" class="mobile-logout th-submenu-btn">Logout</button></li>\n                                        </ul>\n                                    </li>`);
                            } else {
                                mobileMenuList.insertAdjacentHTML('beforeend', `\n                                    <li class="mobile-auth-links">\n                                        <a href="auth-system/login.php">Login</a>\n                                    </li>\n                                    <li class="mobile-auth-links">\n                                        <a href="auth-system/register.php">Register</a>\n                                    </li>`);
                            }
                        }
                    });
                </script>
                <style>
                    /* Responsive user profile and dropdown styles */
                    #user-profile-section .user-profile-wrapper { align-items: center; }
                    #user-profile-section #user-avatar { font-size: 18px; }
                    #user-profile-section #user-avatar-img { width: 45px; height: 45px; border-radius: 50%; display: none; }
                    .user-profile-wrapper.has-avatar #user-avatar { display: none; }
                    .user-profile-wrapper.has-avatar #user-avatar-img { display: block; }
                    #userDropdown .dropdown-item {
                        display: block;
                        width: 100%;
                        text-align: left;
                        padding: 10px 14px;
                        border: none;
                        background: transparent;
                        color: #333;
                        font-size: 15px;
                        cursor: pointer;
                    }
                    #userDropdown .dropdown-item:hover { background: #f5f5f5; color: #d4a33a; }

                    /* on small screens make the dropdown full-width below header */
                    @media (max-width: 768px) {
                        #userDropdown {
                            position: fixed !important;
                            top: 56px !important;
                            right: 8px !important;
                            left: 8px !important;
                            min-width: unset !important;
                            border-radius: 8px !important;
                            padding: 6px 0 !important;
                        }
                        #user-profile-section .user-profile-wrapper { gap: 8px; }
                        #user-profile-section .contact-title { display: none; }
                        #user-profile-section .contact-text { font-size: 14px; }
                        #userDropdown .dropdown-item { font-size: 16px; padding: 12px 18px; }
                    }
                    /* Mobile user item styles */
                    .mobile-user-toggle {
                        display: inline-flex;
                        align-items: center;
                        gap: 10px;
                        width: 100%;
                        padding: 10px 14px;
                        border: none;
                        background: transparent;
                        text-align: left;
                        cursor: pointer;
                        font-size: 15px;
                        color: #111;
                    }
                    .mobile-avatar {
                        display: inline-flex;
                        align-items: center;
                        justify-content: center;
                        width: 36px;
                        height: 36px;
                        border-radius: 50%;
                        background: var(--theme-color);
                        color: #fff;
                        font-weight: 700;
                        font-size: 14px;
                        flex: 0 0 36px;
                    }
                    .mobile-avatar-img {
                        width: 36px;
                        height: 36px;
                        border-radius: 50%;
                        object-fit: cover;
                        display: inline-block;
                    }
                    .mobile-user-name { font-weight: 700; }
                    .th-submenu { padding-left: 12px; }
                    .th-submenu .th-submenu-btn {
                        display: block;
                        width: 100%;
                        padding: 12px 14px;
                        border: none;
                        background: transparent;
                        text-align: left;
                        font-size: 15px;
                        color: #222;
                        cursor: pointer;
                    }
                    .th-submenu .th-submenu-btn:hover { background: #f7f7f7; color: var(--theme-color); }
                </style>
                <script>
                    // Utility: Replace avatar initials with uploaded image if available
                    function updateMobileAvatar() {
                        try {
                            const avatarUrl = localStorage.getItem('userAvatarUrl');
                            document.querySelectorAll('.mobile-user-item .mobile-avatar').forEach(function (el) {
                                const name = localStorage.getItem('userName') || 'User';
                                if (avatarUrl) {
                                    // if image already present, update src
                                    let img = el.querySelector('img.mobile-avatar-img');
                                    if (!img) {
                                        img = document.createElement('img');
                                        img.className = 'mobile-avatar-img';
                                        el.innerHTML = '';
                                        el.appendChild(img);
                                    }
                                    img.src = avatarUrl;
                                    img.alt = name;
                                } else {
                                    // show initial
                                    el.textContent = (name || 'U').charAt(0).toUpperCase();
                                }
                            });
                        } catch (e) { /* ignore */ }
                    }
                    // Hook mobile header button to menu toggle
                    (function () {
                        const mobileBtn = document.querySelector('.mobile-menu-btn');
                        if (!mobileBtn) return;
                        mobileBtn.addEventListener('click', function (e) {
                            e.preventDefault();
                            const wrapper = document.querySelector('.th-menu-wrapper');
                            if (wrapper) {
                                wrapper.classList.toggle('th-body-visible');
                                document.body.classList.toggle('th-body-visible');
                            }
                        });
                    })();
                    // Hook close button inside menu
                    (function () {
                        const closeBtn = document.querySelector('.th-menu-wrapper .th-menu-toggle');
                        if (!closeBtn) return;
                        closeBtn.addEventListener('click', function (e) {
                            e.preventDefault();
                            const wrapper = document.querySelector('.th-menu-wrapper');
                            if (wrapper) {
                                wrapper.classList.remove('th-body-visible');
                                document.body.classList.remove('th-body-visible');
                            }
                        });
                    })();
                </script>

            </div>

            <div class="sticky-wrapper">
                <div class="container th-container5">
                    <div class="menu-area">
                        <div class="row align-items-center justify-content-between">
                            <div class="col-auto">
                                <div class="header-logo"><a href="index.php"><img
                                            src="assets/img/logo-white.svg" alt="Faren  "></a></div>
                            </div>
                            <div class="col-auto">
                                <nav class="main-menu d-none d-lg-inline-block">
                                    <ul>
                                        <li class="menu-item-has-children"><a
                                                href="index.php">Home</a>

                                        </li>
                                        <li class="menu-item-has-children"><a href="about.php">About</a>
                                            <ul class="sub-menu">
                                                <li><a href="team.php">Team</a></li>
                                                <li><a href="blog.php">Blog</a></li>
                                                <li><a href="faq.php">FAQ</a></li>
                                            </ul>
                                        </li>
                                        <li class="menu-item-has-children"><a href="service.php">Services</a>
                                            <ul class="sub-menu">
                                                <li><a href="commercial.php">Commercial</a></li>
                                                <li><a href="exterior.php">Exterior</a></li>
                                                <li><a href="decor.php">Decor & Art</a></li>
                                                <li><a href="multipurpose.php">Residential</a></li>
                                            </ul>
                                        </li>
                                        <li class="menu-item-has-children"><a href="project.php">Projects</a>
                                           
                                        </li>
                                        <li class="menu-item-has-children"><a href="gallery.php">gallery</a>
                                        </li>
                                        <li class="menu-item-has-children"><a href="shop.php">shop</a>
                                           


                                        <li class="menu-item-has-children"><a href="cart.php">cart</a>
                                            <ul class="sub-menu">
                                                <!-- <li><a href="pricing.html">Price Table</a></li> -->
                                                <li><a href="orders.php">Orders</a></li>
                                                <li><a href="checkout.php">Checkout</a></li>
                                                <li><a href="my-wishlist.php">Wishlist</a></li>
                                            </ul>
                                        </li>
                                        </li>
                                       
                                        </li>
                                        <li><a href="contact.php">Contact</a></li>
                                    </ul>
                                </nav>
                            </div>
                            <div class="col-auto">
                                <div class="header-button d-none d-lg-flex"><a href="consultation.php"
                                        class="th-btn white-border">Get Free Consultant</a> <button type="button"
                                        class="icon-btn sideMenuToggler d-none d-lg-block"><i
                                            class="fa-regular fa-bars"></i></button></div>
                                <div class="header-button"><button type="button"
                                        class="th-menu-toggle d-inline-block d-lg-none"><i
                                            class="far fa-bars"></i></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </header>

    <!-- Blog Section -->
    <section class="th-blog-wrapper space-top space-extra-bottom" style="padding-top: 310px;">
        <div class="container">
            <div class="row">
                <div class="col-xxl-8 col-lg-7">
                    <div class="row">
                        <style>
                            .single-grid {
                                border-radius: 20px;
                                overflow: hidden;
                                background: #ffffff;
                                border: 1px solid rgba(0,0,0,0.08);
                                transition: .45s ease;
                                box-shadow: 0 12px 28px rgba(0,0,0,0.08);
                                position: relative;
                            }
                            .single-grid:hover {
                                transform: translateY(-10px);
                                box-shadow: 0 20px 40px rgba(0,0,0,0.15);
                            }
                            .single-grid::before {
                                content: "";
                                position: absolute;
                                top: 0;
                                left: 0;
                                height: 4px;
                                width: 0%;
                                background: linear-gradient(90deg,#6f63ff,#9c89ff,#6f63ff);
                                transition: .45s ease;
                            }
                            .single-grid:hover::before { width: 100%; }
                            .single-grid .blog-img img {
                                width: 100%;
                                height: auto;
                                border-radius: 18px;
                                transition: transform .55s ease, filter .35s ease;
                            }
                            .single-grid:hover .blog-img img {
                                transform: scale(1.12);
                                filter: brightness(1.1);
                            }
                            .single-grid .blog-content { padding: 22px 20px 25px; }
                            .blog-meta a {
                                font-size: 14px;
                                color: #6d6d8f;
                                margin-right: 12px;
                                font-weight: 600;
                                transition: .25s ease;
                            }
                            .blog-meta a:hover { color: #6f63ff; text-shadow: 0 0 8px rgba(111,99,255,0.35); }
                            .single-grid .box-title {
                                font-size: 22px;
                                font-weight: 700;
                                color: #222243;
                                transition: .35s ease;
                                line-height: 1.35;
                            }
                            .single-grid:hover .box-title { color: #ff9558; text-shadow: 0 0 10px rgba(111,99,255,0.25); }
                            .single-grid .th-btn.th-border {
                                padding: 10px 22px;
                                border-radius: 10px;
                                border: 2px solid #6f63ff;
                                transition: .35s ease;
                                font-size: 14px;
                                font-weight: 600;
                            }
                            .single-grid:hover .th-btn.th-border {
                                background: #6f63ff;
                                color: #fff;
                                box-shadow: 0 8px 18px rgba(111,99,255,0.25);
                            }
                            .blog-date {
                                text-align: right;
                                font-weight: 700;
                                color: #222;
                                transition: .3s ease;
                            }
                            .blog-date .date {
                                display: block;
                                font-size: 26px;
                                line-height: 1;
                            }
                            .blog-date .month {
                                font-size: 12px;
                                letter-spacing: 1px;
                                color: #888;
                            }
                            .single-grid:hover .blog-date { color: #6f63ff; text-shadow: 0 0 8px rgba(111,99,255,0.25); }
                            .no-blogs {
                                grid-column: 1 / -1;
                                text-align: center;
                                padding: 40px;
                                color: #999;
                            }
                            @media(max-width: 992px) {
                                .single-grid .box-title { font-size: 20px; }
                            }
                            @media(max-width: 768px) {
                                .single-grid { border-radius: 16px; }
                                .single-grid .blog-content { padding: 18px 16px; }
                            }
                            @media(max-width: 480px) {
                                .single-grid .box-title { font-size: 18px; }
                                .blog-meta a { font-size: 13px; }
                            }
                        </style>

                        <!-- Blog Posts from Database -->
                        <?php if (count($blogs) > 0): ?>
                            <?php foreach ($blogs as $blog): ?>
                                <div class="col-xl-6">
                                    <div class="th-blog blog-single has-post-thumbnail single-grid">
                                        <div class="blog-img global-img">
                                            <a href="blog-details.php?id=<?php echo htmlspecialchars($blog['id']); ?>">
                                                <img src="<?php echo htmlspecialchars($blog['image_path']); ?>" alt="<?php echo htmlspecialchars($blog['title']); ?>">
                                            </a>
                                        </div>
                                        <div class="blog-content">
                                            <div class="blog-meta">
                                                <a href="blog.php?category=<?php echo urlencode($blog['category']); ?>"><?php echo htmlspecialchars($blog['category']); ?></a>
                                                <a class="author" href="#">by <?php echo htmlspecialchars($blog['author']); ?></a>
                                            </div>
                                            <h2 class="box-title">
                                                <a href="blog-details.php?id=<?php echo htmlspecialchars($blog['id']); ?>">
                                                    <?php echo htmlspecialchars($blog['title']); ?>
                                                </a>
                                            </h2>
                                            <div class="btn-group justify-content-between">
                                                <a href="blog-details.php?id=<?php echo htmlspecialchars($blog['id']); ?>" class="th-btn th-border">Read More</a>
                                                <div class="blog-date">
                                                    <span class="date"><?php echo htmlspecialchars($blog['day']); ?></span>
                                                    <span class="month"><?php echo htmlspecialchars($blog['month']); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <div class="col-12 no-blogs">
                                <h3>No blog posts yet</h3>
                                <p>Check back soon for exciting content!</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Sidebar -->
                <div class="col-xxl-4 col-lg-5">
                    <aside class="sidebar-area style2">
                        <div class="widget widget_search">
                            <style>
                                .widget_search .search-form {
                                    position: relative;
                                    display: flex;
                                    align-items: center;
                                    background: rgba(255,255,255,0.65);
                                    border-radius: 14px;
                                    padding: 12px 14px;
                                    border: 1px solid rgba(0,0,0,0.08);
                                    backdrop-filter: blur(14px);
                                    transition: .35s ease;
                                    box-shadow: 0 6px 18px rgba(0,0,0,0.08);
                                }
                                .widget_search .search-form:hover {
                                    transform: translateY(-4px);
                                    box-shadow: 0 12px 28px rgba(111,99,255,0.25);
                                    border-color: rgba(111,99,255,0.4);
                                }
                                .widget_search .search-form input {
                                    width: 100%;
                                    padding: 12px 10px;
                                    border: none;
                                    background: transparent;
                                    font-size: 15px;
                                    font-weight: 500;
                                    color: #2d2d50;
                                    outline: none;
                                    transition: .35s ease;
                                }
                                .widget_search .search-form input:focus { letter-spacing: 0.5px; }
                                .widget_search .search-form button {
                                    background: #6f63ff;
                                    border: none;
                                    width: 42px;
                                    height: 42px;
                                    border-radius: 12px;
                                    display: flex;
                                    justify-content: center;
                                    align-items: center;
                                    color: #fff;
                                    transition: .35s ease;
                                    cursor: pointer;
                                }
                                .widget_search .search-form button:hover {
                                    background: #5547ff;
                                    box-shadow: 0 0 12px rgba(111,99,255,0.45);
                                }
                                .widget_search .search-form button i {
                                    font-size: 18px;
                                    transition: .45s ease;
                                }
                                .widget_search .search-form button:hover i {
                                    transform: rotate(20deg) scale(1.1);
                                }
                            </style>
                            <form class="search-form" action="blog.php" method="GET">
                                <input type="text" name="search" placeholder="Search blogs..." value="<?php echo isset($_GET['search']) ? htmlspecialchars($_GET['search']) : ''; ?>">
                                <button type="submit"><i class="far fa-search"></i></button>
                            </form>
                        </div>

                        <!-- Featured Blog Widget -->
                        <div class="widget">
                            <style>
                                .widget .widget_title {
                                    font-size: 22px;
                                    font-weight: 800;
                                    margin-bottom: 18px;
                                    color: #2f2f49;
                                    position: relative;
                                    display: inline-block;
                                }
                                .widget .widget_title::after {
                                    content: "";
                                    position: absolute;
                                    left: 0;
                                    bottom: -6px;
                                    width: 45px;
                                    height: 3px;
                                    background: linear-gradient(90deg,#6f63ff,#9b86ff);
                                    border-radius: 6px;
                                }
                                .recent-post-wrap {
                                    display: flex;
                                    flex-direction: column;
                                    gap: 18px;
                                }
                                .recent-post {
                                    display: flex;
                                    gap: 14px;
                                    padding: 14px;
                                    border-radius: 14px;
                                    background: rgba(255,255,255,0.7);
                                    border: 1px solid rgba(0,0,0,0.08);
                                    backdrop-filter: blur(10px);
                                    transition: .35s ease;
                                }
                                .recent-post:hover {
                                    transform: translateY(-6px);
                                    box-shadow: 0 14px 26px rgba(111,99,255,0.18);
                                    border-color: rgba(111,99,255,0.35);
                                }
                                .recent-post .media-img {
                                    flex-shrink: 0;
                                    width: 78px;
                                    height: 78px;
                                    border-radius: 12px;
                                    overflow: hidden;
                                    position: relative;
                                }
                                .recent-post .media-img img {
                                    width: 100%;
                                    height: 100%;
                                    object-fit: cover;
                                    transition: .45s ease;
                                }
                                .recent-post:hover .media-img img { transform: scale(1.08); }
                                .recent-post .media-body {
                                    display: flex;
                                    flex-direction: column;
                                    justify-content: center;
                                }
                                .recent-post-meta {
                                    display: flex;
                                    gap: 10px;
                                    margin-bottom: 4px;
                                }
                                .recent-post-meta a {
                                    font-size: 13px;
                                    font-weight: 600;
                                    color: #6f63ff;
                                    transition: .3s ease;
                                }
                                .recent-post-meta a:hover { color: #4c41ff; text-shadow: 0 0 6px rgba(111,99,255,0.35); }
                                .recent-post .post-title {
                                    font-size: 15px;
                                    font-weight: 700;
                                    line-height: 1.35;
                                    color: #2a2a3f;
                                }
                                .recent-post .post-title a {
                                    display: inline-block;
                                    transition: .35s ease;
                                }
                                .recent-post .post-title a:hover { color: #6f63ff; text-shadow: 0 0 8px rgba(111,99,255,0.4); }
                            </style>

                            <h3 class="widget_title">Featured Blogs</h3>
                            <div class="recent-post-wrap">
                                <?php if (count($blogs) > 0): ?>
                                    <?php foreach (array_slice($blogs, 0, 4) as $blog): ?>
                                        <div class="recent-post">
                                            <div class="media-img">
                                                <a href="blog-details.php?id=<?php echo htmlspecialchars($blog['id']); ?>">
                                                    <img src="<?php echo htmlspecialchars($blog['image_path']); ?>" alt="Blog Image">
                                                </a>
                                            </div>
                                            <div class="media-body">
                                                <div class="recent-post-meta">
                                                    <a href="#"><?php echo htmlspecialchars($blog['day'] . ' ' . $blog['month']); ?></a>
                                                </div>
                                                <h4 class="post-title">
                                                    <a class="text-inherit" href="blog-details.php?id=<?php echo htmlspecialchars($blog['id']); ?>">
                                                        <?php echo htmlspecialchars(strlen($blog['title']) > 50 ? substr($blog['title'], 0, 50) . '...' : $blog['title']); ?>
                                                    </a>
                                                </h4>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Contact Form Widget -->
                        <div class="widget widget_quote">
                            <style>
                                .widget_quote {
                                    background: #ffffff;
                                    padding: 30px;
                                    border-radius: 16px;
                                    border: 1px solid #e5e5e5;
                                    box-shadow: 0 8px 25px rgba(0,0,0,0.06);
                                    transition: 0.3s ease;
                                }
                                .widget_quote:hover {
                                    transform: translateY(-4px);
                                    box-shadow: 0 12px 35px rgba(0,0,0,0.08);
                                }
                                .widget_quote .widget_title {
                                    font-size: 22px;
                                    font-weight: 700;
                                    margin-bottom: 18px;
                                    color: #0d1c17;
                                }
                                .widget_quote .form-group {
                                    position: relative;
                                    margin-bottom: 18px;
                                }
                                .widget_quote .form-control,
                                .widget_quote .form-select {
                                    width: 100%;
                                    background: #f7f7f7;
                                    border: 1px solid #dcdcdc;
                                    border-radius: 12px;
                                    padding: 14px 46px 14px 14px;
                                    font-size: 15px;
                                    transition: 0.3s ease;
                                }
                                .widget_quote textarea.form-control {
                                    height: 110px;
                                    resize: none;
                                }
                                .widget_quote .form-control:focus,
                                .widget_quote .form-select:focus {
                                    background: #fff;
                                    border-color: #1e8f64;
                                    box-shadow: 0 0 0 3px rgba(30, 143, 100, 0.25);
                                }
                                .widget_quote .form-group i {
                                    position: absolute;
                                    right: 14px;
                                    top: 50%;
                                    transform: translateY(-50%);
                                    color: #999;
                                    font-size: 16px;
                                    pointer-events: none;
                                }
                                .widget_quote .form-group textarea + i {
                                    top: 18px;
                                    transform: none;
                                }
                                .widget_quote .form-btn { margin-top: 10px; }
                                .widget_quote .th-btn {
                                    width: 100%;
                                    padding: 14px 20px;
                                    border-radius: 12px;
                                    font-size: 16px;
                                }
                            </style>

                            <h3 class="widget_title">Have any Question?</h3>
                            <form action="mail.php" method="POST" class="widget-form">
                                <div class="form-group">
                                    <input type="text" class="form-control" name="name" id="name" placeholder="Full Name*" required>
                                    <i class="fal fa-user"></i>
                                </div>
                                <div class="form-group">
                                    <input type="email" class="form-control" name="email" id="email" placeholder="Email Address*" required>
                                    <i class="fal fa-envelope"></i>
                                </div>
                                <div class="form-group">
                                    <input type="tel" class="form-control" name="phone" id="phone" placeholder="Phone Number*" required>
                                    <i class="fal fa-phone"></i>
                                </div>
                                <div class="form-group">
                                    <select name="subject" id="subject" class="form-select" required>
                                        <option value="" disabled selected>Select Service*</option>
                                        <option value="Blog Inquiry">Blog Inquiry</option>
                                        <option value="Design Consultation">Design Consultation</option>
                                        <option value="Project Discussion">Project Discussion</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <textarea name="message" id="message" cols="30" rows="3" class="form-control" placeholder="Your Message" required></textarea>
                                    <i class="fal fa-comment"></i>
                                </div>
                                <p class="form-messages mb-0 mt-3"></p>
                                <div class="form-btn col-12">
                                    <button type="submit" class="th-btn style2 th-icon">Submit Now</button>
                                </div>
                            </form>
                        </div>
                    </aside>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer (Simplified) -->
    <footer class="footer-wrapper">
        <div class="widget-area">
            <div class="container">
                <div style="text-align: center; padding: 40px 0; border-top: 1px solid rgba(255,255,255,0.1);">
                    <p style="color: rgba(255,255,255,0.6);">© 2025 Faren Interior Design. All Rights Reserved.</p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Scroll to Top -->
    <div class="scroll-top">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewbox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 307.919;"></path>
        </svg>
    </div>

    <!-- Scripts -->
    <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <script src="assets/js/swiper-bundle.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/jquery.counterup.min.js"></script>
    <script src="assets/js/circle-progress.js"></script>
    <script src="assets/js/jquery-ui.min.js"></script>
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/isotope.pkgd.min.js"></script>
    <script src="assets/js/nice-select.min.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/main.js"></script>
    <script>
        // Update auth UI based on localStorage
        document.addEventListener('DOMContentLoaded', function () {
            const authSection = document.getElementById('auth-section');
            const userProfileSection = document.getElementById('user-profile-section');
            const userData = localStorage.getItem('user_data');

            if (userData) {
                try {
                    const user = JSON.parse(userData);
                    if (user.name) {
                        authSection.style.display = 'none';
                        userProfileSection.style.display = 'flex';
                        document.getElementById('user-name').textContent = user.name;
                    }
                } catch (e) {
                    console.error('Error parsing user data:', e);
                }
            }
        });
    </script>
</body>

</html>
