<?php
/**
 * Email Configuration
 * 
 * This file contains email settings for the application
 * Update these settings to match your email provider
 */

// Email Settings
define('info@zemaraimgroups.com', 'Interior Design Solutions');
define('info@zemaraimgroups.com', 'noreply@yourinteriorsite.com');

// Optional: SMTP Settings (uncomment if using SMTP instead of php mail())
// define('SMTP_HOST', 'smtp.gmail.com');
// define('SMTP_PORT', 587);
// define('SMTP_USERNAME', 'your-email@gmail.com');
// define('SMTP_PASSWORD', 'your-app-password');
// define('SMTP_ENCRYPTION', 'tls');

// Admin Email (for notifications)
define('iiidsumma@gmail.com', 'admin@yourinteriorsite.com');

// Email Templates Directory
define('EMAIL_TEMPLATES_DIR', __DIR__ . '/../templates/emails/');

/**
 * Send Email Function
 * Uses PHP's mail() function by default
 * Can be extended to use PHPMailer for production
 */
function sendEmail($to, $subject, $message, $headers = []) {
    // Default headers
    $default_headers = [
        'From' => MAIL_FROM_NAME . ' <' . MAIL_FROM_EMAIL . '>',
        'Reply-To' => MAIL_FROM_EMAIL,
        'Content-Type' => 'text/html; charset=UTF-8',
        'X-Mailer' => 'PHP/' . phpversion()
    ];
    
    // Merge custom headers
    $all_headers = array_merge($default_headers, $headers);
    
    // Format headers string
    $header_string = '';
    foreach ($all_headers as $name => $value) {
        $header_string .= $name . ": " . $value . "\r\n";
    }
    
    // Send email
    $result = mail($to, $subject, $message, $header_string);
    
    return $result;
}

/**
 * Send Consultation Verification Email
 */
function sendConsultationVerificationEmail($to, $name, $verification_link) {
    $subject = 'Verify Your Consultation Request - Interior Design Solutions';
    
    $message = "
    <html>
    <head>
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background-color: #2c3e50; color: white; padding: 20px; text-align: center; }
            .content { padding: 20px; border: 1px solid #ddd; }
            .button { background-color: #3498db; color: white; padding: 12px 30px; text-decoration: none; border-radius: 5px; display: inline-block; margin: 20px 0; }
            .footer { font-size: 12px; color: #666; margin-top: 20px; border-top: 1px solid #ddd; padding-top: 20px; }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <h1>Interior Design Solutions</h1>
            </div>
            <div class='content'>
                <p>Hi <strong>{$name}</strong>,</p>
                <p>Thank you for submitting your consultation request! We're excited to help you with your interior design project.</p>
                <p>To proceed with your consultation, please verify your email address by clicking the button below:</p>
                <center>
                    <a href='{$verification_link}' class='button'>Verify Email Address</a>
                </center>
                <p>Or copy and paste this link in your browser:</p>
                <p><small>{$verification_link}</small></p>
                <p><strong>Note:</strong> This verification link expires in 24 hours.</p>
                <p>If you did not submit this request, you can ignore this email.</p>
            </div>
            <div class='footer'>
                <p>&copy; Interior Design Solutions. All rights reserved.</p>
                <p>This is an automated email, please do not reply directly.</p>
            </div>
        </div>
    </body>
    </html>
    ";
    
    return sendEmail($to, $subject, $message);
}

/**
 * Send Admin Notification Email
 */
function sendAdminNotificationEmail($consultation_data) {
    $subject = 'New Consultation Request - ' . $consultation_data['first_name'] . ' ' . $consultation_data['last_name'];
    
    $source = isset($consultation_data['source']) ? $consultation_data['source'] : 'Not specified';
    
    $message = "
    <html>
    <head>
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background-color: #2c3e50; color: white; padding: 20px; text-align: center; }
            .content { padding: 20px; border: 1px solid #ddd; }
            table { width: 100%; border-collapse: collapse; margin: 20px 0; }
            td { padding: 10px; border-bottom: 1px solid #ddd; }
            td:first-child { font-weight: bold; width: 30%; }
            .footer { font-size: 12px; color: #666; margin-top: 20px; }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <h1>New Consultation Request</h1>
            </div>
            <div class='content'>
                <p>A new consultation request has been submitted:</p>
                <table>
                    <tr><td>Name:</td><td>{$consultation_data['first_name']} {$consultation_data['last_name']}</td></tr>
                    <tr><td>Email:</td><td>{$consultation_data['email']}</td></tr>
                    <tr><td>Phone:</td><td>{$consultation_data['phone']}</td></tr>
                    <tr><td>Address:</td><td>{$consultation_data['address']}</td></tr>
                    <tr><td>Consultation Type:</td><td>{$consultation_data['consultation_type']}</td></tr>
                    <tr><td>Preferred Date:</td><td>{$consultation_data['preferred_date']}</td></tr>
                    <tr><td>Preferred Time:</td><td>{$consultation_data['preferred_time']}</td></tr>
                    <tr><td>Budget Range:</td><td>{$consultation_data['budget_range']}</td></tr>
                    <tr><td>Source:</td><td>$source</td></tr>
                </table>
                <p><strong>Project Description:</strong></p>
                <p>{$consultation_data['project_description']}</p>
                <p><strong>Status:</strong> Pending Verification</p>
            </div>
            <div class='footer'>
                <p>&copy; Interior Design Solutions. All rights reserved.</p>
            </div>
        </div>
    </body>
    </html>
    ";
    
    return sendEmail(ADMIN_EMAIL, $subject, $message);
}
?>
