<?php
echo "<h2>XAMPP Mail Configuration Diagnostic</h2>";

// Check mail function
echo "<h3>1. Mail Function Status:</h3>";
if (function_exists('mail')) {
    echo "<p style='color: green;'>✓ mail() function is available</p>";
} else {
    echo "<p style='color: red;'>✗ mail() function is NOT available</p>";
    exit;
}

// Check php.ini settings
echo "<h3>2. Current PHP Mail Configuration:</h3>";
echo "<table border='1' cellpadding='10' style='border-collapse: collapse;'>";
echo "<tr><td><strong>SMTP</strong></td><td>" . ini_get('SMTP') . "</td></tr>";
echo "<tr><td><strong>smtp_port</strong></td><td>" . ini_get('smtp_port') . "</td></tr>";
echo "<tr><td><strong>sendmail_path</strong></td><td>" . (ini_get('sendmail_path') ?: 'Not configured') . "</td></tr>";
echo "<tr><td><strong>sendmail_from</strong></td><td>" . (ini_get('sendmail_from') ?: 'Not configured') . "</td></tr>";
echo "</table>";

echo "<h3>3. SOLUTION FOR WINDOWS XAMPP:</h3>";
echo "<p style='background: #fffbea; padding: 15px; border-left: 4px solid #fbbf24;'>";
echo "<strong>Option 1: Use Gmail SMTP (Easiest)</strong><br>";
echo "Edit: <code>C:\\xampp\\php\\php.ini</code><br>";
echo "Find and replace the [mail function] section with:<br>";
echo "<pre style='background: #f3f4f6; padding: 10px; border-radius: 5px; overflow-x: auto;'>
[mail function]
SMTP = mail.zemaraimgroups.com
smtp_port = 465
sendmail_from = info@zemaraimgroups.com
</pre>";
echo "Then restart Apache.<br><br>";

echo "<strong>Option 2: Use SendGrid/Mailgun (Recommended)</strong><br>";
echo "1. Sign up at sendgrid.com (free tier available)<br>";
echo "2. Get your SMTP credentials<br>";
echo "3. Add to php.ini:<br>";
echo "<pre style='background: #f3f4f6; padding: 10px; border-radius: 5px; overflow-x: auto;'>
SMTP = mail.zemaraimgroups.com
smtp_port = 465
sendmail_from = info@zemaraimgroups.com
</pre>";
echo "</p>";

echo "<h3>4. Test Email Sending:</h3>";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $test_email = trim($_POST['test_email'] ?? '');
    
    if (empty($test_email)) {
        echo "<p style='color: red;'>Please enter an email address</p>";
    } else {
        $headers = "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=UTF-8\r\n";
        $headers .= "From: noreply@interiordesign.com\r\n";
        
        $subject = "Test Email - Interior Design System";
        $body = "<html><body>";
        $body .= "<h2>Test Email</h2>";
        $body .= "<p>If you received this, your mail system is working!</p>";
        $body .= "<p>Sent at: " . date('Y-m-d H:i:s') . "</p>";
        $body .= "</body></html>";
        
        $result = @mail($test_email, $subject, $body, $headers);
        
        if ($result) {
            echo "<p style='color: green; background: #d1fae5; padding: 10px; border-radius: 5px;'>";
            echo "✓ Test email sent successfully to: <strong>" . htmlspecialchars($test_email) . "</strong><br>";
            echo "Check your inbox (and spam folder)!";
            echo "</p>";
        } else {
            echo "<p style='color: red; background: #fee2e2; padding: 10px; border-radius: 5px;'>";
            echo "✗ Test email FAILED<br>";
            echo "Your mail server is not properly configured yet.";
            echo "</p>";
        }
    }
}
?>

<form method="POST" style="margin-top: 20px;">
    <label for="test_email"><strong>Test Email Address:</strong></label><br>
    <input type="email" id="test_email" name="test_email" placeholder="your-email@example.com" style="padding: 8px; width: 300px; margin: 10px 0;" required>
    <button type="submit" style="padding: 8px 20px; background: #8b6f47; color: white; border: none; border-radius: 5px; cursor: pointer;">Send Test Email</button>
</form>

<hr style="margin: 30px 0;">

<h3>5. After Configuring Mail:</h3>
<ol style="line-height: 2;">
    <li>Edit php.ini with your SMTP settings</li>
    <li>Save and restart Apache</li>
    <li>Test using the form above</li>
    <li>Then go to <a href="admin-manage-emails.php">Email Manager</a> and click "Resend All Pending"</li>
    <li>All queued emails will be sent!</li>
</ol>

<p style="background: #e0f2fe; padding: 15px; border-radius: 5px; margin-top: 20px;">
<strong>💡 Quick Note:</strong> If using Gmail, you may need to:<br>
- Enable "Less secure app access" in Gmail settings, OR<br>
- Use an App Password instead of your regular password
</p>
?>
