<?php
session_start();
require_once 'config/db.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.html');
    exit;
}

$user_id = $_SESSION['user_id'];

// Fetch user data
$stmt = $connection->prepare("SELECT id, name, email, phone FROM users WHERE id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user_result = $stmt->get_result();
$user = $user_result->fetch_assoc();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Schedule Consultation - Interior Design Solutions</title>
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: aliceblue;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            min-height: 100vh;
            padding: 20px;
            margin: 0;
        }

        .consultation-container {
            max-width: 700px;
            margin: 40px auto;
            background: white;
            border-radius: 15px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            overflow: hidden;
            margin-top: 240px
        }

        .consultation-header {
            background: #d4a33a;
            color: white;
            padding: 40px;
            text-align: center;
        }

        .consultation-header h1 {
            font-size: 28px;
            margin-bottom: 10px;
        }

        .consultation-header p {
            color: white;
            font-size: 16px;
            opacity: 0.9;
        }

        .consultation-form {
            padding: 40px;
        }

        .form-group {
            margin-bottom: 25px;
        }

        label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #333;
        }

        input[type="text"],
        input[type="email"],
        input[type="tel"],
        input[type="date"],
        select,
        textarea {
            width: 100%;
            padding: 12px;
            border: 2px solid #e0e0e0;
            border-radius: 5px;
            font-family: inherit;
            font-size: 14px;
            transition: border-color 0.3s ease;
        }

        input[type="text"]:focus,
        input[type="email"]:focus,
        input[type="tel"]:focus,
        input[type="date"]:focus,
        select:focus,
        textarea:focus {
            outline: none;
            border-color: #667eea;
        }

        select {
            appearance: none;
            background-image: url('data:image/svg+xml;utf8,<svg fill="black" height="24" viewBox="0 0 24 24" width="24" xmlns="http://www.w3.org/2000/svg"><path d="M7 10l5 5 5-5z"/></svg>');
            background-repeat: no-repeat;
            background-position: right 10px center;
            background-size: 20px;
            padding-right: 35px;
        }

        textarea {
            resize: vertical;
            min-height: 100px;
        }

        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
        }

        .section-title {
            font-size: 18px;
            font-weight: 600;
            color: #333;
            margin: 30px 0 20px 0;
            padding-bottom: 10px;
            border-bottom: 2px solid #667eea;
        }

        .btn {
            padding: 12px 30px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            width: 100%;
        }

        .btn-submit {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            margin-top: 20px;
        }

        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
        }

        .alert {
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }

        .alert.success {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .alert.error {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }

        .required {
            color: #e74c3c;
        }

        .back-link {
            display: inline-block;
            margin-bottom: 20px;
            color: #667eea;
            text-decoration: none;
            font-weight: 600;
        }

        .back-link:hover {
            text-decoration: underline;
        }

        @media (max-width: 768px) {
            .consultation-header {
                padding: 30px;
            }

            .consultation-header h1 {
                font-size: 24px;
            }

            .consultation-form {
                padding: 25px;
            }

            .form-row {
                grid-template-columns: 1fr;
            }

            .consultation-container {
                margin: 30px auto;
            }
        }

        @media (max-width: 480px) {
            body {
                padding: 10px;
                background: white;
            }

            .consultation-container {
                margin: 15px 0;
                border-radius: 10px;
                box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            }

            .consultation-header {
                padding: 20px;
            }

            .consultation-header h1 {
                font-size: 20px;
                margin-bottom: 8px;
            }

            .consultation-header p {
                font-size: 14px;
            }

            .consultation-form {
                padding: 20px;
            }

            .form-group {
                margin-bottom: 18px;
            }

            label {
                font-size: 13px;
                margin-bottom: 6px;
            }

            input[type="text"],
            input[type="email"],
            input[type="tel"],
            input[type="date"],
            select,
            textarea {
                padding: 10px;
                font-size: 14px;
            }

            .form-row {
                grid-template-columns: 1fr;
                gap: 15px;
            }

            .section-title {
                font-size: 16px;
                margin: 25px 0 15px 0;
            }

            .btn {
                padding: 12px 20px;
                font-size: 14px;
                width: 100%;
            }

            .back-link {
                font-size: 13px;
                margin-bottom: 15px;
            }

            .required {
                font-size: 14px;
            }

            select {
                background-size: 18px;
                padding-right: 30px;
            }
        }
    </style>
</head>
<body>
    <?php include 'header-section.html'; ?>
    
    <div class="consultation-container">
        <div class="consultation-header">
            <h1>Schedule Your Consultation</h1>
            <p>Let's discuss your interior design project</p>
        </div>

        <div class="consultation-form">
            <a href="customer-dashboard.php" class="back-link">← Back to Dashboard</a>

            <form id="consultationForm">
                <div id="messageAlert"></div>

                <div class="section-title">Personal Information</div>

                <div class="form-row">
                    <div class="form-group">
                        <label for="first_name">First Name <span class="required">*</span></label>
                        <input type="text" id="first_name" name="first_name" required value="<?php echo htmlspecialchars(explode(' ', $user['name'] ?? '')[0]); ?>">
                    </div>
                    <div class="form-group">
                        <label for="last_name">Last Name <span class="required">*</span></label>
                        <input type="text" id="last_name" name="last_name" required value="<?php echo htmlspecialchars(implode(' ', array_slice(explode(' ', $user['name'] ?? ''), 1))); ?>">
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label for="email">Email Address <span class="required">*</span></label>
                        <input type="email" id="email" name="email" required value="<?php echo htmlspecialchars($user['email'] ?? ''); ?>">
                    </div>
                    <div class="form-group">
                        <label for="phone">Phone Number <span class="required">*</span></label>
                        <input type="tel" id="phone" name="phone" required value="<?php echo htmlspecialchars($user['phone'] ?? ''); ?>">
                    </div>
                </div>

                <div class="form-group">
                    <label for="address">Address <span class="required">*</span></label>
                    <textarea id="address" name="address" required><?php echo htmlspecialchars($user['address'] ?? ''); ?></textarea>
                </div>

                <div class="section-title">Consultation Details</div>

                <div class="form-group">
                    <label for="consultation_type">Type of Consultation <span class="required">*</span></label>
                    <select id="consultation_type" name="consultation_type" required>
                        <option value="">Select a consultation type</option>
                        <option value="residential">Residential Interior Design</option>
                        <option value="commercial">Commercial Interior Design</option>
                        <option value="renovation">Home Renovation</option>
                        <option value="furniture">Furniture Selection</option>
                        <option value="colors">Color & Style Consultation</option>
                    </select>
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label for="preferred_date">Preferred Date <span class="required">*</span></label>
                        <input type="date" id="preferred_date" name="preferred_date" min="<?php echo date('Y-m-d'); ?>" required>
                    </div>
                    <div class="form-group">
                        <label for="preferred_time">Preferred Time <span class="required">*</span></label>
                        <select id="preferred_time" name="preferred_time" required>
                            <option value="">Select a time</option>
                            <option value="09:00">9:00 AM</option>
                            <option value="10:00">10:00 AM</option>
                            <option value="11:00">11:00 AM</option>
                            <option value="12:00">12:00 PM</option>
                            <option value="13:00">1:00 PM</option>
                            <option value="14:00">2:00 PM</option>
                            <option value="15:00">3:00 PM</option>
                            <option value="16:00">4:00 PM</option>
                            <option value="17:00">5:00 PM</option>
                        </select>
                    </div>
                </div>

                <div class="form-group">
                    <label for="project_description">Project Description <span class="required">*</span></label>
                    <textarea id="project_description" name="project_description" placeholder="Tell us about your project, style preferences, and any specific requirements..." required></textarea>
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label for="budget_range">Budget Range <span class="required">*</span></label>
                        <select id="budget_range" name="budget_range" required>
                            <option value="">Select budget range</option>
                            <option value="10k-50k">₱10,000 - ₱50,000</option>
                            <option value="50k-100k">₱50,000 - ₱100,000</option>
                            <option value="100k-200k">₱100,000 - ₱200,000</option>
                            <option value="200k-500k">₱200,000 - ₱500,000</option>
                            <option value="500k+">₱500,000+</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="source">How did you hear about us?</label>
                        <select id="source" name="source">
                            <option value="">Select option</option>
                            <option value="social-media">Social Media</option>
                            <option value="google">Google Search</option>
                            <option value="friend">Friend Referral</option>
                            <option value="website">Our Website</option>
                            <option value="advertisement">Advertisement</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                </div>

                <button type="submit" class="btn btn-submit">Submit Consultation Request</button>
            </form>
        </div>
    </div>

    <!-- Verification Modal -->
    <div id="verificationModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.5); z-index: 1000; align-items: center; justify-content: center;">
        <div style="background: white; padding: 40px; border-radius: 10px; text-align: center; max-width: 400px; box-shadow: 0 10px 40px rgba(0,0,0,0.3);">
            <div style="font-size: 48px; margin-bottom: 20px;">✓</div>
            <h3 style="color: #333; margin-bottom: 15px;">Consultation Request Submitted!</h3>
            <p style="color: #666; margin-bottom: 20px;">We've sent a verification email to <strong><?php echo htmlspecialchars($user['email']); ?></strong></p>
            <p style="color: #666; margin-bottom: 20px;">Please check your email and click the verification link to confirm your consultation request.</p>
            <button onclick="window.location.href='customer-dashboard.php';" class="btn btn-submit">Go to Dashboard</button>
        </div>
    </div>

    <script>
        document.getElementById('consultationForm').addEventListener('submit', async (e) => {
            e.preventDefault();

            const formData = new FormData();
            formData.append('first_name', document.getElementById('first_name').value);
            formData.append('last_name', document.getElementById('last_name').value);
            formData.append('email', document.getElementById('email').value);
            formData.append('phone', document.getElementById('phone').value);
            formData.append('address', document.getElementById('address').value);
            formData.append('consultation_type', document.getElementById('consultation_type').value);
            formData.append('preferred_date', document.getElementById('preferred_date').value);
            formData.append('preferred_time', document.getElementById('preferred_time').value);
            formData.append('project_description', document.getElementById('project_description').value);
            formData.append('budget_range', document.getElementById('budget_range').value);
            formData.append('source', document.getElementById('source').value);

            try {
                const response = await fetch('api/submit-consultation.php', {
                    method: 'POST',
                    body: formData
                });

                const data = await response.json();
                const messageDiv = document.getElementById('messageAlert');

                if (data.success) {
                    document.getElementById('verificationModal').style.display = 'flex';
                } else {
                    messageDiv.innerHTML = `<div class="alert error">${data.message}</div>`;
                }
            } catch (error) {
                document.getElementById('messageAlert').innerHTML = `<div class="alert error">Error submitting form. Please try again.</div>`;
            }
        });
    </script>
</body>
</html>
<?php include 'footer-section.html'; ?>