<!doctype html>
<html class="no-js" lang="zxx">

<head>
    <?php 
    session_start();
    ?>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Faren Interior Design</title>
    <meta name="author" content="themeholy">
    <meta name="description" content="Faren   - Architecture & Interior Design Template">
    <meta name="keywords" content="Faren   - Architecture & Interior Design Template">
    <meta name="robots" content="INDEX,FOLLOW">
    <meta name="viewport" content="width=device-width,initial-scale=1,shrink-to-fit=no">
    <link rel="apple-touch-icon" sizes="57x57" href="assets/img/favicons/apple-icon-57x57.png">
    <link rel="apple-touch-icon" sizes="60x60" href="assets/img/favicons/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="assets/img/favicons/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="assets/img/favicons/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="assets/img/favicons/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="assets/img/favicons/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="assets/img/favicons/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="assets/img/favicons/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="assets/img/favicons/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192" href="assets/img/favicons/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="32x32" href="assets/img/favicons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="assets/img/favicons/favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="assets/img/favicons/favicon-16x16.png">
    <link rel="manifest" href="assets/img/favicons/manifest.json">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="assets/img/favicons/ms-icon-144x144.png">
    <meta name="theme-color" content="#ffffff">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin="">
    <link href="../../css2-1?family=DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">
    <link rel="stylesheet" href="assets/css/swiper-bundle.min.css">
    <link rel="stylesheet" href="assets/css/style.css">
    <script src="assets/js/auth-ui-global.js"></script>
</head>

<body id="show-grid">
    <!-- header -->
     <?php include 'header-section.html'; ?>
     
     <?php
     // Initialize message variables
     $success_message = '';
     $error_message = '';
     ?>
    
    <!-- CONTACT INFO SECTION -->
    <div class="space">
        <!-- STYLE -->
         <style>
/* ------------------------------
   PREMIUM CONTACT INFO BOXES
   ------------------------------ */

.space {
    margin-top: 290px;
    padding-top: 310px;
}

.contact-media {
    display: flex;
    align-items: flex-start;
    gap: 18px;
    padding: 28px;
    border-radius: 18px;
    background: rgba(255, 255, 255, 0.06);
    border: 1px solid rgba(255, 255, 255, 0.15);
    backdrop-filter: blur(12px);
    transition: .35s ease;
    position: relative;
    overflow: hidden;
}

/* subtle floating glow effect */
.contact-media::before {
    content: "";
    position: absolute;
    inset: 0;
    background: radial-gradient(circle at top right, rgba(255,255,255,0.12), transparent 70%);
    opacity: 0;
    transition: .35s;
}

.contact-media:hover::before {
    opacity: 1;
}

/* Hover Lift */
.contact-media:hover {
    transform: translateY(-6px);
    border-color: rgba(255,255,255,0.30);
}

/* Icon Button Style */
.icon-btn {
    width: 58px;
    height: 58px;
    border-radius: 14px;
    background: #111;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 22px;
    color: var(--theme-color, #ffb400);
    transition: .35s ease;
    box-shadow: 0 8px 18px rgba(0,0,0,0.2);
}

.contact-media:hover .icon-btn {
    background: var(--theme-color, #ffb400);
    color: #fff;
    transform: scale(1.08);
}

/* Text Styling */
.media-body .box-title {
    font-size: 20px;
    font-weight: 600;
    margin-bottom: 6px;
    color: #000000;
}

.media-body .box-text,
.media-body .box-text a {
    color: #000000;
    font-size: 15px;
    line-height: 1.6;
    display: block;
}

.media-body .box-text a:hover {
    color: var(--theme-color, #ffb400);
}

/* ---- RESPONSIVE ---- */
/* Tablet: 992px and below */
@media (max-width: 992px) {
    .space {
        margin-top: 290px;
        padding-top: 150px;
    }

    .contact-media {
        padding: 24px;
        border-radius: 16px;
    }
    
    .icon-btn {
        width: 52px;
        height: 52px;
        font-size: 20px;
    }
}

/* Small devices: 768px and below */
@media (max-width: 768px) {
    .space {
        margin-top: 290px;
        padding-top: 100px;
    }

    .contact-media {
        padding: 20px;
        gap: 16px;
    }

    .icon-btn {
        width: 48px;
        height: 48px;
        font-size: 18px;
        flex-shrink: 0;
    }

    .media-body .box-title {
        font-size: 18px;
    }

    .media-body .box-text,
    .media-body .box-text a {
        font-size: 14px;
    }
}

/* Mobile: 576px and below - REMOVE TOP SPACE */
@media (max-width: 576px) {
    .space {
        margin-top: 0;
        padding-top: 20px;
        padding-bottom: 20px;
    }

    .contact-media {
        flex-direction: row;
        padding: 16px;
        gap: 12px;
        border-radius: 12px;
        margin-bottom: 12px;
    }

    .icon-btn {
        width: 44px;
        height: 44px;
        font-size: 16px;
        flex-shrink: 0;
    }

    .media-body .box-title {
        font-size: 16px;
        margin-bottom: 4px;
    }

    .media-body .box-text,
    .media-body .box-text a {
        font-size: 13px;
        line-height: 1.5;
    }
}
</style>

        <div class="container">
            <div class="row gy-4">
                <div class="col-xl-4 col-md-6">
                    <div class="contact-media">
                        <div class="icon-btn"><i class="fa-solid fa-location-dot"></i></div>
                        <div class="media-body">
                            <h5 class="box-title">Our Current Location</h5>
                            <p class="box-text">4517 Washington Ave. Manchester, Kentucky 39495. USA</p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6">
                    <div class="contact-media">
                        <div class="icon-btn"><i class="fa-solid fa-phone"></i></div>
                        <div class="media-body">
                            <h5 class="box-title">Phone Number</h5>
                            <p class="box-text"><a href="tel:+00123666000666">+00 (123) 666 000 666</a> <a
                                    href="tel:+00123888000222">+00 (123) 888 000 222</a></p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6">
                    <div class="contact-media">
                        <div class="icon-btn"><i class="fa-solid fa-envelope"></i></div>
                        <div class="media-body">
                            <h5 class="box-title">Email Address</h5>
                            <p class="box-text"><a href="mailto:info@examplemail.com">info@examplemail.com</a> <a
                                    href="mailto:help@faren.com">help@faren.com</a></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- GET IN TOUCH -->
   <div class="contact-area overflow-hidden space" id="contact-sec" style="margin-top: 20px;">
       <style>
/* =================================
   CONTACT IMAGE – FULL RESPONSIVE FIX
================================= */

/* reset previous behavior */
.contact-image.style2 {
  position: relative;
  display: grid;
  grid-template-columns: repeat(12, 1fr);
  gap: clamp(12px, 2vw, 20px);
  align-items: stretch;
}

/* base image wrapper */
.contact-image.style2 > div {
  position: relative;
  width: 100%;
  overflow: hidden;
  border-radius: 20px;
}

/* image itself */
.contact-image.style2 img {
  width: 100%;
  height: 100%;
  object-fit: cover;
  aspect-ratio: 4 / 3;
  transition: transform .6s ease;
}

/* subtle interaction */
.contact-image.style2 img:hover {
  transform: scale(1.05);
}

/* =================================
   DESKTOP LAYOUT (ASYMMETRIC)
================================= */
.contact-image.style2 .img1 {
  grid-column: span 7;
  aspect-ratio: 4 / 5;
}

.contact-image.style2 .img2 {
  grid-column: span 5;
  aspect-ratio: 1 / 1;
}

.contact-image.style2 .img3 {
  grid-column: span 5;
  aspect-ratio: 3 / 2;
}

.contact-image.style2 .img4 {
  grid-column: span 7;
  aspect-ratio: 16 / 9;
}

/* force aspect control */
.contact-image.style2 .img1 img,
.contact-image.style2 .img2 img,
.contact-image.style2 .img3 img,
.contact-image.style2 .img4 img {
  aspect-ratio: inherit;
}

/* =================================
   TABLET (BALANCED GRID)
================================= */
@media (max-width: 1199px) {
  .contact-image.style2 {
    grid-template-columns: repeat(2, 1fr);
  }

  .contact-image.style2 > div {
    grid-column: span 1 !important;
    aspect-ratio: 4 / 3;
  }
}

/* =================================
   MOBILE (2-COLUMN GRID LAYOUT)
================================= */
@media (max-width: 767px) {
  .contact-image.style2 {
    grid-template-columns: repeat(2, 1fr);
    gap: clamp(10px, 1.5vw, 15px);
  }

  .contact-image.style2 > div {
    aspect-ratio: 4 / 3;
  }

  .contact-image.style2 .img1,
  .contact-image.style2 .img2,
  .contact-image.style2 .img3,
  .contact-image.style2 .img4 {
    grid-column: span 1 !important;
  }
}

/* =================================
   MOBILE FORM OPTIMIZATION
================================= */
@media (max-width: 767px) {
  .contact-area .row {
    --bs-gutter-y: 1rem;
  }

  .contact-area .title-area {
    margin-bottom: 25px;
  }

  .contact-area .title-area .sub-title {
    font-size: 13px;
  }

  .contact-area .title-area .sec-title {
    font-size: 24px;
    line-height: 1.3;
  }

  .contact-area .form-group {
    margin-bottom: 12px;
  }

  .contact-area .form-control,
  .contact-area .form-select {
    font-size: 15px;
    padding: 12px 14px;
    height: auto;
  }

  .contact-area .form-group input::placeholder,
  .contact-area .form-group textarea::placeholder {
    font-size: 14px;
  }

  .contact-area .form-group textarea {
    min-height: 100px;
  }

  .contact-area .form-btn {
    margin-top: 15px;
  }

  .contact-area .form-messages {
    font-size: 13px;
  }

  .contact-area .col-xl-6 {
    margin-bottom: 30px;
  }
}

/* =================================
   ULTRA-SMALL MOBILE (=380px)
================================= */
@media (max-width: 380px) {
  .contact-area .title-area .sec-title {
    font-size: 20px;
  }

  .contact-area .form-control,
  .contact-area .form-select {
    font-size: 14px;
    padding: 10px 12px;
  }

  .contact-area .form-group textarea {
    min-height: 80px;
    font-size: 14px;
  }

  .contact-area .th-btn {
    font-size: 14px;
    padding: 12px 20px;
  }
}

/* =================================
   ULTRA-WIDE SCREENS
================================= */
@media (min-width: 1600px) {
  .contact-image.style2 img {
    aspect-ratio: 16 / 9;
  }
}
</style>


        <div class="container">
            <div class="row gy-4">
                <div class="col-xl-6">
                    <form action="mail.php" method="POST" class="contact-form ajax-contact">
                        <div class="title-area pe-xl-5 me-xl-5"><span class="sub-title style2 text-anime">get in
                                touch</span>
                            <h2 class="sec-title split-text">Transforming <span class="text-theme">Visions </span>Into
                                Reality</h2>
                        </div>
                        <div class="row">
                            <?php if ($success_message): ?>
                            <div class="alert alert-success" role="alert">
                                <?php echo htmlspecialchars($success_message); ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($error_message): ?>
                            <div class="alert alert-danger" role="alert">
                                <?php echo htmlspecialchars($error_message); ?>
                            </div>
                        <?php endif; ?>
                            <div class="form-group col-md-6"><input type="text" class="form-control" name="name"
                                    id="name" placeholder="Full Name"> <i class="fa-solid fa-user"></i></div>
                            <div class="form-group col-md-6"><input type="email" class="form-control" name="email"
                                    id="email" placeholder="Email Address"> <i class="fa-solid fa-envelope"></i></div>
                            <div class="form-group col-md-6"><input type="tel" class="form-control" name="number"
                                    id="number" placeholder="Phone Number"> <i class="fa-solid fa-phone"></i></div>
                            <div class="form-group col-md-6">
                                <select name="subject" id="subject" class="form-select nice-select">
                                    <option value="">Inquire Services</option>
                                    <option value="Interior Consulting">Interior Consulting</option>
                                    <option value="Decor & Art Design">Decor & Art Design</option>
                                    <option value="Exterior Design">Exterior Design</option>
                                    <option value="Furniture Design">Furniture Design</option>
                                </select>
                            </div>
                            <div class="form-group col-12"><textarea name="message" id="message" cols="30" rows="3"
                                    class="form-control" placeholder="Your Message"></textarea> <i
                                    class="fa-solid fa-comment"></i></div>
                            <div class="col-12 form-group"><input type="checkbox" id="html"> <label for="html">I agree
                                    with the privacy policy</label></div>
                            <div class="form-btn mt-20 col-12">
                                <?php if (isset($_SESSION['user_id'])): ?>
                                    <!-- User is logged in - Show submit button -->
                                    <button type="submit" class="th-btn style4">Send Message</button>
                                <?php else: ?>
                                    <!-- User not logged in - Show login prompt -->
                                    <button type="button" class="th-btn style4" onclick="redirectToLogin()">
                                        Login to Send Message
                                    </button>
                                <?php endif; ?>
                            </div>
                        </div>
                        <p class="form-messages mb-0 mt-3"></p>
                    </form>
                </div>
                <div class="col-xl-6">
                    <div class="contact-image style2">
                        <div class="img1 img-anim-left"><img src="assets/img/normal/contact-2-1.jpg" alt=""></div>
                        <div class="img2 img-anim-right"><img src="assets/img/normal/contact-2-2.jpg" alt=""></div>
                        <div class="img3 img-anim-left"><img src="assets/img/normal/contact-2-3.jpg" alt=""></div>
                        <div class="img4 img-anim-right"><img src="assets/img/normal/contact-2-4.jpg" alt=""></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- <div class="shape-mockup spin d-none d-xxl-block" data-top="10%" data-right="13%"><img
                src="assets/img/shape/element-5.png" alt=""></div> -->
    </div>
    <div class="">
        <!-- STYLE -->
         <style>
/* --------------------------
   PREMIUM GOOGLE MAP DESIGN
   -------------------------- */

.contact-map {
    position: relative;
    width: 100%;
    height: 420px;
    border-radius: 22px;
    overflow: hidden;
    box-shadow: 0 20px 40px rgba(0, 0, 0, 0.25);
    transform: translateZ(0);
}

/* Beautiful Zoom animation */
.contact-map iframe {
    width: 100%;
    height: 100%;
    border: 0;
    transition: transform .5s ease-in-out;
}

.contact-map:hover iframe {
    transform: scale(1.04);
}

/* Floating location icon */
.contact-icon {
    position: absolute;
    left: 50%;
    top: 50%;
    width: 85px;
    height: 85px;
    transform: translate(-50%, -50%);
    background: rgba(255, 255, 255, 0.12);
    padding: 18px;
    border-radius: 50%;
    backdrop-filter: blur(12px);
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 8px 25px rgba(0,0,0,0.25);
    animation: floating 3s ease-in-out infinite;
}

/* Icon inside */
.contact-icon img {
    width: 42px;
    height: 42px;
    filter: drop-shadow(0px 4px 8px rgba(0,0,0,.3));
}

/* Floating animation */
@keyframes floating {
    0% { transform: translate(-50%, -50%) translateY(0); }
    50% { transform: translate(-50%, -50%) translateY(-10px); }
    100% { transform: translate(-50%, -50%) translateY(0); }
}

/* -------------------------
   Responsive Map Styling
   ------------------------- */
@media (max-width: 992px) {
    .contact-map {
        height: 340px;
        border-radius: 18px;
    }
    .contact-icon {
        width: 70px;
        height: 70px;
    }
    .contact-icon img {
        width: 32px;
    }
}

@media (max-width: 576px) {
    .contact-map {
        height: 270px;
        border-radius: 15px;
    }
    .contact-icon {
        width: 60px;
        height: 60px;
        padding: 12px;
    }
}
</style>

        <div class="contact-map"><iframe
                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3644.7310056272386!2d89.2286059153658!3d24.00527418490799!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x39fe9b97badc6151%3A0x30b048c9fb2129bc!2sAngfuztheme!5e0!3m2!1sen!2sbd!4v1651028958211!5m2!1sen!2sbd"
                allowfullscreen="" loading="lazy"></iframe>
            <div class="contact-icon"><img src="assets/img/icon/location-dot.svg" alt=""></div>
        </div>
    </div>
    <!-- FOOTER SECTION - MODERN AESTHETIC DESIGN -->
    
    <div class="scroll-top"><svg class="progress-circle svg-content" width="100%" height="100%" viewbox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98"
                style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 307.919;">
            </path>
        </svg></div>
    <script src="assets/js/vendor/jquery-3.7.1.min.js"></script>
    <script src="assets/js/swiper-bundle.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <script src="assets/js/jquery.counterup.min.js"></script>
    <script src="assets/js/circle-progress.js"></script>
    <script src="assets/js/jquery-ui.min.js"></script>
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="assets/js/isotope.pkgd.min.js"></script>
    <script src="assets/js/nice-select.min.js"></script>
    <script src="assets/js/wow.min.js"></script>
    <script src="assets/js/threesixty.min.js"></script>
    <script src="assets/js/panolens.min.js"></script>
    <script src="assets/js/gsap.min.js"></script>
    <script src="assets/js/ScrollTrigger.min.js"></script>
    <script src="assets/js/SplitText.js"></script>
    <script src="assets/js/SplitType.js"></script>
    <script src="assets/js/lenis.min.js"></script>
    <script src="assets/js/CustomEase.min.js"></script>
    <script src="assets/js/main.js"></script>
    
    <script>
    /**
     * Contact Form Handler with Authentication
     */
    
    // Redirect to login page
    function redirectToLogin() {
        alert('Please login to send a message. You will be redirected to login page.');
        window.location.href = 'auth-system/login.php?redirect=../contact.php';
    }
    
    // Handle contact form submission
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.querySelector('.ajax-contact');
        const submitBtn = form.querySelector('button[type="submit"]');
        const messageElement = form.querySelector('.form-messages');
        
        if (!form) return;
        
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            
            // Disable submit button
            if (submitBtn) {
                submitBtn.disabled = true;
                submitBtn.textContent = 'Sending...';
            }
            
            // Collect form data
            const formData = new FormData(this);
            
            // Send via AJAX
            fetch('mail.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Success message
                    messageElement.innerHTML = '<div class="alert alert-success" role="alert">' + 
                        data.message + 
                        '</div>';
                    
                    // Reset form
                    form.reset();
                    
                    // Show success notification
                    console.log('Message sent successfully:', data);
                    
                    // Optional: Redirect to admin dashboard after 2 seconds
                    setTimeout(() => {
                        window.location.href = 'admin-contact-messages.php';
                    }, 2000);
                } else {
                    // Error message
                    if (data.error_code === 'NOT_LOGGED_IN') {
                        // User not logged in
                        messageElement.innerHTML = '<div class="alert alert-warning" role="alert">' + 
                            'Please <a href="auth-system/login.php?redirect=../contact.php">login</a> to send a message.' + 
                            '</div>';
                        redirectToLogin();
                    } else {
                        messageElement.innerHTML = '<div class="alert alert-danger" role="alert">' + 
                            data.message + 
                            '</div>';
                    }
                }
            })
            .catch(error => {
                messageElement.innerHTML = '<div class="alert alert-danger" role="alert">' + 
                    'Error: ' + error.message + 
                    '</div>';
                console.error('Error:', error);
            })
            .finally(() => {
                // Re-enable submit button
                if (submitBtn) {
                    submitBtn.disabled = false;
                    submitBtn.textContent = 'Send Message';
                }
            });
        });
    });
    </script>
</body>

</html>
<?php include 'footer-section.html'; ?>