<!-- This file helps debug the mail sending issue -->
<?php
session_start();

// Only accessible to logged-in users
if (!isset($_SESSION['user_id'])) {
    die('Please log in');
}

echo "<h2>Consultation Form Debug</h2>";
echo "<p>Check the PHP error log to see if emails are being sent:</p>";

$error_log = ini_get('error_log');
echo "<p><strong>Error Log Location:</strong> " . htmlspecialchars($error_log) . "</p>";

if ($error_log && file_exists($error_log)) {
    echo "<p style='color: green;'>✓ Error log file exists</p>";
    
    // Show last 20 lines of error log
    echo "<h3>Recent Log Entries:</h3>";
    echo "<pre style='background: #f4f4f4; padding: 10px; border-radius: 5px; max-height: 400px; overflow-y: auto;'>";
    $lines = array_slice(explode("\n", file_get_contents($error_log)), -20);
    foreach ($lines as $line) {
        if (!empty(trim($line))) {
            echo htmlspecialchars($line) . "\n";
        }
    }
    echo "</pre>";
} else {
    echo "<p style='color: orange;'>⚠ Error log not found or not configured</p>";
}

echo "<h3>Mail Configuration:</h3>";
echo "<ul>";
echo "<li><strong>SMTP:</strong> " . ini_get('SMTP') . "</li>";
echo "<li><strong>smtp_port:</strong> " . ini_get('smtp_port') . "</li>";
echo "<li><strong>sendmail_path:</strong> " . ini_get('sendmail_path') . "</li>";
echo "<li><strong>sendmail_from:</strong> " . ini_get('sendmail_from') . "</li>";
echo "</ul>";

// Test mail function
echo "<h3>Send Test Email:</h3>";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $test_email = $_POST['test_email'] ?? 'test@example.com';
    $headers = "MIME-Version: 1.0\r\n";
    $headers .= "Content-type: text/html; charset=UTF-8\r\n";
    $headers .= "From: info@zemaraimgroups.com\r\n";
    
    $message = "<html><body><h2>Test Email</h2><p>Sent at: " . date('Y-m-d H:i:s') . "</p></body></html>";
    
    $result = @mail($test_email, "Test Email", $message, $headers);
    
    if ($result) {
        echo "<p style='color: green;'>✓ Test email sent to: " . htmlspecialchars($test_email) . "</p>";
    } else {
        echo "<p style='color: red;'>✗ Test email FAILED to send</p>";
    }
}

?>
<form method="POST">
    <input type="email" name="test_email" placeholder="Enter test email" value="<?php echo htmlspecialchars($_POST['test_email'] ?? ''); ?>">
    <button type="submit">Send Test Email</button>
</form>
