<?php
// Debug the update-order-status.php file
session_start();

// Mock the session for testing
$_SESSION['user_role'] = 'admin';
$_SERVER['REQUEST_METHOD'] = 'POST';

// Mock POST data
$_POST['order_id'] = '1';
$_POST['status'] = 'delivered';

// Now test the file
echo "<h2>Testing update-order-status.php</h2>";
echo "<p>Testing with order_id=1, status=delivered</p>";
echo "<hr>";

$host = 'localhost';
$db = 'zemaraim_interior';
$user = 'zemaraim';
$password = '8wwxk]-X3Kx]CJ]5';

$connection = new mysqli($host, $user, $password, $db);

if ($connection->connect_error) {
    echo "❌ Database connection failed: " . $connection->connect_error;
    exit;
}

echo "✓ Database connected<br>";

// Check if orders table exists
$check = $connection->query("SELECT COUNT(*) as count FROM orders");
if ($check) {
    $row = $check->fetch_assoc();
    echo "✓ Orders table exists (count: " . $row['count'] . ")<br>";
} else {
    echo "❌ Orders table error: " . $connection->error . "<br>";
}

// Try to get an order
$order_stmt = $connection->prepare("
    SELECT o.id, u.email, u.name FROM orders o 
    JOIN users u ON o.user_id = u.id 
    WHERE o.id = ?
");

if (!$order_stmt) {
    echo "❌ Prepare statement failed: " . $connection->error . "<br>";
    exit;
}

$order_id = 1;
$order_stmt->bind_param("i", $order_id);
$order_stmt->execute();
$order_result = $order_stmt->get_result();
$order = $order_result->fetch_assoc();

if ($order) {
    echo "✓ Order found: ID=" . $order['id'] . ", Email=" . $order['email'] . "<br>";
    echo "  - Customer: " . $order['name'] . "<br>";
} else {
    echo "⚠ No order found with ID=1<br>";
}

// Try to update the order
$stmt = $connection->prepare("UPDATE orders SET status = ? WHERE id = ?");
if (!$stmt) {
    echo "❌ Update statement failed: " . $connection->error . "<br>";
    exit;
}

$status = 'delivered';
$stmt->bind_param("si", $status, $order_id);

if ($stmt->execute()) {
    echo "✓ Order status updated successfully<br>";
} else {
    echo "❌ Update failed: " . $stmt->error . "<br>";
}

echo "<hr>";
echo "<p><strong>Summary:</strong> The API should work now. Try clicking 'Delivered' again in the admin dashboard.</p>";

$connection->close();
?>
