<?php
/**
 * Debug OTP Email Issue
 * Check if PHPMailer is installed and EmailService is working
 */

echo "<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 20px; border-radius: 8px; }
        h1 { color: #333; }
        .section { margin: 20px 0; padding: 15px; border: 1px solid #ddd; border-radius: 4px; }
        .pass { background: #d4edda; border-color: #28a745; }
        .fail { background: #f8d7da; border-color: #dc3545; }
        .warn { background: #fff3cd; border-color: #ffc107; }
        code { background: #f0f0f0; padding: 2px 6px; border-radius: 3px; }
        pre { background: #f0f0f0; padding: 10px; overflow-x: auto; }
    </style>
</head>
<body>
    <div class='container'>
        <h1>🔍 OTP Email Debugging</h1>";

// Check 1: EmailService exists
$service_exists = file_exists(__DIR__ . '/auth-system/EmailService.php');
echo "<div class='section " . ($service_exists ? 'pass' : 'fail') . "'>
    <strong>✓ EmailService.php</strong>: " . ($service_exists ? 'Found' : 'Missing') . "
</div>";

// Check 2: PHPMailer files
$phpmailer_dir = __DIR__ . '/auth-system/PHPMailer';
$phpmailer_files = [
    'PHPMailer.php' => file_exists($phpmailer_dir . '/PHPMailer.php'),
    'SMTP.php' => file_exists($phpmailer_dir . '/SMTP.php'),
    'Exception.php' => file_exists($phpmailer_dir . '/Exception.php')
];

$phpmailer_ok = array_reduce($phpmailer_files, fn($a, $b) => $a && $b, true);

echo "<div class='section " . ($phpmailer_ok ? 'pass' : 'warn') . "'>
    <strong>PHPMailer Files</strong>:
    <ul>";
foreach ($phpmailer_files as $file => $exists) {
    echo "<li>" . ($exists ? '✓' : '✗') . " $file</li>";
}
echo "</ul>
    <p style='margin: 10px 0; font-size: 12px; color: #666;'>
        Path: <code>$phpmailer_dir</code>
    </p>";

if (!$phpmailer_ok) {
    echo "<p style='color: #dc3545; margin: 10px 0;'>
        <strong>⚠️ Action Required:</strong> Download PHPMailer files<br>
        Run: <code>download-phpmailer.bat</code>
    </p>";
}
echo "</div>";

// Check 3: Email configuration
echo "<div class='section warn'>
    <strong>📧 Email Configuration Status</strong>:
    <p style='margin: 10px 0;'>
        Check if credentials are set in: <code>auth-system/EmailService.php</code>
    </p>";

$email_service = file_get_contents(__DIR__ . '/auth-system/EmailService.php');
$has_credentials = (strpos($email_service, 'your-email@gmail.com') === false);

if ($has_credentials) {
    echo "<p style='color: #28a745;'>✓ Email credentials appear to be configured</p>";
} else {
    echo "<p style='color: #dc3545;'>
        <strong>⚠️ Action Required:</strong><br>
        Still using default placeholder email addresses.<br>
        Edit <code>auth-system/EmailService.php</code> lines 53-57:<br>
        <code>\$mail->Username = 'your-email@gmail.com';</code><br>
        <code>\$mail->Password = 'your-app-password';</code>
    </p>";
}
echo "</div>";

// Check 4: Dev mode logs
echo "<div class='section'>
    <strong>📝 Email Logs (Dev Mode)</strong>:";

$logs_dir = __DIR__ . '/auth-system/logs';
if (is_dir($logs_dir)) {
    $today_log = $logs_dir . '/emails_' . date('Y-m-d') . '.txt';
    if (file_exists($today_log)) {
        $logs = file_get_contents($today_log);
        echo "<p style='color: #28a745; margin: 5px 0;'>✓ Logs found for today</p>";
        echo "<pre style='max-height: 300px;'>" . htmlspecialchars($logs) . "</pre>";
    } else {
        echo "<p style='color: #999;'>No logs yet for today. Emails will appear here.</p>";
    }
} else {
    echo "<p style='color: #ffc107;'>Logs directory not created yet.</p>";
}
echo "</div>";

// Check 5: Test email
echo "<div class='section'>
    <strong>🧪 Send Test Email</strong>:
    <form method='POST' style='margin-top: 10px;'>
        <input type='email' name='test_email' placeholder='your-email@example.com' required style='padding: 8px; width: 250px;'>
        <button type='submit' name='send_test' style='padding: 8px 15px; background: #007bff; color: white; border: none; border-radius: 4px; cursor: pointer;'>Send OTP</button>
    </form>";

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['send_test'])) {
    $test_email = $_POST['test_email'];
    
    require_once __DIR__ . '/auth-system/EmailService.php';
    
    $otp = EmailService::generateOTP();
    $result = EmailService::sendEmailVerificationOTP($test_email, 'Test User', $otp);
    
    if ($result) {
        echo "<p style='color: #28a745; margin-top: 10px;'>✓ OTP sent to $test_email!</p>";
        echo "<p style='color: #666; font-size: 12px;'>Check your email and spam folder. The email log above will also show the attempt.</p>";
    } else {
        echo "<p style='color: #dc3545; margin-top: 10px;'>✗ Failed to send OTP to $test_email</p>";
        echo "<p style='color: #666; font-size: 12px;'>Check the logs above for error details.</p>";
    }
}

echo "</div>";

// Check 6: Database
echo "<div class='section'>
    <strong>🗄️ Database Connection</strong>:";

// Don't die on connection error
$conn = @new mysqli('localhost', 'zemaraim', '8wwxk]-X3Kx]CJ]5', 'zemaraim_interior');

if ($conn->connect_error === null) {
    echo "<p style='color: #28a745;'>✓ Database connected successfully</p>";
    
    // Check OTP table
    $result = $conn->query("SHOW TABLES LIKE 'otp_verification'");
    if ($result && $result->num_rows > 0) {
        echo "<p style='color: #28a745;'>✓ OTP verification table exists</p>";
    } else {
        echo "<p style='color: #dc3545;'>✗ OTP verification table missing</p>";
    }
} else {
    echo "<p style='color: #dc3545;'>✗ Database connection failed: " . htmlspecialchars($conn->connect_error) . "</p>";
    echo "<p style='color: #666; font-size: 12px; margin: 10px 0;'>
        <strong>Solution:</strong><br>
        1. Open XAMPP Control Panel<br>
        2. Click <strong>Start</strong> next to MySQL<br>
        3. Wait for it to show 'Running'<br>
        4. Refresh this page
    </p>";
}

echo "</div>";

echo "</div>
</body>
</html>";
?>
